/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen.preview;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.screen.preview.BlockCapture;
import com.supermartijn642.rechiseled.screen.preview.BlockCaptureLevel;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class ScreenBlockRenderer {
    private static final RandomSource RANDOM_SOURCE = RandomSource.create();
    private static final Set<Block> erroredBlocks = new HashSet<Block>();
    private static BlockCaptureLevel fakeLevel;

    public static void drawBlock(PoseStack poseStack, BlockCapture capture, double x, double y, double scale, float yaw, float pitch, boolean flatShading) {
        AABB bounds = capture.getBounds();
        double span = Math.sqrt(bounds.getXsize() * bounds.getXsize() + bounds.getYsize() * bounds.getYsize() + bounds.getZsize() * bounds.getZsize());
        scale /= span;
        if (fakeLevel == null) {
            fakeLevel = new BlockCaptureLevel();
        }
        fakeLevel.setCapture(capture);
        poseStack.pushPose();
        poseStack.translate(x, y, 350.0);
        poseStack.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.scale((float)scale, (float)scale, (float)scale);
        poseStack.mulPose(new Quaternionf().setAngleAxis(pitch / 180.0f * (float)Math.PI, 1.0f, 0.0f, 0.0f));
        poseStack.mulPose(new Quaternionf().setAngleAxis(yaw / 180.0f * (float)Math.PI, 0.0f, 1.0f, 0.0f));
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        for (Map.Entry<BlockPos, BlockState> entry : capture.getBlocks()) {
            BlockState state = entry.getValue();
            if (erroredBlocks.contains(state.getBlock())) continue;
            try {
                ScreenBlockRenderer.renderBlock((BlockAndTintGetter)fakeLevel, entry.getKey(), entry.getValue(), poseStack, (MultiBufferSource)bufferSource);
            }
            catch (Exception e) {
                Rechiseled.LOGGER.error("Encountered an exception whilst rendering block '{}'!", (Object)BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()), (Object)e);
                erroredBlocks.add(state.getBlock());
            }
        }
        poseStack.popPose();
        if (flatShading) {
            Lighting.setupForFlatItems();
            bufferSource.endBatch();
            Lighting.setupFor3DItems();
        }
        fakeLevel.setCapture(null);
    }

    private static void renderBlock(BlockAndTintGetter level, BlockPos pos, BlockState state, PoseStack poseStack, MultiBufferSource bufferSource) {
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() - 0.5, (double)pos.getY() - 0.5, (double)pos.getZ() - 0.5);
        long seed = state.getSeed(pos);
        BlockRenderDispatcher blockRenderer = ClientUtils.getBlockRenderer();
        BakedModel model = blockRenderer.getBlockModel(state);
        ModelData modelData = model.getModelData(level, pos, state, ModelData.EMPTY);
        RANDOM_SOURCE.setSeed(seed);
        ChunkRenderTypeSet renderTypes = model.getRenderTypes(state, RANDOM_SOURCE, modelData);
        for (RenderType renderType : renderTypes) {
            RenderType itemRenderType = renderType == RenderType.translucent() ? Sheets.translucentItemSheet() : Sheets.cutoutBlockSheet();
            blockRenderer.renderBatched(state, pos, level, poseStack, bufferSource.getBuffer(itemRenderType), true, RANDOM_SOURCE, modelData, renderType);
        }
        poseStack.popPose();
    }
}

