/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.CursorType;
import com.supermartijn642.core.gui.CursorTypes;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.rechiseled.Rechiseled;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class FilterOptionsWidget
extends BaseWidget {
    private static final ResourceLocation BUTTONS = Rechiseled.identifier("textures/screen/filter_buttons.png");
    private static final ResourceLocation MARKER = Rechiseled.identifier("textures/screen/filter_marker.png");
    private static final ResourceLocation CHECKMARK = Rechiseled.identifier("textures/screen/checkmark.png");
    private static final int PADDING = 20;
    private final BooleanSupplier showBlocks;
    private final BooleanSupplier showStairs;
    private final BooleanSupplier showSlabs;
    private final BooleanSupplier showNonConnecting;
    private final Runnable toggleShowBlocks;
    private final Runnable toggleShowStairs;
    private final Runnable toggleShowSlabs;
    private final Runnable toggleShowConnecting;
    private final Runnable resetFilters;
    private final int collapsedWidth;
    private final int collapsedHeight;
    private final Dropdown dropdown;
    private boolean active = true;

    public FilterOptionsWidget(int x, int y, BooleanSupplier showBlocks, BooleanSupplier showStairs, BooleanSupplier showSlabs, BooleanSupplier showNonConnecting, Runnable toggleShowBlocks, Runnable toggleShowStairs, Runnable toggleShowSlabs, Runnable toggleShowConnecting, Runnable resetFilters) {
        super(x, y, 12, 12);
        this.showBlocks = showBlocks;
        this.showStairs = showStairs;
        this.showSlabs = showSlabs;
        this.showNonConnecting = showNonConnecting;
        this.toggleShowBlocks = toggleShowBlocks;
        this.toggleShowStairs = toggleShowStairs;
        this.toggleShowSlabs = toggleShowSlabs;
        this.toggleShowConnecting = toggleShowConnecting;
        this.resetFilters = resetFilters;
        this.collapsedWidth = this.width;
        this.collapsedHeight = this.height;
        this.dropdown = (Dropdown)this.addWidget((Widget)new Dropdown(this.x, this.y + 11));
    }

    public boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
        if (!this.active) {
            return hasBeenHandled;
        }
        boolean canClickDropdown = this.dropdown.expanded && !hasBeenHandled;
        hasBeenHandled |= super.mousePressed(mouseX, mouseY, button, hasBeenHandled);
        if (canClickDropdown && hasBeenHandled) {
            return true;
        }
        if (!hasBeenHandled && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            if (button == 0) {
                this.setExpanded(!this.dropdown.expanded);
            } else if (button == 1) {
                this.resetFilters.run();
            }
            hasBeenHandled = true;
            AbstractButtonWidget.playClickSound();
        } else {
            this.setExpanded(false);
        }
        return hasBeenHandled;
    }

    private void setExpanded(boolean expanded) {
        this.dropdown.setExpanded(expanded);
        this.width = Math.max(this.collapsedWidth, this.dropdown.width());
        this.height = this.collapsedHeight + this.dropdown.height();
    }

    public void setActive(boolean active) {
        this.active = active;
        if (!active) {
            this.setExpanded(false);
        }
    }

    public CursorType curser(int mouseX, int mouseY) {
        if (this.active && mouseX >= this.x && mouseX < this.x + this.collapsedWidth && mouseY >= this.y && mouseY < this.y + this.collapsedHeight) {
            return CursorTypes.pointingHand();
        }
        return this.dropdown.curser(mouseX, mouseY);
    }

    public Component getNarrationMessage() {
        return TextComponents.translation((String)"rechiseled.chiseling.filter").get();
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        tooltips.accept((Component)TextComponents.translation((String)"rechiseled.chiseling.filter").get());
        tooltips.accept((Component)TextComponents.translation((String)"rechiseled.chiseling.filter.clear").color(ChatFormatting.GRAY).italic().get());
    }

    public void renderTooltips(WidgetRenderContext context, int mouseX, int mouseY) {
        if (this.active && this.isFocused() && mouseX >= this.x && mouseX < this.x + this.collapsedWidth && mouseY >= this.y && mouseY < this.y + this.collapsedHeight) {
            super.renderTooltips(context, mouseX, mouseY);
        }
    }

    public void renderBackground(WidgetRenderContext context, int mouseX, int mouseY) {
        if (this.dropdown.expanded && (mouseX < this.x - 20 || mouseX > this.x + this.width + 20 || mouseY < this.y - 20 || mouseY > this.y + this.height + 20)) {
            this.setExpanded(false);
        }
        ScreenUtils.bindTexture((ResourceLocation)BUTTONS);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)this.y, (float)this.collapsedWidth, (float)this.collapsedHeight, (float)0.0f, (float)((float)(this.active ? (this.isFocused() || this.dropdown.expanded ? 1 : 0) : 2) / 3.0f), (float)1.0f, (float)0.33333334f);
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        if (!(this.showBlocks.getAsBoolean() && this.showStairs.getAsBoolean() && this.showSlabs.getAsBoolean() && this.showNonConnecting.getAsBoolean())) {
            ScreenUtils.bindTexture((ResourceLocation)MARKER);
            ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)(this.x + this.collapsedWidth - 4), (float)this.y, (float)4.0f, (float)4.0f);
        }
    }

    private class Dropdown
    extends BaseWidget {
        private final Component showBlocksText;
        private final Component showStairsText;
        private final Component showSlabsText;
        private final Component showNonConnectingText;
        private final int expandedWidth;
        private final int expandedHeight;
        private boolean expanded;

        public Dropdown(int x, int y) {
            super(x, y, 0, 0);
            this.showBlocksText = TextComponents.translation((String)"rechiseled.chiseling.filter.show_blocks").get();
            this.showStairsText = TextComponents.translation((String)"rechiseled.chiseling.filter.show_stairs").get();
            this.showSlabsText = TextComponents.translation((String)"rechiseled.chiseling.filter.show_slabs").get();
            this.showNonConnectingText = TextComponents.translation((String)"rechiseled.chiseling.filter.show_non_connecting").get();
            int width = Minecraft.getInstance().font.width((FormattedText)this.showBlocksText);
            width = Math.max(width, Minecraft.getInstance().font.width((FormattedText)this.showStairsText));
            width = Math.max(width, Minecraft.getInstance().font.width((FormattedText)this.showSlabsText));
            width = Math.max(width, Minecraft.getInstance().font.width((FormattedText)this.showNonConnectingText));
            this.expandedWidth = width + 16;
            this.expandedHeight = 46;
        }

        void setExpanded(boolean expanded) {
            this.expanded = expanded;
            if (expanded) {
                this.width = this.expandedWidth;
                this.height = this.expandedHeight;
            } else {
                this.height = 0;
                this.width = 0;
            }
        }

        public Component getNarrationMessage() {
            return null;
        }

        public CursorType curser(int mouseX, int mouseY) {
            return this.expanded && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height ? CursorTypes.pointingHand() : null;
        }

        public void renderForeground(WidgetRenderContext context, int mouseX, int mouseY) {
            int hoveredLine;
            if (!this.expanded) {
                return;
            }
            PoseStack poseStack = context.poseStack();
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 500.0f);
            ScreenUtils.fillRect((PoseStack)poseStack, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.54509807f, (float)0.54509807f, (float)0.54509807f, (float)1.0f);
            if (this.expanded && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
                hoveredLine = Math.max((int)Math.floor((float)(mouseY - this.y) / (float)this.height * 4.0f), 0);
                ScreenUtils.fillRect((PoseStack)poseStack, (float)this.x, (float)(this.y + 1 + 11 * hoveredLine), (float)this.width, (float)11.0f, (float)0.5882353f, (float)0.5882353f, (float)0.5882353f, (float)1.0f);
            } else {
                hoveredLine = -1;
            }
            this.renderLine(poseStack, 0, hoveredLine, FilterOptionsWidget.this.showBlocks, this.showBlocksText);
            this.renderLine(poseStack, 1, hoveredLine, FilterOptionsWidget.this.showStairs, this.showStairsText);
            this.renderLine(poseStack, 2, hoveredLine, FilterOptionsWidget.this.showSlabs, this.showSlabsText);
            this.renderLine(poseStack, 3, hoveredLine, FilterOptionsWidget.this.showNonConnecting, this.showNonConnectingText);
            poseStack.popPose();
        }

        private void renderLine(PoseStack poseStack, int line, int hoveredLine, BooleanSupplier isEnabled, Component text) {
            if (isEnabled.getAsBoolean()) {
                ScreenUtils.bindTexture((ResourceLocation)CHECKMARK);
                ScreenUtils.drawTexture((PoseStack)poseStack, (float)(this.x + 3), (float)(this.y + 2 + line * 11), (float)8.0f, (float)8.0f);
            }
            ScreenUtils.drawString((PoseStack)poseStack, (Component)(hoveredLine == line ? TextComponents.fromTextComponent((Component)text).italic().get() : text), (float)(isEnabled.getAsBoolean() ? (float)(this.x + 12) : (float)(this.x + 3)), (float)(this.y + 3 + line * 11));
        }

        public boolean mousePressed(int mouseX, int mouseY, int button, boolean hasBeenHandled) {
            if (this.expanded && !hasBeenHandled && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
                int line = Math.max((int)Math.floor((float)(mouseY - this.y) / (float)this.height * 4.0f), 0);
                if (line == 0) {
                    FilterOptionsWidget.this.toggleShowBlocks.run();
                } else if (line == 1) {
                    FilterOptionsWidget.this.toggleShowStairs.run();
                } else if (line == 2) {
                    FilterOptionsWidget.this.toggleShowSlabs.run();
                } else if (line == 3) {
                    FilterOptionsWidget.this.toggleShowConnecting.run();
                }
                hasBeenHandled = true;
            }
            return hasBeenHandled;
        }
    }
}

