/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.AbstractButtonWidget;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.screen.DisplayEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class ChiselAllWidget
extends AbstractButtonWidget {
    private static final ResourceLocation GREY_BUTTONS = Rechiseled.identifier("textures/screen/grey_buttons.png");
    private static final ResourceLocation CHISEL_TEXTURE = Rechiseled.identifier("textures/item/chisel.png");
    private final Supplier<DisplayEntry> currentEntry;
    public int chiselableItems = 0;

    public ChiselAllWidget(int x, int y, int width, int height, Supplier<DisplayEntry> currentEntry, Runnable onPress) {
        super(x, y, width, height, onPress);
        this.currentEntry = currentEntry;
    }

    protected boolean isClickable() {
        return this.currentEntry.get() != null;
    }

    public Component getNarrationMessage() {
        Holder message = new Holder();
        this.getTooltips(arg_0 -> ((Holder)message).set(arg_0));
        return (Component)message.get();
    }

    protected void getTooltips(Consumer<Component> tooltips) {
        if (this.currentEntry.get() != null) {
            tooltips.accept((Component)TextComponents.translation((String)"rechiseled.chiseling.chisel_all").bold().get());
            tooltips.accept((Component)TextComponents.translation((String)"rechiseled.chiseling.chisel_all.shift", (Object[])new Object[]{TextComponents.translation((String)"key.keyboard.left.shift").color(ChatFormatting.GOLD).get()}).get());
            tooltips.accept((Component)TextComponents.translation((String)"rechiseled.chiseling.chisel_all.items", (Object[])new Object[]{TextComponents.number((int)this.chiselableItems).get()}).italic().color(ChatFormatting.GRAY).get());
        }
    }

    public void render(WidgetRenderContext context, int mouseX, int mouseY) {
        boolean hasEntry = this.currentEntry.get() != null;
        ScreenUtils.bindTexture((ResourceLocation)GREY_BUTTONS);
        ScreenUtils.drawTexture((PoseStack)context.poseStack(), (float)this.x, (float)this.y, (float)this.width, (float)this.height, (float)0.0f, (float)((float)(hasEntry ? (this.isFocused() ? 2 : 0) : 1) / 3.0f), (float)1.0f, (float)0.33333334f);
        ScreenUtils.bindTexture((ResourceLocation)CHISEL_TEXTURE);
        ChiselAllWidget.drawColoredTexture(context.poseStack(), this.x + 1, this.y + 2, this.width - 2, this.height - 4, hasEntry ? 1.0f : 0.19607843f, hasEntry ? 1.0f : 0.19607843f, hasEntry ? 1.0f : 0.19607843f);
    }

    private static void drawColoredTexture(PoseStack poseStack, float x, float y, float width, float height, float red, float green, float blue) {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = poseStack.last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buffer.addVertex(matrix, x, y + height, 0.0f).setUv(0.0f, 1.0f).setColor(red, green, blue, 1.0f);
        buffer.addVertex(matrix, x + width, y + height, 0.0f).setUv(1.0f, 1.0f).setColor(red, green, blue, 1.0f);
        buffer.addVertex(matrix, x + width, y, 0.0f).setUv(1.0f, 0.0f).setColor(red, green, blue, 1.0f);
        buffer.addVertex(matrix, x, y, 0.0f).setUv(0.0f, 0.0f).setColor(red, green, blue, 1.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }
}

