/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.chiseling;

import com.google.common.collect.Sets;
import com.supermartijn642.core.registry.RegistryUtil;
import com.supermartijn642.core.util.Holder;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.Rechiseled;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingBlockShape;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingRecipeManager;
import com.supermartijn642.rechiseled.api.chiseling.ItemWithWorth;
import com.supermartijn642.rechiseled.api.chiseling.plugin.ChiselingRecipePlugin;
import com.supermartijn642.rechiseled.api.chiseling.plugin.MutableChiselingRecipe;
import com.supermartijn642.rechiseled.api.chiseling.plugin.RechiseledChiselingRecipePlugin;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntryImpl;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipeDatapackPlugin;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipeImpl;
import com.supermartijn642.rechiseled.chiseling.plugin.ChiselingRecipeMutationContextImpl;
import com.supermartijn642.rechiseled.chiseling.plugin.ChiselingRecipesLoadedContextImpl;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class ChiselingRecipeManagerImpl
implements ChiselingRecipeManager {
    private static final ChiselingRecipeManagerImpl SERVER = new ChiselingRecipeManagerImpl();
    private static final ChiselingRecipeManagerImpl CLIENT = new ChiselingRecipeManagerImpl();
    private List<ChiselingRecipe> recipes;
    private static final List<PluginEntry> PLUGINS = new ArrayList<PluginEntry>();
    private static final Map<ResourceLocation, PluginEntry> PLUGINS_BY_IDENTIFIER = new HashMap<ResourceLocation, PluginEntry>();
    private static boolean finalized = false;

    public static ChiselingRecipeManagerImpl get(boolean client) {
        return client ? CLIENT : SERVER;
    }

    @Override
    public List<ChiselingRecipe> getAllRecipes() {
        if (this.recipes == null) {
            throw new IllegalStateException("Recipes can only be queried when in a game!");
        }
        return this.recipes;
    }

    @Override
    @Nullable
    public ChiselingRecipe getRecipeForItem(ItemLike item) {
        if (this.recipes == null) {
            throw new IllegalStateException("Recipes can only be queried when in a game!");
        }
        for (ChiselingRecipe recipe : this.recipes) {
            if (!recipe.contains(item)) continue;
            return recipe;
        }
        return null;
    }

    public static synchronized void registerPlugin(ResourceLocation identifier, ChiselingRecipePlugin plugin, int priority) {
        if (finalized) {
            throw new IllegalStateException("Trying to register chiseling plugin '" + String.valueOf(identifier) + "' after initialization!");
        }
        if (PLUGINS_BY_IDENTIFIER.containsKey(identifier)) {
            throw new IllegalStateException("Duplicate chiseling plugin registration for '" + String.valueOf(identifier) + "': '" + ChiselingRecipeManagerImpl.PLUGINS_BY_IDENTIFIER.get((Object)identifier).plugin.getClass().getName() + "' and '" + plugin.getClass().getName() + "'!");
        }
        PluginEntry entry = new PluginEntry(identifier, priority, plugin);
        PLUGINS_BY_IDENTIFIER.put(identifier, entry);
        PLUGINS.add(entry);
    }

    public static synchronized void finalizePlugins() {
        if (finalized) {
            throw new IllegalStateException("Plugins are already finalized!");
        }
        ChiselingRecipeManagerImpl.registerPlugin(ChiselingRecipeDatapackPlugin.IDENTIFIER, ChiselingRecipeDatapackPlugin.INSTANCE, 0);
        ChiselingRecipeManagerImpl.loadAnnotationPlugins();
        PLUGINS.sort(Comparator.comparingInt(PluginEntry::priority).thenComparing(PluginEntry::identifier));
        finalized = true;
        Rechiseled.LOGGER.info("{} chiseling plugins were registered: {}", (Object)PLUGINS.size(), (Object)PLUGINS.stream().map(PluginEntry::identifier).toArray());
    }

    private static void loadAnnotationPlugins() {
        Type pluginAnnotation = Type.getType(RechiseledChiselingRecipePlugin.class);
        for (ModFileScanData scanData : ModList.get().getAllScanData()) {
            if (scanData.getIModInfoData().isEmpty() || ((IModFileInfo)scanData.getIModInfoData().getFirst()).getMods().isEmpty()) continue;
            String modid = ((IModInfo)((IModFileInfo)scanData.getIModInfoData().getFirst()).getMods().getFirst()).getModId();
            for (ModFileScanData.AnnotationData annotation : scanData.getAnnotations()) {
                if (!annotation.annotationType().equals((Object)pluginAnnotation)) continue;
                try {
                    ChiselingRecipePlugin plugin;
                    Constructor<?> constructor;
                    Class<?> clazz;
                    if (!annotation.targetType().equals((Object)ElementType.TYPE)) {
                        throw new RuntimeException("Chiseling plugin annotation must be a applied to a class!");
                    }
                    String identifier = annotation.annotationData().getOrDefault("identifier", "plugin");
                    if (!RegistryUtil.isValidIdentifier((String)identifier)) {
                        throw new RuntimeException("Rechiseled chiseling plugin from mod '" + modid + "' has invalid identifier '" + identifier + "'!");
                    }
                    int priority = annotation.annotationData().getOrDefault("priority", 100);
                    try {
                        clazz = Class.forName(annotation.clazz().getClassName());
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to obtain class '" + annotation.clazz().getClassName() + "'!", e);
                    }
                    if (!ChiselingRecipePlugin.class.isAssignableFrom(clazz)) {
                        throw new RuntimeException("Plugin class '" + clazz.getName() + "' must extend '" + ChiselingRecipePlugin.class.getSimpleName() + "!");
                    }
                    try {
                        constructor = clazz.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Plugin class '" + clazz.getName() + "' must have a default constructor!", e);
                    }
                    try {
                        plugin = (ChiselingRecipePlugin)constructor.newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to create instance of '" + annotation.clazz().getClassName() + "'!", e);
                    }
                    ChiselingRecipeManagerImpl.registerPlugin(ResourceLocation.fromNamespaceAndPath((String)modid, (String)identifier), plugin, priority);
                }
                catch (Exception e) {
                    Rechiseled.LOGGER.error("Failed to create chiseling recipe plugin from mod '{}'!", (Object)modid, (Object)e);
                }
            }
        }
    }

    public static void loadRecipes() {
        Holder<ResourceLocation> activePlugin = new Holder<ResourceLocation>(){

            public ResourceLocation get() {
                ResourceLocation identifier = (ResourceLocation)super.get();
                if (identifier == null) {
                    throw new IllegalStateException("No active plugin found!");
                }
                return identifier;
            }
        };
        ChiselingRecipeMutationContextImpl context = new ChiselingRecipeMutationContextImpl(() -> ((Holder)activePlugin).get());
        for (PluginEntry plugin : PLUGINS) {
            activePlugin.set((Object)plugin.identifier);
            try {
                plugin.plugin.mutateRecipes(context);
            }
            catch (Exception e) {
                throw new RuntimeException("Chiseling recipe plugin '" + String.valueOf(plugin.identifier) + "' threw an exception whilst mutation chiseling recipes!", e);
            }
        }
        activePlugin.set(null);
        context.invalidate();
        List<MutableChiselingRecipe> recipes = context.getRecipesUnsafe();
        List<ChiselingRecipe> mergedRecipes = ChiselingRecipeManagerImpl.mergeRecipes(recipes);
        Rechiseled.LOGGER.info("Loaded {} chiseling recipes", (Object)mergedRecipes.size());
        SERVER.updateRecipes(mergedRecipes);
    }

    private static List<ChiselingRecipe> mergeRecipes(List<MutableChiselingRecipe> recipes) {
        ArrayList<Pair> groupedRecipes = new ArrayList<Pair>(recipes.size());
        for (MutableChiselingRecipe mutableChiselingRecipe : recipes) {
            if (mutableChiselingRecipe.entries().isEmpty()) continue;
            ChiselingRecipeImpl newRecipe = new ChiselingRecipeImpl(mutableChiselingRecipe.entries());
            groupedRecipes.add(Pair.of(new HashSet<Item>(newRecipe.getItems()), new ArrayList<ChiselingRecipeImpl>(List.of(newRecipe))));
        }
        block1: for (int i = 0; i < groupedRecipes.size(); ++i) {
            Pair pair = (Pair)groupedRecipes.get(i);
            for (int j = i + 1; j < groupedRecipes.size(); ++j) {
                Pair pair2 = (Pair)groupedRecipes.get(j);
                if (Sets.intersection((Set)((Set)pair.left()), (Set)((Set)pair2.left())).isEmpty()) continue;
                ((Set)pair.left()).addAll((Collection)pair2.left());
                ((List)pair.right()).addAll((Collection)pair2.right());
                groupedRecipes.remove(j);
                --i;
                continue block1;
            }
        }
        for (Pair pair : groupedRecipes) {
            ((List)pair.right()).sort(Comparator.comparingInt(recipes::indexOf));
        }
        HashMap worths = new HashMap();
        for (Pair group : groupedRecipes) {
            for (ChiselingRecipe chiselingRecipe : (List)group.right()) {
                for (ChiselingEntry entry2 : chiselingRecipe.entries()) {
                    ((ChiselingEntryImpl)entry2).items().forEach((item, worth) -> worths.merge(item, worth, (worth1, worth2) -> worth1.worth() > worth2.worth() ? worth1 : worth2));
                }
            }
        }
        ArrayList arrayList = new ArrayList(groupedRecipes.size());
        for (Pair pair : groupedRecipes) {
            ArrayList<ChiselingEntry> arrayList2 = new ArrayList<ChiselingEntry>();
            for (ChiselingRecipe recipe : (List)pair.right()) {
                block9: for (ChiselingEntry entry3 : recipe.entries()) {
                    for (ChiselingEntry existingEntry : arrayList2) {
                        if (!((ChiselingEntryImpl)existingEntry).items().keySet().containsAll(((ChiselingEntryImpl)entry3).items().keySet())) continue;
                        continue block9;
                    }
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        if (!((ChiselingEntryImpl)entry3).items().keySet().containsAll(((ChiselingEntryImpl)arrayList2.get(i)).items().keySet())) continue;
                        arrayList2.remove(i);
                        --i;
                    }
                    arrayList2.add(entry3);
                }
            }
            arrayList.add(arrayList2);
        }
        for (List list : arrayList) {
            list.replaceAll(entry -> {
                ItemWithWorth regularBlock = entry.hasRegularItem(ChiselingBlockShape.BLOCK) ? (ItemWithWorth)worths.get(entry.getRegularItem(ChiselingBlockShape.BLOCK).item()) : null;
                ItemWithWorth regularStairs = entry.hasRegularItem(ChiselingBlockShape.STAIRS) ? (ItemWithWorth)worths.get(entry.getRegularItem(ChiselingBlockShape.STAIRS).item()) : null;
                ItemWithWorth regularSlab = entry.hasRegularItem(ChiselingBlockShape.SLAB) ? (ItemWithWorth)worths.get(entry.getRegularItem(ChiselingBlockShape.SLAB).item()) : null;
                ItemWithWorth connectingBlock = entry.hasConnectingItem(ChiselingBlockShape.BLOCK) ? (ItemWithWorth)worths.get(entry.getConnectingItem(ChiselingBlockShape.BLOCK).item()) : null;
                ItemWithWorth connectingStairs = entry.hasConnectingItem(ChiselingBlockShape.STAIRS) ? (ItemWithWorth)worths.get(entry.getConnectingItem(ChiselingBlockShape.STAIRS).item()) : null;
                ItemWithWorth connectingSlab = entry.hasConnectingItem(ChiselingBlockShape.SLAB) ? (ItemWithWorth)worths.get(entry.getConnectingItem(ChiselingBlockShape.SLAB).item()) : null;
                return new ChiselingEntryImpl(entry.owner(), entry.recipe(), regularBlock, regularStairs, regularSlab, connectingBlock, connectingStairs, connectingSlab);
            });
        }
        ArrayList<ChiselingRecipe> mergedRecipes = new ArrayList<ChiselingRecipe>(arrayList.size());
        for (List list : arrayList) {
            mergedRecipes.add(new ChiselingRecipeImpl(list));
        }
        return mergedRecipes;
    }

    public void updateRecipes(List<ChiselingRecipe> recipes) {
        this.recipes = List.copyOf(recipes);
        ChiselingRecipesLoadedContextImpl context = new ChiselingRecipesLoadedContextImpl(this, this == CLIENT);
        for (PluginEntry plugin : PLUGINS) {
            try {
                plugin.plugin.onRecipesLoaded(context);
            }
            catch (Exception e) {
                Rechiseled.LOGGER.error("Chiseling recipe plugin '{}' threw an exception whilst handling chiseling recipe update!", (Object)plugin.identifier, (Object)e);
            }
        }
    }

    public void clearRecipes() {
        this.recipes = null;
    }

    private record PluginEntry(ResourceLocation identifier, int priority, ChiselingRecipePlugin plugin) {
    }
}

