/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.chiseling;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingBlockShape;
import com.supermartijn642.rechiseled.api.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.api.chiseling.ItemWithWorth;
import com.supermartijn642.rechiseled.chiseling.ItemWithWorthImpl;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ChiselingEntryImpl
implements ChiselingEntry {
    private final ResourceLocation owner;
    private final ResourceLocation recipe;
    private final ItemWithWorth regularBlock;
    private final ItemWithWorth regularStairs;
    private final ItemWithWorth regularSlab;
    private final ItemWithWorth connectingBlock;
    private final ItemWithWorth connectingStairs;
    private final ItemWithWorth connectingSlab;
    private final ItemWithWorth primaryItem;
    private final ItemWithWorth primaryBlock;
    private final ItemWithWorth primaryStair;
    private final ItemWithWorth primarySlab;
    private final ItemWithWorth primaryRegularItem;
    private final ItemWithWorth primaryConnectingItem;
    private final Map<Item, ItemWithWorth> items;

    public ChiselingEntryImpl(ResourceLocation owner, ResourceLocation recipe, ItemWithWorth regularBlock, ItemWithWorth regularStairs, ItemWithWorth regularSlab, ItemWithWorth connectingBlock, ItemWithWorth connectingStairs, ItemWithWorth connectingSlab) {
        Item duplicate = ChiselingEntryImpl.checkDuplicateItems(regularBlock, regularStairs, regularSlab, connectingBlock, connectingStairs, connectingSlab);
        if (duplicate != null) {
            throw new IllegalArgumentException("Duplicate item '" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)duplicate)) + "'!");
        }
        this.owner = owner;
        this.recipe = recipe;
        this.regularBlock = regularBlock;
        this.regularStairs = regularStairs;
        this.regularSlab = regularSlab;
        this.connectingBlock = connectingBlock;
        this.connectingStairs = connectingStairs;
        this.connectingSlab = connectingSlab;
        this.primaryBlock = regularBlock == null ? connectingBlock : regularBlock;
        this.primaryStair = regularStairs == null ? connectingStairs : regularStairs;
        ItemWithWorth itemWithWorth = this.primarySlab = regularSlab == null ? connectingSlab : regularSlab;
        ItemWithWorth itemWithWorth2 = regularBlock == null ? (regularStairs == null ? regularSlab : regularStairs) : (this.primaryRegularItem = regularBlock);
        ItemWithWorth itemWithWorth3 = connectingBlock == null ? (connectingStairs == null ? connectingSlab : connectingStairs) : (this.primaryConnectingItem = connectingBlock);
        ItemWithWorth itemWithWorth4 = this.primaryBlock == null ? (this.primaryStair == null ? this.primarySlab : this.primaryStair) : (this.primaryItem = this.primaryBlock);
        if (this.primaryItem == null) {
            throw new IllegalArgumentException("Entry must have at least one item!");
        }
        this.items = Stream.of(regularBlock, regularStairs, regularSlab, connectingBlock, connectingStairs, connectingSlab).filter(Objects::nonNull).collect(Collectors.toUnmodifiableMap(ItemWithWorth::item, Function.identity()));
    }

    @Override
    public ResourceLocation owner() {
        return this.owner;
    }

    @Override
    @Nullable
    public ResourceLocation recipe() {
        return this.recipe;
    }

    public Map<Item, ItemWithWorth> items() {
        return this.items;
    }

    @Override
    public boolean hasShape(ChiselingBlockShape shape) {
        return switch (shape) {
            default -> throw new MatchException(null, null);
            case ChiselingBlockShape.BLOCK -> {
                if (this.primaryBlock != null) {
                    yield true;
                }
                yield false;
            }
            case ChiselingBlockShape.STAIRS -> {
                if (this.primaryStair != null) {
                    yield true;
                }
                yield false;
            }
            case ChiselingBlockShape.SLAB -> this.primarySlab != null;
        };
    }

    @Override
    public boolean hasRegularItem(ChiselingBlockShape shape) {
        return switch (shape) {
            default -> throw new MatchException(null, null);
            case ChiselingBlockShape.BLOCK -> {
                if (this.regularBlock != null) {
                    yield true;
                }
                yield false;
            }
            case ChiselingBlockShape.STAIRS -> {
                if (this.regularStairs != null) {
                    yield true;
                }
                yield false;
            }
            case ChiselingBlockShape.SLAB -> this.regularSlab != null;
        };
    }

    @Override
    public boolean hasConnectingItem(ChiselingBlockShape shape) {
        return switch (shape) {
            default -> throw new MatchException(null, null);
            case ChiselingBlockShape.BLOCK -> {
                if (this.connectingBlock != null) {
                    yield true;
                }
                yield false;
            }
            case ChiselingBlockShape.STAIRS -> {
                if (this.connectingStairs != null) {
                    yield true;
                }
                yield false;
            }
            case ChiselingBlockShape.SLAB -> this.connectingSlab != null;
        };
    }

    @Override
    @Nullable
    public ItemWithWorth getRegularItem(ChiselingBlockShape shape) {
        return switch (shape) {
            default -> throw new MatchException(null, null);
            case ChiselingBlockShape.BLOCK -> this.regularBlock;
            case ChiselingBlockShape.STAIRS -> this.regularStairs;
            case ChiselingBlockShape.SLAB -> this.regularSlab;
        };
    }

    @Override
    @Nullable
    public ItemWithWorth getConnectingItem(ChiselingBlockShape shape) {
        return switch (shape) {
            default -> throw new MatchException(null, null);
            case ChiselingBlockShape.BLOCK -> this.connectingBlock;
            case ChiselingBlockShape.STAIRS -> this.connectingStairs;
            case ChiselingBlockShape.SLAB -> this.connectingSlab;
        };
    }

    @Override
    @Nullable
    public ItemWithWorth getAnyItem(ChiselingBlockShape shape) {
        return switch (shape) {
            default -> throw new MatchException(null, null);
            case ChiselingBlockShape.BLOCK -> this.primaryBlock;
            case ChiselingBlockShape.STAIRS -> this.primaryStair;
            case ChiselingBlockShape.SLAB -> this.primarySlab;
        };
    }

    @Override
    public ItemWithWorth getAnyItem() {
        return this.primaryItem;
    }

    @Override
    @Nullable
    public ItemWithWorth getAnyRegularItem() {
        return this.primaryRegularItem;
    }

    @Override
    @Nullable
    public ItemWithWorth getAnyConnectingItem() {
        return this.primaryConnectingItem;
    }

    @Override
    public boolean contains(ItemLike item) {
        return this.items.containsKey(item.asItem());
    }

    public static ChiselingEntry fromJson(JsonElement element) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            String s = element.getAsString();
            ResourceLocation identifier = ResourceLocation.tryParse((String)s);
            if (identifier == null) {
                throw new JsonParseException("Invalid identifier '" + s + "'!");
            }
            Optional optional = BuiltInRegistries.ITEM.getOptional(identifier);
            if (optional.isEmpty()) {
                throw new JsonParseException("Unknown item '" + String.valueOf(identifier) + "'!");
            }
            ItemWithWorth item = ItemWithWorthImpl.defaultWorth((Item)optional.get());
            return new ChiselingEntryImpl(null, null, item, null, null, null, null, null);
        }
        if (!element.isJsonObject()) {
            throw new JsonParseException("Entry elements must be objects!");
        }
        JsonObject json = element.getAsJsonObject();
        boolean optional = false;
        if (json.has("optional")) {
            if (!json.get("optional").isJsonPrimitive() || !json.getAsJsonPrimitive("optional").isBoolean()) {
                throw new JsonParseException("Entry property 'optional' must be a boolean!");
            }
            optional = json.get("optional").getAsBoolean();
        }
        if (json.has("item") || json.has("connecting_item")) {
            ItemWithWorth item = ChiselingEntryImpl.readItem(json, "item", optional);
            ItemWithWorth connectingItem = ChiselingEntryImpl.readItem(json, "connecting_item", optional);
            if (item == null && connectingItem == null) {
                if (!optional) {
                    throw new JsonParseException("Empty chiseling entry!");
                }
                return null;
            }
            Item duplicate = ChiselingEntryImpl.checkDuplicateItems(item, connectingItem);
            if (duplicate != null) {
                throw new JsonParseException("Duplicate item '" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)duplicate)) + "' within one entry!");
            }
            return new ChiselingEntryImpl(null, null, item, null, null, connectingItem, null, null);
        }
        if (!(json.has("block") || json.has("stairs") || json.has("slab") || json.has("connecting_block") || json.has("connecting_stairs") || json.has("connecting_slab"))) {
            throw new JsonParseException("Entry must have at least one of 'block', 'stairs', 'slab', 'connecting_block', 'connecting_stairs' or 'connecting_slab'!");
        }
        ItemWithWorth regularBlock = ChiselingEntryImpl.readItem(json, "block", optional);
        ItemWithWorth regularStairs = ChiselingEntryImpl.readItem(json, "stairs", optional);
        ItemWithWorth regularSlab = ChiselingEntryImpl.readItem(json, "slab", optional);
        ItemWithWorth connectingBlock = ChiselingEntryImpl.readItem(json, "connecting_block", optional);
        ItemWithWorth connectingStairs = ChiselingEntryImpl.readItem(json, "connecting_stairs", optional);
        ItemWithWorth connectingSlab = ChiselingEntryImpl.readItem(json, "connecting_slab", optional);
        if (regularBlock == null && regularStairs == null && regularSlab == null && connectingBlock == null && connectingStairs == null && connectingSlab == null) {
            if (!optional) {
                throw new JsonParseException("Empty chiseling entry!");
            }
            return null;
        }
        Item duplicate = ChiselingEntryImpl.checkDuplicateItems(regularBlock, regularStairs, regularSlab, connectingBlock, connectingStairs, connectingSlab);
        if (duplicate != null) {
            throw new JsonParseException("Duplicate item '" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)duplicate)) + "' within one entry!");
        }
        return new ChiselingEntryImpl(null, null, regularBlock, regularStairs, regularSlab, connectingBlock, connectingStairs, connectingSlab);
    }

    private static ItemWithWorth readItem(JsonObject json, String key, boolean optional) {
        if (!json.has(key)) {
            return null;
        }
        if (!json.get(key).isJsonPrimitive() || !json.getAsJsonPrimitive(key).isString()) {
            throw new JsonParseException("Entry property '" + key + "' must be a string!");
        }
        String s = json.get(key).getAsString();
        ResourceLocation identifier = ResourceLocation.tryParse((String)s);
        if (identifier == null) {
            throw new JsonParseException("Invalid identifier '" + s + "' for entry property '" + key + "'!");
        }
        Optional item = BuiltInRegistries.ITEM.getOptional(identifier);
        if (item.isEmpty()) {
            if (!optional) {
                throw new JsonParseException("Unknown item '" + String.valueOf(identifier) + "' for entry property '" + key + "'!");
            }
            return null;
        }
        if (!json.has(key + "_worth")) {
            return item.map(ItemWithWorthImpl::defaultWorth).orElse(null);
        }
        JsonElement element = json.get(key + "_worth");
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
            throw new JsonParseException("Entry property '" + key + "' must be a number!");
        }
        float worth = element.getAsFloat();
        if (worth <= 0.0f) {
            throw new JsonParseException("Invalid worth '" + worth + "' for entry property '" + key + "'!");
        }
        return ItemWithWorthImpl.of((Item)item.get(), worth);
    }

    private static Item checkDuplicateItems(ItemWithWorth ... items) {
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            for (int j = i + 1; j < items.length; ++j) {
                if (items[j] == null || items[i].item() != items[j].item()) continue;
                return items[i].item();
            }
        }
        return null;
    }
}

