/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.blocks;

import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.rechiseled.blocks.RechiseledBlock;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RechiseledPillarBlock
extends RechiseledBlock {
    public static final EnumProperty<Direction.Axis> AXIS_PROPERTY = BlockStateProperties.AXIS;

    public RechiseledPillarBlock(boolean connecting, BlockProperties properties) {
        super(connecting, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(AXIS_PROPERTY, (Comparable)Direction.Axis.Y));
    }

    public RechiseledPillarBlock(boolean connecting, BlockBehaviour.Properties properties) {
        super(connecting, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(AXIS_PROPERTY, (Comparable)Direction.Axis.Y));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(AXIS_PROPERTY, (Comparable)context.getClickedFace().getAxis());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        Direction.Axis axis;
        if ((rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) && (axis = (Direction.Axis)state.getValue(AXIS_PROPERTY)) != Direction.Axis.Y) {
            return (BlockState)state.setValue(AXIS_PROPERTY, (Comparable)(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS_PROPERTY});
    }
}

