/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.blocks;

import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.blocks.RechiseledBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RechiseledGlassBlock
extends RechiseledBlock {
    private Block stairs;
    private Block slab;
    private boolean haveStairsAndSlabBeenSet = false;
    private volatile Map<Pair<BlockState, BlockState>, Boolean[]> shouldHideFaceCache = null;

    public RechiseledGlassBlock(boolean connecting, BlockProperties properties) {
        super(connecting, properties.noOcclusion().isSuffocating(Blocks::never));
    }

    public RechiseledGlassBlock(boolean connecting, BlockBehaviour.Properties properties) {
        super(connecting, properties.noOcclusion().isSuffocating(Blocks::never));
    }

    public void setStairsAndSlab(Block stairs, Block slab) {
        if (this.haveStairsAndSlabBeenSet) {
            throw new IllegalStateException("Already set stairs and slab!");
        }
        this.haveStairsAndSlabBeenSet = true;
        this.stairs = stairs;
        this.slab = slab;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean skipRendering(BlockState state, BlockState otherState, Direction side) {
        if (!this.haveStairsAndSlabBeenSet) {
            throw new IllegalStateException("Stairs and slab have not been set!");
        }
        if (!(otherState.is((Block)this) || otherState.is(this.stairs) || otherState.is(this.slab))) {
            return false;
        }
        if (this.shouldHideFaceCache == null) {
            RechiseledGlassBlock rechiseledGlassBlock = this;
            synchronized (rechiseledGlassBlock) {
                if (this.shouldHideFaceCache == null) {
                    this.shouldHideFaceCache = new HashMap<Pair<BlockState, BlockState>, Boolean[]>();
                }
            }
        }
        return RechiseledGlassBlock.calculateShouldHideFace(state, otherState, side, this.shouldHideFaceCache);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean calculateShouldHideFace(BlockState state, BlockState neighbor, Direction side, Map<Pair<BlockState, BlockState>, Boolean[]> cache) {
        Boolean[] booleans;
        Map<Pair<BlockState, BlockState>, Boolean[]> map = cache;
        synchronized (map) {
            booleans = cache.computeIfAbsent((Pair<BlockState, BlockState>)Pair.of((Object)state, (Object)neighbor), s -> new Boolean[6]);
        }
        if (booleans[side.ordinal()] == null) {
            VoxelShape neighborShape;
            VoxelShape ourShape = state.getShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO).getFaceShape(side);
            boolean shouldHideFace = !Shapes.joinIsNotEmpty((VoxelShape)ourShape, (VoxelShape)(neighborShape = neighbor.getShape((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO).getFaceShape(side.getOpposite())), (BooleanOp)BooleanOp.NOT_SAME);
            Map<Pair<BlockState, BlockState>, Boolean[]> map2 = cache;
            synchronized (map2) {
                booleans[side.ordinal()] = shouldHideFace;
            }
        }
        return booleans[side.ordinal()];
    }
}

