/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomItemRenderer;
import com.supermartijn642.rechiseled.ChiselItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ChiselItemRenderer
implements CustomItemRenderer {
    private static final ThreadLocal<Boolean> RECURSION_GUARD = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        ChiselItemRenderer.renderChisel(stack, transformType, poseStack, bufferSource, combinedLight, combinedOverlay);
        if (transformType == ItemDisplayContext.GUI) {
            if (RECURSION_GUARD.get() != null) {
                return;
            }
            ItemStack storedStack = ChiselItem.getStoredStack(stack);
            if (!storedStack.isEmpty()) {
                poseStack.pushPose();
                poseStack.translate(0.25, 0.75, 1.0);
                poseStack.scale(0.5f, 0.5f, 0.5f);
                RECURSION_GUARD.set(true);
                try {
                    ClientUtils.getItemRenderer().renderStatic(storedStack, ItemDisplayContext.GUI, combinedLight, combinedOverlay, poseStack, bufferSource, null, 0);
                }
                finally {
                    RECURSION_GUARD.remove();
                }
                poseStack.popPose();
            }
        }
    }

    private static void renderChisel(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        ItemRenderer renderer = ClientUtils.getItemRenderer();
        BakedModel model = renderer.getModel(stack, null, null, 0);
        for (BakedModel subModel : model.getRenderPasses(stack, true)) {
            for (RenderType renderType : subModel.getRenderTypes(stack, true)) {
                VertexConsumer vertexConsumer = ItemRenderer.getFoilBuffer((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)true, (boolean)stack.hasFoil());
                renderer.renderModelLists(subModel, stack, combinedLight, combinedOverlay, poseStack, vertexConsumer);
            }
        }
    }
}

