/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.rechiseled.ChiselItem;
import com.supermartijn642.rechiseled.Rechiseled;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ChiselItemHighlighter {
    public static void registerListeners() {
        NeoForge.EVENT_BUS.addListener(e -> {
            if (e.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
                ChiselItemHighlighter.renderChiselHighlight((MultiBufferSource)RenderUtils.getMainBufferSource(), e.getPoseStack());
            }
        });
    }

    private static void renderChiselHighlight(MultiBufferSource bufferSource, PoseStack poseStack) {
        HitResult result = ClientUtils.getMinecraft().hitResult;
        if (result == null || result.getType() != HitResult.Type.BLOCK || !(result instanceof BlockHitResult)) {
            return;
        }
        ItemStack chisel = ClientUtils.getPlayer().getMainHandItem();
        if (chisel.getItem() != Rechiseled.chisel) {
            return;
        }
        ItemStack storedStack = ChiselItem.getStoredStack(chisel);
        Level level = ClientUtils.getWorld();
        boolean isShiftDown = ClientUtils.getMinecraft().options.keyShift.isDown();
        List<Pair<BlockPos, BlockState>> chiselableBlocks = ChiselItem.findChiselableBlocks(level, ((BlockHitResult)result).getBlockPos(), ((BlockHitResult)result).getDirection(), storedStack, isShiftDown);
        if (chiselableBlocks.isEmpty()) {
            return;
        }
        BlockShape shape = BlockShape.empty();
        for (Pair<BlockPos, BlockState> pair : chiselableBlocks) {
            BlockState state = (BlockState)pair.right();
            BlockPos pos = (BlockPos)pair.left();
            shape = BlockShape.or((BlockShape)BlockShape.create((VoxelShape)state.getShape((BlockGetter)level, pos)).offset(pos), (BlockShape[])new BlockShape[]{shape});
        }
        if (shape.isEmpty()) {
            return;
        }
        Vec3 camera = RenderUtils.getCameraPosition();
        poseStack.pushPose();
        poseStack.translate(-camera.x, -camera.y, -camera.z);
        RenderUtils.renderShape((PoseStack)poseStack, (BlockShape)shape, (float)1.0f, (float)1.0f, (float)1.0f, (boolean)false);
        poseStack.popPose();
    }
}

