/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.globalxp.xpblock.client;

import bl4ckscor3.mod.globalxp.Configuration;
import bl4ckscor3.mod.globalxp.xpblock.XPBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;

public class XPBlockEntityRenderer
implements BlockEntityRenderer<XPBlockEntity> {
    private ItemStack emerald = new ItemStack((ItemLike)Items.EMERALD, 1);

    public XPBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(XPBlockEntity be, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        HitResult hitResult;
        if (be == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        poseStack.pushPose();
        if (be.getBlockPos() != null && (hitResult = mc.hitResult) instanceof BlockHitResult) {
            BlockHitResult hitResult2 = (BlockHitResult)hitResult;
            if (be.getBlockPos().equals((Object)hitResult2.getBlockPos())) {
                double y = 1.5;
                if (((Boolean)Configuration.CLIENT.renderXPInfo.get()).booleanValue()) {
                    this.renderTextAboveBlock(mc, poseStack, buffer, combinedLight, (Component)Component.literal((String)((int)be.getStoredLevels() + " (" + be.getStoredXP() + ")")), y);
                    y += 0.25;
                }
                if (be.hasCustomName() && ((Boolean)Configuration.CLIENT.renderCustomName.get()).booleanValue()) {
                    this.renderTextAboveBlock(mc, poseStack, buffer, combinedLight, be.getCustomName(), y);
                }
            }
        }
        float time = (float)be.getLevel().getLevelData().getGameTime() + partialTicks;
        double offset = Math.sin((double)time * (Double)Configuration.CLIENT.bobSpeed.get() / 8.0) / 10.0;
        BakedModel model = mc.getItemRenderer().getModel(this.emerald, be.getLevel(), null, 0);
        poseStack.translate(0.5, 0.4 + offset, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(time * 4.0f * ((Double)Configuration.CLIENT.spinSpeed.get()).floatValue()));
        mc.getItemRenderer().render(this.emerald, ItemDisplayContext.GROUND, false, poseStack, buffer, combinedLight, combinedOverlay, model);
        poseStack.popPose();
    }

    public void renderTextAboveBlock(Minecraft mc, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, Component text, double y) {
        float opacity = mc.options.getBackgroundOpacity(0.25f);
        int backgroundColor = (int)(opacity * 255.0f) << 24;
        float halfWidth = -mc.font.width((FormattedText)text) / 2;
        poseStack.pushPose();
        poseStack.translate(0.5, y, 0.5);
        poseStack.mulPose(mc.getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f positionMatrix = poseStack.last().pose();
        mc.font.drawInBatch(text, halfWidth, 0.0f, 0x20FFFFFF, false, positionMatrix, buffer, Font.DisplayMode.SEE_THROUGH, backgroundColor, combinedLight);
        mc.font.drawInBatch(text, halfWidth, 0.0f, -1, false, positionMatrix, buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
        poseStack.popPose();
    }
}

