/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.globalxp.xpblock;

import bl4ckscor3.mod.globalxp.Configuration;
import bl4ckscor3.mod.globalxp.GlobalXP;
import bl4ckscor3.mod.globalxp.XPUtils;
import bl4ckscor3.mod.globalxp.xpblock.XPBlock;
import com.google.common.math.IntMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class XPBlockEntity
extends BlockEntity
implements Nameable {
    private Component name;
    private int storedXP = 0;
    private float storedLevels = 0.0f;
    private boolean destroyedByCreativePlayer;

    public XPBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)GlobalXP.XP_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public int addXP(int amount) {
        int space = Integer.MAX_VALUE - this.storedXP;
        this.storedXP = IntMath.saturatedAdd((int)this.storedXP, (int)amount);
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        if (amount > space) {
            return amount - space;
        }
        return 0;
    }

    public int removeXP(int amount) {
        int amountRemoved = Math.min(amount, this.storedXP);
        if (amountRemoved <= 0) {
            return 0;
        }
        this.storedXP -= amountRemoved;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        return amountRemoved;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveCustomOnly(lookupProvider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setStoredXP(int xp) {
        this.storedXP = xp;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public int getStoredXP() {
        return this.storedXP;
    }

    public float getStoredLevels() {
        return this.storedLevels;
    }

    public void setDestroyedByCreativePlayer(boolean destroyedByCreativePlayer) {
        this.destroyedByCreativePlayer = destroyedByCreativePlayer;
    }

    public boolean isDestroyedByCreativePlayer() {
        return this.destroyedByCreativePlayer;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        tag.putInt("stored_xp", this.storedXP);
        if (this.name != null) {
            tag.putString("CustomName", Component.Serializer.toJson((Component)this.name, (HolderLookup.Provider)lookupProvider));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.setStoredXP(tag.getInt("stored_xp"));
        if (tag.contains("CustomName", 8)) {
            this.name = XPBlockEntity.parseCustomNameSafe((String)tag.getString("CustomName"), (HolderLookup.Provider)lookupProvider);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.name = (Component)input.get(DataComponents.CUSTOM_NAME);
        this.setStoredXP((Integer)input.get(GlobalXP.STORED_XP));
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        tag.remove("CustomName");
        tag.remove("stored_xp");
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.name);
        builder.set(GlobalXP.STORED_XP, (Object)this.storedXP);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, XPBlockEntity be) {
        if (level.getGameTime() % 5L == 0L && ((Boolean)Configuration.SERVER.pickupXP.get()).booleanValue() && !((Boolean)state.getValue((Property)XPBlock.POWERED)).booleanValue()) {
            be.pickupDroppedXP();
        }
    }

    private void pickupDroppedXP() {
        for (ExperienceOrb orb : this.level.getEntitiesOfClass(ExperienceOrb.class, this.getPickupArea(), EntitySelector.ENTITY_STILL_ALIVE.and(e -> !e.getPersistentData().getBoolean("GlobalXPMarker")))) {
            int amount = orb.getValue();
            if (this.getStoredXP() + amount > this.getCapacity()) continue;
            int unused = this.addXP(amount);
            orb.discard();
            if (unused <= 0) continue;
            this.level.addFreshEntity((Entity)new ExperienceOrb(this.level, orb.getX(), orb.getY(), orb.getZ(), unused));
        }
    }

    private AABB getPickupArea() {
        double x = (double)this.getBlockPos().getX() + 0.5;
        double y = (double)this.getBlockPos().getY() + 0.5;
        double z = (double)this.getBlockPos().getZ() + 0.5;
        double range = (Double)Configuration.SERVER.pickupRange.get() + 0.5;
        return new AABB(x - range, y - range, z - range, x + range, y + range, z + range);
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getCustomName() {
        return this.name;
    }

    public Component getDefaultName() {
        return Component.translatable((String)((XPBlock)((Object)GlobalXP.XP_BLOCK.get())).getDescriptionId());
    }
}

