/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.globalxp.xpblock;

import bl4ckscor3.mod.globalxp.Configuration;
import bl4ckscor3.mod.globalxp.GlobalXP;
import bl4ckscor3.mod.globalxp.openmods.utils.EnchantmentUtils;
import bl4ckscor3.mod.globalxp.xpblock.XPBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;

public class XPBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Block.box((double)1.0E-4, (double)1.0E-4, (double)1.0E-4, (double)15.999, (double)15.999, (double)15.999);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public XPBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof XPBlockEntity) {
            XPBlockEntity xpBlock = (XPBlockEntity)blockEntity;
            if (!level.isClientSide) {
                if (player.isShiftKeyDown()) {
                    int xpToStore = 0;
                    if ((Integer)Configuration.SERVER.storingAmount.get() != -1) {
                        xpToStore = Math.min((Integer)Configuration.SERVER.storingAmount.get(), EnchantmentUtils.getPlayerXP(player));
                    } else if (((Boolean)Configuration.SERVER.storeUntilPreviousLevel.get()).booleanValue()) {
                        int xpForCurrentLevel = EnchantmentUtils.getExperienceForLevel(player.experienceLevel);
                        xpToStore = EnchantmentUtils.getPlayerXP(player) - xpForCurrentLevel;
                        if (xpToStore == 0 && player.experienceLevel > 0) {
                            xpToStore = xpForCurrentLevel - EnchantmentUtils.getExperienceForLevel(player.experienceLevel - 1);
                        }
                    } else {
                        xpToStore = EnchantmentUtils.getPlayerXP(player);
                    }
                    if (xpToStore == 0) {
                        return InteractionResult.PASS;
                    }
                    int unused = xpBlock.addXP(xpToStore);
                    EnchantmentUtils.addPlayerXP(player, -xpToStore + unused);
                    return InteractionResult.SUCCESS;
                }
                if (!player.isShiftKeyDown()) {
                    int xpRetrieved;
                    if ((Integer)Configuration.SERVER.retrievalAmount.get() != -1) {
                        xpRetrieved = (int)((double)xpBlock.removeXP((Integer)Configuration.SERVER.retrievalAmount.get()) * (Double)Configuration.SERVER.retrievalPercentage.get());
                    } else if (((Boolean)Configuration.SERVER.retriveUntilNextLevel.get()).booleanValue()) {
                        int xpToRetrieve = EnchantmentUtils.getExperienceForLevel(player.experienceLevel + 1) - EnchantmentUtils.getPlayerXP(player);
                        xpRetrieved = (int)((double)xpBlock.removeXP(xpToRetrieve) * (Double)Configuration.SERVER.retrievalPercentage.get());
                    } else {
                        xpRetrieved = (int)((double)xpBlock.getStoredXP() * (Double)Configuration.SERVER.retrievalPercentage.get());
                        xpBlock.setStoredXP(0);
                    }
                    if (xpRetrieved > 0) {
                        this.addOrSpawnXPForPlayer(player, xpRetrieved);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void addOrSpawnXPForPlayer(Player player, int amount) {
        if (((Boolean)Configuration.SERVER.retrieveXPOrbs.get()).booleanValue()) {
            Level level = player.level();
            if (!level.isClientSide) {
                ExperienceOrb orb = new ExperienceOrb(level, player.getX(), player.getY(), player.getZ(), amount);
                orb.getPersistentData().putBoolean("GlobalXPMarker", true);
                level.addFreshEntity((Entity)orb);
            }
        } else {
            int previousLevel = player.experienceLevel;
            NeoForge.EVENT_BUS.post((Event)new PlayerXpEvent.XpChange(player, amount));
            EnchantmentUtils.addPlayerXP(player, amount);
            if (previousLevel != player.experienceLevel) {
                NeoForge.EVENT_BUS.post((Event)new PlayerXpEvent.LevelChange(player, player.experienceLevel));
            }
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof XPBlockEntity) {
            XPBlockEntity xpBlock = (XPBlockEntity)blockEntity;
            return Math.min(15, Math.floorDiv(xpBlock.getStoredXP(), (int)((Integer)Configuration.SERVER.xpForComparator.get())));
        }
        return 0;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        XPBlockEntity xpBlock;
        BlockEntity blockEntity;
        if (!level.isClientSide && player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof XPBlockEntity && (xpBlock = (XPBlockEntity)blockEntity).getStoredXP() > 0) {
            ItemStack stack = new ItemStack((ItemLike)GlobalXP.XP_BLOCK_ITEM.get());
            stack.applyComponents(xpBlock.collectComponents());
            ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stack);
            entity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)entity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(level.hasNeighborSignal(pos))));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new XPBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : XPBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)GlobalXP.XP_BLOCK_ENTITY_TYPE.get()), XPBlockEntity::serverTick);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }
}

