/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.globalxp;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Configuration {
    public static final ModConfigSpec SERVER_SPEC;
    public static final Client CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Server SERVER;

    private Configuration() {
    }

    static {
        Pair clientSpecPair = new ModConfigSpec.Builder().configure(Client::new);
        Pair serverSpecPair = new ModConfigSpec.Builder().configure(Server::new);
        CLIENT_SPEC = (ModConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        SERVER_SPEC = (ModConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.DoubleValue spinSpeed;
        public final ModConfigSpec.DoubleValue bobSpeed;
        public final ModConfigSpec.BooleanValue renderXPInfo;
        public final ModConfigSpec.BooleanValue renderCustomName;

        Client(ModConfigSpec.Builder builder) {
            this.spinSpeed = builder.comment("How fast the emerald should spin (multiplier of the default speed)").defineInRange("spinSpeed", 1.0, 0.0, Double.MAX_VALUE);
            this.bobSpeed = builder.comment("How fast the emerald should bob up and down (multiplier of the default speed)").defineInRange("bobSpeed", 1.0, 0.0, Double.MAX_VALUE);
            this.renderXPInfo = builder.comment("Whether info about the saved levels should be shown above the XP Block").define("renderXPInfo", true);
            this.renderCustomName = builder.comment("Whether the block's custom name should be shown above the XP Block").define("renderCustomName", true);
        }
    }

    public static class Server {
        public final ModConfigSpec.IntValue xpForComparator;
        public final ModConfigSpec.BooleanValue pickupXP;
        public final ModConfigSpec.DoubleValue pickupRange;
        public final ModConfigSpec.BooleanValue retriveUntilNextLevel;
        public final ModConfigSpec.IntValue retrievalAmount;
        public final ModConfigSpec.BooleanValue storeUntilPreviousLevel;
        public final ModConfigSpec.IntValue storingAmount;
        public final ModConfigSpec.DoubleValue retrievalPercentage;
        public final ModConfigSpec.BooleanValue retrieveXPOrbs;

        Server(ModConfigSpec.Builder builder) {
            this.xpForComparator = builder.comment("The amount of XP needed for the comparator to output a redstone signal of strength one. By default, the signal will be at full strength if the block has 30 levels stored.").defineInRange("xpForComparator", 93, 0, 0x8888888);
            this.pickupXP = builder.comment("Whether the XP Block will pickup any XP orbs around it").define("pickupXP", true);
            this.pickupRange = builder.comment("The range in blocks around the XP Block in which XP orbs will be picked up").defineInRange("pickupRange", 3.0, 0.0, 50.0);
            this.retriveUntilNextLevel = builder.comment("Setting this to true will remove only as much XP from the block at a time as is needed for the player to reach their next level. Setting to false will retrieve all stored XP at once.").define("retrieve_until_next_level", true);
            this.retrievalAmount = builder.comment(new String[]{"Sets the amount of XP points that will be removed from the XP Block and added to the player's XP bar when the player interacts with the block", "If this is set to anything other than -1, this setting will override the \"retrieve_until_next_level\" configuration setting.", "As such, setting this to 0 will disable XP retrieval, and setting to -1 will make the XP Block ignore this setting."}).defineInRange("retrieval_amount", -1, -1, Integer.MAX_VALUE);
            this.storeUntilPreviousLevel = builder.comment("Setting this to true will store only as much XP from the player's XP bar until reaching the previous level, meaning only one level at maximum will be added to the block's storage at a time. Setting to false will store all the XP the player has.").define("store_until_previous_level", false);
            this.storingAmount = builder.comment(new String[]{"Sets the amount of XP points that will be removed from the player's XP bar and stored in the XP Block when the player interacts with it.", "If this is set to anything other than -1, this setting will override the \"store_until_previous_level\" configuration setting.", "As such, setting this to 0 will disable adding XP to the block, and setting to -1 will make the XP Block ignore this setting."}).defineInRange("storing_amount", -1, -1, Integer.MAX_VALUE);
            this.retrievalPercentage = builder.comment(new String[]{"The percentage of XP that the XP Block will give back, as a sort of cost of using it.", "Example: If this config value is set to 0.75, and an XP Block has 100 XP stored, attempting to retrieve these 100 XP will give back 75 XP.", "Note: This will not be 100% accurate, as Minecraft's XP does not use decimals."}).defineInRange("retrieval_percentage", 1.0, 0.0, 1.0);
            this.retrieveXPOrbs = builder.comment(new String[]{"Setting this to true will remove XP from the block in XP orb form. This is useful if you want to use XP from the block for tools enchanted with Mending.", "These XP orbs will not be picked back up by the XP Block, if \"pickupXP\" is true."}).define("retrieve_xp_orbs", false);
        }
    }
}

