/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractModonomiconLanguageProvider
implements ModonomiconLanguageProvider,
DataProvider {
    protected final Map<String, String> data = new Object2ObjectOpenHashMap();
    protected final PackOutput output;
    protected final String modId;
    protected final String locale;
    private final ModonomiconLanguageProvider cachedProvider;

    public AbstractModonomiconLanguageProvider(PackOutput output, String modId, String locale, ModonomiconLanguageProvider cachedProvider) {
        this.output = output;
        this.modId = modId;
        this.locale = locale;
        this.cachedProvider = cachedProvider;
    }

    public AbstractModonomiconLanguageProvider(PackOutput output, String modId, String locale) {
        this(output, modId, locale, null);
    }

    protected abstract void addTranslations();

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        this.addTranslations();
        if (this.cachedProvider != null) {
            this.cachedProvider.data(this.data::put);
        }
        if (!this.data.isEmpty()) {
            return this.save(cache, this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve(this.modId).resolve("lang").resolve(this.locale + ".json"));
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    @NotNull
    public String getName() {
        return "Languages: " + this.locale;
    }

    private CompletableFuture<?> save(CachedOutput cache, Path target) {
        JsonObject json = new JsonObject();
        this.data.forEach((arg_0, arg_1) -> ((JsonObject)json).addProperty(arg_0, arg_1));
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)target);
    }

    @Override
    @NotNull
    public Map<String, String> data() {
        return this.data;
    }

    @Override
    public void accept(String key, String value) {
        if (this.data.put(key, value) != null) {
            throw new IllegalStateException("Duplicate translation key " + key);
        }
    }
}

