/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.sgearmetalworks.datagen.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.sgearmetalworks.registry.SGearMetalworksRegistrator;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.silentchaos512.gear.setup.SgDataComponents;

public class GearComponentIngredient
extends DataComponentIngredient {
    public static final MapCodec<GearComponentIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.create((ResourceKey)Registries.ITEM, (Codec)BuiltInRegistries.ITEM.holderByNameCodec(), (boolean)false).fieldOf("items").forGetter(DataComponentIngredient::items), (App)DataComponentPredicate.CODEC.fieldOf("components").forGetter(DataComponentIngredient::components)).apply((Applicative)builder, GearComponentIngredient::new));

    public GearComponentIngredient(HolderSet<Item> items, DataComponentPredicate components) {
        super(items, components, false);
    }

    public IngredientType<?> getType() {
        return (IngredientType)SGearMetalworksRegistrator.GEAR_INGREDIENT_TYPE.get();
    }

    public static Ingredient of(ItemStack stack) {
        DataComponentMap.Builder builder = DataComponentMap.builder();
        if (stack.has(SgDataComponents.MATERIAL_LIST)) {
            builder.set(SgDataComponents.MATERIAL_LIST, (Object)((List)stack.get(SgDataComponents.MATERIAL_LIST)));
        }
        return GearComponentIngredient.of(DataComponentPredicate.allOf((DataComponentMap)builder.build()), new ItemLike[]{stack.getItem()});
    }

    public static Ingredient of(DataComponentPredicate predicate, ItemLike ... items) {
        return GearComponentIngredient.of(predicate, (HolderSet<Item>)HolderSet.direct(Arrays.stream(items).map(ItemLike::asItem).map(Item::builtInRegistryHolder).toList()));
    }

    public static Ingredient of(DataComponentPredicate predicate, HolderSet<Item> items) {
        return new GearComponentIngredient(items, predicate).toVanilla();
    }
}

