/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.sensor;

import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineWriter;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.sensor.TurbineSensorType;
import it.zerono.mods.zerocore.base.redstone.sensor.AbstractSensorSetting;
import it.zerono.mods.zerocore.base.redstone.sensor.SensorBehavior;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import net.minecraft.nbt.CompoundTag;

public class TurbineSensorSetting
extends AbstractSensorSetting<ITurbineReader, ITurbineWriter, TurbineSensorType, TurbineSensorSetting> {
    public static final TurbineSensorSetting DISABLED = new TurbineSensorSetting();

    public TurbineSensorSetting(TurbineSensorType sensor, SensorBehavior behavior, int v1, int v2) {
        super((Enum)sensor, behavior, v1, v2);
    }

    public static TurbineSensorSetting syncDataFrom(CompoundTag data) {
        try {
            return new TurbineSensorSetting(data);
        }
        catch (IllegalArgumentException ex) {
            Log.LOGGER.error("Invalid NBT data while reading a TurbineSensorSetting");
            return DISABLED;
        }
    }

    public CompoundTag syncDataTo(CompoundTag data) {
        return super.syncDataTo(NBTHelper.nbtSetEnum((CompoundTag)data, (String)"sensor", (Enum)((TurbineSensorType)this.Sensor)));
    }

    public void inputAction(ITurbineWriter turbine, boolean isExternallyPowered, int externalPowerLevel) {
        switch ((TurbineSensorType)this.Sensor) {
            case inputActive: {
                this.acceptInputActive(turbine, isExternallyPowered);
                break;
            }
            case inputEngageCoils: {
                this.acceptInputEngageCoils(turbine, isExternallyPowered);
                break;
            }
            case inputFlowRegulator: {
                this.acceptInputFlowRegulator(turbine, isExternallyPowered, externalPowerLevel);
            }
        }
    }

    public TurbineSensorSetting copy() {
        return new TurbineSensorSetting((TurbineSensorType)this.Sensor, this.Behavior, this.Value1, this.Value2);
    }

    public boolean equals(Object other) {
        if (other instanceof TurbineSensorSetting) {
            TurbineSensorSetting s = (TurbineSensorSetting)((Object)other);
            return this == s || this.Sensor == s.Sensor && this.Behavior == s.Behavior && this.Value1 == s.Value1 && this.Value2 == s.Value2;
        }
        return false;
    }

    private TurbineSensorSetting() {
        this(TurbineSensorType.Disabled, SensorBehavior.Disabled, 0, 0);
    }

    protected TurbineSensorSetting(CompoundTag data) throws IllegalArgumentException {
        super(data, TurbineSensorSetting::readSensorTypeFrom);
    }

    private static TurbineSensorType readSensorTypeFrom(CompoundTag data) {
        if (!data.contains("sensor")) {
            throw new IllegalArgumentException("Invalid NBT data");
        }
        return (TurbineSensorType)NBTHelper.nbtGetEnum((CompoundTag)data, (String)"sensor", TurbineSensorType::valueOf, (Enum)TurbineSensorType.Disabled);
    }

    private void acceptInputActive(ITurbineWriter turbine, Boolean isExternallyPowered) {
        switch (this.Behavior) {
            case SetFromSignal: {
                turbine.setMachineActive(isExternallyPowered);
                break;
            }
            case ToggleOnPulse: {
                if (!isExternallyPowered.booleanValue()) break;
                turbine.toggleMachineActive();
            }
        }
    }

    private void acceptInputEngageCoils(ITurbineWriter turbine, Boolean isExternallyPowered) {
        switch (this.Behavior) {
            case SetFromSignal: {
                turbine.setInductorEngaged(isExternallyPowered);
                break;
            }
            case ToggleOnPulse: {
                if (!isExternallyPowered.booleanValue()) break;
                turbine.setInductorEngaged(!turbine.isInductorEngaged());
            }
        }
    }

    private void acceptInputFlowRegulator(ITurbineWriter turbine, Boolean isExternallyPowered, int externalPowerLevel) {
        switch (this.Behavior) {
            case SetFromSignal: {
                turbine.setMaxIntakeRate(isExternallyPowered != false ? this.Value1 : this.Value2);
                break;
            }
            case SetFromSignalLevel: {
                turbine.setMaxIntakeRatePercentage(isExternallyPowered != false ? (int)((double)externalPowerLevel / 15.0 * 100.0) : 0);
                break;
            }
            case SetOnPulse: {
                turbine.setMaxIntakeRate(this.Value1);
                break;
            }
            case AugmentOnPulse: {
                turbine.changeMaxIntakeRate(this.Value1);
                break;
            }
            case ReduceOnPulse: {
                turbine.changeMaxIntakeRate(-this.Value1);
            }
        }
    }
}

