/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorBladeState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorComponentType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorShaftState;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.zerocore.base.multiblock.part.GenericDeviceBlock;
import it.zerono.mods.zerocore.base.multiblock.part.INeverCauseRenderingSkip;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class TurbineRotorComponentBlock
extends GenericDeviceBlock<MultiblockTurbine, ITurbinePartType>
implements INeighborChangeListener.Notifier,
INeverCauseRenderingSkip {
    public static final EnumProperty<RotorShaftState> ROTOR_SHAFT_STATE = EnumProperty.create((String)"state", RotorShaftState.class);
    public static final EnumProperty<RotorBladeState> ROTOR_BLADE_STATE = EnumProperty.create((String)"state", RotorBladeState.class);
    private Component _bladeTooltipInfo;

    public static TurbineRotorComponentBlock shaft(MultiblockPartBlock.MultiblockPartProperties<ITurbinePartType> properties) {
        return new TurbineRotorComponentBlock((MultiblockPartBlock.MultiblockPartProperties)properties){

            @Override
            public boolean isShaft() {
                return true;
            }

            @Override
            public boolean isBlade() {
                return false;
            }

            @Override
            public RotorComponentType getComponentType() {
                return RotorComponentType.Shaft;
            }

            protected void buildBlockState(StateDefinition.Builder<Block, BlockState> builder) {
                super.buildBlockState(builder);
                builder.add(new Property[]{ROTOR_SHAFT_STATE});
            }

            protected BlockState buildDefaultState(BlockState state) {
                return (BlockState)super.buildDefaultState(state).setValue((Property)ROTOR_SHAFT_STATE, (Comparable)((Object)RotorShaftState.getDefault()));
            }
        };
    }

    public static TurbineRotorComponentBlock blade(MultiblockPartBlock.MultiblockPartProperties<ITurbinePartType> properties) {
        return new TurbineRotorComponentBlock((MultiblockPartBlock.MultiblockPartProperties)properties){

            @Override
            public boolean isShaft() {
                return false;
            }

            @Override
            public boolean isBlade() {
                return true;
            }

            @Override
            public RotorComponentType getComponentType() {
                return RotorComponentType.Blade;
            }

            protected void buildBlockState(StateDefinition.Builder<Block, BlockState> builder) {
                super.buildBlockState(builder);
                builder.add(new Property[]{ROTOR_BLADE_STATE});
            }

            protected BlockState buildDefaultState(BlockState state) {
                return (BlockState)super.buildDefaultState(state).setValue((Property)ROTOR_BLADE_STATE, (Comparable)((Object)RotorBladeState.getDefault()));
            }
        };
    }

    public abstract boolean isShaft();

    public abstract boolean isBlade();

    public abstract RotorComponentType getComponentType();

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return this == adjacentBlockState.getBlock();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (this.isBlade()) {
            if (null == this._bladeTooltipInfo) {
                this._bladeTooltipInfo = this.getMultiblockVariant().filter(v -> v instanceof IMultiblockTurbineVariant).map(v -> (IMultiblockTurbineVariant)v).map(variant -> Component.translatable((String)"gui.bigreactors.turbine.controller.rotorstatus.tooltip.value2", (Object[])new Object[]{String.format(String.valueOf(ChatFormatting.DARK_AQUA) + String.valueOf(ChatFormatting.BOLD) + "%d", variant.getBaseFluidPerBlade())}).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true)))).orElse(CodeHelper.TEXT_EMPTY_LINE);
            }
            tooltip.add(this._bladeTooltipInfo);
        }
    }

    protected TurbineRotorComponentBlock(MultiblockPartBlock.MultiblockPartProperties<ITurbinePartType> properties) {
        super(properties);
    }
}

