/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.turbine.CoilMaterial;
import it.zerono.mods.extremereactors.api.turbine.CoilMaterialRegistry;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.AbstractFluidGeneratorMultiblockController;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.FluidContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.FluidType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.IFluidContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.IFluidContainerAccess;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineEnvironment;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineMachine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineWriter;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.RpmUpdateTracker;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbineData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbineLogic;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.VentSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineCasingEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineChargingPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineFluidPortEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineGlassEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbinePowerTapEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorBearingEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorComponentBlock;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorComponentEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.rotor.RotorComponentType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPortHandler;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.AllowedHandlerAction;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.WideEnergyBuffer;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.ITickableMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class MultiblockTurbine
extends AbstractFluidGeneratorMultiblockController<MultiblockTurbine, IMultiblockTurbineVariant>
implements ITurbineMachine,
ITurbineEnvironment,
ITurbineWriter,
IDebuggable {
    private static final IFluidContainerAccess FLUID_CONTAINER_ACCESS = new IFluidContainerAccess(){

        @Override
        public AllowedHandlerAction getAllowedActionFor(FluidType fluidType) {
            switch (fluidType) {
                default: {
                    return AllowedHandlerAction.InsertOnly;
                }
                case Liquid: 
            }
            return AllowedHandlerAction.ExtractOnly;
        }

        @Override
        public FluidType getFluidTypeFrom(IoDirection portDirection) {
            switch (portDirection) {
                default: {
                    return FluidType.Gas;
                }
                case Output: 
            }
            return FluidType.Liquid;
        }
    };
    private final TurbineData _data;
    private final TurbineLogic _logic;
    private final IMultiblockTurbineVariant _variant;
    private final FluidContainer _fluidContainer;
    private final RpmUpdateTracker _rpmUpdateTracker;
    private final Set<ITickableMultiblockPart> _attachedTickables;
    private final List<TurbineRotorBearingEntity> _attachedRotorBearings;
    private final Set<TurbineRotorComponentEntity> _attachedRotorComponents;
    private final Set<IPowerPort> _attachedPowerTaps;
    private final Set<TurbineFluidPortEntity> _attachedFluidPorts;
    private final List<TurbineFluidPortEntity> _attachedOutputFluidPorts;
    private final List<TurbineFluidPortEntity> _attachedInputFluidPorts;
    private int _rotorBladesCount;
    private final Set<BlockPos> _validationFoundCoils;

    public MultiblockTurbine(Level world, IMultiblockTurbineVariant variant) {
        super(world);
        this._variant = variant;
        this._data = new TurbineData(variant);
        this._fluidContainer = new FluidContainer(FLUID_CONTAINER_ACCESS);
        this._rpmUpdateTracker = new RpmUpdateTracker(100, 5, 10.0f, 100.0f);
        this._attachedTickables = Sets.newHashSet();
        this._attachedRotorBearings = Lists.newLinkedList();
        this._attachedPowerTaps = Sets.newHashSet();
        this._attachedRotorComponents = Sets.newHashSet();
        this._rotorBladesCount = 0;
        this._attachedFluidPorts = Sets.newHashSet();
        this._attachedOutputFluidPorts = Lists.newLinkedList();
        this._attachedInputFluidPorts = Lists.newLinkedList();
        this._validationFoundCoils = Sets.newHashSet();
        this._logic = new TurbineLogic(this, this._data, this.getEnergyBuffer());
    }

    public static double getAdjustedPowerProductionMultiplier() {
        return (Double)Config.COMMON.general.powerProductionMultiplier.get() * (Double)Config.COMMON.turbine.turbinePowerProductionMultiplier.get();
    }

    public void reset() {
        this.setMachineActive(false);
        this._fluidContainer.reset();
        this._data.reset();
        this.getEnergyBuffer().empty();
        this.resizeFluidContainer();
    }

    public void onFluidPortChanged() {
        this.rebuildFluidPortsSubsets();
    }

    @Override
    public Optional<IFluidHandler> getLiquidHandler() {
        return this.getFluidHandler(IoDirection.Output);
    }

    @Override
    public Optional<IFluidHandler> getGasHandler() {
        return this.getFluidHandler(IoDirection.Input);
    }

    @Override
    public Optional<IFluidHandler> getFluidHandler(IoDirection portDirection) {
        return Optional.of(this._fluidContainer.getWrapper(portDirection));
    }

    public void setMachineActive(boolean active) {
        if (this.isMachineActive() == active) {
            return;
        }
        this._active = active;
        if (active) {
            this.forEachConnectedParts(IMultiblockPart::onMachineActivated);
        } else {
            this.forEachConnectedParts(IMultiblockPart::onMachineDeactivated);
        }
        this.callOnLogicalServer(() -> this.markReferenceCoordForUpdate());
    }

    @Override
    public ITurbineEnvironment getEnvironment() {
        return this;
    }

    @Override
    public IFluidContainer getFluidContainer() {
        return this._fluidContainer;
    }

    @Override
    public void performOutputCycle() {
        ProfilerFiller profiler = this.getWorld().getProfiler();
        profiler.push("Power");
        this.distributeEnergyEqually();
        profiler.popPush("Coolant");
        this.distributeCoolantEqually();
        profiler.pop();
    }

    @Override
    public void performInputCycle() {
        ProfilerFiller profiler = this.getWorld().getProfiler();
        profiler.push("Vapor");
        this.acquireVaporEqually();
        profiler.pop();
    }

    @Override
    public boolean isSimulator() {
        return false;
    }

    @Override
    public Optional<CoilMaterial> getCoilBlock(BlockPos position) {
        return CoilMaterialRegistry.get(WorldHelper.getLoadedBlockStateOrAir((Level)this.getWorld(), (BlockPos)position));
    }

    @Override
    public RotorComponentType getRotorComponentTypeAt(BlockPos position) {
        Level world = this.getWorld();
        BlockState state = WorldHelper.getLoadedBlockStateOrAir((Level)world, (BlockPos)position);
        Block block = state.getBlock();
        if (state.isAir()) {
            return RotorComponentType.Ignore;
        }
        if (block instanceof TurbineRotorComponentBlock) {
            TurbineRotorComponentBlock rotorComponent = (TurbineRotorComponentBlock)block;
            return rotorComponent.getComponentType();
        }
        return RotorComponentType.CandidateCoil;
    }

    @Override
    public boolean isAssembledAndActive() {
        return this.isAssembled() && this.isMachineActive();
    }

    @Override
    public int getCoolantAmount() {
        return this._fluidContainer.getLiquidAmount();
    }

    @Override
    public int getVaporAmount() {
        return this._fluidContainer.getGasAmount();
    }

    @Override
    public int getCapacity() {
        return this._fluidContainer.getCapacity();
    }

    @Override
    public int getMaxIntakeRate() {
        return this._data.getMaxIntakeRate();
    }

    @Override
    public int getMaxIntakeRateHardLimit() {
        return this.getVariant().getMaxPermittedFlow();
    }

    @Override
    public double getEnergyGeneratedLastTick() {
        return this._data.getEnergyGeneratedLastTick();
    }

    @Override
    public int getFluidConsumedLastTick() {
        return this._data.getFluidConsumedLastTick();
    }

    @Override
    public float getRotorEfficiencyLastTick() {
        return this._data.getRotorEfficiencyLastTick();
    }

    @Override
    public float getRotorSpeed() {
        int blades = this.getRotorBladesCount();
        int rotorMass = this.getRotorMass();
        if (blades <= 0 || rotorMass <= 0) {
            return 0.0f;
        }
        return this._data.getRotorEnergy() / (float)(blades * rotorMass);
    }

    @Override
    public int getRotorBladesCount() {
        return this._rotorBladesCount;
    }

    @Override
    public float getMaxRotorSpeed() {
        return this.getVariant().getMaxRotorSpeed();
    }

    @Override
    public int getRotorMass() {
        return this._data.getRotorMass();
    }

    @Override
    public VentSetting getVentSetting() {
        return this._data.getVentSetting();
    }

    @Override
    public boolean isInductorEngaged() {
        return this._data.isInductorEngaged();
    }

    @Override
    public void setMaxIntakeRate(int rate) {
        if (this.isAssembled()) {
            this._data.setMaxIntakeRate(rate);
            this.markReferenceCoordDirty();
        }
    }

    @Override
    public void setMaxIntakeRatePercentage(int percentage) {
        if (this.isAssembled()) {
            this._data.setMaxIntakeRatePercentage(percentage);
            this.markReferenceCoordDirty();
        }
    }

    @Override
    public void changeMaxIntakeRate(int delta) {
        if (this.isAssembled()) {
            this._data.setMaxIntakeRate(this._data.getMaxIntakeRate() + delta);
            this.markReferenceCoordDirty();
        }
    }

    @Override
    public void setVentSetting(VentSetting setting) {
        this._data.setVentSetting(setting);
        this.markReferenceCoordDirty();
    }

    @Override
    public void setInductorEngaged(boolean engaged) {
        if (this.isAssembled()) {
            this._data.setInductorEngaged(engaged);
            this.markReferenceCoordDirty();
        }
    }

    @Override
    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, registries, syncReason);
        if (data.contains("active")) {
            this._active = data.getBoolean("active");
        }
        this.syncChildDataEntityFrom((ISyncableEntity)this._fluidContainer, "fluidcontainer", data, registries, syncReason);
        this.syncChildDataEntityFrom(this._data, "internaldata", data, registries, syncReason);
        if (syncReason.isFullSync()) {
            this._rpmUpdateTracker.setValue(this.getRotorSpeed());
        }
    }

    @Override
    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, registries, syncReason);
        data.putBoolean("active", this.isMachineActive());
        this.syncChildDataEntityTo((ISyncableEntity)this._fluidContainer, "fluidcontainer", data, registries, syncReason);
        this.syncChildDataEntityTo(this._data, "internaldata", data, registries, syncReason);
        return data;
    }

    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        if (!this.isAssembled()) {
            return;
        }
        messages.addUnlocalized("Active: %s", new Object[]{this.isMachineActive()});
        this.getEnergyBuffer().getDebugMessages(side, messages);
        messages.add(side, (IDebuggable)this._data, "Internal data:");
        messages.add(side, (IDebuggable)this._fluidContainer, "Fluids Tanks:");
    }

    protected void markReferenceCoordDirty() {
        this._rpmUpdateTracker.reset();
        super.markReferenceCoordDirty();
    }

    @Override
    public IMultiblockTurbineVariant getVariant() {
        return this._variant;
    }

    protected void sendClientUpdates() {
        this.sendUpdates();
    }

    protected boolean updateServer() {
        ProfilerFiller profiler = this.getWorld().getProfiler();
        profiler.push("Extreme Reactors|Turbine update");
        profiler.push("Input");
        this.performInputCycle();
        profiler.popPush("Generate");
        this._logic.update();
        profiler.popPush("Distribute");
        this.performOutputCycle();
        profiler.popPush("Tickables");
        this._attachedTickables.forEach(ITickableMultiblockPart::onMultiblockServerTick);
        profiler.popPush("Updates");
        this.checkAndSendClientUpdates();
        profiler.popPush("RpmTracker");
        if (this._rpmUpdateTracker.shouldUpdate(this.getRotorSpeed())) {
            this.markReferenceCoordDirty();
        }
        profiler.pop();
        profiler.pop();
        return this._data.getEnergyGeneratedLastTick() > 0.0 || this._data.getFluidConsumedLastTick() > 0;
    }

    public boolean isPartCompatible(IMultiblockPart<MultiblockTurbine> part) {
        return part instanceof AbstractTurbineEntity && ((AbstractTurbineEntity)part).getMultiblockVariant().filter(variant -> this.getVariant() == variant).isPresent();
    }

    protected void onPartAdded(IMultiblockPart<MultiblockTurbine> newPart) {
        if (newPart instanceof ITickableMultiblockPart) {
            this._attachedTickables.add((ITickableMultiblockPart)newPart);
        }
        if (newPart instanceof TurbineRotorBearingEntity) {
            this._attachedRotorBearings.add((TurbineRotorBearingEntity)newPart);
        } else if (newPart instanceof TurbineRotorComponentEntity) {
            this._attachedRotorComponents.add((TurbineRotorComponentEntity)newPart);
        } else if (newPart instanceof TurbinePowerTapEntity || newPart instanceof TurbineChargingPortEntity) {
            this._attachedPowerTaps.add((IPowerPort)newPart);
        } else if (newPart instanceof TurbineFluidPortEntity) {
            this._attachedFluidPorts.add((TurbineFluidPortEntity)newPart);
        }
    }

    protected void onPartRemoved(IMultiblockPart<MultiblockTurbine> oldPart) {
        if (oldPart instanceof ITickableMultiblockPart) {
            this._attachedTickables.remove(oldPart);
        }
        if (oldPart instanceof TurbineRotorBearingEntity) {
            this._attachedRotorBearings.remove(oldPart);
        } else if (oldPart instanceof TurbineRotorComponentEntity) {
            this._attachedRotorComponents.remove(oldPart);
        } else if (oldPart instanceof TurbinePowerTapEntity || oldPart instanceof TurbineChargingPortEntity) {
            this._attachedPowerTaps.remove(oldPart);
        } else if (oldPart instanceof TurbineFluidPortEntity) {
            this._attachedFluidPorts.remove(oldPart);
        }
    }

    protected void onMachineAssembled() {
        if (this._attachedPowerTaps.isEmpty()) {
            this.setOutputEnergySystem(INTERNAL_ENERGY_SYSTEM);
        } else {
            CodeHelper.optionalIfPresentOrThrow(this._attachedPowerTaps.stream().map(IPowerPort::getPowerPortHandler).map(IPowerPortHandler::getEnergySystem).findFirst(), x$0 -> this.setOutputEnergySystem((EnergySystem)x$0));
        }
        this._rotorBladesCount = (int)this._attachedRotorComponents.stream().filter(c -> c.isTypeOfPart((IMultiblockPartType)TurbinePartType.RotorBlade)).count();
        this.setInteriorInvisible(!this.isAnyPartConnected(part -> part instanceof TurbineGlassEntity));
        this.rebuildFluidPortsSubsets();
        this.getEnergyBuffer().setCapacity(WideAmount.from((double)((double)((long)this.getVariant().getPartEnergyCapacity() * (long)this.getPartsCount()) * MultiblockTurbine.getAdjustedPowerProductionMultiplier())));
        this.getEnergyBuffer().setMaxExtract(this.getVariant().getMaxEnergyExtractionRate());
        this.resizeFluidContainer();
        this.updateRotorAndCoilsParameters();
        this.callOnLogicalSide(() -> this.markReferenceCoordForUpdate(), () -> this.markMultiblockForRenderUpdate());
    }

    protected void onMachineDisassembled() {
        this._data.onTurbineDisassembled();
        this._rpmUpdateTracker.setValue(0.0f);
        if (this.calledByLogicalClient()) {
            this.markMultiblockForRenderUpdate();
        }
    }

    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this._attachedRotorBearings.size() != 1) {
            validatorCallback.setLastError("multiblock.validation.turbine.invalid_rotor_count", new Object[0]);
            return false;
        }
        if (!this.isAnyPartConnected(part -> part instanceof TurbineControllerEntity)) {
            validatorCallback.setLastError("multiblock.validation.turbine.too_few_controllers", new Object[0]);
            return false;
        }
        if (!super.isMachineWhole(validatorCallback)) {
            return false;
        }
        if (!this.validateRotor(this._attachedRotorBearings.get(0), validatorCallback)) {
            return false;
        }
        return this.validateEnergySystems(validatorCallback);
    }

    protected boolean isBlockGoodForFrame(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockTurbine.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForTop(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockTurbine.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForBottom(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockTurbine.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForSides(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return MultiblockTurbine.invalidBlockForExterior(world, x, y, z, validatorCallback);
    }

    protected boolean isBlockGoodForInterior(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos position = new BlockPos(x, y, z);
        BlockState state = world.getBlockState(position);
        if (state.isAir()) {
            return true;
        }
        if (CoilMaterialRegistry.get(state).isPresent()) {
            this._validationFoundCoils.add(position);
            return true;
        }
        validatorCallback.setLastError(position, "multiblock.validation.turbine.invalid_block_for_interior", new Object[0]);
        return false;
    }

    protected void onAssimilate(IMultiblockController<MultiblockTurbine> assimilated) {
        if (!(assimilated instanceof MultiblockTurbine)) {
            Log.LOGGER.warn(Log.TURBINE, "[{}] Turbine @ {} is attempting to assimilate a non-Turbine machine! That machine's data will be lost!", (Object)CodeHelper.getWorldSideName((Level)this.getWorld()), (Object)this.getReferenceCoord());
            return;
        }
        this._data.onAssimilate(((MultiblockTurbine)assimilated)._data);
    }

    protected void onAssimilated(IMultiblockController<MultiblockTurbine> assimilator) {
        this._attachedTickables.clear();
        this._attachedRotorBearings.clear();
        this._rotorBladesCount = 0;
        this._attachedRotorComponents.clear();
        this._attachedPowerTaps.clear();
        this._attachedFluidPorts.clear();
        this._attachedOutputFluidPorts.clear();
        this._attachedInputFluidPorts.clear();
    }

    private boolean validateRotor(TurbineRotorBearingEntity bearing, IMultiblockValidator validatorCallback) {
        this._validationFoundCoils.clear();
        return (Boolean)this.mapBoundingBoxCoordinates((min, max) -> this.validateRotor(bearing, validatorCallback, bearing.getRotorDirection(), (BlockPos)min, (BlockPos)max), false);
    }

    private boolean validateRotor(TurbineRotorBearingEntity bearing, IMultiblockValidator validatorCallback, Direction rotorDirection, BlockPos turbineMin, BlockPos turbineMax) {
        BlockPos rotorCoord = bearing.getWorldPosition();
        BlockPos endRotorCoord = switch (rotorDirection.getAxis()) {
            case Direction.Axis.X -> rotorCoord.relative(rotorDirection, Math.abs(turbineMax.getX() - turbineMin.getX()) - 1);
            default -> rotorCoord.relative(rotorDirection, Math.abs(turbineMax.getY() - turbineMin.getY()) - 1);
            case Direction.Axis.Z -> rotorCoord.relative(rotorDirection, Math.abs(turbineMax.getZ() - turbineMin.getZ()) - 1);
        };
        Set shaftsPositions = this._attachedRotorComponents.stream().filter(TurbineRotorComponentEntity::isShaft).map(AbstractMultiblockPart::getWorldPosition).collect(Collectors.toSet());
        Set bladesPositions = this._attachedRotorComponents.stream().filter(TurbineRotorComponentEntity::isBlade).map(AbstractMultiblockPart::getWorldPosition).collect(Collectors.toSet());
        Direction.Axis rotatedAxis = rotorDirection.getAxis();
        boolean encounteredCoils = false;
        while (!shaftsPositions.isEmpty() && !rotorCoord.equals((Object)endRotorCoord)) {
            if (!shaftsPositions.remove(rotorCoord = rotorCoord.relative(rotorDirection))) {
                validatorCallback.setLastError(rotorCoord, "multiblock.validation.turbine.block_must_be_rotor", new Object[0]);
                return false;
            }
            boolean encounteredBlades = false;
            for (Direction bladeDirection : CodeHelper.perpendicularDirections((Direction)rotorDirection)) {
                boolean bladeFound = false;
                BlockPos checkCoord = rotorCoord.relative(bladeDirection);
                while (bladesPositions.remove(checkCoord)) {
                    if (encounteredCoils) {
                        validatorCallback.setLastError(checkCoord, "multiblock.validation.turbine.blades_too_far", new Object[0]);
                        return false;
                    }
                    encounteredBlades = true;
                    bladeFound = true;
                    checkCoord = checkCoord.relative(bladeDirection);
                }
                if (bladeFound || !this._validationFoundCoils.remove(checkCoord)) continue;
                encounteredCoils = true;
                if (encounteredBlades) {
                    validatorCallback.setLastError(checkCoord, "multiblock.validation.turbine.metal_too_near", new Object[0]);
                    return false;
                }
                Direction rotatedDir = CodeHelper.directionRotateAround((Direction)bladeDirection, (Direction.Axis)rotatedAxis);
                BlockPos coilCheck = checkCoord.relative(rotatedDir);
                this._validationFoundCoils.remove(coilCheck);
                rotatedDir = CodeHelper.directionRotateAround((Direction)CodeHelper.directionRotateAround((Direction)rotatedDir, (Direction.Axis)rotatedAxis), (Direction.Axis)rotatedAxis);
                coilCheck = checkCoord.relative(rotatedDir);
                this._validationFoundCoils.remove(coilCheck);
            }
        }
        if (!rotorCoord.equals((Object)endRotorCoord)) {
            validatorCallback.setLastError("multiblock.validation.turbine.shaft_too_short", new Object[0]);
            return false;
        }
        if (!shaftsPositions.isEmpty()) {
            validatorCallback.setLastError("multiblock.validation.turbine.found_loose_rotor_blocks", new Object[]{shaftsPositions.size()});
            return false;
        }
        if (!bladesPositions.isEmpty()) {
            validatorCallback.setLastError("multiblock.validation.turbine.found_loose_rotor_blades", new Object[]{bladesPositions.size()});
            return false;
        }
        if (!this._validationFoundCoils.isEmpty()) {
            validatorCallback.setLastError("multiblock.validation.turbine.invalid_metals_shape", new Object[]{this._validationFoundCoils.size()});
            return false;
        }
        if (WorldHelper.getTile((Level)this.getWorld(), (BlockPos)rotorCoord.relative(rotorDirection)).map(te -> te instanceof TurbineCasingEntity).orElse(false).booleanValue()) {
            return true;
        }
        validatorCallback.setLastError("multiblock.validation.turbine.invalid_rotor_end", new Object[0]);
        return false;
    }

    private boolean validateEnergySystems(IMultiblockValidator validatorCallback) {
        if (!this._attachedPowerTaps.isEmpty() && 1L != this._attachedPowerTaps.stream().map(IPowerPort::getPowerPortHandler).map(IPowerPortHandler::getEnergySystem).distinct().limit(2L).count()) {
            validatorCallback.setLastError("multiblock.validation.reactor.mixed_power_systems", new Object[0]);
            return false;
        }
        return true;
    }

    private void distributeEnergyEqually() {
        WideEnergyBuffer energyBuffer = this.getEnergyBuffer();
        WideAmount amountDistributed = MultiblockTurbine.distributeEnergyEqually(energyBuffer.getEnergyStored(), this._attachedPowerTaps);
        if (amountDistributed.greaterThan(WideAmount.ZERO)) {
            energyBuffer.shrink(amountDistributed);
        }
    }

    private void distributeCoolantEqually() {
        int amountDistributed = MultiblockTurbine.distributeFluidEqually((FluidStack)this._fluidContainer.getStackCopy(FluidType.Liquid), this._attachedOutputFluidPorts);
        if (amountDistributed > 0) {
            this._fluidContainer.extract(FluidType.Liquid, amountDistributed, OperationMode.Execute);
        }
    }

    private void acquireVaporEqually() {
        MultiblockTurbine.acquireFluidEqually(this._fluidContainer.getWrapper(IoDirection.Input), this._fluidContainer.getFreeSpace(FluidType.Gas), this._attachedInputFluidPorts);
    }

    private static boolean invalidBlockForExterior(Level world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos position = new BlockPos(x, y, z);
        validatorCallback.setLastError(position, "multiblock.validation.turbine.invalid_block_for_exterior", new Object[]{ModBlock.getNameForTranslation((Block)world.getBlockState(position).getBlock())});
        return false;
    }

    private void updateRotorAndCoilsParameters() {
        this.forBoundingBoxCoordinates((min, max) -> this._data.update(this.getEnvironment(), (BlockPos)min, (BlockPos)max, this.getVariant()), min -> min.offset(1, 1, 1), max -> max.offset(-1, -1, -1));
    }

    private int calculateTurbineVolume() {
        return (Integer)this.mapBoundingBoxCoordinates((min, max) -> CodeHelper.mathVolume((BlockPos)min.offset(1, 1, 1), (BlockPos)max.offset(-1, -1, -1)), 0);
    }

    private void resizeFluidContainer() {
        int outerVolume = (Integer)this.mapBoundingBoxCoordinates(CodeHelper::mathVolume, 0) - this.calculateTurbineVolume();
        this._fluidContainer.setCapacity(Mth.clamp((int)(outerVolume * this.getVariant().getPartFluidCapacity()), (int)0, (int)this.getVariant().getMaxFluidCapacity()));
    }

    private void rebuildFluidPortsSubsets() {
        this._attachedInputFluidPorts.clear();
        this._attachedOutputFluidPorts.clear();
        for (TurbineFluidPortEntity port : this._attachedFluidPorts) {
            if (!port.getFluidPortHandler().isActive()) continue;
            if (port.getIoDirection().isInput()) {
                this._attachedInputFluidPorts.add(port);
                continue;
            }
            this._attachedOutputFluidPorts.add(port);
        }
    }
}

