/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.model;

import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.ClientFuelRodsLayout;
import it.zerono.mods.zerocore.lib.client.model.data.NamedModelProperty;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;

public final class ReactorFuelRodModelData {
    public static final ModelData DEFAULT;
    public static final ModelProperty<Short> REACTANTS_MODEL_KEY;
    public static final ModelProperty<Direction.Axis> ORIENTATION;
    public static final ModelProperty<Boolean> OCCLUDED;
    public static final ModelProperty<Byte> FUEL_LEVEL;
    public static final ModelProperty<Byte> WASTE_LEVEL;
    private static final Short2ObjectMap<ModelData> s_cache;

    public static ModelData from(ClientFuelRodsLayout.FuelData fuelData, boolean rodIsOccluded) {
        return ReactorFuelRodModelData.from(fuelData.getOrientation(), fuelData.getFuelLevel(), fuelData.getWasteLevel(), rodIsOccluded);
    }

    public static short getModelKey(ModelData data) {
        Short v = (Short)data.get(REACTANTS_MODEL_KEY);
        return null != v ? v : (short)0;
    }

    public static Direction.Axis getOrientation(ModelData data) {
        Direction.Axis v = (Direction.Axis)data.get(ORIENTATION);
        return null == v ? Direction.Axis.X : v;
    }

    public static boolean isOccluded(ModelData data) {
        Boolean v = (Boolean)data.get(OCCLUDED);
        return null != v && v != false;
    }

    public static byte getFuelLevel(ModelData data) {
        Byte v = (Byte)data.get(FUEL_LEVEL);
        return null != v ? v : (byte)0;
    }

    public static byte getWasteLevel(ModelData data) {
        Byte v = (Byte)data.get(WASTE_LEVEL);
        return null != v ? v : (byte)0;
    }

    private ReactorFuelRodModelData() {
    }

    private static short createKey(Direction.Axis axis, byte fuelLevel, byte wasteLevel, boolean rodIsOccluded) {
        return (short)((switch (axis) {
            case Direction.Axis.X -> 16384;
            case Direction.Axis.Z -> 49152;
            default -> 0;
        }) | (rodIsOccluded ? 8192 : 0) | fuelLevel << 4 | wasteLevel & 0xF);
    }

    private static ModelData from(Direction.Axis axis, byte fuelLevel, byte wasteLevel, boolean rodIsOccluded) {
        return (ModelData)s_cache.computeIfAbsent(ReactorFuelRodModelData.createKey(axis, fuelLevel, wasteLevel, rodIsOccluded), k -> ModelData.builder().with(REACTANTS_MODEL_KEY, (Object)((short)(k & 0xFF))).with(ORIENTATION, (Object)axis).with(OCCLUDED, (Object)rodIsOccluded).with(FUEL_LEVEL, (Object)fuelLevel).with(WASTE_LEVEL, (Object)wasteLevel).build());
    }

    static {
        REACTANTS_MODEL_KEY = new NamedModelProperty("REACTANTS_MODEL_KEY", Objects::nonNull);
        ORIENTATION = new NamedModelProperty("ORIENTATION", Objects::nonNull);
        OCCLUDED = new NamedModelProperty("OCCLUDED", Objects::nonNull);
        FUEL_LEVEL = new NamedModelProperty("FUEL_LEVEL", Objects::nonNull);
        WASTE_LEVEL = new NamedModelProperty("WASTE_LEVEL", Objects::nonNull);
        s_cache = new Short2ObjectArrayMap(512);
        DEFAULT = ReactorFuelRodModelData.from(Direction.Axis.Y, (byte)0, (byte)0, false);
    }
}

