/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.AbstractFluidizerEntity;
import it.zerono.mods.zerocore.base.BaseHelper;
import it.zerono.mods.zerocore.base.CommonConstants;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.DebuggableHelper;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.data.component.FluidStackListComponent;
import it.zerono.mods.zerocore.lib.data.component.IComponentProvider;
import it.zerono.mods.zerocore.lib.data.nbt.IConditionallySyncableEntity;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.fluid.FluidStackHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.ingredient.RecipeIngredientSourceWrapper;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidizerFluidInjectorEntity
extends AbstractFluidizerEntity
implements MenuProvider,
INeighborChangeListener,
IConditionallySyncableEntity,
IComponentProvider<FluidStackListComponent> {
    public static int MAX_CAPACITY = 8000;
    private static final ResourceLocation SYNC_DATA_ID = ExtremeReactors.ROOT_LOCATION.buildWithSuffix("fluidinjector");
    private final FluidStackHolder _fluids = (FluidStackHolder)((FluidStackHolder)new FluidStackHolder(1, ($, stack) -> this.isValidIngredient((FluidStack)stack)).setOnLoadListener(this::onFluidsChanged)).setOnContentsChangedListener(this::onFluidsChanged);
    private boolean _shouldSync;

    public FluidizerFluidInjectorEntity(BlockPos position, BlockState blockState) {
        super(Content.TileEntityTypes.FLUIDIZER_FLUIDINJECTOR.get(), position, blockState);
        this._fluids.setMaxCapacity(MAX_CAPACITY);
    }

    public IRecipeIngredientSource<FluidStack> asRecipeSource() {
        return RecipeIngredientSourceWrapper.wrap((IFluidHandler)this._fluids, (int)0);
    }

    public IFluidHandler getFluidHandler() {
        return this._fluids;
    }

    public FluidStack getStack() {
        return this._fluids.getStackAt(0);
    }

    public boolean isValidIngredient(FluidStack stack) {
        return (Boolean)this.evalOnController(c -> c.isValidIngredient(stack), false);
    }

    public static void itemTooltipBuilder(ItemStack stack, Item.TooltipContext context, Consumer<@NotNull Component> appender, TooltipFlag flag) {
        FluidStackListComponent component = (FluidStackListComponent)stack.get(FluidStackListComponent.getComponentType());
        if (null != component) {
            MutableComponent text = component.isEmpty(0) ? BaseHelper.emptyValue() : TextHelper.translatable((String)"gui.bigreactors.fluidizer.fluidinjector.component.content", (Object[])new Object[]{FluidHelper.getFluidName((FluidStack)((FluidStack)component.getStack(0))), component.getAmount(0)});
            appender.accept((Component)text.setStyle(CommonConstants.STYLE_TOOLTIP_VALUE));
        }
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return this.isMachineAssembled() && null != this.getNeighborCapability() ? 1 : 0;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        this.requestClientRenderUpdate();
    }

    public void syncDataFrom(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, registries, syncReason);
        this.syncChildDataEntityFrom((ISyncableEntity)this._fluids, "inv", data, registries, syncReason);
        if (syncReason.isFullSync()) {
            this._shouldSync = true;
        }
    }

    public CompoundTag syncDataTo(CompoundTag data, HolderLookup.Provider registries, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, registries, syncReason);
        this.syncChildDataEntityTo((ISyncableEntity)this._fluids, "inv", data, registries, syncReason);
        return data;
    }

    public ResourceLocation getSyncableEntityId() {
        return SYNC_DATA_ID;
    }

    public boolean shouldSyncEntity() {
        boolean result = this._shouldSync;
        this._shouldSync = false;
        return result;
    }

    public FluidStackListComponent createDataComponent() {
        return this._fluids.createDataComponent();
    }

    public void mergeComponent(FluidStackListComponent component) {
        this._fluids.mergeComponent(component);
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        messages.add((Object)this._fluids, DebuggableHelper::getDebugMessagesFor, "Fluids");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return null;
    }

    public Component getDisplayName() {
        return super.getPartDisplayName();
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        FluidStackListComponent component = (FluidStackListComponent)input.get(FluidStackListComponent.getComponentType());
        if (null != component) {
            this.mergeComponent(component);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder collector) {
        collector.set(FluidStackListComponent.getComponentType(), (Object)this.createDataComponent());
    }

    public ItemStack asStorableStack() {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockType());
        stack.set(FluidStackListComponent.getComponentType(), (Object)this.createDataComponent());
        return stack;
    }

    @Nullable
    private IFluidHandler getNeighborCapability() {
        return CodeHelper.optionalMap((Optional)this.getPartWorld(), (Optional)this.getOutwardDirection(), (level, direction) -> (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, this.getWorldPosition().relative(direction), (Object)direction.getOpposite())).orElse(null);
    }

    private void onFluidsChanged() {
        this.onFluidsChanged(IStackHolder.ChangeType.Replaced, 0);
    }

    private void onFluidsChanged(IStackHolder.ChangeType changeType, int slot) {
        this.setChanged();
        this.onIngredientsChanged(changeType);
        this._shouldSync = true;
    }
}

