/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.reactor;

import net.minecraft.util.Mth;

public class Moderator {
    public static final Moderator AIR = new Moderator(0.1f, 0.25f, 1.1f, 0.05f);
    public static final Moderator WATER = new Moderator(0.33f, 0.5f, 1.33f, 0.1f);
    private float _absorption;
    private float _heatEfficiency;
    private float _moderation;
    private float _heatConductivity;

    Moderator(float absorption, float heatEfficiency, float moderation, float heatConductivity) {
        this.setAbsorption(absorption);
        this.setHeatEfficiency(heatEfficiency);
        this.setModeration(moderation);
        this.setHeatConductivity(heatConductivity);
    }

    public float getAbsorption() {
        return this._absorption;
    }

    public void setAbsorption(float value) {
        this._absorption = Mth.clamp((float)value, (float)0.0f, (float)1.0f);
    }

    public float getHeatEfficiency() {
        return this._heatEfficiency;
    }

    public void setHeatEfficiency(float value) {
        this._heatEfficiency = Mth.clamp((float)value, (float)0.0f, (float)1.0f);
    }

    public float getModeration() {
        return this._moderation;
    }

    public void setModeration(float value) {
        this._moderation = Math.max(1.0f, value);
    }

    public float getHeatConductivity() {
        return this._heatConductivity;
    }

    public void setHeatConductivity(float value) {
        this._heatConductivity = Math.max(0.0f, value);
    }
}

