/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors;

import com.mojang.brigadier.CommandDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.command.ExtremeReactorsCommand;
import it.zerono.mods.extremereactors.gamecontent.mekanism.IMekanismService;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.network.UpdateFluidizerFluidStatus;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.network.UpdateClientsFuelRodsLayout;
import it.zerono.mods.extremereactors.proxy.IForgeProxy;
import it.zerono.mods.extremereactors.proxy.IProxy;
import it.zerono.mods.extremereactors.proxy.ServerProxy;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.IFluidPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.IFluidPortHandler;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPortHandler;
import it.zerono.mods.zerocore.lib.compat.SidedDependencyServiceLoader;
import it.zerono.mods.zerocore.lib.compat.computer.IComputerCraftService;
import it.zerono.mods.zerocore.lib.data.ResourceLocationBuilder;
import it.zerono.mods.zerocore.lib.network.AbstractBlockEntityPlayPacket;
import it.zerono.mods.zerocore.lib.network.NetworkHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.Nullable;

@Mod(value="bigreactors")
public class ExtremeReactors {
    public static final String MOD_ID = "bigreactors";
    public static final String MOD_NAME = "Extreme Reactors 2";
    public static ResourceLocationBuilder ROOT_LOCATION = ResourceLocationBuilder.of((String)"bigreactors");
    private static ExtremeReactors s_instance;
    private static SidedDependencyServiceLoader<IProxy> s_proxy;
    private final NetworkHandler _network;

    public static ExtremeReactors getInstance() {
        return s_instance;
    }

    public static IProxy getProxy() {
        return (IProxy)s_proxy.get();
    }

    public ExtremeReactors(IEventBus modBus, ModContainer container, Dist distribution) {
        s_instance = this;
        this._network = new NetworkHandler();
        s_proxy = new SidedDependencyServiceLoader(IProxy.class, ServerProxy::new);
        Object object = s_proxy.get();
        if (object instanceof IForgeProxy) {
            IForgeProxy forgeProxy = (IForgeProxy)object;
            forgeProxy.initialize(modBus);
        }
        Config.initialize(container);
        Content.initialize(modBus);
        modBus.addListener(ExtremeReactors::onInterModProcess);
        modBus.addListener(ExtremeReactors::onRegisterCapabilities);
        modBus.addListener(ExtremeReactors::onRegisterPackets);
        NeoForge.EVENT_BUS.addListener(ExtremeReactors::onRegisterCommands);
    }

    public void sendPacket(CustomPacketPayload packet, ServerLevel level, BlockPos center, int radius) {
        this._network.sendToAllAround((Vec3i)center, (double)radius, level, null, packet, new CustomPacketPayload[0]);
    }

    private static void onInterModProcess(InterModProcessEvent event) {
        ExtremeReactors.imcProcessAPIMessages(event, "reactant-register");
        ExtremeReactors.imcProcessAPIMessages(event, "mapping-register");
        ExtremeReactors.imcProcessAPIMessages(event, "reaction-register");
        ExtremeReactors.imcProcessAPIMessages(event, "reaction-remove");
        ExtremeReactors.imcProcessAPIMessages(event, "mapping-remove");
        ExtremeReactors.imcProcessAPIMessages(event, "reactant-remove");
        ExtremeReactors.imcProcessAPIMessages(event, "moderator-s-register");
        ExtremeReactors.imcProcessAPIMessages(event, "moderator-f-register");
        ExtremeReactors.imcProcessAPIMessages(event, "moderator-s-remove");
        ExtremeReactors.imcProcessAPIMessages(event, "moderator-f-remove");
        ExtremeReactors.imcProcessAPIMessages(event, "fluid-register");
        ExtremeReactors.imcProcessAPIMessages(event, "fluid-mapping-register");
        ExtremeReactors.imcProcessAPIMessages(event, "fluid-transition-register");
        ExtremeReactors.imcProcessAPIMessages(event, "fluid-transition-remove");
        ExtremeReactors.imcProcessAPIMessages(event, "fluid-mapping-remove");
        ExtremeReactors.imcProcessAPIMessages(event, "fluid-remove");
        ExtremeReactors.imcProcessAPIMessages(event, "coilmaterial-register");
        ExtremeReactors.imcProcessAPIMessages(event, "coilmaterial-remove");
        ApiWrapper.processFile();
    }

    private static void imcProcessAPIMessages(InterModProcessEvent event, String method) {
        event.getIMCStream(method::equals).map(imc -> (Runnable)imc.messageSupplier().get()).forEach(Runnable::run);
    }

    private static void onRegisterCommands(RegisterCommandsEvent event) {
        ExtremeReactorsCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private static void onRegisterPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MOD_ID).versioned("2.0.0");
        registrar.playToClient(UpdateClientsFuelRodsLayout.TYPE, UpdateClientsFuelRodsLayout.STREAM_CODEC, AbstractBlockEntityPlayPacket::handlePacket);
        registrar.playToClient(UpdateFluidizerFluidStatus.TYPE, UpdateFluidizerFluidStatus.STREAM_CODEC, AbstractBlockEntityPlayPacket::handlePacket);
    }

    private static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Content.TileEntityTypes.REACTOR_SOLID_ACCESSPORT.get(), (be, context) -> be.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, Content.TileEntityTypes.REACTOR_FLUID_ACCESSPORT.get(), (be, context) -> be.getFluidHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, Content.TileEntityTypes.REACTOR_FLUIDPORT_FORGE_ACTIVE.get(), ExtremeReactors::getFluidHandlerCapability);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, Content.TileEntityTypes.REACTOR_FLUIDPORT_FORGE_PASSIVE.get(), ExtremeReactors::getFluidHandlerCapability);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, Content.TileEntityTypes.REACTOR_POWERTAP_FE_ACTIVE.get(), ExtremeReactors::getEnergyStorageCapability);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, Content.TileEntityTypes.REACTOR_POWERTAP_FE_PASSIVE.get(), ExtremeReactors::getEnergyStorageCapability);
        ((IComputerCraftService)IComputerCraftService.SERVICE.get()).registerCapabilityProvider(event, Content.TileEntityTypes.REACTOR_COMPUTERPORT.get());
        ((IMekanismService)IMekanismService.SERVICE.get()).registerGasCapabilityProvider(event, Content.TileEntityTypes.REACTOR_FLUIDPORT_MEKANISM_PASSIVE.get());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, Content.TileEntityTypes.TURBINE_FLUIDPORT_FORGE_ACTIVE.get(), ExtremeReactors::getFluidHandlerCapability);
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, Content.TileEntityTypes.TURBINE_FLUIDPORT_FORGE_PASSIVE.get(), ExtremeReactors::getFluidHandlerCapability);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, Content.TileEntityTypes.TURBINE_POWERTAP_FE_ACTIVE.get(), ExtremeReactors::getEnergyStorageCapability);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, Content.TileEntityTypes.TURBINE_POWERTAP_FE_PASSIVE.get(), ExtremeReactors::getEnergyStorageCapability);
        ((IComputerCraftService)IComputerCraftService.SERVICE.get()).registerCapabilityProvider(event, Content.TileEntityTypes.TURBINE_COMPUTERPORT.get());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, Content.TileEntityTypes.REPROCESSOR_FLUIDINJECTOR.get(), (be, context) -> be.getHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Content.TileEntityTypes.REPROCESSOR_WASTEINJECTOR.get(), (be, context) -> be.getHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Content.TileEntityTypes.REPROCESSOR_OUTPUTPORT.get(), (be, context) -> be.getHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, Content.TileEntityTypes.REPROCESSOR_POWERPORT.get(), (be, context) -> be.getHandler());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, Content.TileEntityTypes.FLUIDIZER_SOLIDINJECTOR.get(), (be, context) -> be.getItemHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, Content.TileEntityTypes.FLUIDIZER_FLUIDINJECTOR.get(), (be, context) -> be.getFluidHandler());
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, Content.TileEntityTypes.FLUIDIZER_OUTPUTPORT.get(), (be, context) -> be.getHandler());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, Content.TileEntityTypes.FLUIDIZER_POWERPORT.get(), ExtremeReactors::getEnergyStorageCapability);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, Content.TileEntityTypes.ENERGIZER_POWERPORT_FE.get(), ExtremeReactors::getEnergyStorageCapability);
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, Content.TileEntityTypes.ENERGIZER_POWERPORT_FE_ACTIVE.get(), ExtremeReactors::getEnergyStorageCapability);
        ((IComputerCraftService)IComputerCraftService.SERVICE.get()).registerCapabilityProvider(event, Content.TileEntityTypes.ENERGIZER_COMPUTERPORT.get());
    }

    @Nullable
    private static IFluidHandler getFluidHandlerCapability(IFluidPort port, Direction context) {
        IFluidPortHandler iFluidPortHandler = port.getFluidPortHandler();
        if (iFluidPortHandler instanceof IFluidHandler) {
            IFluidHandler handler = (IFluidHandler)iFluidPortHandler;
            return handler;
        }
        return null;
    }

    @Nullable
    private static IEnergyStorage getEnergyStorageCapability(IPowerPort port, Direction context) {
        IPowerPortHandler iPowerPortHandler = port.getPowerPortHandler();
        if (iPowerPortHandler instanceof IEnergyStorage) {
            IEnergyStorage handler = (IEnergyStorage)iPowerPortHandler;
            return handler;
        }
        return null;
    }
}

