/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Utils.RefinedTypesUtil;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeableEnergyStorage
implements EnergyStorage {
    private long capacity;
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeableEnergyStorage.class);
    public UUID uuid;
    private long stored;

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public void setStored(long stored) {
        this.stored = stored;
    }

    public UpgradeableEnergyStorage(long capacity, UUID uuid) {
        CoreValidations.validateNotNegative((long)capacity, (String)"Capacity must be non-negative");
        this.capacity = capacity;
        this.uuid = uuid;
    }

    public long getStored() {
        return this.stored;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long receive(long amount, Action action) {
        OmniItemProxxy proxy;
        if (amount <= 0L) {
            return 0L;
        }
        long spaceRemaining = this.capacity - this.stored;
        long acceptedInternally = Math.min(amount, spaceRemaining);
        long excess = amount - acceptedInternally;
        if (action == Action.EXECUTE && acceptedInternally > 0L) {
            this.stored += acceptedInternally;
        }
        long insertedExternally = 0L;
        if (excess > 0L && (proxy = OmniGridBlockItem.GLOBAL_STORAGES.get(this.uuid)) != null && proxy.utilityTypes.contains((Object)UtilityType.ENERGY_HANDLER)) {
            insertedExternally = RefinedTypesUtil.safeEnergyInsert((Storage)proxy.getOrCreateStorage(), excess, action);
        }
        return acceptedInternally + insertedExternally;
    }

    public long extract(long amount, Action action) {
        long maxExtract = Math.min(this.stored, amount);
        if (maxExtract > 0L && action == Action.EXECUTE) {
            this.stored -= maxExtract;
        }
        return maxExtract;
    }
}

