/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.neoforge.InWorldOmniGrid;
import com.omnigrid.neoforge.Items;
import com.omnigrid.neoforge.OmniCommandData;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public final class UpgradeCountContainer
extends SimpleContainer {
    private static final int SIZE = 4;
    private static final int CAP = 3;
    private final InWorldOmniGrid grid;

    public UpgradeCountContainer(InWorldOmniGrid grid) {
        super(4);
        this.grid = grid;
        this.resyncFromBE();
    }

    private OmniCommandData data() {
        return this.grid.getBlockEntity().getOmniData();
    }

    private int[] up() {
        return this.data().getUpgrades();
    }

    private static ItemStack stackForIndex(int i, int n) {
        if (n <= 0) {
            return ItemStack.EMPTY;
        }
        return switch (i) {
            case 0 -> new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getSpeedUpgrade(), n);
            case 1 -> new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getStackUpgrade(), n);
            case 2 -> new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getRangeUpgrade(), n);
            case 3 -> new ItemStack((ItemLike)Items.INSTANCE.getOmniEnergy(), n);
            default -> ItemStack.EMPTY;
        };
    }

    private static boolean isValidForIndex(int i, ItemStack s) {
        if (s.isEmpty()) {
            return true;
        }
        return switch (i) {
            case 0 -> s.is((Item)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getSpeedUpgrade());
            case 1 -> s.is((Item)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getStackUpgrade());
            case 2 -> s.is((Item)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getRangeUpgrade());
            case 3 -> s.is((Item)Items.INSTANCE.getOmniEnergy());
            default -> false;
        };
    }

    private static int cap(int n) {
        return Math.min(n, 3);
    }

    private void writeBE(int index, int cnt) {
        OmniCommandData d = this.data();
        int[] arr = d.getUpgrades();
        arr[index] = cnt;
        d.setUpgrades(arr);
        this.grid.getBlockEntity().updateOmniController(d);
        this.grid.getBlockEntity().setChanged();
    }

    public void resyncFromBE() {
        int[] arr = this.up();
        for (int i = 0; i < 4; ++i) {
            super.setItem(i, UpgradeCountContainer.stackForIndex(i, arr[i]));
        }
        this.setChanged();
    }

    public int getMaxStackSize() {
        return 3;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 3;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return UpgradeCountContainer.isValidForIndex(index, stack);
    }

    public void setItem(int index, ItemStack stack) {
        if (!UpgradeCountContainer.isValidForIndex(index, stack)) {
            return;
        }
        int newCnt = UpgradeCountContainer.cap(stack.getCount());
        this.writeBE(index, newCnt);
        super.setItem(index, UpgradeCountContainer.stackForIndex(index, newCnt));
    }

    public ItemStack removeItem(int index, int amount) {
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        int cur = this.up()[index];
        int take = Math.min(amount, cur);
        if (take <= 0) {
            return ItemStack.EMPTY;
        }
        int remain = cur - take;
        this.writeBE(index, remain);
        super.setItem(index, UpgradeCountContainer.stackForIndex(index, remain));
        return UpgradeCountContainer.stackForIndex(index, take);
    }

    public ItemStack removeItemNoUpdate(int index) {
        int cur = this.up()[index];
        if (cur <= 0) {
            return ItemStack.EMPTY;
        }
        this.writeBE(index, 0);
        super.setItem(index, ItemStack.EMPTY);
        return UpgradeCountContainer.stackForIndex(index, cur);
    }

    public void clearContent() {
        this.writeBE(0, 0);
        this.writeBE(1, 0);
        this.writeBE(2, 0);
        this.writeBE(3, 0);
        for (int i = 0; i < 4; ++i) {
            super.setItem(i, ItemStack.EMPTY);
        }
        this.setChanged();
    }
}

