/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.neoforge.ClientResourceTracker;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record UpdateTracker(UUID storageReference, PlatformResourceKey[] resources, long[] amounts) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateTracker> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier((String)"update_tracker_batch"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateTracker> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, UpdateTracker>(){

        public UpdateTracker decode(RegistryFriendlyByteBuf buf) {
            UUID id = buf.readUUID();
            PlatformResourceKey[] keys = new PlatformResourceKey[4];
            long[] values = new long[4];
            for (int i = 0; i < 4; ++i) {
                boolean hasKey = buf.readBoolean();
                keys[i] = hasKey ? (PlatformResourceKey)ResourceCodecs.STREAM_CODEC.decode((Object)buf) : null;
                values[i] = buf.readVarLong();
            }
            return new UpdateTracker(id, keys, values);
        }

        public void encode(RegistryFriendlyByteBuf buf, UpdateTracker msg) {
            buf.writeUUID(msg.storageReference());
            for (int i = 0; i < 4; ++i) {
                PlatformResourceKey key = msg.resources()[i];
                buf.writeBoolean(key != null);
                if (key != null) {
                    ResourceCodecs.STREAM_CODEC.encode((Object)buf, (Object)key);
                }
                buf.writeVarLong(msg.amounts()[i]);
            }
        }
    };
    public static HashMap<UUID, ClientResourceTracker> CLIENT_TRACKERS = new HashMap();

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public static void handle(UpdateTracker packet, PacketContext ctx) {
        PlatformResourceKey[] keysCopy = new PlatformResourceKey[4];
        long[] valuesCopy = new long[4];
        for (int i = 0; i < 4; ++i) {
            keysCopy[i] = packet.resources()[i];
            valuesCopy[i] = packet.amounts()[i];
        }
        CLIENT_TRACKERS.put(packet.storageReference(), new ClientResourceTracker(keysCopy, valuesCopy));
    }
}

