/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.OmniCommandData;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record UpdateCommandData(OmniCommandData commandData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateCommandData> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier((String)"omni_command_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateCommandData> STREAM_CODEC = StreamCodec.of((buf, pkt) -> {
        RegistryAccess access = buf.registryAccess();
        CompoundTag tag = pkt.commandData().toNbt((HolderLookup.Provider)access);
        buf.writeNbt((Tag)tag);
    }, buf -> {
        RegistryAccess access = buf.registryAccess();
        CompoundTag tag = buf.readNbt();
        OmniCommandData data = OmniCommandData.fromNbt(tag, (HolderLookup.Provider)access);
        return new UpdateCommandData(data);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public static void handle(UpdateCommandData pkt, PacketContext ctx) {
        AbstractContainerMenu abstractContainerMenu;
        Player player = ctx.getPlayer();
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof AbstractOmniGridContainerMenu) {
            AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
            menu.onSyncDataReceived(pkt.commandData());
        }
    }
}

