/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Regulator.OmniRegulator;
import com.omnigrid.Utils.OmniOverclockerPlusItem;
import com.omnigrid.Utils.OmniProxyBucket;
import com.omnigrid.Utils.OmniProxyDisk;
import com.omnigrid.Utils.OmniUtilityItem;
import com.omnigrid.Utils.OmniVoider;
import com.omnigrid.Utils.PresetItem;
import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.Utils.UtilityBundle;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.ToggleableSlot;
import com.refinedmods.refinedstorage.common.autocrafting.PatternItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternState;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.Level;

public class ToggleableUtilitySlot
extends ToggleableSlot {
    public ToggleableUtilitySlot(Container container, AbstractOmniGridContainerMenu menu, int slot, int x, int y) {
        super(container, slot, x, y, 2, menu);
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean isValid() {
        return !this.menu.screenIsTransferPanel && super.isValid();
    }

    public void ResetMenu() {
        if (this.menu.gridPlayer.level().isClientSide) {
            this.menu.sortDelayTicks = 30;
        } else {
            this.menu.updateImmediete = true;
            this.menu.updateScheduled = true;
        }
    }

    @Override
    public void onTake(Player player, ItemStack stack) {
        if (stack.getItem() instanceof PresetItem) {
            OmniCommandData.writePresetToItem(this.menu.dataServer, stack, this.menu.storageReference);
        }
        if ((stack.getItem() instanceof OmniProxyDisk || stack.getItem() instanceof OmniProxyBucket) && !player.level().isClientSide) {
            ArrayList<Object> comp = new ArrayList<Object>();
            comp.add(Component.literal((String)"Linked to ").withStyle(ChatFormatting.GREEN));
            if (OmniGridBlockItem.GLOBAL_STORAGES.containsKey(this.menu.storageReference) && OmniGridBlockItem.GLOBAL_STORAGES.get((Object)this.menu.storageReference).name != null) {
                comp.add(OmniGridBlockItem.GLOBAL_STORAGES.get((Object)this.menu.storageReference).name);
            } else {
                comp.add(Component.literal((String)("Unnamed Omni Grid: " + String.valueOf(this.menu.storageReference))).withStyle(ChatFormatting.GRAY));
            }
            stack.set(net.minecraft.core.component.DataComponents.LORE, (Object)new ItemLore(comp));
            stack.set(DataComponents.INSTANCE.getStorageReference(), (Object)this.menu.storageReference);
        }
        super.onTake(player, stack);
        this.ResetMenu();
    }

    @Override
    public boolean mayPickup(Player player) {
        return super.isValid();
    }

    @Override
    public boolean mayPlace(ItemStack stack) {
        boolean hasAutoCraftingCore;
        Object typesInside;
        Level level = this.menu.gridPlayer.level();
        if (stack.getItem() instanceof OmniRegulator || stack.getItem() instanceof PresetItem || stack.getItem() instanceof OmniProxyDisk || stack.getItem() instanceof OmniVoider || stack.getItem() instanceof OmniProxyBucket) {
            return true;
        }
        if (stack.getItem() instanceof OmniOverclockerPlusItem) {
            Player player = this.menu.gridPlayer;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                if (this.menu.dataServer.getUpgrades()[0] == 3) {
                    TransferUtils.giveAdvancement(sp, "omni_overclock", "none");
                }
            }
            return true;
        }
        Item item = stack.getItem();
        if (item instanceof UtilityBundle) {
            UtilityBundle bundle = (UtilityBundle)item;
            typesInside = UtilityBundle.getUtilityTypes(stack);
            if (typesInside.isEmpty()) {
                return true;
            }
            List<UtilityType> installed = this.menu.getUtilityTypes();
            Iterator iterator = typesInside.iterator();
            while (iterator.hasNext()) {
                UtilityType t2 = (UtilityType)((Object)iterator.next());
                if (!installed.contains((Object)t2)) continue;
                return false;
            }
            boolean bundleHasCurios = typesInside.stream().anyMatch(t -> TransferUtils.UtilityTypeHelpers.isCurios(t));
            boolean gridHasCurios = installed.stream().anyMatch(t -> TransferUtils.UtilityTypeHelpers.isCurios(t));
            return !bundleHasCurios || !gridHasCurios;
        }
        typesInside = stack.getItem();
        if (typesInside instanceof OmniUtilityItem) {
            OmniUtilityItem utilItem = (OmniUtilityItem)((Object)typesInside);
            UtilityType type = utilItem.getUtilityType();
            List<UtilityType> installed = this.menu.getUtilityTypes();
            if (installed.contains((Object)type)) {
                return false;
            }
            boolean isCurios = TransferUtils.UtilityTypeHelpers.isCurios(type);
            boolean gridHasCurios = installed.stream().anyMatch(t -> TransferUtils.UtilityTypeHelpers.isCurios(t));
            return !isCurios || !gridHasCurios;
        }
        boolean bl = hasAutoCraftingCore = level.isClientSide ? this.menu.getDataClient().isCoreInstalled(CoreTypes.AUTOCRAFTING) : this.menu.dataServer.isCoreInstalled(CoreTypes.AUTOCRAFTING);
        if (!hasAutoCraftingCore) {
            return false;
        }
        Item installed = stack.getItem();
        if (!(installed instanceof PatternItem)) {
            return false;
        }
        PatternItem patternItem = (PatternItem)installed;
        PatternState state = (PatternState)stack.get(DataComponents.INSTANCE.getPatternState());
        return state != null;
    }

    private static boolean isIsCuriosItem(OmniUtilityItem utilItem) {
        UtilityType type = utilItem.getUtilityType();
        boolean isCuriosItem = type == UtilityType.CURIOS_1 || type == UtilityType.CURIOS_2 || type == UtilityType.CURIOS_3 || type == UtilityType.CURIOS_4 || type == UtilityType.CURIOS_5;
        return isCuriosItem;
    }

    @Override
    public void set(ItemStack stack) {
        super.set(stack);
        this.container.setChanged();
        if (!this.menu.gridPlayer.level().isClientSide) {
            this.menu.markDataServerDirty();
            this.menu.slotsChanged(this.container);
        }
        this.ResetMenu();
    }
}

