/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleableSlot
extends Slot {
    public AbstractOmniGridContainerMenu menu;
    public int page;
    private static final Logger LOGGER = LoggerFactory.getLogger(ToggleableSlot.class);

    public ToggleableSlot(Container container, int slot, int x, int y, int page, AbstractOmniGridContainerMenu menu) {
        super(container, slot, x, y);
        this.menu = menu;
        this.page = page;
    }

    public void onTake(Player player, ItemStack stack) {
        super.onTake(player, stack);
    }

    public boolean isValid() {
        return this.menu.tabPage == this.page && !this.menu.screenIsTransferPanel;
    }

    public boolean isHighlightable() {
        return this.isValid();
    }

    public boolean isActive() {
        return this.isValid();
    }

    public boolean mayPlace(ItemStack stack) {
        return this.isValid();
    }

    public boolean mayPickup(Player player) {
        return this.isValid();
    }

    public void set(ItemStack stack) {
        super.set(stack);
        if (this.menu.surpressUpdate) {
            return;
        }
        this.container.setChanged();
        if (!this.menu.gridPlayer.level().isClientSide) {
            this.menu.markDataServerDirty();
        }
        this.menu.slotsChanged(this.container);
        this.menu.updateImmediete = true;
        this.menu.updateScheduled = true;
        this.menu.broadcastChanges();
    }
}

