/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.CoreItem;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.ToggleableSlot;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToggleableCoreSlot
extends ToggleableSlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToggleableCoreSlot.class);
    public int coreIdx;

    public ToggleableCoreSlot(Container container, AbstractOmniGridContainerMenu menu, int slot, int x, int y, int idx) {
        super(container, slot, x, y, 3, menu);
        this.coreIdx = idx;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean mayPickup(Player player) {
        if (CoreTypes.fromId(this.coreIdx) == CoreTypes.DISK_DRIVE) {
            for (Slot disk : this.menu.getDiskSlots()) {
                if (disk.getContainerSlot() <= 0 || !disk.hasItem()) continue;
                return false;
            }
        }
        return super.isValid();
    }

    @Override
    public boolean mayPlace(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof CoreItem)) {
            return false;
        }
        CoreItem core = (CoreItem)item;
        return core.getCoreType().getId() == this.coreIdx && super.mayPlace(stack);
    }

    @Override
    public void onTake(Player player, ItemStack stack) {
        super.onTake(player, stack);
        if (this.menu.dataServer != null) {
            this.menu.dataServer = this.menu.validateCommands(this.menu.dataServer);
        }
        if (this.menu.getDataClient() != null) {
            this.menu.setDataClient(this.menu.validateCommands(this.menu.getDataClient()));
        }
    }

    @Override
    public void set(ItemStack stack) {
        if (this.menu.disableCoreUpdates) {
            return;
        }
        super.set(stack);
        if (!this.menu.disableCoreUpdates && !this.menu.gridPlayer.level().isClientSide()) {
            CoreItem ci;
            CoreItem core;
            Item item = stack.getItem();
            CoreItem coreItem = core = item instanceof CoreItem ? (ci = (CoreItem)item) : null;
            if (core != null) {
                this.menu.dataServer.setCoreInstalled(core.getCoreType(), !stack.isEmpty());
            }
            this.menu.syncCoreData(this.getContainerSlot(), !stack.isEmpty());
            this.menu.broadcastChanges();
        }
    }
}

