/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.refinedmods.refinedstorage.common.grid.AbstractGridContainerMenu;
import com.refinedmods.refinedstorage.common.grid.GridSortingTypes;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

class SortingTypeSideButtonWidget
extends AbstractSideButtonWidget {
    private static final MutableComponent TITLE = IdentifierUtil.createTranslation((String)"gui", (String)"grid.sorting.type");
    private static final List<MutableComponent> SUBTEXT_QUANTITY = List.of(IdentifierUtil.createTranslation((String)"gui", (String)"grid.sorting.type.quantity").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_NAME = List.of(IdentifierUtil.createTranslation((String)"gui", (String)"grid.sorting.type.name").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_ID = List.of(IdentifierUtil.createTranslation((String)"gui", (String)"grid.sorting.type.id").withStyle(ChatFormatting.GRAY));
    private static final List<MutableComponent> SUBTEXT_LAST_MODIFIED = List.of(IdentifierUtil.createTranslation((String)"gui", (String)"grid.sorting.type.last_modified").withStyle(ChatFormatting.GRAY));
    private static final ResourceLocation QUANTITY = IdentifierUtil.createIdentifier((String)"widget/side_button/grid/sorting_type/quantity");
    private static final ResourceLocation NAME = IdentifierUtil.createIdentifier((String)"widget/side_button/grid/sorting_type/name");
    private static final ResourceLocation ID = IdentifierUtil.createIdentifier((String)"widget/side_button/grid/sorting_type/id");
    private static final ResourceLocation LAST_MODIFIED = IdentifierUtil.createIdentifier((String)"widget/side_button/grid/sorting_type/last_modified");
    private final AbstractGridContainerMenu menu;

    SortingTypeSideButtonWidget(AbstractGridContainerMenu menu) {
        super(SortingTypeSideButtonWidget.createPressAction(menu));
        this.menu = menu;
    }

    private static Button.OnPress createPressAction(AbstractGridContainerMenu menu) {
        return btn -> menu.setSortingType(SortingTypeSideButtonWidget.toggle(menu.getSortingType()));
    }

    private static GridSortingTypes toggle(GridSortingTypes sortingType) {
        return switch (sortingType) {
            default -> throw new MatchException(null, null);
            case GridSortingTypes.QUANTITY -> GridSortingTypes.NAME;
            case GridSortingTypes.NAME -> GridSortingTypes.ID;
            case GridSortingTypes.ID -> GridSortingTypes.LAST_MODIFIED;
            case GridSortingTypes.LAST_MODIFIED -> GridSortingTypes.QUANTITY;
        };
    }

    protected ResourceLocation getSprite() {
        return switch (this.menu.getSortingType()) {
            default -> throw new MatchException(null, null);
            case GridSortingTypes.QUANTITY -> QUANTITY;
            case GridSortingTypes.NAME -> NAME;
            case GridSortingTypes.ID -> ID;
            case GridSortingTypes.LAST_MODIFIED -> LAST_MODIFIED;
        };
    }

    protected MutableComponent getTitle() {
        return TITLE;
    }

    protected List<MutableComponent> getSubText() {
        return switch (this.menu.getSortingType()) {
            default -> throw new MatchException(null, null);
            case GridSortingTypes.QUANTITY -> SUBTEXT_QUANTITY;
            case GridSortingTypes.NAME -> SUBTEXT_NAME;
            case GridSortingTypes.ID -> SUBTEXT_ID;
            case GridSortingTypes.LAST_MODIFIED -> SUBTEXT_LAST_MODIFIED;
        };
    }
}

