/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Utils.SlotUtil;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.CraftingGridRecipeTransferPacket;
import com.omnigrid.neoforge.TransferInput;
import com.omnigrid.neoforge.TransferType;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RecipeHandler<T extends AbstractOmniGridContainerMenu>
implements IRecipeTransferHandler<T, RecipeHolder<CraftingRecipe>> {
    private final Class<T> clazz;
    private static final Logger LOGGER = LoggerFactory.getLogger(RecipeHandler.class);

    RecipeHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Class<T> getContainerClass() {
        return this.clazz;
    }

    public Optional<MenuType<T>> getMenuType() {
        return Optional.empty();
    }

    public RecipeType<RecipeHolder<CraftingRecipe>> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T containerMenu, RecipeHolder<CraftingRecipe> recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        ((AbstractOmniGridContainerMenu)((Object)containerMenu)).closeConfig = true;
        ResourceRepository repository = containerMenu.getRepository();
        MutableResourceList available = ((AbstractOmniGridContainerMenu)((Object)containerMenu)).getAvailableListForRecipeTransfer();
        List<TransferInput> transferInputs = this.getTransferInputs((ResourceRepository<GridResource>)repository, recipeSlots, available);
        TransferType type = this.getTransferType(transferInputs);
        if (doTransfer) {
            this.doTransfer(recipeSlots, containerMenu);
        }
        return type == TransferType.AVAILABLE ? null : new Error();
    }

    private TransferType getTransferType(List<TransferInput> transferInputs) {
        if (transferInputs.stream().allMatch(input -> input.type() == TransferType.AVAILABLE)) {
            return TransferType.AVAILABLE;
        }
        boolean hasMissing = transferInputs.stream().anyMatch(input -> input.type() == TransferType.MISSING);
        boolean hasAutocraftable = transferInputs.stream().anyMatch(input -> input.type() == TransferType.AUTOCRAFTABLE);
        if (hasMissing && hasAutocraftable) {
            return TransferType.MISSING_BUT_SOME_AUTOCRAFTABLE;
        }
        if (hasAutocraftable) {
            return TransferType.MISSING_BUT_ALL_AUTOCRAFTABLE;
        }
        return TransferType.MISSING;
    }

    private void doTransfer(IRecipeSlotsView recipeSlots, T containerMenu) {
        List<List<ItemResource>> inputs = SlotUtil.getItems(recipeSlots, RecipeIngredientRole.INPUT);
        ((AbstractOmniGridContainerMenu)((Object)containerMenu)).transferRecipe(inputs);
        Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new CraftingGridRecipeTransferPacket(inputs));
    }

    private List<TransferInput> getTransferInputs(ResourceRepository<GridResource> repository, IRecipeSlotsView recipeSlots, MutableResourceList available) {
        return recipeSlots.getSlotViews(RecipeIngredientRole.INPUT).stream().filter(slotView -> !slotView.isEmpty()).map(slotView -> this.toTransferInput(repository, available, (IRecipeSlotView)slotView)).toList();
    }

    private TransferInput toTransferInput(ResourceRepository<GridResource> repository, MutableResourceList available, IRecipeSlotView slotView) {
        List possibilities = slotView.getItemStacks().toList();
        for (ItemStack possibility : possibilities) {
            ItemResource possibilityResource = ItemResource.ofItemStack((ItemStack)possibility);
            if (available.remove((ResourceKey)possibilityResource, 1L) == null) continue;
            return new TransferInput(slotView, TransferType.AVAILABLE, null);
        }
        List<ItemResource> autocraftingPossibilities = possibilities.stream().map(ItemResource::ofItemStack).filter(arg_0 -> repository.isSticky(arg_0)).sorted(Comparator.comparingLong(arg_0 -> repository.getAmount(arg_0))).toList();
        if (!autocraftingPossibilities.isEmpty()) {
            return new TransferInput(slotView, TransferType.AUTOCRAFTABLE, autocraftingPossibilities.getFirst());
        }
        return new TransferInput(slotView, TransferType.MISSING, null);
    }

    static class Error
    implements IRecipeTransferError {
        Error() {
        }

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }
    }
}

