/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Utils.UtilityType;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record PickBlockRequest(ItemStack requested) implements IPayloadHandler<PickBlockRequest>,
CustomPacketPayload
{
    private static final Logger LOGGER = LoggerFactory.getLogger(PickBlockRequest.class);
    public static final CustomPacketPayload.Type<PickBlockRequest> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier((String)"omni_pickblock"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PickBlockRequest> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, PickBlockRequest::requested, PickBlockRequest::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public void handle(PickBlockRequest msg, IPayloadContext ctx) {
        boolean sameItem;
        ServerPlayer player = (ServerPlayer)ctx.player();
        if (player == null) {
            return;
        }
        ItemStack main = player.getMainHandItem();
        if (main.getItem() instanceof OmniGridBlockItem) {
            return;
        }
        UUID playerId = player.getUUID();
        ArrayList<OmniItemProxxy> proxxies = new ArrayList<OmniItemProxxy>();
        for (UUID key : OmniGridBlockItem.GLOBAL_STORAGES.keySet()) {
            OmniItemProxxy p = OmniGridBlockItem.GLOBAL_STORAGES.get(key);
            if (p == null || p.player == null || !playerId.equals(p.player) || !p.getOrCreateStorage().utilityTypes.contains((Object)UtilityType.BLOCK_PICKER)) continue;
            proxxies.add(p);
        }
        if (proxxies.isEmpty()) {
            return;
        }
        ItemStack requested = msg.requested.copy();
        boolean bl = sameItem = !main.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)main, (ItemStack)requested);
        if (sameItem) {
            int max;
            int remaining = max = requested.getMaxStackSize();
            ItemResource key = ItemResource.ofItemStack((ItemStack)requested);
            ItemStack fullStack = ItemStack.EMPTY;
            for (OmniItemProxxy omniItemProxxy : proxxies) {
                long extracted = omniItemProxxy.getOrCreateStorage().extract((ResourceKey)key, remaining, Action.EXECUTE, (Actor)new PlayerActor(ctx.player()));
                if (extracted <= 0L) continue;
                if (fullStack.isEmpty()) {
                    fullStack = requested.copy();
                    fullStack.setCount((int)extracted);
                } else {
                    fullStack.grow((int)extracted);
                }
                if ((remaining = (int)((long)remaining - extracted)) > 0) continue;
                break;
            }
            if (fullStack.isEmpty()) {
                return;
            }
            ItemStack held = main.copy();
            if (!held.isEmpty()) {
                for (OmniItemProxxy proxxy : proxxies) {
                    if (held.isEmpty()) break;
                    long inserted = proxxy.getOrCreateStorage().insert((ResourceKey)ItemResource.ofItemStack((ItemStack)held), held.getCount(), Action.EXECUTE, (Actor)new PlayerActor(ctx.player()));
                    if (inserted <= 0L) continue;
                    held.shrink((int)inserted);
                }
            }
            player.setItemInHand(InteractionHand.MAIN_HAND, fullStack);
            player.inventoryMenu.broadcastChanges();
            return;
        }
        ItemStack held = main.copy();
        if (!held.isEmpty()) {
            for (OmniItemProxxy proxxy : proxxies) {
                if (held.isEmpty()) break;
                long inserted = proxxy.getOrCreateStorage().insert((ResourceKey)ItemResource.ofItemStack((ItemStack)held), held.getCount(), Action.EXECUTE, (Actor)new PlayerActor(ctx.player()));
                if (inserted <= 0L) continue;
                held.shrink((int)inserted);
            }
            player.setItemInHand(InteractionHand.MAIN_HAND, held);
        }
        if (requested.isEmpty()) {
            return;
        }
        ItemResource key = ItemResource.ofItemStack((ItemStack)requested);
        int needed = requested.getCount();
        ItemStack result = ItemStack.EMPTY;
        for (OmniItemProxxy omniItemProxxy : proxxies) {
            long extracted = omniItemProxxy.getOrCreateStorage().extract((ResourceKey)key, needed, Action.EXECUTE, (Actor)new PlayerActor(ctx.player()));
            if (extracted <= 0L) continue;
            result = requested.copy();
            result.setCount((int)extracted);
            break;
        }
        if (result.isEmpty()) {
            return;
        }
        player.setItemInHand(InteractionHand.MAIN_HAND, result);
        player.inventoryMenu.broadcastChanges();
    }
}

