/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.neoforge.Items;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import java.util.function.Consumer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class OmniUpgradeSlot
extends Slot {
    private final Consumer<OmniUpgradeSlot> onChange;

    public OmniUpgradeSlot(Container container, int slot, int x, int y, Consumer<OmniUpgradeSlot> onChange) {
        super(container, slot, x, y);
        this.onChange = onChange;
    }

    public boolean mayPlace(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof UpgradeItem)) {
            return false;
        }
        UpgradeItem item2 = (UpgradeItem)item;
        return switch (this.getContainerSlot()) {
            case 0 -> {
                if (item2 == com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getSpeedUpgrade()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (item2 == com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getStackUpgrade()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (item2 == com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getRangeUpgrade()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (item2 == Items.INSTANCE.getOmniEnergy()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public int getMaxStackSize(ItemStack stack) {
        return 3;
    }

    public int getMaxStackSize() {
        return 3;
    }

    public void set(ItemStack stack) {
        boolean sameCount;
        ItemStack before = this.getItem();
        boolean sameType = ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)before);
        boolean bl = sameCount = stack.getCount() == before.getCount();
        if (sameType && sameCount) {
            return;
        }
        super.set(stack);
        if (this.onChange != null) {
            this.onChange.accept(this);
        }
    }

    public ItemStack remove(int amount) {
        ItemStack after;
        ItemStack before = this.getItem().copy();
        ItemStack removed = super.remove(amount);
        if (!(this.onChange == null || ItemStack.isSameItemSameComponents((ItemStack)before, (ItemStack)(after = this.getItem())) && before.getCount() == after.getCount())) {
            this.onChange.accept(this);
        }
        return removed;
    }

    public void onTake(Player player, ItemStack stack) {
        super.onTake(player, stack);
        if (this.onChange != null) {
            this.onChange.accept(this);
        }
    }

    public boolean mayPickup(Player player) {
        return true;
    }
}

