/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.OmniRegulator.StorageRestriction;
import com.omnigrid.Regulator.RestrictionMode;
import com.omnigrid.StorageProxy.OmniProxyRemoteItem;
import com.omnigrid.Utils.CobblePrinterStorage;
import com.omnigrid.Utils.EnergyPrinterStorage;
import com.omnigrid.Utils.OmniCompositeStorage;
import com.omnigrid.Utils.OmniFilterData;
import com.omnigrid.Utils.OmniUtilityItem;
import com.omnigrid.Utils.RefinedTypesUtil;
import com.omnigrid.Utils.UtilityBundle;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.Utils.WaterPrinterStorage;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.Config;
import com.omnigrid.neoforge.OmniFurnaceSlot;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniGridResourceHandler;
import com.omnigrid.neoforge.OmniGridStorage;
import com.omnigrid.neoforge.OmniGridTask;
import com.omnigrid.neoforge.Platform;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.resource.list.listenable.ListenableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.listenable.ResourceListListener;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.api.storage.root.RootStorageListener;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniRootStorage
implements RootStorage {
    public List<StorageRestriction> restrictionList = new ArrayList<StorageRestriction>();
    public List<UtilityType> utilityTypes = new ArrayList<UtilityType>();
    public static final ItemResource COBBLE = new ItemResource(Items.COBBLESTONE);
    public static final FluidResource WATER = new FluidResource((Fluid)Fluids.WATER);
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniGridStorage.class);
    public List<ResourceKey> voidResources = new ArrayList<ResourceKey>();
    @Nullable
    public AbstractOmniGridContainerMenu menu;
    protected final OmniCompositeStorage storage;
    public ListenableResourceList list;
    private final Set<RootStorageListener> listeners;
    private long pendingPrinterDrain = 0L;
    private double cachedPower = 0.0;

    public void addRestriction(StorageRestriction restriction) {
        this.restrictionList.add(restriction);
    }

    public OmniRootStorage() {
        this(MutableResourceListImpl.create(), new HashSet<RootStorageListener>());
    }

    public void addVoidResources(@Nullable OmniFilterData data) {
        if (data != null) {
            for (int i = 0; i < 9; ++i) {
                long test;
                PlatformResourceKey res = data.get(i);
                if (res == null) continue;
                this.voidResources.add((ResourceKey)res);
                long amt = this.get((ResourceKey)res);
                if (amt <= 0L || (test = this.insert((ResourceKey)res, amt, Action.SIMULATE, Actor.EMPTY)) <= 0L) continue;
                this.extract((ResourceKey)res, amt, Action.EXECUTE, Actor.EMPTY);
            }
        }
    }

    public OmniRootStorage(MutableResourceListImpl list, Set<RootStorageListener> listeners) {
        this.list = new ListenableResourceList((MutableResourceList)list);
        this.storage = new OmniCompositeStorage((MutableResourceList)this.list, this);
        this.listeners = listeners;
    }

    public void addUtilityTypesFromStacks(List<ItemStack> stacks) {
        if (stacks == null || stacks.isEmpty()) {
            return;
        }
        for (ItemStack stack : stacks) {
            OmniUtilityItem utilItem;
            UtilityType type;
            Item item;
            if (stack.isEmpty() || !((item = stack.getItem()) instanceof OmniUtilityItem) || (type = (utilItem = (OmniUtilityItem)item).getUtilityType()) == null) continue;
            this.addUtilityType(type);
        }
    }

    public void addUtilityTypesFromBundle(ItemStack bundleStack) {
        if (bundleStack.isEmpty()) {
            return;
        }
        if (!(bundleStack.getItem() instanceof UtilityBundle)) {
            return;
        }
        BundleContents contents = (BundleContents)bundleStack.get(net.minecraft.core.component.DataComponents.BUNDLE_CONTENTS);
        if (contents == null || contents.isEmpty()) {
            return;
        }
        List<ItemStack> items = contents.itemCopyStream().toList();
        this.addUtilityTypesFromStacks(items);
    }

    public void addUtilityType(UtilityType type) {
        if (!this.utilityTypes.contains((Object)type)) {
            this.utilityTypes.add(type);
            if (type == UtilityType.COBBLE_GENERATOR || type == UtilityType.CREATIVE) {
                this.storage.addSource(new CobblePrinterStorage());
            }
            if (type == UtilityType.WATER_SOURCE || type == UtilityType.CREATIVE) {
                this.storage.addSource(new WaterPrinterStorage());
            }
            if (RefinedTypesUtil.rtInstalled() && type == UtilityType.CREATIVE) {
                this.storage.addSource(new EnergyPrinterStorage());
            }
        }
    }

    public void resetUtilityType() {
        this.utilityTypes.clear();
    }

    public boolean hasUtilityType(UtilityType type) {
        return this.utilityTypes.contains((Object)type);
    }

    public void sortSources() {
        this.storage.sortSources();
    }

    public void addSource(Storage source) {
        this.storage.addSource(source);
    }

    public void removeSource(Storage source) {
        this.storage.removeSource(source);
    }

    public boolean hasSource(Predicate<Storage> matcher) {
        return this.storage.getSources().stream().anyMatch(matcher);
    }

    public void addListener(RootStorageListener listener) {
        this.list.addListener((ResourceListListener)listener);
        this.listeners.add(listener);
    }

    public void removeListener(RootStorageListener listener) {
        this.list.removeListener((ResourceListListener)listener);
        this.listeners.remove(listener);
    }

    public long get(ResourceKey resource) {
        return this.list.get(resource);
    }

    private void recordDeltaIfNeeded(ResourceKey key, long delta, Action action) {
        if (action != Action.EXECUTE) {
            return;
        }
        if (delta == 0L) {
            return;
        }
        if (this.menu == null) {
            return;
        }
        this.menu.recordDelta(key, delta);
        this.menu.flushDeltas();
        this.menu.broadcastChanges();
    }

    public boolean contains(ResourceKey resource) {
        return this.list.contains(resource);
    }

    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        long floor;
        long current;
        long maxExtractable;
        RestrictionMode mode;
        StorageRestriction restriction = this.getRestriction(resource);
        if (restriction != null && ((mode = restriction.type()) == RestrictionMode.EXTRACT_FLOOR || mode == RestrictionMode.BOTH) && (amount = Math.min(amount, maxExtractable = Math.max(0L, (current = this.list.get(resource)) - (floor = restriction.limit())))) <= 0L) {
            return 0L;
        }
        long extracted = this.storage.extract(resource, amount, action, actor);
        if (extracted <= 0L) {
            return 0L;
        }
        if (action == Action.EXECUTE) {
            for (RootStorageListener listener : this.listeners) {
                listener.afterInsert(resource, extracted);
            }
        }
        if (extracted > 0L && action == Action.EXECUTE && actor instanceof PlayerActor) {
            PlayerActor oa = (PlayerActor)actor;
            if (resource instanceof ItemResource || resource instanceof FluidResource) {
                this.applyOmniActorDrain(oa, extracted, ((PlatformResourceKey)resource).getResourceType());
            }
        }
        this.recordDeltaIfNeeded(resource, -extracted, action);
        return extracted;
    }

    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        long toInsert;
        long inserted;
        RestrictionMode mode;
        ItemResource ira;
        ItemResource ir;
        if (amount <= 0L || resource instanceof ItemResource && (ir = (ItemResource)resource).item() instanceof OmniGridBlockItem || resource instanceof ItemResource && (ira = (ItemResource)resource).item() instanceof AirItem) {
            return 0L;
        }
        if (this.menu != null && resource instanceof ItemResource && (ir = (ItemResource)resource).item() instanceof OmniProxyRemoteItem && this.menu.storageReference == ir.toItemStack().get(DataComponents.INSTANCE.getStorageReference())) {
            return 0L;
        }
        if (this.voidResources.contains(resource)) {
            long test = this.storage.insert(resource, 1L, Action.SIMULATE, Actor.EMPTY);
            if (test > 0L) {
                return amount;
            }
            return 0L;
        }
        StorageRestriction restriction = this.getRestriction(resource);
        if (restriction != null && ((mode = restriction.type()) == RestrictionMode.INSERT_LIMIT || mode == RestrictionMode.BOTH)) {
            long maxAllowed;
            long current = this.list.get(resource);
            if (current >= (maxAllowed = restriction.limit())) {
                return 0L;
            }
            long maxInsertable = maxAllowed - current;
            if ((amount = Math.min(amount, maxInsertable)) <= 0L) {
                return 0L;
            }
        }
        long totalIntercepted = 0L;
        if (action == Action.EXECUTE) {
            for (RootStorageListener listener : this.listeners) {
                long available;
                long intercepted = listener.beforeInsert(resource, available = amount - totalIntercepted);
                if (intercepted > available || intercepted < 0L) {
                    throw new IllegalStateException("Intercepted " + intercepted);
                }
                if ((totalIntercepted += intercepted) != amount) continue;
                return totalIntercepted;
            }
        }
        if ((inserted = this.storage.insert(resource, toInsert = amount - totalIntercepted, action, actor)) > 0L && action == Action.EXECUTE) {
            this.notifyAfterInsertListeners(resource, inserted);
        }
        if (inserted > 0L && action == Action.EXECUTE && actor instanceof PlayerActor) {
            PlayerActor oa = (PlayerActor)actor;
            if (resource instanceof ItemResource || resource instanceof FluidResource) {
                this.applyOmniActorDrain(oa, inserted, ((PlatformResourceKey)resource).getResourceType());
            }
        }
        if (action == Action.EXECUTE) {
            for (RootStorageListener listener : this.listeners) {
                listener.afterInsert(resource, inserted);
            }
        }
        this.recordDeltaIfNeeded(resource, inserted + totalIntercepted, action);
        return inserted + totalIntercepted;
    }

    public void addPrinterDrain(long amount) {
        this.pendingPrinterDrain += amount;
    }

    public long consumePrinterDrain() {
        long out = this.pendingPrinterDrain;
        this.pendingPrinterDrain = 0L;
        return out;
    }

    private StorageRestriction getRestriction(ResourceKey key) {
        for (StorageRestriction r : this.restrictionList) {
            if (!r.resource().equals((Object)key)) continue;
            return r;
        }
        return null;
    }

    private void applyOmniActorDrain(PlayerActor oa, long amount, ResourceType resourceType) {
        if (amount <= 0L) {
            return;
        }
        Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
        long unitsPerFE = 0L;
        if (resourceType == ResourceTypes.ITEM) {
            if (oa.name().equals("Push") || oa.name().equals("Pull") || oa.name().equals("Depositor")) {
                unitsPerFE = cfg.itemsPerFE();
            } else if (oa.name().equals("Collect")) {
                unitsPerFE = cfg.vacuumPerFE();
            } else if (oa.name().equals("Search")) {
                unitsPerFE = cfg.searchPerFE();
            } else if (oa.name().equals("Autocrafter")) {
                unitsPerFE = cfg.autoCraftFECost();
            } else if (oa.name().equals("ForceCrafting")) {
                unitsPerFE = (long)cfg.autoCraftFECost() * 4L;
            } else if (oa.name().equals("Auto-Loot")) {
                unitsPerFE = cfg.itemsPerFE();
            }
        } else if (resourceType == ResourceTypes.FLUID) {
            if (oa.name().equals("Push") || oa.name().equals("Pull")) {
                unitsPerFE = cfg.fluidPerFE();
            } else if (oa.name().equals("Sponge")) {
                unitsPerFE = cfg.spongeFECost();
            }
        }
        if (unitsPerFE <= 0L) {
            return;
        }
        this.cachedPower += (double)amount / (double)unitsPerFE;
        long wholeFe = (long)Math.floor(this.cachedPower);
        if (wholeFe > 0L) {
            this.pendingPrinterDrain += wholeFe;
            this.cachedPower -= (double)wholeFe;
        }
    }

    private void notifyAfterInsertListeners(ResourceKey resource, long inserted) {
        long available = inserted;
        for (RootStorageListener listener : this.listeners) {
            long reserved = listener.afterInsert(resource, available);
            if (reserved > available || reserved < 0L) {
                throw new IllegalStateException("Reserved %d while %d was available".formatted(reserved, available));
            }
            if ((available -= reserved) != 0L) continue;
            return;
        }
    }

    public Collection<ResourceAmount> getAll() {
        boolean exists;
        Collection real = this.storage.getAll();
        ArrayList<ResourceAmount> result = new ArrayList<ResourceAmount>(real);
        if ((this.hasUtilityType(UtilityType.COBBLE_GENERATOR) || this.hasUtilityType(UtilityType.CREATIVE)) && !(exists = real.stream().anyMatch(r -> {
            ItemResource ir;
            ResourceKey patt0$temp = r.resource();
            return patt0$temp instanceof ItemResource && (ir = (ItemResource)patt0$temp).equals((Object)COBBLE);
        }))) {
            result.add(new ResourceAmount((ResourceKey)COBBLE, Integer.MAX_VALUE));
        }
        if (this.hasUtilityType(UtilityType.WATER_SOURCE) || this.hasUtilityType(UtilityType.CREATIVE)) {
            result.add(new ResourceAmount((ResourceKey)new FluidResource((Fluid)Fluids.WATER), Integer.MAX_VALUE));
        }
        if (this.hasUtilityType(UtilityType.CREATIVE) && RefinedTypesUtil.rtInstalled()) {
            result.add(new ResourceAmount((ResourceKey)EnergyResource.createEnergyResource(), Integer.MAX_VALUE));
        }
        return result;
    }

    public ResourceKey getResourceForTask(OmniGridTask task) {
        if (task == null) {
            return null;
        }
        List all = this.storage.getAll().stream().toList();
        if (all.isEmpty()) {
            return null;
        }
        if (task.resource == null || task.resource.isEmpty()) {
            if (task.cachedResourceIndex >= 0 && task.cachedResourceIndex < all.size()) {
                return ((ResourceAmount)all.get(task.cachedResourceIndex)).resource();
            }
            ResourceKey first = ((ResourceAmount)all.get(0)).resource();
            task.cachedResourceIndex = 0;
            return first;
        }
        ResourceKey wanted = (ResourceKey)task.resource.get();
        if (wanted instanceof ItemResource) {
            ItemResource cachedItem;
            ResourceKey cached;
            if (task.cachedResourceIndex >= 0 && task.cachedResourceIndex < all.size() && (cached = ((ResourceAmount)all.get(task.cachedResourceIndex)).resource()) instanceof ItemResource && OmniGridResourceHandler.matchesTask((cachedItem = (ItemResource)cached).toItemStack(), task)) {
                return cached;
            }
            for (int i = 0; i < all.size(); ++i) {
                ItemResource ir;
                ItemStack stack;
                ResourceAmount ra = (ResourceAmount)all.get(i);
                ResourceKey key = ra.resource();
                if (!(key instanceof ItemResource) || !OmniGridResourceHandler.matchesTask(stack = (ir = (ItemResource)key).toItemStack(), task)) continue;
                task.cachedResourceIndex = i;
                return key;
            }
            return null;
        }
        if (task.cachedResourceIndex >= 0 && task.cachedResourceIndex < all.size() && ((ResourceAmount)all.get(task.cachedResourceIndex)).resource().equals((Object)wanted)) {
            return wanted;
        }
        for (int i = 0; i < all.size(); ++i) {
            if (!((ResourceAmount)all.get(i)).resource().equals((Object)wanted)) continue;
            task.cachedResourceIndex = i;
            return wanted;
        }
        return null;
    }

    private boolean isSmeltable(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return !OmniFurnaceSlot.getSmeltingResult(this.menu.gridPlayer.level(), stack).output().isEmpty();
    }

    private boolean isSmeltable(ItemStack stack, Level level) {
        if (stack.isEmpty()) {
            return false;
        }
        return !OmniFurnaceSlot.getSmeltingResult(level, stack).output().isEmpty();
    }

    @Nullable
    public PlatformResourceKey getSmeltableResourceForTask(OmniGridTask task, Level level) {
        if (task == null) {
            return null;
        }
        List all = this.storage.getAll().stream().toList();
        if (all.isEmpty()) {
            return null;
        }
        if (task.resource == null || task.resource.isEmpty()) {
            ItemResource ir;
            ResourceKey cached;
            if (task.cachedResourceIndex >= 0 && task.cachedResourceIndex < all.size() && (cached = ((ResourceAmount)all.get(task.cachedResourceIndex)).resource()) instanceof ItemResource && this.isSmeltable((ir = (ItemResource)cached).toItemStack())) {
                return ir;
            }
            for (int i = 0; i < all.size(); ++i) {
                ItemResource ir2;
                ResourceKey key = ((ResourceAmount)all.get(i)).resource();
                if (!(key instanceof ItemResource) || !this.isSmeltable((ir2 = (ItemResource)key).toItemStack())) continue;
                task.cachedResourceIndex = i;
                return ir2;
            }
            return null;
        }
        ResourceKey wanted = (ResourceKey)task.resource.get();
        if (wanted instanceof ItemResource) {
            ItemResource cachedItem;
            ItemStack stack;
            ResourceKey cached;
            if (task.cachedResourceIndex >= 0 && task.cachedResourceIndex < all.size() && (cached = ((ResourceAmount)all.get(task.cachedResourceIndex)).resource()) instanceof ItemResource && OmniGridResourceHandler.matchesTask(stack = (cachedItem = (ItemResource)cached).toItemStack(), task) && this.isSmeltable(stack, level)) {
                return cachedItem;
            }
            for (int i = 0; i < all.size(); ++i) {
                ItemResource ir;
                ItemStack stack2;
                ResourceKey key = ((ResourceAmount)all.get(i)).resource();
                if (!(key instanceof ItemResource) || !OmniGridResourceHandler.matchesTask(stack2 = (ir = (ItemResource)key).toItemStack(), task) || !this.isSmeltable(stack2, level)) continue;
                task.cachedResourceIndex = i;
                return ir;
            }
            return null;
        }
        return null;
    }

    public long getStored() {
        return this.storage.getStored();
    }

    public Optional<TrackedResource> findTrackedResourceByActorType(ResourceKey resource, Class<? extends Actor> actorType) {
        return this.storage.findTrackedResourceByActorType(resource, actorType);
    }

    public long getFuzzy(ResourceKey resourceKey) {
        long total = 0L;
        if (resourceKey instanceof ItemResource) {
            ItemResource ir = (ItemResource)resourceKey;
            for (ResourceAmount ra : this.getAll()) {
                ItemResource res;
                ResourceKey resourceKey2 = ra.resource();
                if (!(resourceKey2 instanceof ItemResource) || (res = (ItemResource)resourceKey2).item() != ir.item()) continue;
                total += ra.amount();
            }
        }
        return total;
    }
}

