/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.google.common.util.concurrent.RateLimiter;
import com.omnigrid.OmniRegulator.StorageRestriction;
import com.omnigrid.Regulator.OmniRegulator;
import com.omnigrid.Regulator.RestrictionMode;
import com.omnigrid.Utils.MergedPattern;
import com.omnigrid.Utils.OmniCompositePositionedExternalStorage;
import com.omnigrid.Utils.OmniEnergyImporterTransferStrategyFactory;
import com.omnigrid.Utils.OmniExporterStrategy;
import com.omnigrid.Utils.OmniFilterData;
import com.omnigrid.Utils.OmniOverclockerPlusItem;
import com.omnigrid.Utils.OmniProxxyStorage;
import com.omnigrid.Utils.OmniProxyDisk;
import com.omnigrid.Utils.OmniSelfNetwork;
import com.omnigrid.Utils.OmniTaskFilter;
import com.omnigrid.Utils.OmniUpgradeState;
import com.omnigrid.Utils.OmniUtilityItem;
import com.omnigrid.Utils.OmniVoider;
import com.omnigrid.Utils.RangedInvHandler;
import com.omnigrid.Utils.RefinedTypesUtil;
import com.omnigrid.Utils.SmeltResult;
import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.Utils.UtilityBundle;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.BasicCrafting;
import com.omnigrid.neoforge.Config;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.DataComponents;
import com.omnigrid.neoforge.FurnaceData;
import com.omnigrid.neoforge.InteractionUtils;
import com.omnigrid.neoforge.OmniBlockTarget;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniCraftTask;
import com.omnigrid.neoforge.OmniCraftTaskManager;
import com.omnigrid.neoforge.OmniEffectPacket;
import com.omnigrid.neoforge.OmniEnergyExporterStrategyFactory;
import com.omnigrid.neoforge.OmniFurnaceSlot;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniGridResourceHandler;
import com.omnigrid.neoforge.OmniGridStorage;
import com.omnigrid.neoforge.OmniGridTask;
import com.omnigrid.neoforge.OmniResourceDirection;
import com.omnigrid.neoforge.OmniRootStorage;
import com.omnigrid.neoforge.OmniUtilityInventory;
import com.omnigrid.neoforge.Platform;
import com.omnigrid.neoforge.PlayerTargetting;
import com.omnigrid.neoforge.UpdateTracker;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternLayout;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatus;
import com.refinedmods.refinedstorage.api.autocrafting.status.TaskStatusListener;
import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.autocrafting.task.Task;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.autocrafting.ParentContainer;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternListener;
import com.refinedmods.refinedstorage.api.network.autocrafting.PatternProvider;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.energy.EnergyProvider;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.node.importer.CompositeImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.security.Permission;
import com.refinedmods.refinedstorage.api.network.security.SecurityActor;
import com.refinedmods.refinedstorage.api.network.security.SecurityNetworkComponent;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.TrackedResourceAmount;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorage;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageListener;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageProvider;
import com.refinedmods.refinedstorage.api.storage.root.RootStorageListener;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.exporter.ExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.importer.ImporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.security.PlatformSecurityNetworkComponent;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.autocrafting.PatternItem;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeState;
import com.ultramega.refinedtypes.importer.EnergyImporterTransferStrategyFactory;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class OmniItemProxxy
implements IItemHandler,
StorageNetworkComponent,
AutocraftingNetworkComponent,
PatternProvider,
EnergyProvider,
PlatformSecurityNetworkComponent,
EnergyNetworkComponent,
SecurityNetworkComponent {
    private int processQuantity = 1;
    public int activeTasks = 0;
    public int taskIndex = 0;
    public int taskTimer = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniItemProxxy.class);
    public boolean equipped = false;
    public boolean furnaceDirty = false;
    public String smelting = "";
    @javax.annotation.Nullable
    public BlockPos blockPos;
    private List<UUID> uuids = new ArrayList<UUID>();
    private List<UUID> linkedOmniGrids = new ArrayList<UUID>();
    public int healCD = 0;
    public int overclock = 0;
    public Level level;
    public long[] trackValues = new long[4];
    public int updateTrackerCD = 0;
    public List<UtilityType> utilityTypes = new ArrayList<UtilityType>();
    private int speed = 0;
    public float stress = 0.0f;
    public boolean dirtyResourceSlots = false;
    public int energy = 0;
    private float craftCooldown = 0.0f;
    private int range = 0;
    private boolean isDirty = false;
    public float accumulatedXp = 0.0f;
    private int emptyTicks = 0;
    public ArrayList<OmniGridTask> cachedTasks = new ArrayList();
    public ArrayList<OmniGridTask> blockForcedCrafting = new ArrayList();
    private OmniCommandData commandData;
    Map<ResourceKey, List<MergedPattern>> patterns = new HashMap<ResourceKey, List<MergedPattern>>();
    Map<ResourceKey, List<Pattern>> patternsByResource = new HashMap<ResourceKey, List<Pattern>>();
    private OmniGridStorage omniStorage;
    public boolean dirtyUI = false;
    public UUID uuid;
    public boolean dirtyStats = false;
    @javax.annotation.Nullable
    public UUID player;
    public double smeltingProgress = 0.0;
    public int fuel = 0;
    public int selectedIndex = 0;
    private final OmniCraftTaskManager taskManager;
    public RateLimiter proxyUpdate = RateLimiter.create((double)0.5);
    public OmniSelfNetwork network;
    private OmniUtilityInventory inventory;
    private int stacked = 0;
    @javax.annotation.Nullable
    public BlockPos taskCenterPosition;
    @javax.annotation.Nullable
    public Direction beDirection;
    public List<ExternalStorage> externalStorageProviders = new ArrayList<ExternalStorage>();
    public boolean isBlockForm = false;
    @javax.annotation.Nullable
    public Component name = null;
    public final net.minecraft.resources.ResourceKey<Level> levelKey;
    public EnergyStorage energyStorage;
    public int color = 7;
    public int cachedStorageCount = 0;
    public int stressCooldown = 5;
    public double toDrain = 0.0;
    public int cd = 20;
    @javax.annotation.Nullable
    public PlatformResourceKey cachedSmeltingTarget = null;
    private boolean storageDirty = true;
    private RateLimiter storageCleaner = RateLimiter.create((double)0.05);
    private static final int STRESS_SYNC_INTERVAL = 20;
    private int stressSyncCooldown = 0;
    private static final boolean DEBUG_PROCESSING = false;
    public boolean permaClocked = false;
    public final Set<Pattern> allPatterns = new HashSet<Pattern>();
    private final Set<PatternListener> patternListeners = new HashSet<PatternListener>();
    public static final TagKey<Fluid> XP_TAG = TagKey.create((net.minecraft.resources.ResourceKey)Registries.FLUID, (ResourceLocation)ResourceLocation.tryBuild((String)"c", (String)"experience"));
    @javax.annotation.Nullable
    public static Fluid xpFluid = Fluids.WATER;
    private final Set<PatternListener> listeners = new HashSet<PatternListener>();

    public List<UUID> getUuids() {
        return this.uuids;
    }

    public void setUuids(List<UUID> uuids) {
        this.uuids = uuids;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getProcessQuantity() {
        return this.processQuantity;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getRange() {
        return this.range;
    }

    public int getRemoteRange() {
        int r = this.range;
        if (this.utilityTypes.contains((Object)UtilityType.REMOTE_BOOSTER)) {
            r += 2;
        }
        return r * 6;
    }

    public void setRange(int range) {
        this.range = range;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public int getStacks() {
        return this.stacked;
    }

    public void setProcessQuantity(int processQuantity) {
        this.processQuantity = processQuantity;
    }

    public ArrayList<OmniGridTask> getCachedTasks() {
        return this.cachedTasks;
    }

    public OmniUtilityInventory getInventory() {
        return this.inventory;
    }

    public OmniCraftTaskManager getTaskManager() {
        return this.taskManager;
    }

    public void tick() {
        this.taskManager.tickTasks();
    }

    public void setInventory(OmniUtilityInventory inventory) {
        this.inventory = inventory;
    }

    public OmniItemProxxy(OmniUtilityInventory inv, OmniCommandData data, Level level, UUID uuid, @javax.annotation.Nullable BlockPos blockPos, @javax.annotation.Nullable Direction blockDirection, EnergyStorage energyStorage) {
        this.levelKey = level.dimension();
        this.blockPos = blockPos;
        this.taskCenterPosition = blockPos;
        this.beDirection = blockDirection;
        this.energyStorage = energyStorage;
        this.taskManager = new OmniCraftTaskManager(this);
        this.inventory = inv;
        this.uuid = uuid;
        this.network = new OmniSelfNetwork(uuid);
        this.uuids = new ArrayList<UUID>();
        for (int i = 0; i < 8; ++i) {
            ItemStack disk = inv.getItem(i);
            if (!disk.has(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference())) continue;
            if (disk.getItem() instanceof StorageContainerItem) {
                this.uuids.add((UUID)disk.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()));
            }
            if (!(disk.getItem() instanceof OmniProxyDisk) || disk.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()) == uuid) continue;
            this.linkedOmniGrids.add((UUID)disk.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()));
        }
        this.level = level;
        this.stacked = data.getUpgrades()[1];
        this.speed = data.getUpgrades()[0];
        this.range = data.getUpgrades()[2];
        this.energy = data.getUpgrades()[3];
        if (this.stacked > 0) {
            this.processQuantity = 64 * (int)Math.pow(4.0, this.stacked - 1);
        }
        boolean bl = this.isBlockForm = blockDirection != null;
        if (this.isBlockForm) {
            this.resetResourceHandlers();
        }
        this.setUpdatedData(data);
        this.smeltingProgress = data.getBurnTime();
        Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
        for (int i = 0; i < 16; ++i) {
            Direction accessSide;
            if (data.disabledCommands[i] || data.commands[i].getAction() == 0 && data.commands[i].getTarget() != 7) continue;
            Optional<PlatformResourceKey> resOpt = Optional.ofNullable(data.commands[i].getResource());
            int actionIndex = data.commands[i].getAction();
            int directionIndex = data.commands[i].getTarget();
            int typeIndex = data.commands[i].getMode();
            OmniGridTask task = new OmniGridTask(i, resOpt, actionIndex, directionIndex, typeIndex, data.commands[i].isInverted(), data.commands[i].isLinked(), data.getUpgrades(), data.commands[i].getQuantity(), data.commands[i].getTargetConfig());
            if (!task.isBlockTarget && task.isDirectional && this.isBlockForm) {
                OmniResourceDirection resDir = task.direction;
                BlockPos center = this.taskCenterPosition;
                accessSide = OmniItemProxxy.mapRelativeProvide(resDir, this.beDirection);
                if (task.provide || task.blacklist) {
                    AbstractOmniGridBlockEntity entity = this.getBlockEntity();
                    if (entity == null) continue;
                    Direction direction = accessSide.getOpposite();
                    if (entity.resourceHandler == null || !entity.resourceHandler.containsKey(direction)) continue;
                    if (task.provide) {
                        entity.resourceHandler.get((Object)accessSide.getOpposite()).exportWhiteList.add(task);
                    } else if (task.blacklist) {
                        entity.resourceHandler.get((Object)accessSide.getOpposite()).insertionBlacklist.add(task);
                    }
                } else if (center != null && resDir != null && resDir != OmniResourceDirection.PLAYER) {
                    BlockPos adjacent = OmniItemProxxy.computeAdjacentTarget(center, resDir, this.beDirection.getOpposite());
                    task.blockTarget = new OmniBlockTarget(Items.CHEST, adjacent, accessSide);
                    task.linkContainer = false;
                    task.isBlockTarget = true;
                }
            }
            if (task.isBlockTarget) {
                if (task.blockTarget == null) {
                    task.blockTarget = data.getBlockTarget(task.blockTargetIndex);
                }
                if (task.blockTarget == null) continue;
                OmniBlockTarget target = task.blockTarget;
                BlockPos targetPos = target.getPosition().relative(target.getDirection());
                accessSide = target.getDirection().getOpposite();
                if (task.push) {
                    ExporterTransferStrategy ex = this.createExporterStrategy((ServerLevel)level, accessSide, targetPos);
                    task.exporters.put(target.getPosition(), ex);
                }
                if (task.external) {
                    this.externalStorageProviders.add(new ExternalStorage(this.createExternalStorageStrategy((ServerLevel)level, target.getDirection(), target.getPosition(), this::getCurrentPosition, this.getRemoteRange(), task), (ExternalStorageListener)new SpyingExternalStorageListener(this)));
                }
                if (task.pull) {
                    ImporterTransferStrategy im = this.createImporterStrategy((ServerLevel)level, accessSide, targetPos);
                    task.importers.put(target.getPosition(), im);
                }
                if (task.linkContainer) {
                    List<BlockPos> linkedPositions = TransferUtils.discoverLinkedPositions((Level)((ServerLevel)level), target);
                    if (task.maintain) {
                        task.cacheBlockPositions = linkedPositions;
                    } else {
                        for (BlockPos linkedPos : linkedPositions) {
                            if (linkedPos.equals((Object)targetPos)) continue;
                            BlockPos targ = linkedPos.relative(target.getDirection());
                            if (task.push) {
                                task.exporters.put(linkedPos, this.createExporterStrategy((ServerLevel)level, accessSide, targ));
                            }
                            if (!task.pull) continue;
                            task.importers.put(linkedPos, this.createImporterStrategy((ServerLevel)level, accessSide, targ));
                        }
                    }
                }
            }
            if (task.player && this.isBlockForm) continue;
            if (task.compress && task.basicCrafting == BasicCrafting.BLOCK_FORCED && data.isCoreInstalled(CoreTypes.AUTOCRAFTING)) {
                this.blockForcedCrafting.add(task);
                continue;
            }
            if (!data.isValidTask(task)) continue;
            this.cachedTasks.add(task);
        }
        this.patterns = this.resolveUtilitySlots(level);
        this.getOrCreateStorage();
    }

    @javax.annotation.Nullable
    public AbstractOmniGridBlockEntity getBlockEntity() {
        if (!this.isBlockForm || this.blockPos == null) {
            return null;
        }
        BlockEntity be = this.level.getBlockEntity(this.blockPos);
        if (!(be instanceof AbstractOmniGridBlockEntity)) {
            LOGGER.warn("[OmniGrid] resetResourceHandlers aborted: no valid OmniGrid block entity at {}", (Object)this.blockPos);
            return null;
        }
        AbstractOmniGridBlockEntity entity = (AbstractOmniGridBlockEntity)be;
        return entity;
    }

    public void resetResourceHandlers() {
        if (this.level == null) {
            LOGGER.warn("[OmniGrid] resetResourceHandlers aborted: level is null");
            return;
        }
        if (this.blockPos == null) {
            LOGGER.warn("[OmniGrid] resetResourceHandlers aborted: blockPos is null");
            return;
        }
        BlockEntity be = this.level.getBlockEntity(this.blockPos);
        if (!(be instanceof AbstractOmniGridBlockEntity)) {
            LOGGER.warn("[OmniGrid] resetResourceHandlers aborted: no valid OmniGrid block entity at {}", (Object)this.blockPos);
            return;
        }
        AbstractOmniGridBlockEntity entity = (AbstractOmniGridBlockEntity)be;
        if (entity.resourceHandler == null) {
            LOGGER.warn("[OmniGrid] resetResourceHandlers aborted: resourceHandler map is null");
            return;
        }
        for (Direction direction : Direction.values()) {
            OmniGridResourceHandler obj = entity.resourceHandler.get(direction);
            if (!(obj instanceof OmniGridResourceHandler)) continue;
            OmniGridResourceHandler res = obj;
            res.insertionBlacklist.clear();
            res.exportWhiteList.clear();
        }
    }

    public static Direction mapRelative(OmniResourceDirection dir, Direction beFacing) {
        if (dir == null) {
            return null;
        }
        return switch (dir) {
            case OmniResourceDirection.FRONT -> beFacing;
            case OmniResourceDirection.BACK -> beFacing.getOpposite();
            case OmniResourceDirection.LEFT -> beFacing.getCounterClockWise();
            case OmniResourceDirection.RIGHT -> beFacing.getClockWise();
            case OmniResourceDirection.UP -> Direction.UP;
            case OmniResourceDirection.DOWN -> Direction.DOWN;
            default -> null;
        };
    }

    public static Direction mapRelativeProvide(OmniResourceDirection dir, Direction beFacing) {
        if (dir == null) {
            return null;
        }
        return switch (dir) {
            case OmniResourceDirection.FRONT -> beFacing.getOpposite();
            case OmniResourceDirection.BACK -> beFacing;
            case OmniResourceDirection.LEFT -> beFacing.getCounterClockWise();
            case OmniResourceDirection.RIGHT -> beFacing.getClockWise();
            case OmniResourceDirection.UP -> Direction.UP;
            case OmniResourceDirection.DOWN -> Direction.DOWN;
            default -> null;
        };
    }

    public static BlockPos computeAdjacentTarget(BlockPos center, OmniResourceDirection resDir, Direction beFacing) {
        Direction worldDir = OmniItemProxxy.mapRelative(resDir, beFacing);
        if (resDir == OmniResourceDirection.FRONT || resDir == OmniResourceDirection.BACK) {
            return center.relative(worldDir.getOpposite());
        }
        if (worldDir == null) {
            return null;
        }
        return center.relative(worldDir);
    }

    private ExporterTransferStrategy createExporterStrategy(ServerLevel serverLevel, Direction direction, BlockPos blockPos) {
        Direction incomingDirection = direction.getOpposite();
        BlockPos sourcePosition = blockPos.relative(direction);
        List factories = RefinedStorageApi.INSTANCE.getExporterTransferStrategyRegistry().getAll();
        if (this.utilityTypes.contains((Object)UtilityType.CREATIVE)) {
            this.energy = 4;
        }
        Map<Class<? extends ResourceKey>, ExporterTransferStrategy> strategies = factories.stream().collect(Collectors.toMap(ExporterTransferStrategyFactory::getResourceType, factory -> factory.create(serverLevel, sourcePosition, incomingDirection, (UpgradeState)new OmniUpgradeState(this.stacked, this.energy), false)));
        strategies.put(EnergyResource.class, new OmniEnergyExporterStrategyFactory().create(serverLevel, sourcePosition, incomingDirection, new OmniUpgradeState(this.stacked, this.energy), false));
        return new OmniExporterStrategy(strategies, this.uuid);
    }

    public int processPullPush(OmniGridTask task, int needed) {
        BlockPos pos;
        boolean succeededThisCycle;
        BlockPos position = this.taskCenterPosition;
        int successes = 0;
        int range = this.getRemoteRange();
        BlockPos targetPos = task.blockTarget.getPosition();
        int dx = Math.abs(position.getX() - targetPos.getX());
        int dy = Math.abs(position.getY() - targetPos.getY());
        int dz = Math.abs(position.getZ() - targetPos.getZ());
        if (dx > range || dy > range || dz > range) {
            return 0;
        }
        int remotePenalty = this.getEnergy();
        if (!task.importers.isEmpty()) {
            while (successes < needed) {
                succeededThisCycle = false;
                for (Map.Entry<BlockPos, ImporterTransferStrategy> entry : task.importers.entrySet()) {
                    pos = entry.getKey();
                    ImporterTransferStrategy importer = entry.getValue();
                    boolean ok = importer.transfer((Filter)new OmniTaskFilter(task), (Actor)new PlayerActor("Pull"), (Network)this.network);
                    this.VisibleEffect(this.level, pos, ok);
                    if (!ok) continue;
                    ++successes;
                    succeededThisCycle = true;
                }
                if (succeededThisCycle) continue;
                break;
            }
        }
        if (!task.exporters.isEmpty()) {
            while (successes < needed) {
                succeededThisCycle = false;
                for (Map.Entry<BlockPos, ImporterTransferStrategy> entry : task.exporters.entrySet()) {
                    pos = entry.getKey();
                    ExporterTransferStrategy exporter = (ExporterTransferStrategy)entry.getValue();
                    ResourceKey res = this.getOrCreateStorage().getResourceForTask(task);
                    if (res == null) {
                        this.VisibleEffect(this.level, pos, false);
                        continue;
                    }
                    ExporterTransferStrategy.Result result = exporter.transfer(res, (Actor)new PlayerActor("Pull"), (Network)this.network);
                    this.VisibleEffect(this.level, pos, result == ExporterTransferStrategy.Result.EXPORTED);
                    if (result != ExporterTransferStrategy.Result.EXPORTED) continue;
                    ++successes;
                    succeededThisCycle = true;
                }
                if (succeededThisCycle) continue;
                break;
            }
        }
        return successes;
    }

    public void VisibleEffect(Level level, BlockPos pos, boolean active) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Player player : level.players()) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer sp = (ServerPlayer)player;
                com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient(sp, (CustomPacketPayload)new OmniEffectPacket(pos.asLong(), (byte)this.color, active));
            }
        }
    }

    public BlockPos getCurrentPosition() {
        return this.taskCenterPosition;
    }

    private ExternalStorageProvider createExternalStorageStrategy(ServerLevel serverLevel, Direction direction, BlockPos blockPos, Supplier<BlockPos> runPosition, int range, OmniGridTask task) {
        return new OmniCompositePositionedExternalStorage(RefinedStorageApi.INSTANCE.getExternalStorageProviderFactories().stream().map(factory -> factory.create(serverLevel, blockPos, direction)).toList(), blockPos, runPosition, range, task);
    }

    private ImporterTransferStrategy createImporterStrategy(ServerLevel serverLevel, Direction direction, BlockPos blockPos) {
        Direction incomingDirection = direction.getOpposite();
        BlockPos sourcePosition = blockPos.relative(direction);
        ArrayList<ImporterTransferStrategyFactory> factories = new ArrayList<ImporterTransferStrategyFactory>(RefinedStorageApi.INSTANCE.getImporterTransferStrategyRegistry().getAll());
        factories.removeIf(factory -> factory instanceof EnergyImporterTransferStrategyFactory);
        factories.add(new OmniEnergyImporterTransferStrategyFactory());
        return new CompositeImporterTransferStrategy(factories.stream().map(factory -> factory.create(serverLevel, sourcePosition, incomingDirection, (UpgradeState)new OmniUpgradeState(this.stacked, this.energy))).toList());
    }

    public boolean verifyEnergy() {
        if (this.utilityTypes.contains((Object)UtilityType.ENERGY_BREAKER) && this.energyStorage.getStored() <= this.getMaxStress()) {
            return false;
        }
        return this.energyStorage.getStored() > 0L;
    }

    public long getMaxStress() {
        return this.energyStorage.getCapacity() / (long)(5 - this.getEnergy());
    }

    public void drainEnergyFromToDrain(EnergyStorage eStorage) {
        if (this.toDrain < 1.0) {
            return;
        }
        int amt = (int)this.toDrain;
        if (amt >= 1) {
            int extracted = Math.toIntExact(eStorage.extract((long)amt, Action.EXECUTE));
            this.toDrain -= (double)extracted;
        }
    }

    public boolean diminishStress(EnergyStorage eStorage) {
        this.drainEnergyFromToDrain(eStorage);
        this.updateStress(eStorage);
        if (this.utilityTypes.contains((Object)UtilityType.CREATIVE)) {
            this.stress = 0.0f;
            return false;
        }
        long maxStress = this.getMaxStress();
        if (maxStress <= 0L) {
            this.stress = 0.0f;
            return false;
        }
        if (this.stressCooldown > 0) {
            --this.stressCooldown;
        } else if (this.stress > 0.0f) {
            double stressRatio = (double)this.stress / (double)maxStress;
            double stressPercent = stressRatio * 100.0;
            long decay = maxStress / 1000L;
            decay += (long)this.getEnergy() * (maxStress / 1000L);
            if (stressPercent > 20.0 && !this.utilityTypes.contains((Object)UtilityType.ENERGY_BREAKER)) {
                double over = stressPercent - 20.0;
                double decayMultiplier = 1.0 + over * 0.05;
                decay = (long)((double)decay * decayMultiplier);
            }
            decay = (long)Math.min((float)decay, this.stress);
            this.stressCooldown = Math.max(0, Math.toIntExact(5L - decay));
            int power = Math.toIntExact(decay);
            if (this.overclock > 0) {
                power *= 2;
            }
            this.toDrain += (double)((float)power * (1.0f - (float)this.getEnergy() * 0.1f));
            this.stress -= (float)decay;
        }
        if (this.stress > (float)maxStress) {
            this.stressCooldown = 0;
            return true;
        }
        return false;
    }

    public void attemptAbsorb() {
        if (!this.utilityTypes.contains((Object)UtilityType.SPONGE)) {
            return;
        }
        if (this.cd > 0) {
            --this.cd;
            return;
        }
        this.cd = 20;
        this.absorbFluidsAround(this.taskCenterPosition);
    }

    public boolean attemptProcess() {
        this.externalStorageProviders.forEach(ExternalStorage::detectChanges);
        if (this.proxyUpdate.tryAcquire() && this.taskCenterPosition != null && !this.utilityTypes.contains((Object)UtilityType.PROXY_ACCESSOR)) {
            for (Storage storage : this.getOrCreateStorage().storage.getSources()) {
                if (!(storage instanceof OmniProxxyStorage)) continue;
                OmniProxxyStorage proxxyStorage = (OmniProxxyStorage)storage;
                proxxyStorage.thisPosition = this.taskCenterPosition;
            }
        }
        if (this.overclock > 0) {
            --this.overclock;
        } else if (this.permaClocked) {
            this.overclock = 100;
        }
        if (this.utilityTypes.contains((Object)UtilityType.CREATIVE)) {
            this.stress = 0.0f;
            return true;
        }
        if (!this.verifyEnergy()) {
            return false;
        }
        if (this.craftCooldown <= 0.0f) {
            double stressRatio;
            this.craftCooldown = 10 - this.speed * 2;
            if (this.overclock > 0) {
                this.craftCooldown -= 2.0f;
            }
            if (this.utilityTypes.contains((Object)UtilityType.ENERGY_BREAKER) && (stressRatio = (double)this.stress / (double)this.getMaxStress()) > 0.2 && stressRatio <= 1.0) {
                double over = stressRatio * 100.0 - 20.0;
                double slowdown = 1.0 + over * 0.05;
                this.craftCooldown = (int)Math.ceil((double)this.craftCooldown * slowdown);
            }
            return true;
        }
        this.craftCooldown -= 1.0f;
        return false;
    }

    public boolean placeBlockTask(Player player, OmniGridTask omniGridTask) {
        ResourceKey resource = this.getOrCreateStorage().getResourceForTask(omniGridTask);
        if (resource == null || !this.utilityTypes.contains((Object)UtilityType.CONSTRUCTOR)) {
            return false;
        }
        return this.placeBlockFromStorage(player, resource, omniGridTask.direction, omniGridTask);
    }

    public boolean placeBlockFromStorage(Player player, ResourceKey key, OmniResourceDirection direction, OmniGridTask task) {
        boolean canReplace;
        ItemResource res;
        Item item;
        if (player == null || direction == null) {
            return false;
        }
        Level level = player.level();
        if (level.isClientSide) {
            return false;
        }
        if (!(key instanceof ItemResource) || !((item = (res = (ItemResource)key).item()) instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        boolean isCrawling = player.getPose() == Pose.CROUCHING || player.getPose() == Pose.SHOOTING || player.getPose() == Pose.SLIDING || player.getPose() == Pose.SITTING;
        BlockPos playerPos = player.blockPosition();
        int verticalOffset = !isCrawling && direction != OmniResourceDirection.DOWN ? 1 : 0;
        Direction facing = player.getDirection();
        Direction worldDir = switch (direction) {
            case OmniResourceDirection.FRONT -> facing;
            case OmniResourceDirection.BACK -> facing.getOpposite();
            case OmniResourceDirection.LEFT -> facing.getCounterClockWise();
            case OmniResourceDirection.RIGHT -> facing.getClockWise();
            case OmniResourceDirection.UP -> Direction.UP;
            default -> Direction.DOWN;
        };
        BlockPos basePos = playerPos.relative(worldDir);
        BlockPos targetPos = basePos.above(verticalOffset);
        if (!InteractionUtils.canInteractWithBlock(player, level, targetPos, Direction.DOWN)) {
            task.cooldown = 60;
            return false;
        }
        BlockState old = level.getBlockState(targetPos);
        BlockState placeState = blockItem.getBlock().defaultBlockState();
        boolean bl = canReplace = old.canBeReplaced() || old.isAir() || level.isEmptyBlock(targetPos);
        if (!canReplace) {
            return false;
        }
        long extracted = this.getOrCreateStorage().extract(key, 1L, Action.EXECUTE, Actor.EMPTY);
        if (extracted <= 0L) {
            return false;
        }
        if (!level.setBlock(targetPos, placeState, 3)) {
            this.getOrCreateStorage().insert(key, 1L, Action.EXECUTE, Actor.EMPTY);
            return false;
        }
        placeState.getBlock().setPlacedBy(level, targetPos, placeState, (LivingEntity)player, ItemStack.EMPTY);
        this.VisibleEffect(level, targetPos, true);
        return true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.furnaceDirty = true;
        this.isDirty = dirty;
    }

    public OmniCommandData getCachedData() {
        this.setDirty(false);
        return this.commandData;
    }

    public void setUpdatedData(OmniCommandData updatedData) {
        this.commandData = updatedData;
    }

    public int basicCraftingInStorage(OmniGridTask task, int amountLimit, Level level) {
        if (amountLimit <= 0) {
            return 0;
        }
        BasicCrafting mode = task.basicCrafting;
        if (mode == null) {
            return 0;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0;
        }
        if (task.jeiCraft) {
            // empty if block
        }
        return switch (mode) {
            default -> throw new MatchException(null, null);
            case BasicCrafting.COMPRESS_3x3 -> this.runCompression(task, amountLimit, 9, this::get3x3CraftingResult);
            case BasicCrafting.COMPRESS_2x2 -> this.runCompression(task, amountLimit, 4, this::get2x2CraftingResult);
            case BasicCrafting.DECOMPRESS_1x1 -> this.runDecompression(task, amountLimit);
            case BasicCrafting.ROW_3x1 -> this.runLineCraft(task, amountLimit, 3, this::get3x1CraftingResult);
            case BasicCrafting.COLUMN_1x3 -> this.runLineCraft(task, amountLimit, 3, this::get1x3CraftingResult);
            case BasicCrafting.REQUEST -> this.runRequest(task);
            case BasicCrafting.SMELT -> this.transferSmelt(task);
            case BasicCrafting.BLOCK_FORCED -> 0;
        };
    }

    public int transferSmelt(OmniGridTask task) {
        PlatformResourceKey resource = this.getOrCreateStorage().getSmeltableResourceForTask(task, this.level);
        if (resource != this.cachedSmeltingTarget) {
            this.cachedSmeltingTarget = resource;
        }
        task.cooldown = 20;
        return 0;
    }

    private int runRequest(OmniGridTask task) {
        if (task.resource.isEmpty()) {
            return 0;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0;
        }
        PlatformResourceKey key = task.resource.get();
        if (!(key instanceof ItemResource)) {
            return 0;
        }
        if (task.maintainAmount != -1 && this.getOrCreateStorage().get((ResourceKey)key) >= (long)task.maintainAmount) {
            task.cooldown = 20;
            return 0;
        }
        ItemStack requestedStack = ((ItemResource)key).toItemStack();
        if (this.taskManager.hasTask((ResourceKey)key)) {
            return 0;
        }
        List<MergedPattern> list = this.patterns.get(key);
        if (list == null || list.isEmpty()) {
            return 0;
        }
        MergedPattern chosen = null;
        block0: for (MergedPattern p : list) {
            if (!p.isValid() || !ItemStack.isSameItemSameComponents((ItemStack)p.getPrimaryOutput(), (ItemStack)requestedStack)) continue;
            for (ItemStack in : p.getInputs()) {
                ItemResource r = ItemResource.ofItemStack((ItemStack)in);
                long needed = in.getCount();
                long available = storage.get((ResourceKey)r);
                if (available >= needed) continue;
                continue block0;
            }
            chosen = p;
            break;
        }
        if (chosen == null) {
            return 0;
        }
        if (chosen.getType() == PatternType.PROCESSING) {
            ItemStack firstInput;
            ItemStack itemStack = firstInput = chosen.getInputs().isEmpty() ? ItemStack.EMPTY : chosen.getInputs().getFirst();
            if (!firstInput.isEmpty()) {
                ItemResource inputRes = ItemResource.ofItemStack((ItemStack)firstInput);
                for (PlatformResourceKey smeltKey : this.commandData.furnaceData.smeltItems) {
                    ItemResource smeltItem;
                    if (!(smeltKey instanceof ItemResource) || !ItemStack.isSameItemSameComponents((ItemStack)(smeltItem = (ItemResource)smeltKey).toItemStack(), (ItemStack)firstInput)) continue;
                    return 0;
                }
            }
        }
        this.taskManager.addTask(new OmniCraftTask((ResourceKey)key, 1L, 1L, false));
        return 1;
    }

    public ItemStack get1x3CraftingResult(ItemStack input) {
        if (input.isEmpty()) {
            return ItemStack.EMPTY;
        }
        String key = TransferUtils.stackKey(input);
        if (TransferUtils.CRAFTING_CACHE_1x3.containsKey(key)) {
            return TransferUtils.CRAFTING_CACHE_1x3.get(key).copy();
        }
        TransientCraftingContainer tempCraft = new TransientCraftingContainer(new AbstractContainerMenu(this, null, -1){

            public ItemStack quickMoveStack(Player player, int index) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player playerIn) {
                return false;
            }
        }, 1, 3);
        for (int i = 0; i < 3; ++i) {
            tempCraft.setItem(i, input.copy());
        }
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)tempCraft.asCraftInput(), this.level);
        ItemStack result = recipe.isPresent() ? ((CraftingRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)tempCraft.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ItemStack.EMPTY;
        TransferUtils.CRAFTING_CACHE_1x3.put(key, result.copy());
        return result;
    }

    public ItemStack get2x2CraftingResult(ItemStack input) {
        if (input.isEmpty()) {
            return ItemStack.EMPTY;
        }
        String key = TransferUtils.stackKey(input);
        if (TransferUtils.CRAFTING_CACHE_2x2.containsKey(key)) {
            return TransferUtils.CRAFTING_CACHE_2x2.get(key).copy();
        }
        TransientCraftingContainer tempCraft = new TransientCraftingContainer(new AbstractContainerMenu(this, null, -1){

            public ItemStack quickMoveStack(Player player, int index) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player playerIn) {
                return false;
            }
        }, 2, 2);
        for (int i = 0; i < 4; ++i) {
            tempCraft.setItem(i, input.copy());
        }
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)tempCraft.asCraftInput(), this.level);
        ItemStack result = recipe.isPresent() ? ((CraftingRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)tempCraft.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ItemStack.EMPTY;
        TransferUtils.CRAFTING_CACHE_2x2.put(key, result.copy());
        return result;
    }

    private ItemStack getCraftResult(ItemStack original, TransientCraftingContainer temp) {
        Level lvl = this.level;
        Optional recipe = lvl.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)temp.asCraftInput(), lvl);
        return recipe.isPresent() ? ((CraftingRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)temp.asCraftInput(), (HolderLookup.Provider)lvl.registryAccess()) : ItemStack.EMPTY;
    }

    public ItemStack get3x3CraftingResult(ItemStack input) {
        if (input.isEmpty()) {
            return ItemStack.EMPTY;
        }
        String key = TransferUtils.stackKey(input);
        if (TransferUtils.CRAFTING_CACHE_3x3.containsKey(key)) {
            return TransferUtils.CRAFTING_CACHE_3x3.get(key).copy();
        }
        TransientCraftingContainer tempCraft = new TransientCraftingContainer(new AbstractContainerMenu(this, null, -1){

            public ItemStack quickMoveStack(Player player, int index) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player playerIn) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            tempCraft.setItem(i, input.copy());
        }
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)tempCraft.asCraftInput(), this.level);
        ItemStack result = recipe.isPresent() ? ((CraftingRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)tempCraft.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ItemStack.EMPTY;
        TransferUtils.CRAFTING_CACHE_3x3.put(key, result.copy());
        return result;
    }

    private int runCompression(OmniGridTask task, int amountLimit, int recipeSize, Function<ItemStack, ItemStack> computeResult) {
        OmniRootStorage storage = this.getOrCreateStorage();
        int total = 0;
        for (ResourceAmount ra : new ArrayList<ResourceAmount>(storage.getAll())) {
            int actual;
            int neededItems;
            long extracted;
            long available;
            int maxPossible;
            int compressions;
            ItemStack output;
            ItemResource ir;
            ItemStack base;
            ResourceKey resourceKey = ra.resource();
            if (!(resourceKey instanceof ItemResource) || !OmniGridResourceHandler.matchesTask(base = (ir = (ItemResource)resourceKey).toItemStack(), task) || (output = computeResult.apply(base)).isEmpty() || (compressions = Math.min(maxPossible = (int)((available = ra.amount()) / (long)recipeSize), amountLimit)) <= 0 || (extracted = this.extractFromStorages((ResourceKey)ir, neededItems = compressions * recipeSize, false, "Autocrafter")) <= 0L || (actual = (int)(extracted / (long)recipeSize)) <= 0) continue;
            ItemStack out = output.copy();
            out.setCount(out.getCount() * actual);
            long inserted = this.insertIntoStorages((ResourceKey)ItemResource.ofItemStack((ItemStack)out), out.getCount(), false, "Autocrafter");
            this.updateGridIfOpen((PlatformResourceKey)ir, -extracted);
            this.updateGridIfOpen(out, inserted);
            total = (int)((long)total + inserted);
            if ((amountLimit -= actual) > 0) continue;
            break;
        }
        return total;
    }

    private int runDecompression(OmniGridTask task, int amountLimit) {
        OmniRootStorage storage = this.getOrCreateStorage();
        int total = 0;
        for (ResourceAmount ra : new ArrayList<ResourceAmount>(storage.getAll())) {
            long extracted;
            long available;
            int craftable;
            ItemStack result;
            ItemResource ir;
            ItemStack input;
            ResourceKey resourceKey = ra.resource();
            if (!(resourceKey instanceof ItemResource) || !OmniGridResourceHandler.matchesTask(input = (ir = (ItemResource)resourceKey).toItemStack(), task) || (result = this.get1x1Result(input)).isEmpty() || (craftable = Math.min((int)(available = ra.amount()), amountLimit)) <= 0 || (extracted = this.extractFromStorages((ResourceKey)ir, craftable, false, "Autocrafter")) <= 0L) continue;
            ItemStack out = result.copy();
            out.setCount(out.getCount() * (int)extracted);
            long inserted = this.insertIntoStorages((ResourceKey)ItemResource.ofItemStack((ItemStack)out), out.getCount(), false, "Autocraft");
            this.updateGridIfOpen((PlatformResourceKey)ir, (long)(-((int)extracted)));
            this.updateGridIfOpen(out, inserted);
            total = (int)((long)total + inserted);
            if ((amountLimit -= (int)extracted) > 0) continue;
            break;
        }
        return total;
    }

    private int runLineCraft(OmniGridTask task, int amountLimit, int recipeSize, Function<ItemStack, ItemStack> computeResult) {
        return this.runCompression(task, amountLimit, recipeSize, computeResult::apply);
    }

    public ItemStack getShapeless1Result(ItemStack input) {
        if (input.isEmpty()) {
            return ItemStack.EMPTY;
        }
        String key = TransferUtils.stackKey(input);
        if (TransferUtils.CRAFTING_CACHE_1x1.containsKey(key)) {
            return TransferUtils.CRAFTING_CACHE_1x1.get(key).copy();
        }
        TransientCraftingContainer tempCraft = new TransientCraftingContainer(new AbstractContainerMenu(this, null, -1){

            public ItemStack quickMoveStack(Player player, int index) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player playerIn) {
                return false;
            }
        }, 1, 1);
        tempCraft.setItem(0, input.copy());
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)tempCraft.asCraftInput(), this.level);
        ItemStack result = recipe.isPresent() ? ((CraftingRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)tempCraft.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ItemStack.EMPTY;
        TransferUtils.CRAFTING_CACHE_1x1.put(key, result.copy());
        return result;
    }

    private ItemStack get1x1Result(ItemStack input) {
        return this.getShapeless1Result(input);
    }

    public ItemStack get3x1CraftingResult(ItemStack input) {
        if (input.isEmpty()) {
            return ItemStack.EMPTY;
        }
        String key = TransferUtils.stackKey(input);
        if (TransferUtils.CRAFTING_CACHE_3x1.containsKey(key)) {
            return TransferUtils.CRAFTING_CACHE_3x1.get(key).copy();
        }
        TransientCraftingContainer tempCraft = new TransientCraftingContainer(new AbstractContainerMenu(this, null, -1){

            public ItemStack quickMoveStack(Player player, int index) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player playerIn) {
                return false;
            }
        }, 3, 1);
        for (int i = 0; i < 3; ++i) {
            tempCraft.setItem(i, input.copy());
        }
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)tempCraft.asCraftInput(), this.level);
        ItemStack result = recipe.isPresent() ? ((CraftingRecipe)((RecipeHolder)recipe.get()).value()).assemble((RecipeInput)tempCraft.asCraftInput(), (HolderLookup.Provider)this.level.registryAccess()) : ItemStack.EMPTY;
        TransferUtils.CRAFTING_CACHE_3x1.put(key, result.copy());
        return result;
    }

    public int getStackCount() {
        int total = 0;
        if (this.level == null) {
            return 0;
        }
        for (UUID diskUuids : this.getUuids()) {
            Optional pos = RefinedStorageApi.INSTANCE.getStorageRepository(this.level).get(diskUuids);
            if (!pos.isPresent()) continue;
            total += ((SerializableStorage)RefinedStorageApi.INSTANCE.getStorageRepository(this.level).get(diskUuids).get()).getAll().size();
        }
        return total;
    }

    public OmniRootStorage getOrCreateStorage() {
        if (this.storageCleaner.tryAcquire() || this.omniStorage == null || this.storageDirty) {
            this.initializeStorage();
            this.storageDirty = false;
        }
        return this.omniStorage.getRootStorage();
    }

    public void doTasks(boolean isHeld, @javax.annotation.Nullable Player player) {
        if (this.isDirty) {
            return;
        }
        if (this.utilityTypes.contains((Object)UtilityType.LIMITER) && !isHeld) {
            return;
        }
        if (this.utilityTypes.contains((Object)UtilityType.LIMITER_INVERTED) && isHeld) {
            return;
        }
        this.attemptAbsorb();
        ArrayList<OmniGridTask> tasks = this.getCachedTasks();
        if (tasks == null || tasks.isEmpty()) {
            this.stressCooldown = 0;
            return;
        }
        int attempts = tasks.size();
        float activity = 0.0f;
        int successes = (int)Math.pow(2.0, this.getStacks());
        if (this.overclock > 0) {
            successes *= 4;
        }
        int completed = 0;
        while (attempts-- > 0 && completed < successes) {
            block14: {
                OmniGridTask task;
                if (this.taskIndex >= tasks.size()) {
                    this.taskIndex = 0;
                }
                if ((task = (OmniGridTask)tasks.get(this.taskIndex++)) == null || !task.isValid) continue;
                if (task.cooldown > 0) {
                    --task.cooldown;
                    continue;
                }
                try {
                    float result = this.runSingleTask(task, player, this.level);
                    if (result > 0.0f) {
                        ++completed;
                        activity += result;
                    } else {
                        task.cooldown = 1 + this.getSpeed();
                    }
                }
                catch (Exception e) {
                    task.isValid = false;
                    if (player == null) break block14;
                    Object resource = "";
                    if (task.resource.isPresent()) {
                        resource = (String)resource + String.valueOf(task.resource) + " ";
                    }
                    player.displayClientMessage((Component)Component.literal((String)("Omni Grid terminated task " + task.idx + " : " + (String)resource + String.valueOf((Object)task.action) + " " + String.valueOf((Object)task.direction) + " with error " + e.getLocalizedMessage())).withStyle(ChatFormatting.RED), false);
                    LOGGER.info("Omni Grid terminated task " + task.idx + " : " + (String)resource + String.valueOf((Object)task.action) + " " + String.valueOf((Object)task.direction) + " with error " + e.getLocalizedMessage());
                }
            }
            if (completed < successes) continue;
            break;
        }
        this.stress += (float)this.getOrCreateStorage().consumePrinterDrain();
        if (activity <= 0.0f) {
            --this.stressCooldown;
        }
    }

    private float runSingleTask(OmniGridTask task, @javax.annotation.Nullable Player player, Level level) {
        if ((task.player || task.open) && this.isBlockForm) {
            return 0.0f;
        }
        float activity = 0.0f;
        int range = 2 + this.getRange() * 2;
        int amount = this.getProcessQuantity();
        int processes = this.getStacks();
        switch (processes) {
            case 2: {
                processes = 4;
                break;
            }
            case 3: {
                processes = 16;
                break;
            }
            default: {
                processes = 1;
            }
        }
        if (this.overclock > 0) {
            processes *= 2;
        }
        Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
        int compressPerFE = cfg.compressPerFE();
        int searchPerFE = cfg.searchPerFE();
        int vacuumPerFE = cfg.vacuumPerFE();
        if (task.player || task.isBlockTarget) {
            if (task.maintain) {
                activity += (float)this.maintainItems(player, task, (int)Math.pow(4.0, this.getStacks()));
            } else if (task.player && !task.isBlockTarget) {
                if (task.push) {
                    activity += (float)this.transferItemsToPlayer(player, true, task, amount, 1);
                } else if (task.pull) {
                    activity += (float)this.transferItemsToPlayer(player, false, task, amount, 1);
                }
            }
        }
        if (task.push && task.isDirectional && this.placeBlockTask(player, task)) {
            activity += (float)cfg.constructorCoreFECost();
        }
        if (task.isBlockTarget) {
            activity += (float)this.processPullPush(task, processes);
        }
        if (task.compress) {
            float ops = this.basicCraftingInStorage(task, amount, level);
            activity += OmniItemProxxy.safeActivity(ops, compressPerFE);
        }
        if (task.search) {
            float moved = this.transferItemsFromNearbyContainers(level, task, range, amount, processes + 1);
            activity += OmniItemProxxy.safeActivity(moved, searchPerFE);
        } else if (task.collect) {
            float collected = this.collectItemsInArea(level, task, range, 64, processes + 2, player);
            activity += OmniItemProxxy.safeActivity(collected, vacuumPerFE);
        }
        return activity;
    }

    public int maintainItems(@javax.annotation.Nullable Player player, OmniGridTask task, int amountLimit) {
        task.cooldown = 3;
        if (task == null || !task.maintain) {
            return 0;
        }
        int desired = task.maintainAmount;
        if (player != null && task.isXP) {
            if (this.utilityTypes.contains((Object)UtilityType.XP_HANLDER)) {
                this.handlePlayerXP(player, false, task.fluid, desired);
            }
            return 0;
        }
        int current = 0;
        if (task.isBlockTarget) {
            if (task.linkContainer && task.cacheBlockPositions != null && !task.cacheBlockPositions.isEmpty()) {
                return this.maintainItemsInLinkedContainers(player, task, amountLimit);
            }
            if (task.blockTarget != null) {
                return this.maintainItemsInBlockTarget(player, task, amountLimit);
            }
            return 0;
        }
        if (player == null) {
            return 0;
        }
        if (task.player && task.playerTargetting == PlayerTargetting.CONTAINER_ITEMS) {
            return this.maintainItemsInPlayerContainerItem(player, task, amountLimit);
        }
        PlayerTargetting pt = task.playerTargetting != null ? task.playerTargetting : PlayerTargetting.INVENTORY_HOTBAR;
        InvWrapper fullInv = new InvWrapper((Container)player.getInventory());
        Object scopedHandler = null;
        switch (pt) {
            case HOTBAR: {
                scopedHandler = new RangedInvHandler((IItemHandler)fullInv, 0, 9);
                for (int i = 0; i < 9; ++i) {
                    current += OmniItemProxxy.countMatchingItemsInStack(player.getInventory().getItem(i), task);
                }
                break;
            }
            case INVENTORY_NO_HOTBAR: {
                scopedHandler = new RangedInvHandler((IItemHandler)fullInv, 9, 36);
                for (int i = 9; i < 36; ++i) {
                    current += OmniItemProxxy.countMatchingItemsInStack(player.getInventory().getItem(i), task);
                }
                break;
            }
            case OFFHAND: {
                scopedHandler = new RangedInvHandler((IItemHandler)fullInv, 40, 41);
                current += OmniItemProxxy.countMatchingItemsInStack(player.getOffhandItem(), task);
                break;
            }
            case ENDERCHEST: {
                scopedHandler = new InvWrapper((Container)player.getEnderChestInventory());
                current += TransferUtils.countMatchingItems((IItemHandler)scopedHandler, task);
                break;
            }
            default: {
                scopedHandler = fullInv;
                for (ItemStack s : player.getInventory().items) {
                    current += OmniItemProxxy.countMatchingItemsInStack(s, task);
                }
            }
        }
        return this.applyMaintainMovement(player, task, current, desired, amountLimit, (IItemHandler)scopedHandler, null);
    }

    public int applyMaintainMovement(Player player, OmniGridTask task, int current, int desired, int amountLimit, @javax.annotation.Nullable IItemHandler handler, @javax.annotation.Nullable BlockPos blockPos) {
        int delta = desired - current;
        if (delta == 0) {
            return 0;
        }
        int toMove = Math.min(Math.abs(delta), amountLimit);
        if (toMove <= 0) {
            return 0;
        }
        if (handler != null && blockPos != null) {
            if (delta > 0) {
                return this.moveFromStorageToHandler(task, handler, toMove);
            }
            return this.moveFromHandlerToStorage(task, handler, toMove);
        }
        if (handler != null) {
            if (delta > 0) {
                return this.moveFromStorageToHandler(task, handler, toMove);
            }
            return this.moveFromHandlerToStorage(task, handler, toMove);
        }
        return this.maintainMovementPlayerInventory(player, task, delta, toMove);
    }

    private int maintainMovementPlayerInventory(Player player, OmniGridTask task, int delta, int amount) {
        LOGGER.warn("[Maintain-DIAG] InvMaint: delta={} amount={}", (Object)delta, (Object)amount);
        LOGGER.warn("[Maintain-DIAG] Task key={} any={} invert={}", new Object[]{task.resource, task.any, task.isInverted()});
        if (delta > 0) {
            return this.moveFromStorageToPlayer(player, task, amount);
        }
        return this.moveFromPlayerToStorage(player, task, amount);
    }

    private int moveFromPlayerToStorage(Player player, OmniGridTask task, int amount) {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0;
        }
        PlatformResourceKey key = task.resource.get();
        if (!(key instanceof ItemResource)) {
            return 0;
        }
        ItemResource itemRes = (ItemResource)key;
        int movedTotal = 0;
        for (int i = 0; i < player.getInventory().items.size() && movedTotal < amount; ++i) {
            int request;
            int toExtract;
            ItemStack removed;
            ItemStack slot = (ItemStack)player.getInventory().items.get(i);
            if (slot.isEmpty() || !OmniGridResourceHandler.matchesTask(slot, task) || (removed = slot.split(toExtract = Math.min(request = amount - movedTotal, slot.getCount()))).isEmpty()) continue;
            int count = removed.getCount();
            long inserted = storage.insert((ResourceKey)itemRes, count, Action.EXECUTE, (Actor)new PlayerActor("Pull"));
            if (inserted < (long)count) {
                int leftover = count - (int)inserted;
                ItemStack giveBack = removed.copy();
                giveBack.setCount(leftover);
                player.getInventory().placeItemBackInInventory(giveBack);
            }
            movedTotal = (int)((long)movedTotal + inserted);
        }
        if (movedTotal > 0) {
            player.inventoryMenu.broadcastChanges();
        }
        return movedTotal;
    }

    private int moveFromStorageToPlayer(Player player, OmniGridTask task, int amount) {
        int request;
        long extracted;
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0;
        }
        PlatformResourceKey key = task.resource.get();
        if (!(key instanceof ItemResource)) {
            return 0;
        }
        ItemResource itemRes = (ItemResource)key;
        int movedTotal = 0;
        while (movedTotal < amount && (extracted = storage.extract((ResourceKey)itemRes, request = amount - movedTotal, Action.EXECUTE, (Actor)new PlayerActor("Push"))) > 0L) {
            ItemStack stack = itemRes.toItemStack((long)((int)extracted));
            int before = stack.getCount();
            boolean ok = player.getInventory().add(stack);
            if (ok && stack.isEmpty()) {
                movedTotal += before;
                continue;
            }
            int inserted = before - stack.getCount();
            movedTotal += inserted;
            if (stack.isEmpty()) continue;
            storage.insert((ResourceKey)itemRes, stack.getCount(), Action.EXECUTE, (Actor)new PlayerActor("Push"));
        }
        if (movedTotal > 0) {
            player.inventoryMenu.broadcastChanges();
        }
        return movedTotal;
    }

    public int maintainItemsInBlockTarget(@javax.annotation.Nullable Player player, OmniGridTask task, int amountLimit) {
        Direction accessSide;
        if (task.blockTarget == null) {
            return 0;
        }
        if (this.level == null || this.level.isClientSide()) {
            return 0;
        }
        OmniBlockTarget bt = task.blockTarget;
        BlockPos targetPos = bt.getPosition();
        IItemHandler handler = TransferUtils.resolveBlockHandler(this.level, targetPos, accessSide = bt.getDirection());
        if (handler == null) {
            return 0;
        }
        int desired = task.maintainAmount;
        int current = TransferUtils.countMatchingItems(handler, task);
        int delta = desired - current;
        if (delta == 0) {
            return 0;
        }
        int toMove = Math.min(Math.abs(delta), amountLimit);
        if (toMove <= 0) {
            return 0;
        }
        if (delta > 0) {
            return this.moveFromStorageToHandler(task, handler, toMove);
        }
        return this.moveFromHandlerToStorage(task, handler, toMove);
    }

    private int moveFromStorageToHandler(OmniGridTask task, IItemHandler targetHandler, int amount) {
        int request;
        long extracted;
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null || amount <= 0) {
            return 0;
        }
        ResourceKey key = storage.getResourceForTask(task);
        if (!(key instanceof ItemResource)) {
            return 0;
        }
        ItemResource itemRes = (ItemResource)key;
        int slots = targetHandler.getSlots();
        if (slots <= 0) {
            return 0;
        }
        int movedTotal = 0;
        int startSlot = task.cachedSlotIndex;
        if (startSlot < 0 || startSlot >= slots) {
            startSlot = 0;
        }
        int slot = startSlot;
        for (int attempts = 0; attempts < slots && movedTotal < amount && (extracted = storage.extract((ResourceKey)itemRes, request = amount - movedTotal, Action.EXECUTE, (Actor)new PlayerActor("Pull"))) > 0L; ++attempts) {
            ItemStack remainder;
            ItemStack stack = itemRes.toItemStack((long)((int)extracted));
            int before = stack.getCount();
            int inserted = before - ((remainder = targetHandler.insertItem(slot, stack, false)).isEmpty() ? 0 : remainder.getCount());
            if (inserted > 0) {
                movedTotal += inserted;
                if (!remainder.isEmpty()) {
                    storage.insert((ResourceKey)itemRes, remainder.getCount(), Action.EXECUTE, (Actor)new PlayerActor("Pull"));
                }
                task.cachedSlotIndex = slot;
            } else {
                storage.insert((ResourceKey)itemRes, before, Action.EXECUTE, (Actor)new PlayerActor("Pull"));
            }
            slot = (slot + 1) % slots;
        }
        return movedTotal;
    }

    private int moveFromHandlerToStorage(OmniGridTask task, IItemHandler targetHandler, int amount) {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0;
        }
        PlatformResourceKey key = task.resource.get();
        if (!(key instanceof ItemResource)) {
            return 0;
        }
        ItemResource itemRes = (ItemResource)key;
        int movedTotal = 0;
        for (int slot = 0; slot < targetHandler.getSlots() && movedTotal < amount; ++slot) {
            int request;
            int toExtract;
            ItemStack extracted;
            ItemStack inSlot = targetHandler.getStackInSlot(slot);
            if (inSlot.isEmpty() || !OmniGridResourceHandler.matchesTask(inSlot, task) || (extracted = targetHandler.extractItem(slot, toExtract = Math.min(request = amount - movedTotal, inSlot.getCount()), false)).isEmpty()) continue;
            int count = extracted.getCount();
            long inserted = storage.insert((ResourceKey)itemRes, count, Action.EXECUTE, (Actor)new PlayerActor("Pull"));
            if (inserted <= 0L) {
                ItemStack giveBack = extracted.copy();
                targetHandler.insertItem(slot, giveBack, false);
                continue;
            }
            if (inserted < (long)count) {
                int leftover = count - (int)inserted;
                ItemStack leftoverStack = extracted.copy();
                leftoverStack.setCount(leftover);
                targetHandler.insertItem(slot, leftoverStack, false);
            }
            movedTotal = (int)((long)movedTotal + inserted);
        }
        return movedTotal;
    }

    public int maintainItemsInLinkedContainers(Player player, OmniGridTask task, int amountLimit) {
        if (task.cacheBlockPositions == null || task.cacheBlockPositions.isEmpty()) {
            return 0;
        }
        Level level = player.level();
        if (level == null || level.isClientSide()) {
            return 0;
        }
        if (task.linkRotationIndex >= task.cacheBlockPositions.size()) {
            task.linkRotationIndex = 0;
        }
        BlockPos pos = task.cacheBlockPositions.get(task.linkRotationIndex);
        task.linkRotationIndex = (task.linkRotationIndex + 1) % task.cacheBlockPositions.size();
        Direction side = task.blockTarget != null ? task.blockTarget.getDirection().getOpposite() : Direction.UP;
        IItemHandler handler = TransferUtils.resolveBlockHandler(level, pos, side);
        if (handler == null) {
            return 0;
        }
        int desired = task.maintainAmount;
        int current = TransferUtils.countMatchingItems(handler, task);
        int delta = desired - current;
        if (delta == 0) {
            return 0;
        }
        int toMove = Math.min(Math.abs(delta), amountLimit);
        if (toMove <= 0) {
            return 0;
        }
        if (delta > 0) {
            return this.moveFromStorageToHandler(task, handler, toMove);
        }
        return this.moveFromHandlerToStorage(task, handler, toMove);
    }

    private static int countMatchingItemsInStack(ItemStack stack, OmniGridTask task) {
        if (stack.isEmpty() || !OmniGridResourceHandler.matchesTask(stack, task)) {
            return 0;
        }
        return stack.getCount();
    }

    public int maintainItemsInPlayerContainerItem(Player player, OmniGridTask task, int amountLimit) {
        int current = 0;
        int desired = task.maintainAmount;
        for (ItemStack candidate : player.getInventory().items) {
            IItemHandler handler;
            if (candidate.isEmpty() || (handler = (IItemHandler)Capabilities.ItemHandler.ITEM.getCapability(candidate, null)) == null) continue;
            return this.applyMaintainMovement(player, task, current += TransferUtils.countMatchingItems(handler, task), desired, amountLimit, handler, null);
        }
        if (ModList.get().isLoaded("curios") && CuriosApi.getCuriosInventory((LivingEntity)player).isPresent()) {
            ICuriosItemHandler curios = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get();
            IItemHandlerModifiable equipped = curios.getEquippedCurios();
            for (int i = 0; i < equipped.getSlots(); ++i) {
                IItemHandler handler;
                ItemStack candidate = equipped.getStackInSlot(i);
                if (candidate.isEmpty() || (handler = (IItemHandler)Capabilities.ItemHandler.ITEM.getCapability(candidate, null)) == null) continue;
                return this.applyMaintainMovement(player, task, current += TransferUtils.countMatchingItems(handler, task), desired, amountLimit, handler, null);
            }
        }
        return 0;
    }

    public void collectXpOrbs(int radius, FluidResource fluidResource) {
        if (this.level.isClientSide) {
            return;
        }
        Vec3 center = this.taskCenterPosition.getCenter();
        AABB box = new AABB(center.x - (double)radius, center.y - (double)radius, center.z - (double)radius, center.x + (double)radius, center.y + (double)radius, center.z + (double)radius);
        boolean totalXp = false;
        for (ExperienceOrb orb : this.level.getEntitiesOfClass(ExperienceOrb.class, box)) {
            if (!orb.isAlive()) continue;
            int value = orb.value;
            long deposited = this.getOrCreateStorage().insert((ResourceKey)fluidResource, (long)value * 20L, Action.EXECUTE, (Actor)new PlayerActor("Collect"));
            orb.value = (int)((long)orb.value - deposited / 20L);
            if (orb.value <= 0) {
                orb.discard();
                continue;
            }
            return;
        }
    }

    public int collectItemsInArea(Level level, OmniGridTask task, int radius, int amountLimit, int processes, @javax.annotation.Nullable Player playerForActor) {
        BlockPos center = this.taskCenterPosition;
        if (level == null || amountLimit <= 0) {
            return 0;
        }
        AABB searchArea = new AABB(center.offset(-radius, -radius, -radius).getCenter(), center.offset(radius, radius, radius).getCenter());
        if (task.isXP && this.utilityTypes.contains((Object)UtilityType.XP_HANLDER)) {
            this.collectXpOrbs(radius, new FluidResource(task.fluid));
        }
        int totalTransferred = 0;
        int passes = Math.max(1, processes);
        PlayerActor actor = new PlayerActor("Collect");
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0;
        }
        for (int pass = 0; pass < passes; ++pass) {
            boolean movedSomething = false;
            List items = level.getEntitiesOfClass(ItemEntity.class, searchArea);
            for (ItemEntity entity : items) {
                ItemResource resource;
                long inserted;
                int toMove;
                ItemStack stack;
                if (!entity.isAlive() || (stack = entity.getItem()).isEmpty() || !OmniGridResourceHandler.matchesTask(stack, task) || (toMove = Math.min(stack.getCount(), amountLimit)) <= 0 || (inserted = storage.insert((ResourceKey)(resource = ItemResource.ofItemStack((ItemStack)stack.copyWithCount(toMove))), toMove, Action.EXECUTE, (Actor)actor)) <= 0L) continue;
                stack.shrink((int)inserted);
                this.VisibleEffect(level, entity.blockPosition(), true);
                if (stack.isEmpty()) {
                    entity.discard();
                }
                totalTransferred = (int)((long)totalTransferred + inserted);
                movedSomething = true;
                this.updateGridIfOpen((PlatformResourceKey)resource, inserted);
                break;
            }
            if (!movedSomething) break;
        }
        return totalTransferred;
    }

    public void handlePlayerXP(Player player, boolean pushToPlayer, Fluid fluid, int targetLevel) {
        if (player.level().isClientSide) {
            return;
        }
        FluidResource fluidResource = new FluidResource(fluid);
        OmniRootStorage storage = this.getOrCreateStorage();
        int stacks = this.getStacks();
        int rateMultiplier = 1 << stacks * 8;
        int fluidPerXp = 20;
        if (targetLevel != -1) {
            int currentLevel = player.experienceLevel;
            if (currentLevel == targetLevel) {
                return;
            }
            int currentXp = OmniItemProxxy.getTotalXp(player);
            int targetXp = OmniItemProxxy.xpForLevel(targetLevel);
            int deltaXp = targetXp - currentXp;
            int xpToMove = Math.min(Math.abs(deltaXp), rateMultiplier);
            if (xpToMove <= 0) {
                return;
            }
            long fluidAmount = (long)xpToMove * (long)fluidPerXp;
            if (deltaXp > 0) {
                long extracted = storage.extract((ResourceKey)fluidResource, fluidAmount, Action.SIMULATE, (Actor)new PlayerActor("TargetLevel-Push"));
                if (extracted < (long)fluidPerXp) {
                    return;
                }
                int xpGranted = (int)(extracted / (long)fluidPerXp);
                long fluidToUse = (long)xpGranted * (long)fluidPerXp;
                storage.extract((ResourceKey)fluidResource, fluidToUse, Action.EXECUTE, (Actor)new PlayerActor("TargetLevel-Push"));
                player.giveExperiencePoints(xpGranted);
            } else {
                int availableXp = currentXp;
                if (availableXp < xpToMove) {
                    return;
                }
                long accepted = storage.insert((ResourceKey)fluidResource, fluidAmount, Action.SIMULATE, (Actor)new PlayerActor("Pull"));
                if (accepted < fluidAmount) {
                    return;
                }
                OmniItemProxxy.removeXp(player, xpToMove);
                storage.insert((ResourceKey)fluidResource, fluidAmount, Action.EXECUTE, (Actor)new PlayerActor("Pull"));
            }
            return;
        }
        if (pushToPlayer) {
            long fluidNeeded = (long)fluidPerXp * (long)rateMultiplier;
            long extracted = storage.extract((ResourceKey)fluidResource, fluidNeeded, Action.EXECUTE, (Actor)new PlayerActor("Push"));
            int xpGranted = (int)(extracted / (long)fluidPerXp);
            if (xpGranted > 0) {
                player.giveExperiencePoints(xpGranted);
            }
        } else {
            int availableXp = OmniItemProxxy.getTotalXp(player);
            int xpRequested = Math.min(rateMultiplier, availableXp);
            if (xpRequested <= 0) {
                return;
            }
            long fluidRequested = (long)xpRequested * (long)fluidPerXp;
            long accepted = storage.insert((ResourceKey)fluidResource, fluidRequested, Action.SIMULATE, (Actor)new PlayerActor("Pull"));
            if (accepted < (long)fluidPerXp) {
                return;
            }
            int xpToRemove = (int)(accepted / (long)fluidPerXp);
            OmniItemProxxy.removeXp(player, xpToRemove);
            storage.insert((ResourceKey)fluidResource, (long)xpToRemove * (long)fluidPerXp, Action.EXECUTE, (Actor)new PlayerActor("Pull"));
        }
    }

    private static void removeXp(Player player, int amount) {
        int total = OmniItemProxxy.getTotalXp(player);
        int newTotal = Math.max(0, total - amount);
        player.experienceLevel = 0;
        player.experienceProgress = 0.0f;
        player.totalExperience = 0;
        player.giveExperiencePoints(newTotal);
    }

    public static int xpForLevel(int level) {
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    private static int getTotalXp(Player player) {
        int level = player.experienceLevel;
        float progress = player.experienceProgress;
        int xp = OmniItemProxxy.xpForLevel(level);
        return xp += Math.round(progress * (float)player.getXpNeededForNextLevel());
    }

    public long transferItemsToPlayer(final Player player, boolean pushToPlayer, OmniGridTask task, int amountLimit, int processes) {
        if (amountLimit <= 0) {
            return 0L;
        }
        int passes = Math.max(1, processes);
        OmniRootStorage storage = this.getOrCreateStorage();
        if (task.isEnergy) {
            this.transferEnergy(player, pushToPlayer, task);
            return 0L;
        }
        if (task.isXP) {
            if (this.utilityTypes.contains((Object)UtilityType.XP_HANLDER)) {
                this.handlePlayerXP(player, pushToPlayer, task.fluid, -1);
            }
            return 0L;
        }
        long transferred = 0L;
        Predicate<ItemStack> match = itemToInsert -> OmniGridResourceHandler.matchesTask(itemToInsert, task);
        for (int pass = 0; pass < passes && transferred < (long)amountLimit; ++pass) {
            if (task.playerTargetting == PlayerTargetting.OFFHAND) {
                IItemHandler offhandHandler = new IItemHandler(){

                    public int getSlots() {
                        return 1;
                    }

                    public ItemStack getStackInSlot(int slot) {
                        return (ItemStack)player.getInventory().offhand.get(0);
                    }

                    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                        int space;
                        ItemStack existing = (ItemStack)player.getInventory().offhand.get(0);
                        if (!existing.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack)) {
                            return stack;
                        }
                        int max = stack.getMaxStackSize();
                        int n = space = existing.isEmpty() ? max : max - existing.getCount();
                        if (space <= 0) {
                            return stack;
                        }
                        ItemStack remaining = stack.copy();
                        int toInsert = Math.min(space, remaining.getCount());
                        if (!simulate) {
                            if (existing.isEmpty()) {
                                player.getInventory().offhand.set(0, (Object)remaining.split(toInsert));
                            } else {
                                existing.grow(toInsert);
                                remaining.shrink(toInsert);
                            }
                        } else {
                            remaining.shrink(toInsert);
                        }
                        return remaining;
                    }

                    public ItemStack extractItem(int slot, int amount, boolean simulate) {
                        ItemStack existing = (ItemStack)player.getInventory().offhand.get(0);
                        if (existing.isEmpty()) {
                            return ItemStack.EMPTY;
                        }
                        int count = Math.min(amount, existing.getCount());
                        ItemStack extracted = existing.copyWithCount(count);
                        if (!simulate) {
                            existing.shrink(count);
                        }
                        return extracted;
                    }

                    public int getSlotLimit(int slot) {
                        return 64;
                    }

                    public boolean isItemValid(int slot, ItemStack stack) {
                        return true;
                    }
                };
                transferred += this.handleHandlerTransfer(offhandHandler, storage, pushToPlayer, match, (int)((long)amountLimit - transferred), player);
                continue;
            }
            if (task.playerTargetting == PlayerTargetting.ENDERCHEST) {
                InvWrapper ender = new InvWrapper((Container)player.getEnderChestInventory());
                int size = ender.getSlots();
                transferred += this.handleHandlerTransfer((IItemHandler)ender, storage, pushToPlayer, match, (int)((long)amountLimit - transferred), player, 0, size - 1);
                continue;
            }
            InvWrapper inv = new InvWrapper((Container)player.getInventory());
            int start = 0;
            int end = inv.getSlots() - 1;
            switch (task.playerTargetting) {
                case INVENTORY_NO_HOTBAR: {
                    start = 9;
                    end = 35;
                    break;
                }
                case HOTBAR: {
                    start = 0;
                    end = 8;
                    break;
                }
                case INVENTORY_HOTBAR: {
                    start = 0;
                    end = 35;
                }
            }
            if (task.playerTargetting == PlayerTargetting.CONTAINER_ITEMS) {
                for (int invSlot = 0; invSlot < player.getInventory().items.size(); ++invSlot) {
                    long moved;
                    IItemHandler handler;
                    ItemStack candidate = player.getInventory().getItem(invSlot);
                    if (candidate.isEmpty() || (handler = (IItemHandler)Capabilities.ItemHandler.ITEM.getCapability(candidate, null)) == null || (moved = this.handleHandlerTransfer(handler, storage, pushToPlayer, match, (int)((long)amountLimit - transferred), player)) <= 0L || (transferred += moved) < (long)amountLimit) continue;
                    return transferred;
                }
                if (ModList.get().isLoaded("curios") && CuriosApi.getCuriosInventory((LivingEntity)player).isPresent()) {
                    ICuriosItemHandler curios = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get();
                    IItemHandlerModifiable equipped = curios.getEquippedCurios();
                    int slotCount = equipped.getSlots();
                    for (int cSlot = 0; cSlot < slotCount; ++cSlot) {
                        long moved;
                        IItemHandler handler;
                        ItemStack candidate = equipped.getStackInSlot(cSlot);
                        if (candidate.isEmpty() || (handler = (IItemHandler)Capabilities.ItemHandler.ITEM.getCapability(candidate, null)) == null || (moved = this.handleHandlerTransfer(handler, storage, pushToPlayer, match, (int)((long)amountLimit - transferred), player)) <= 0L || (transferred += moved) < (long)amountLimit) continue;
                        return transferred;
                    }
                }
                return transferred;
            }
            if (task.playerTargetting == PlayerTargetting.CONTAINER_ITEMS || task.playerTargetting == PlayerTargetting.ENDERCHEST) continue;
            transferred += this.handleHandlerTransfer((IItemHandler)inv, storage, pushToPlayer, match, (int)((long)amountLimit - transferred), player, start, end);
        }
        return transferred;
    }

    private long handleHandlerTransfer(IItemHandler handler, OmniRootStorage storage, boolean pushToPlayer, Predicate<ItemStack> match, int limit, Player player) {
        return this.handleHandlerTransfer(handler, storage, pushToPlayer, match, limit, player, 0, handler.getSlots() - 1);
    }

    private long handleHandlerTransfer(IItemHandler handler, OmniRootStorage storage, boolean pushToPlayer, Predicate<ItemStack> match, int limit, Player player, int slotStart, int slotEnd) {
        long moved = 0L;
        if (pushToPlayer) {
            for (ResourceAmount ra : storage.getAll()) {
                if (moved < (long)limit) {
                    ItemStack simulated;
                    ItemStack leftover;
                    int want;
                    int inserted;
                    ItemResource ir;
                    ItemStack stack;
                    ResourceKey resourceKey = ra.resource();
                    if (!(resourceKey instanceof ItemResource) || !match.test(stack = (ir = (ItemResource)resourceKey).toItemStack()) || (inserted = (want = (int)Math.min(ra.amount(), (long)limit - moved)) - (leftover = TransferUtils.insertIntoHandlerRange(handler, simulated = stack.copyWithCount(want), slotStart, slotEnd, false)).getCount()) <= 0) continue;
                    long ex = storage.extract((ResourceKey)ir, inserted, Action.EXECUTE, (Actor)new PlayerActor("Push"));
                    moved += ex;
                    this.updateGridIfOpen((PlatformResourceKey)ir, -ex);
                    continue;
                }
                break;
            }
        } else {
            ItemStack pulled = TransferUtils.extractMatchingRange(handler, match, limit, slotStart, slotEnd, false);
            if (!pulled.isEmpty()) {
                ItemResource ir = ItemResource.ofItemStack((ItemStack)pulled);
                long ins = storage.insert((ResourceKey)ir, pulled.getCount(), Action.EXECUTE, (Actor)new PlayerActor("Pull"));
                moved += ins;
                this.updateGridIfOpen((PlatformResourceKey)ir, ins);
            }
        }
        return moved;
    }

    public int transferItemsFromNearbyContainers(Level level, OmniGridTask omniGridTask, int radius, int amountLimit, int processes) {
        if (amountLimit <= 0) {
            return 0;
        }
        BlockPos position = this.taskCenterPosition;
        OmniRootStorage unifiedStorage = this.getOrCreateStorage();
        if (unifiedStorage == null) {
            return 0;
        }
        int totalTransferred = 0;
        int passes = processes >= 2 ? processes : 1;
        Player player = level.getPlayerByUUID(this.player);
        Direction searchDirection = omniGridTask.mcDirection != null ? omniGridTask.mcDirection : Direction.UP;
        for (int pass = 0; pass < passes; ++pass) {
            boolean movedSomething = false;
            if (omniGridTask.lastContainer != null && omniGridTask.lastContainerDirection != null) {
                IItemHandler handler;
                BlockEntity cachedBE = level.getBlockEntity(omniGridTask.lastContainer);
                if (cachedBE != null && (handler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(level, omniGridTask.lastContainer, cachedBE.getBlockState(), cachedBE, (Object)omniGridTask.lastContainerDirection)) != null) {
                    int transferred = this.tryTransferFromHandler(handler, omniGridTask, amountLimit, player);
                    this.VisibleEffect(level, omniGridTask.lastContainer, transferred > 0);
                    if (transferred > 0) {
                        totalTransferred += transferred;
                        continue;
                    }
                }
                omniGridTask.lastContainer = null;
                omniGridTask.lastContainerDirection = null;
            }
            int containerRotation = omniGridTask.containerRotation % 20;
            int counter = 0;
            for (BlockPos targetPos : BlockPos.betweenClosed((BlockPos)position.offset(-radius, -radius, -radius), (BlockPos)position.offset(radius, radius, radius))) {
                IItemHandler handler;
                if (counter % 20 != containerRotation) {
                    ++counter;
                    continue;
                }
                ++counter;
                BlockEntity targetBE = level.getBlockEntity(targetPos);
                if (targetBE == null || !InteractionUtils.canInteractWithBlock(player, level, targetPos, searchDirection) || (handler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(level, targetPos, targetBE.getBlockState(), targetBE, (Object)searchDirection)) == null) continue;
                int transferred = this.tryTransferFromHandler(handler, omniGridTask, amountLimit, player);
                this.VisibleEffect(level, targetPos, transferred > 0);
                if (transferred <= 0) continue;
                totalTransferred += transferred;
                omniGridTask.lastContainer = targetPos;
                omniGridTask.lastContainerDirection = searchDirection;
                movedSomething = true;
                break;
            }
            omniGridTask.containerRotation = (omniGridTask.containerRotation + 1) % 20;
            if (omniGridTask.containerRotation == 0) {
                omniGridTask.cooldown = 100;
            }
            if (!movedSomething) break;
        }
        return totalTransferred;
    }

    public int tryTransferFromHandler(IItemHandler handler, OmniGridTask omniGridTask, int amountLimit, Player player) {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0;
        }
        int moved = 0;
        PlayerActor actor = new PlayerActor("Search");
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            int toMove;
            ItemResource resource;
            long inserted;
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.isEmpty() || !OmniGridResourceHandler.matchesTask(stack, omniGridTask) || (inserted = storage.insert((ResourceKey)(resource = ItemResource.ofItemStack((ItemStack)stack.copyWithCount(toMove = Math.min(stack.getCount(), amountLimit)))), toMove, Action.EXECUTE, (Actor)actor)) <= 0L) continue;
            handler.extractItem(slot, (int)inserted, false);
            this.updateGridIfOpen(stack, inserted);
            moved = (int)inserted;
            break;
        }
        return moved;
    }

    public long transferEnergy(Player player, boolean pushToPlayer, OmniGridTask task) {
        long maxPerTick;
        OmniRootStorage storage = this.getOrCreateStorage();
        long movedTotal = 0L;
        long power = 1000L;
        if (storage.hasUtilityType(UtilityType.CREATIVE)) {
            maxPerTick = Long.MAX_VALUE;
        } else {
            maxPerTick = (long)((double)power * Math.pow(4.0, this.getEnergy() + this.getStacks()));
            if (maxPerTick <= 0L) {
                return 0L;
            }
        }
        if (task.isBlockTarget) {
            Level level = player.level();
            if (task.cacheBlockTargets == null || task.cacheBlockTargets.isEmpty()) {
                task.cacheBlockTargets = task.linkContainer ? TransferUtils.discoverLinkedBlockTargets(level, task.blockTarget) : List.of(task.blockTarget);
            }
            for (OmniBlockTarget bt : task.cacheBlockTargets) {
                long moved;
                IEnergyStorage target;
                BlockEntity be;
                if (bt == null) continue;
                if (movedTotal >= maxPerTick) break;
                BlockPos pos = bt.getPosition();
                Direction dir = bt.getDirection();
                if (player.blockPosition().distSqr((Vec3i)pos) > (double)(this.getRemoteRange() * this.getRemoteRange()) || (be = level.getBlockEntity(pos)) == null || (target = (IEnergyStorage)Capabilities.EnergyStorage.BLOCK.getCapability(level, pos, level.getBlockState(pos), be, (Object)dir)) == null) continue;
                long remaining = maxPerTick - movedTotal;
                if (pushToPlayer) {
                    long extracted = RefinedTypesUtil.safeEnergyExtract((Storage)storage, remaining, Action.EXECUTE);
                    if (extracted > 0L) {
                        int received = target.receiveEnergy((int)Math.min(extracted, Integer.MAX_VALUE), false);
                        leftover = extracted - (long)received;
                        if (leftover > 0L) {
                            RefinedTypesUtil.safeEnergyInsert((Storage)storage, leftover, Action.EXECUTE);
                        }
                        moved = received;
                    } else {
                        moved = 0L;
                    }
                } else {
                    int extracted = target.extractEnergy((int)Math.min(remaining, Integer.MAX_VALUE), false);
                    if (extracted > 0) {
                        long inserted = RefinedTypesUtil.safeEnergyInsert((Storage)storage, extracted, Action.EXECUTE);
                        leftover = (long)extracted - inserted;
                        if (leftover > 0L) {
                            target.receiveEnergy((int)Math.min(leftover, Integer.MAX_VALUE), false);
                        }
                        moved = inserted;
                    } else {
                        moved = 0L;
                    }
                }
                movedTotal += moved;
                this.VisibleEffect(level, pos, moved > 0L);
            }
            return movedTotal;
        }
        Inventory inv = player.getInventory();
        int first = 0;
        int last = inv.items.size();
        if (task.playerTargetting != null) {
            switch (task.playerTargetting) {
                case HOTBAR: {
                    first = 0;
                    last = 9;
                    break;
                }
                case INVENTORY_NO_HOTBAR: {
                    first = 9;
                    last = 36;
                    break;
                }
                case INVENTORY_HOTBAR: {
                    first = 0;
                    last = 36;
                    break;
                }
                case OFFHAND: {
                    return this.chargeItemEnergy((ItemStack)inv.offhand.get(0), pushToPlayer, maxPerTick, maxPerTick);
                }
                case ENDERCHEST: {
                    PlayerEnderChestContainer ender = player.getEnderChestInventory();
                    return this.chargeContainerEnergy((Container)ender, pushToPlayer, maxPerTick, maxPerTick);
                }
                case CONTAINER_ITEMS: {
                    for (int invSlot = 0; invSlot < player.getInventory().items.size(); ++invSlot) {
                        if (movedTotal >= maxPerTick) {
                            return movedTotal;
                        }
                        ItemStack candidate = player.getInventory().getItem(invSlot);
                        if (candidate.isEmpty()) continue;
                        movedTotal = this.tryTransferFromContainerItem(candidate, player, movedTotal, maxPerTick, maxPerTick, pushToPlayer);
                    }
                    if (ModList.get().isLoaded("curios") && CuriosApi.getCuriosInventory((LivingEntity)player).isPresent()) {
                        ICuriosItemHandler curios = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get();
                        int slotCount = curios.getSlots();
                        for (int cSlot = 0; cSlot < slotCount; ++cSlot) {
                            if (movedTotal >= maxPerTick) {
                                return movedTotal;
                            }
                            ItemStack candidate = curios.getEquippedCurios().getStackInSlot(cSlot);
                            if (candidate.isEmpty()) continue;
                            movedTotal = this.tryTransferFromContainerItem(candidate, player, movedTotal, maxPerTick, maxPerTick, pushToPlayer);
                        }
                    }
                    return movedTotal;
                }
            }
        }
        for (int slot = first; slot < last && movedTotal < maxPerTick; ++slot) {
            IEnergyStorage es;
            ItemStack st = inv.getItem(slot);
            if (st.isEmpty() || (es = (IEnergyStorage)Capabilities.EnergyStorage.ITEM.getCapability(st, null)) == null) continue;
            long moved = this.chargeItemEnergy(st, pushToPlayer, maxPerTick - movedTotal, maxPerTick);
            if (moved > 0L) {
                inv.setChanged();
            }
            movedTotal += moved;
        }
        if (ModList.get().isLoaded("curios") && CuriosApi.getCuriosInventory((LivingEntity)player).isPresent()) {
            ICuriosItemHandler curios = (ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get();
            int slotCount = curios.getSlots();
            for (int cSlot = 0; cSlot < slotCount; ++cSlot) {
                IEnergyStorage es;
                if (movedTotal >= maxPerTick) {
                    return movedTotal;
                }
                ItemStack candidate = curios.getEquippedCurios().getStackInSlot(cSlot);
                if (candidate.isEmpty() || (es = (IEnergyStorage)Capabilities.EnergyStorage.ITEM.getCapability(candidate, null)) == null) continue;
                long moved = this.chargeItemEnergy(candidate, pushToPlayer, maxPerTick - movedTotal, maxPerTick);
                if (moved > 0L) {
                    inv.setChanged();
                }
                movedTotal += moved;
            }
        }
        return movedTotal;
    }

    public long chargeContainerEnergy(Container cont, boolean pushToPlayer, long limit, long maxPerTick) {
        long movedTotal = 0L;
        for (int i = 0; i < cont.getContainerSize() && movedTotal < limit; ++i) {
            ItemStack stack = cont.getItem(i);
            if (stack.isEmpty()) continue;
            long moved = this.chargeItemEnergy(stack, pushToPlayer, limit - movedTotal, maxPerTick);
            movedTotal += moved;
        }
        return movedTotal;
    }

    public long chargeItemEnergy(ItemStack stack, boolean pushToPlayer, long limit, long maxPerTick) {
        IEnergyStorage item = (IEnergyStorage)Capabilities.EnergyStorage.ITEM.getCapability(stack, null);
        if (item == null || stack.getItem() instanceof OmniGridBlockItem) {
            return 0L;
        }
        long moved = 0L;
        if (pushToPlayer) {
            long toExtract = Math.min(limit, maxPerTick);
            long extracted = RefinedTypesUtil.safeEnergyExtract((Storage)this.getOrCreateStorage(), toExtract, Action.EXECUTE);
            if (extracted > 0L) {
                int inserted = item.receiveEnergy((int)extracted, false);
                long unused = extracted - (long)inserted;
                if (unused > 0L) {
                    RefinedTypesUtil.safeEnergyInsert((Storage)this.getOrCreateStorage(), unused, Action.EXECUTE);
                }
                moved = inserted;
            }
        } else {
            long toPull = Math.min(limit, maxPerTick);
            int extracted = item.extractEnergy((int)toPull, false);
            if (extracted > 0) {
                long inserted = RefinedTypesUtil.safeEnergyInsert((Storage)this.getOrCreateStorage(), extracted, Action.EXECUTE);
                long unused = (long)extracted - inserted;
                if (unused > 0L) {
                    item.receiveEnergy((int)unused, false);
                }
                moved = inserted;
            }
        }
        return moved;
    }

    private long tryTransferFromContainerItem(ItemStack containerStack, Player player, long movedTotal, long amountLimit, long maxPerTick, boolean pushToPlayer) {
        IItemHandler handler = (IItemHandler)Capabilities.ItemHandler.ITEM.getCapability(containerStack, null);
        if (handler == null) {
            return movedTotal;
        }
        for (int subSlot = 0; subSlot < handler.getSlots(); ++subSlot) {
            IEnergyStorage es;
            ItemStack inside = handler.getStackInSlot(subSlot);
            if (inside.isEmpty() || (es = (IEnergyStorage)Capabilities.EnergyStorage.ITEM.getCapability(inside, null)) == null) continue;
            long maxToMove = Math.min(amountLimit - movedTotal, maxPerTick);
            long moved = 0L;
            if (pushToPlayer) {
                long extracted = RefinedTypesUtil.safeEnergyExtract((Storage)this.getOrCreateStorage(), maxToMove, Action.EXECUTE);
                if (extracted > 0L) {
                    int received = es.receiveEnergy((int)extracted, false);
                    leftover = extracted - (long)received;
                    if (leftover > 0L) {
                        RefinedTypesUtil.safeEnergyInsert((Storage)this.getOrCreateStorage(), leftover, Action.EXECUTE);
                    }
                    moved = received;
                }
            } else {
                int extracted = es.extractEnergy((int)maxToMove, false);
                if (extracted > 0) {
                    long inserted = RefinedTypesUtil.safeEnergyInsert((Storage)this.getOrCreateStorage(), extracted, Action.EXECUTE);
                    leftover = (long)extracted - inserted;
                    if (leftover > 0L) {
                        es.receiveEnergy((int)leftover, false);
                    }
                    moved = inserted;
                }
            }
            if (moved <= 0L) continue;
            movedTotal += moved;
            this.updateGridIfOpen((PlatformResourceKey)EnergyResource.createEnergyResource(), moved);
            handler.extractItem(subSlot, inside.getCount(), false);
            handler.insertItem(subSlot, inside, false);
            if (movedTotal < amountLimit) continue;
            return movedTotal;
        }
        return movedTotal;
    }

    public static float safeActivity(float workUnits, int perFeConfig) {
        if (perFeConfig <= 0) {
            return 0.0f;
        }
        return workUnits / (float)perFeConfig;
    }

    public void initializeStorage() {
        this.cachedStorageCount = 0;
        StorageRepository repo = RefinedStorageApi.INSTANCE.getStorageRepository(this.level);
        ArrayList<ExternalStorage> initialStorageList = new ArrayList<ExternalStorage>(this.externalStorageProviders);
        List<UUID> ids = this.getUuids();
        for (UUID id : ids) {
            repo.get(id).ifPresentOrElse(initialStorageList::add, () -> LOGGER.warn("[Proxxy][getOrCreateStorage] No storage found for {}", (Object)id));
            if (this.commandData.isCoreInstalled(CoreTypes.DISK_DRIVE)) continue;
            break;
        }
        this.cachedStorageCount = initialStorageList.size();
        for (UUID id : this.linkedOmniGrids) {
            OmniProxxyStorage lrops = new OmniProxxyStorage(id);
            initialStorageList.add((ExternalStorage)lrops);
            if (this.commandData.isCoreInstalled(CoreTypes.DISK_DRIVE)) continue;
            break;
        }
        this.omniStorage = new OmniGridStorage(initialStorageList);
        OmniRootStorage root = this.omniStorage.getRootStorage();
        root.utilityTypes.clear();
        root.restrictionList = new ArrayList<StorageRestriction>();
        for (int i = OmniUtilityInventory.PATTERN_SLOTS_START; i < OmniUtilityInventory.PATTERN_SLOTS_END; ++i) {
            ItemStack item = this.inventory.getItem(i);
            Item item2 = item.getItem();
            if (item2 instanceof OmniUtilityItem) {
                OmniUtilityItem util = (OmniUtilityItem)item2;
                root.addUtilityType(util.getUtilityType());
            }
            if (item.getItem() instanceof UtilityBundle) {
                root.addUtilityTypesFromBundle(item);
            }
            if (item.getItem() instanceof OmniVoider) {
                root.addVoidResources((OmniFilterData)item.get(DataComponents.INSTANCE.getFilterData()));
            }
            if (!((item2 = item.getItem()) instanceof OmniRegulator)) continue;
            OmniRegulator reg = (OmniRegulator)item2;
            if (!item.has(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getRegulatorUpgradeState())) continue;
            RegulatorUpgradeState state = (RegulatorUpgradeState)item.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getRegulatorUpgradeState());
            state.resource().ifPresent(res -> root.addRestriction(new StorageRestriction((ResourceKey)res, (long)state.amount(), (RestrictionMode)((Object)((Object)item.get(DataComponents.INSTANCE.getRestrictionMode()))))));
        }
        this.utilityTypes = root.utilityTypes;
        if (root.hasUtilityType(UtilityType.CREATIVE)) {
            this.energy = 4;
        }
    }

    public void updateGridIfOpen(ResourceKey stack, long amount) {
        if (stack instanceof PlatformResourceKey) {
            PlatformResourceKey res = (PlatformResourceKey)stack;
            amount = 0L;
            this.updateGridIfOpen(res, amount);
        }
    }

    public void updateGridIfOpen(ItemStack stack, long amount) {
        amount = 0L;
        this.updateGridIfOpen((PlatformResourceKey)ItemResource.ofItemStack((ItemStack)stack), amount);
    }

    public void updateGridIfOpen(PlatformResourceKey resource, long amount) {
        ServerLevel serverLevel;
        amount = 0L;
        if (amount == 0L) {
            return;
        }
        UUID ownerId = this.player;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            v0 = sl;
        } else {
            v0 = serverLevel = null;
        }
        if (ownerId == null) {
            if (serverLevel == null) {
                return;
            }
            for (ServerPlayer sp : this.getViewers()) {
                AbstractContainerMenu abstractContainerMenu = sp.containerMenu;
                if (!(abstractContainerMenu instanceof AbstractOmniGridContainerMenu)) continue;
                AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
                if (menu.storageReference != this.uuid) continue;
                menu.recordDelta((ResourceKey)resource, amount);
            }
            return;
        }
        ServerPlayer sp = null;
        if (serverLevel != null) {
            sp = serverLevel.getServer().getPlayerList().getPlayer(ownerId);
        }
        if (sp == null) {
            if (serverLevel == null) {
                return;
            }
            for (ServerPlayer viewer : this.getViewers()) {
                AbstractContainerMenu abstractContainerMenu = viewer.containerMenu;
                if (!(abstractContainerMenu instanceof AbstractOmniGridContainerMenu)) continue;
                AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
                menu.recordDelta((ResourceKey)resource, amount);
            }
            return;
        }
        AbstractContainerMenu abstractContainerMenu = sp.containerMenu;
        if (abstractContainerMenu instanceof AbstractOmniGridContainerMenu) {
            AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
            menu.recordDelta((ResourceKey)resource, amount);
            if (menu.omniGrid.storage == null) {
                return;
            }
        }
    }

    public void updateStress(EnergyStorage eStorage) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        if (this.stressSyncCooldown-- > 0) {
            return;
        }
        this.stressSyncCooldown = 20;
        MinecraftServer server = sl.getServer();
        if (server == null) {
            return;
        }
        for (ServerPlayer sp : server.getPlayerList().getPlayers()) {
            AbstractContainerMenu abstractContainerMenu = sp.containerMenu;
            if (!(abstractContainerMenu instanceof AbstractOmniGridContainerMenu)) continue;
            AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
            if (!this.uuid.equals(menu.storageReference)) continue;
            menu.containerData.set(3, this.getCachedData().bruteforce ? 1 : 0);
            menu.containerData.set(4, (int)this.stress);
            menu.containerData.setPower(eStorage.getStored());
            menu.broadcastChanges();
        }
    }

    public List<ServerPlayer> getViewers() {
        ArrayList<ServerPlayer> list = new ArrayList<ServerPlayer>();
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return list;
        }
        ServerLevel sl = (ServerLevel)level;
        MinecraftServer server = sl.getServer();
        if (server == null) {
            return list;
        }
        for (ServerPlayer p : server.getPlayerList().getPlayers()) {
            AbstractContainerMenu abstractContainerMenu = p.containerMenu;
            if (!(abstractContainerMenu instanceof AbstractOmniGridContainerMenu)) continue;
            AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
            if (!this.uuid.equals(menu.storageReference)) continue;
            list.add(p);
        }
        return list;
    }

    public boolean queueSmelting(MergedPattern pattern, @javax.annotation.Nullable Player player, long amount) {
        PlatformResourceKey key;
        int i;
        Level level;
        if (pattern == null || pattern.getInputs().isEmpty()) {
            return false;
        }
        ItemStack input = pattern.getInputs().getFirst();
        if (input.isEmpty()) {
            return false;
        }
        ItemResource inputResource = ItemResource.ofItemStack((ItemStack)input);
        boolean isBlockGrid = this.blockPos != null;
        List<Object> viewers = Collections.emptyList();
        if (isBlockGrid && player == null && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            viewers = this.getViewers();
        }
        for (i = 0; i < 8; ++i) {
            key = this.commandData.getSmeltingItem(i);
            long storedAmt = this.commandData.furnaceData.toSmelt[i];
            if (!(key instanceof ItemResource)) continue;
            ItemResource existingRes = (ItemResource)key;
            if (storedAmt <= 0L || !ItemStack.isSameItemSameComponents((ItemStack)existingRes.toItemStack(), (ItemStack)input)) continue;
            long newAmt = storedAmt + amount;
            if (newAmt != storedAmt) {
                AbstractContainerMenu abstractContainerMenu;
                this.commandData.furnaceData.toSmelt[i] = newAmt;
                if (!isBlockGrid && player != null && (abstractContainerMenu = player.containerMenu) instanceof AbstractOmniGridContainerMenu) {
                    Object menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
                    this.updateClientSmeltSlot((AbstractOmniGridContainerMenu)((Object)menu), i, inputResource, newAmt);
                }
                if (isBlockGrid) {
                    for (ServerPlayer serverPlayer : viewers) {
                        AbstractContainerMenu abstractContainerMenu2 = serverPlayer.containerMenu;
                        if (!(abstractContainerMenu2 instanceof AbstractOmniGridContainerMenu)) continue;
                        AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu2;
                        this.updateClientSmeltSlot(menu, i, inputResource, newAmt);
                    }
                }
            }
            return true;
        }
        for (i = 0; i < 8; ++i) {
            AbstractContainerMenu abstractContainerMenu;
            boolean slotEmpty;
            key = this.commandData.getSmeltingItem(i);
            long amt = this.commandData.furnaceData.toSmelt[i];
            boolean bl = slotEmpty = key == null || !(key instanceof ItemResource) || amt <= 0L || ((ItemResource)key).toItemStack().isEmpty();
            if (!slotEmpty) continue;
            this.commandData.setSmeltingItem(i, (PlatformResourceKey)inputResource);
            this.commandData.furnaceData.toSmelt[i] = amount;
            if (!isBlockGrid && player != null && (abstractContainerMenu = player.containerMenu) instanceof AbstractOmniGridContainerMenu) {
                AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
                this.updateClientSmeltSlot(menu, i, inputResource, amount);
            }
            if (isBlockGrid) {
                for (ServerPlayer serverPlayer : viewers) {
                    AbstractContainerMenu abstractContainerMenu3 = serverPlayer.containerMenu;
                    if (!(abstractContainerMenu3 instanceof AbstractOmniGridContainerMenu)) continue;
                    AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu3;
                    this.updateClientSmeltSlot(menu, i, inputResource, amount);
                }
            }
            return true;
        }
        return false;
    }

    private void updateClientSmeltSlot(AbstractOmniGridContainerMenu menu, int index, ItemResource resource, long amount) {
        ResourceAmount current = menu.furnaceContainer.get(index);
        if (current == null || current.amount() != amount || !current.resource().equals((Object)resource)) {
            menu.furnaceContainer.set(index, new ResourceAmount((ResourceKey)resource, amount));
            menu.furnaceContainer.toItemContainer().setChanged();
        }
    }

    public void updateTracked(ServerPlayer player, UUID uuid) {
        if (this.getCachedData() == null) {
            return;
        }
        if (this.updateTrackerCD > 0) {
            this.updateTrackerCD -= 10;
            return;
        }
        this.updateTrackerCD = Platform.getConfig().getOmniGrid().monitorUpdateRate();
        PlatformResourceKey[] trackedKeys = this.getCachedData().tracked;
        if (trackedKeys == null) {
            return;
        }
        HashMap<PlatformResourceKey, Integer> indexMap = new HashMap<PlatformResourceKey, Integer>();
        PlatformResourceKey[] oldResources = new PlatformResourceKey[4];
        long[] oldValues = new long[4];
        for (int i = 0; i < 4; ++i) {
            oldResources[i] = trackedKeys[i];
            oldValues[i] = this.trackValues[i];
            if (trackedKeys[i] == null) continue;
            indexMap.put(trackedKeys[i], i);
            this.trackValues[i] = 0L;
        }
        if (indexMap.isEmpty()) {
            return;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        for (int i = 0; i < 4; ++i) {
            PlatformResourceKey key = trackedKeys[i];
            if (key == null) {
                this.trackValues[i] = 0L;
                continue;
            }
            long amount = storage.get((ResourceKey)key);
            this.trackValues[i] = Math.max(0L, amount);
        }
        boolean anyChanged = false;
        for (int i = 0; i < 4; ++i) {
            boolean valueChanged;
            boolean resourceChanged = oldResources[i] != trackedKeys[i];
            boolean bl = valueChanged = oldValues[i] != this.trackValues[i];
            if (!resourceChanged && !valueChanged) continue;
            anyChanged = true;
            this.stress += (float)Platform.getConfig().getOmniGrid().getMonitorCost();
        }
        if (anyChanged) {
            this.sendTrackerPacketToPlayer(player, uuid, trackedKeys, this.trackValues);
        }
    }

    public void updateTrackedBlock(ServerLevel level, BlockPos pos, UUID uuid) {
        if (this.getCachedData() == null) {
            return;
        }
        if (this.updateTrackerCD > 0) {
            --this.updateTrackerCD;
            return;
        }
        this.updateTrackerCD = Platform.getConfig().getOmniGrid().monitorUpdateRate();
        PlatformResourceKey[] trackedKeys = this.getCachedData().tracked;
        if (trackedKeys == null) {
            return;
        }
        HashMap<PlatformResourceKey, Integer> indexMap = new HashMap<PlatformResourceKey, Integer>();
        PlatformResourceKey[] oldResources = new PlatformResourceKey[4];
        long[] oldValues = new long[4];
        for (int i = 0; i < 4; ++i) {
            oldResources[i] = trackedKeys[i];
            oldValues[i] = this.trackValues[i];
            if (trackedKeys[i] == null) continue;
            indexMap.put(trackedKeys[i], i);
            this.trackValues[i] = 0L;
        }
        if (indexMap.isEmpty()) {
            return;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        for (ResourceAmount entry : storage.getAll()) {
            Integer idx = (Integer)indexMap.get(entry.resource());
            if (idx == null) continue;
            int n = idx;
            this.trackValues[n] = this.trackValues[n] + entry.amount();
        }
        boolean anyChanged = false;
        for (int i = 0; i < 4; ++i) {
            if (oldResources[i] == trackedKeys[i] && oldValues[i] == this.trackValues[i]) continue;
            anyChanged = true;
        }
        if (!anyChanged) {
            return;
        }
        PlatformResourceKey[] sendKeys = new PlatformResourceKey[4];
        for (int i = 0; i < 4; ++i) {
            sendKeys[i] = trackedKeys[i];
        }
        int chunkRadius = 2;
        int cx = pos.getX() >> 4;
        int cz = pos.getZ() >> 4;
        for (ServerPlayer player : level.players()) {
            if (player.level() != level) continue;
            int pcx = player.chunkPosition().x;
            int pcz = player.chunkPosition().z;
            if (Math.abs(pcx - cx) > chunkRadius || Math.abs(pcz - cz) > chunkRadius) continue;
            this.sendTrackerPacketToPlayer(player, uuid, sendKeys, this.trackValues);
        }
    }

    private void sendTrackerPacketToPlayer(ServerPlayer player, UUID uuid, PlatformResourceKey[] keys, long[] values) {
        UpdateTracker packet = new UpdateTracker(uuid, keys, values);
        com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient(player, (CustomPacketPayload)packet);
    }

    private ItemResource norm(ItemStack stack) {
        return ItemResource.ofItemStack((ItemStack)new ItemStack((ItemLike)stack.getItem()));
    }

    private long tryInsertIntoBlock(BlockEntity be, IItemHandler handler, ItemResource itemRes, long amount) {
        ItemStack stack = itemRes.toItemStack().copyWithCount((int)amount);
        long insertedTotal = 0L;
        for (int slot = 0; slot < handler.getSlots() && !stack.isEmpty(); ++slot) {
            ItemStack remainder = handler.insertItem(slot, stack, false);
            int inserted = stack.getCount() - remainder.getCount();
            insertedTotal += (long)inserted;
            stack = remainder;
        }
        return insertedTotal;
    }

    private long tryInsertFluidsIntoBlock(BlockEntity be, Direction face, FluidResource fluidRes, long amount) {
        IFluidHandler handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, be.getBlockPos(), (Object)face);
        if (handler == null) {
            return 0L;
        }
        FluidStack stack = new FluidStack(fluidRes.fluid(), (int)amount);
        return handler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
    }

    public boolean attemptProcessing(MergedPattern merged, OmniCraftTask task) {
        if (merged.processingInputs.isEmpty()) {
            return false;
        }
        if (merged.processingPoint == null) {
            return false;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return false;
        }
        OmniBlockTarget tgt = merged.processingPoint;
        BlockPos pos = tgt.getPosition();
        Direction face = tgt.getDirection();
        BlockEntity be = this.level.getBlockEntity(pos);
        if (this.isProcessingTargetBusy(pos, face, task)) {
            task.cooldown = 10;
            return false;
        }
        IItemHandler handler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, pos, this.level.getBlockState(pos), be, (Object)face);
        if (handler == null && face != null) {
            handler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, pos, this.level.getBlockState(pos), be, null);
        }
        if (handler == null) {
            return false;
        }
        if (task.delivered == null || task.delivered.length != merged.processingInputs.size()) {
            task.delivered = new long[merged.processingInputs.size()];
        }
        boolean allSatisfied = true;
        for (int i = 0; i < merged.processingInputs.size(); ++i) {
            long inserted;
            long delivered;
            ResourceAmount ra = merged.processingInputs.get(i);
            long required = ra.amount();
            long remaining = required - (delivered = task.delivered[i]);
            if (remaining <= 0L) continue;
            allSatisfied = false;
            ResourceKey key = ra.resource();
            long extracted = storage.extract(key, remaining, Action.EXECUTE, Actor.EMPTY);
            if (extracted <= 0L) {
                task.cooldown = 5;
                return false;
            }
            if (key instanceof ItemResource) {
                ItemResource itemRes = (ItemResource)key;
                inserted = this.tryInsertIntoBlock(be, handler, itemRes, extracted);
            } else if (key instanceof FluidResource) {
                FluidResource fluidRes = (FluidResource)key;
                inserted = this.tryInsertFluidsIntoBlock(be, face, fluidRes, extracted);
            } else {
                storage.insert(key, extracted, Action.EXECUTE, Actor.EMPTY);
                task.cooldown = 5;
                return false;
            }
            if (inserted < extracted) {
                long rollback = extracted - inserted;
                storage.insert(key, rollback, Action.EXECUTE, Actor.EMPTY);
            }
            int n = i;
            task.delivered[n] = task.delivered[n] + inserted;
        }
        if (allSatisfied) {
            task.incrementProgress();
            --task.craftsNeeded;
            this.VisibleEffect(this.level, pos, true);
            Arrays.fill(task.delivered, 0L);
            if (task.craftsNeeded <= 0L) {
                return true;
            }
        }
        return false;
    }

    private boolean isProcessingTargetBusy(BlockPos pos, Direction side, OmniCraftTask task) {
        IFluidHandler fluid;
        BlockEntity be = this.level.getBlockEntity(pos);
        if (be == null) {
            return false;
        }
        IItemHandler item = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, pos, this.level.getBlockState(pos), be, (Object)side);
        if (item != null) {
            for (int i = 0; i < item.getSlots(); ++i) {
                if (item.getStackInSlot(i).isEmpty()) continue;
                return true;
            }
        }
        if ((fluid = (IFluidHandler)Capabilities.FluidHandler.BLOCK.getCapability(this.level, pos, this.level.getBlockState(pos), be, (Object)side)) != null) {
            for (int i = 0; i < fluid.getTanks(); ++i) {
                if (fluid.getFluidInTank(i).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean tryCraftSimpleTask(OmniCraftTask task, Level level, @javax.annotation.Nullable Player player) {
        if (task == null) {
            return false;
        }
        if (task.cooldown > 0) {
            --task.cooldown;
            return false;
        }
        List possible = this.patterns.getOrDefault(task.getResource(), List.of());
        if (possible.isEmpty()) {
            return false;
        }
        MergedPattern pattern = (MergedPattern)possible.get(0);
        if (!pattern.isValid()) {
            return false;
        }
        ItemStack outputStack = pattern.getPrimaryOutput();
        PatternType type = pattern.getType();
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return false;
        }
        List<ItemStack> inputs = pattern.getInputs();
        if (type == PatternType.PROCESSING) {
            if (!pattern.processingOutputs.isEmpty()) {
                return this.attemptProcessing(pattern, task);
            }
            ItemStack in = inputs.isEmpty() ? ItemStack.EMPTY : inputs.getFirst();
            ItemStack itemStack = outputStack;
            ItemStack smeltCheck = OmniFurnaceSlot.getSmeltingResult(level, in).output();
            if (!smeltCheck.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)smeltCheck)) {
                if (!task.isComplete()) {
                    boolean ok = this.queueSmelting(pattern, player, task.craftsNeeded);
                    this.stress += (float)Platform.getConfig().getOmniGrid().processingFECost();
                    if (ok) {
                        task.craftsNeeded = 0L;
                        task.incrementProgress();
                        this.stress += (float)Platform.getConfig().getOmniGrid().processingFECost();
                        return true;
                    }
                }
                return false;
            }
        }
        for (ItemStack itemStack : inputs) {
            long needed;
            ItemResource key;
            long available;
            if (itemStack.isEmpty() || (available = storage.extract((ResourceKey)(key = this.norm(itemStack)), needed = (long)itemStack.getCount(), Action.SIMULATE, (Actor)new PlayerActor("Autocrafter"))) >= needed) continue;
            task.cooldown = 40;
            return false;
        }
        HashMap<ItemResource, Long> extracted = new HashMap<ItemResource, Long>();
        for (ItemStack input : inputs) {
            long needed;
            if (input.isEmpty()) continue;
            ItemResource key = this.norm(input);
            long taken = storage.extract((ResourceKey)key, needed = (long)input.getCount(), Action.EXECUTE, (Actor)new PlayerActor("Autocrafter"));
            if (taken < needed) {
                OmniItemProxxy.rollbackExtracted(storage, extracted);
                task.cooldown = 40;
                return false;
            }
            extracted.merge(key, taken, Long::sum);
            this.updateGridIfOpen((PlatformResourceKey)key, -taken);
        }
        ItemResource itemResource = this.norm(outputStack);
        long outCount = outputStack.getCount();
        long inserted = storage.insert((ResourceKey)itemResource, outCount, Action.EXECUTE, (Actor)new PlayerActor("Autocrafter"));
        task.amountPerTask = (int)inserted;
        this.stress += (float)Platform.getConfig().getOmniGrid().autoCraftFECost();
        if (inserted < outCount) {
            OmniItemProxxy.rollbackExtracted(storage, extracted);
            task.cooldown = 40;
            return false;
        }
        this.updateGridIfOpen((PlatformResourceKey)itemResource, inserted);
        for (ItemStack input : inputs) {
            long leftover;
            long count;
            Item item;
            ItemStack remainder;
            if (input.isEmpty() || (remainder = (item = input.getItem()).getCraftingRemainingItem(input)).isEmpty()) continue;
            ItemResource rKey = ItemResource.ofItemStack((ItemStack)remainder);
            long added = storage.insert((ResourceKey)rKey, count = (long)remainder.getCount(), Action.EXECUTE, (Actor)new PlayerActor("Autocrafter"));
            if (added > 0L) {
                this.updateGridIfOpen((PlatformResourceKey)rKey, added);
            }
            if ((leftover = count - added) <= 0L || player == null) continue;
            Containers.dropItemStack((Level)level, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)remainder.copyWithCount((int)leftover));
        }
        for (ItemStack leftover : pattern.getLeftovers()) {
            long remain;
            long count;
            if (leftover.isEmpty()) continue;
            ItemResource rKey = ItemResource.ofItemStack((ItemStack)leftover);
            long added = storage.insert((ResourceKey)rKey, count = (long)leftover.getCount(), Action.EXECUTE, Actor.EMPTY);
            if (added > 0L) {
                this.updateGridIfOpen((PlatformResourceKey)rKey, added);
            }
            if ((remain = count - added) <= 0L || player == null) continue;
            Containers.dropItemStack((Level)level, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (ItemStack)leftover.copyWithCount((int)remain));
        }
        this.stress += (float)Platform.getConfig().getOmniGrid().autoCraftFECost();
        return true;
    }

    public void handleFire(Player player) {
        boolean hasWater;
        if (!player.isOnFire()) {
            return;
        }
        if (!this.utilityTypes.contains((Object)UtilityType.FIRE_EXTINGUISHER)) {
            return;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return;
        }
        PlayerActor actor = new PlayerActor("Extinguisher");
        Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
        int waterCostPlayer = cfg.fireExtCostPlayer();
        int waterCostFlowing = cfg.fireExtCostFlowing();
        int waterCostSource = cfg.fireExtCostLavaSrc();
        int waterCostFireBlock = cfg.fireExtCostFire();
        int feCostBase = cfg.fireExtFECost();
        long available = storage.extract((ResourceKey)OmniRootStorage.WATER, waterCostPlayer, Action.SIMULATE, (Actor)actor);
        boolean bl = hasWater = available >= (long)waterCostPlayer;
        if (!hasWater) {
            return;
        }
        this.stress += (float)feCostBase;
        player.extinguishFire();
        Level level = player.level();
        AABB box = player.getBoundingBox().inflate(0.1);
        storage.extract((ResourceKey)OmniRootStorage.WATER, waterCostPlayer, Action.EXECUTE, (Actor)actor);
        for (BlockPos pos : BlockPos.betweenClosedStream((AABB)box).map(BlockPos::immutable).toList()) {
            int waterCost;
            long canTake;
            BlockState state = level.getBlockState(pos);
            if (state.getBlock() == Blocks.LAVA) {
                boolean isSource = state.getFluidState().isSource();
                int waterCost2 = isSource ? waterCostSource : waterCostFlowing;
                int feCost = feCostBase;
                long canTake2 = storage.extract((ResourceKey)OmniRootStorage.WATER, waterCost2, Action.SIMULATE, (Actor)actor);
                if (canTake2 >= (long)waterCost2) {
                    storage.extract((ResourceKey)OmniRootStorage.WATER, waterCost2, Action.EXECUTE, (Actor)actor);
                    this.stress += (float)feCost;
                    BlockState replacement = isSource ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.COBBLESTONE.defaultBlockState();
                    level.setBlock(pos, replacement, 3);
                    level.levelEvent(1501, pos, 0);
                }
            }
            if (state.getBlock() != Blocks.FIRE || (canTake = storage.extract((ResourceKey)OmniRootStorage.WATER, waterCost = waterCostFireBlock, Action.SIMULATE, (Actor)actor)) < (long)waterCost) continue;
            storage.extract((ResourceKey)OmniRootStorage.WATER, waterCost, Action.EXECUTE, (Actor)actor);
            this.stress += (float)feCostBase;
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            level.levelEvent(1501, pos, 0);
        }
    }

    public void handleXP() {
        if (this.utilityTypes.contains((Object)UtilityType.XP_LIQUIFIER)) {
            float stored = this.accumulatedXp;
            Fluid fluid = OmniItemProxxy.findFluidWithTag();
            if (fluid != null) {
                long amount = (long)(stored * 20.0f);
                long inserted = this.getOrCreateStorage().insert((ResourceKey)new FluidResource(fluid), amount, Action.EXECUTE, (Actor)new PlayerActor("Digital Furnace"));
                this.accumulatedXp = (float)(amount - inserted) / 20.0f;
            }
        }
    }

    public void distributeXP(ServerPlayer player) {
        this.handleXP();
        if (player == null) {
            return;
        }
        float stored = this.accumulatedXp;
        if (stored <= 0.0f) {
            return;
        }
        int whole = Mth.floor((float)stored);
        if (whole > 0) {
            player.giveExperiencePoints(whole);
        }
        this.accumulatedXp = stored - (float)whole;
    }

    private static void rollbackExtracted(OmniRootStorage storage, Map<ItemResource, Long> extracted) {
        for (Map.Entry<ItemResource, Long> e : extracted.entrySet()) {
            storage.insert((ResourceKey)e.getKey(), e.getValue(), Action.EXECUTE, Actor.EMPTY);
        }
    }

    public Map<ResourceKey, List<MergedPattern>> resolveUtilitySlots(Level level) {
        Set<Pattern> oldPatterns = this.patternsByResource.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        this.patternsByResource.clear();
        this.utilityTypes.clear();
        Map<ResourceKey, List<MergedPattern>> byOutput = new HashMap<ResourceKey, List<MergedPattern>>();
        for (int i = OmniUtilityInventory.PATTERN_SLOTS_START; i < OmniUtilityInventory.PATTERN_SLOTS_END; ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof UtilityBundle) {
                byOutput = this.handleBundle(stack, level, byOutput, (OmniBlockTarget)stack.get(DataComponents.INSTANCE.getLink()));
                continue;
            }
            Item item = stack.getItem();
            if (item instanceof PatternItem) {
                MergedPattern merged;
                PatternItem patternItem = (PatternItem)item;
                Optional pattern = patternItem.getPattern(stack, level);
                if (pattern.isPresent()) {
                    this.allPatterns.add((Pattern)pattern.get());
                }
                if (!(merged = new MergedPattern(stack, level, null)).isValid()) continue;
                if (merged.getType() == PatternType.PROCESSING && !merged.processingOutputs.isEmpty()) {
                    ResourceKey key = merged.processingOutputs.getFirst().resource();
                    byOutput.computeIfAbsent(key, k -> new ArrayList()).add(merged);
                    continue;
                }
                ItemStack out = merged.getPrimaryOutput();
                if (out.isEmpty()) continue;
                ItemResource key = new ItemResource(out.getItem());
                byOutput.computeIfAbsent((ResourceKey)key, k -> new ArrayList()).add(merged);
                continue;
            }
            this.handleUtilityItem(stack, level, byOutput);
        }
        if (this.utilityTypes.contains((Object)UtilityType.OVERCLOCKER)) {
            this.permaClocked = true;
        }
        Set<Pattern> newPatterns = this.patternsByResource.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (!level.isClientSide) {
            this.notifyPatternDiff(oldPatterns, newPatterns);
        }
        return byOutput;
    }

    private Map<ResourceKey, List<MergedPattern>> handleBundle(ItemStack bundle, Level level, Map<ResourceKey, List<MergedPattern>> patterns, @javax.annotation.Nullable OmniBlockTarget blockTarget) {
        ResourceKey key;
        this.utilityTypes.addAll(UtilityBundle.getUtilityTypes(bundle));
        for (MergedPattern simple : UtilityBundle.getMergedPatterns(bundle, level, blockTarget)) {
            if (!simple.processingOutputs.isEmpty()) {
                ResourceAmount first = simple.processingOutputs.getFirst();
                key = first.resource();
                patterns.computeIfAbsent(key, k -> new ArrayList()).add(simple);
                continue;
            }
            ItemStack output = simple.getPrimaryOutput();
            if (output.isEmpty()) continue;
            key = new ItemResource(output.getItem());
            patterns.computeIfAbsent(key, k -> new ArrayList()).add(simple);
        }
        for (Pattern p : UtilityBundle.getRegularPatterns(bundle, level)) {
            ItemResource itemRes;
            ItemStack out;
            this.allPatterns.add(p);
            if (p.layout().outputs().isEmpty() || !((key = ((ResourceAmount)p.layout().outputs().get(0)).resource()) instanceof ItemResource) || (out = (itemRes = (ItemResource)key).toItemStack()).isEmpty()) continue;
            ItemResource key2 = new ItemResource(out.getItem());
            this.patternsByResource.computeIfAbsent((ResourceKey)key2, k -> new ArrayList()).add(p);
        }
        return patterns;
    }

    private void notifyPatternDiff(Set<Pattern> oldPatterns, Set<Pattern> newPatterns) {
        for (Pattern old : oldPatterns) {
            if (newPatterns.contains(old)) continue;
            for (PatternListener l : this.patternListeners) {
                l.onRemoved(old);
            }
        }
        for (Pattern added : newPatterns) {
            if (oldPatterns.contains(added)) continue;
            for (PatternListener l : this.patternListeners) {
                l.onAdded(added);
            }
        }
    }

    private void handleUtilityItem(ItemStack stack, Level level, Map<ResourceKey, List<MergedPattern>> patterns) {
        Item item = stack.getItem();
        if (item instanceof OmniUtilityItem) {
            OmniUtilityItem ui = (OmniUtilityItem)item;
            this.utilityTypes.add(ui.getUtilityType());
        } else if (stack.getItem() instanceof OmniOverclockerPlusItem) {
            this.utilityTypes.add(UtilityType.OVERCLOCKER);
        }
        item = stack.getItem();
        if (!(item instanceof PatternItem)) {
            return;
        }
        PatternItem pt = (PatternItem)item;
        Pattern rsPattern = pt.getPattern(stack, level).orElse(null);
        if (rsPattern == null) {
            return;
        }
        MergedPattern simple = new MergedPattern(stack, level, null);
        if (!simple.processingOutputs.isEmpty()) {
            ResourceAmount first = simple.processingOutputs.getFirst();
            ResourceKey key = first.resource();
            patterns.computeIfAbsent(key, k -> new ArrayList()).add(simple);
            this.patternsByResource.computeIfAbsent(key, k -> new ArrayList()).add(rsPattern);
            return;
        }
        ItemStack output = simple.getPrimaryOutput();
        if (output.isEmpty()) {
            return;
        }
        ItemResource key = new ItemResource(output.getItem());
        patterns.computeIfAbsent((ResourceKey)key, k -> new ArrayList()).add(simple);
        this.patternsByResource.computeIfAbsent((ResourceKey)key, k -> new ArrayList()).add(rsPattern);
    }

    public long insertIntoStorages(ResourceKey resourceKey, long amount, boolean simulate, String actor) {
        if (amount <= 0L) {
            return 0L;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0L;
        }
        Action action = simulate ? Action.SIMULATE : Action.EXECUTE;
        return storage.insert(resourceKey, amount, action, (Actor)new PlayerActor(actor));
    }

    public long extractFromStorages(ResourceKey resourceKey, long amount, boolean simulate, String actor) {
        if (amount <= 0L) {
            return 0L;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0L;
        }
        Action action = simulate ? Action.SIMULATE : Action.EXECUTE;
        return storage.extract(resourceKey, amount, action, (Actor)new PlayerActor(actor));
    }

    private ItemStack getFuelContainerItem(ItemStack fuel) {
        if (fuel.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack remainder = fuel.getCraftingRemainingItem();
        if (!remainder.isEmpty()) {
            return remainder;
        }
        if (fuel.hasCraftingRemainingItem()) {
            return fuel.getCraftingRemainingItem().copy();
        }
        return ItemStack.EMPTY;
    }

    private void refillFuel(@javax.annotation.Nullable Player player) {
        int FUEL_MAX = 25000;
        for (int i = 0; i < 4; ++i) {
            long taken;
            int cap;
            FluidResource fluidRes;
            ItemStack container = ItemStack.EMPTY;
            PlatformResourceKey key = this.getCachedData().getFuelItem(i);
            if (key == null) continue;
            int burnPerUnit = 0;
            if (key instanceof ItemResource) {
                ItemResource itemRes = (ItemResource)key;
                ItemStack stack = itemRes.toItemStack();
                burnPerUnit = stack.getBurnTime(RecipeType.SMELTING);
                container = this.getFuelContainerItem(stack);
            } else if (key instanceof FluidResource && (fluidRes = (FluidResource)key).fluid().isSame((Fluid)Fluids.LAVA)) {
                burnPerUnit = 20;
            } else if (RefinedTypesUtil.rtInstalled() && key instanceof EnergyResource) {
                int maxFuelPossible;
                int fuelToMake;
                long energyToExtract;
                long takenEnergy;
                int fuelNeeded;
                long storedEnergy = RefinedTypesUtil.safeCheckPower(this.getOrCreateStorage());
                if (storedEnergy < 20L || (fuelNeeded = 25000 - this.fuel) <= 0 || (takenEnergy = this.extractFromStorages((ResourceKey)key, energyToExtract = (long)((fuelToMake = Math.min(fuelNeeded, maxFuelPossible = (int)(storedEnergy / 20L))) * 20), false, "Fuel")) < energyToExtract) continue;
                this.fuel += fuelToMake;
                this.updateGridIfOpen(key, -takenEnergy);
                if (this.fuel < 25000) continue;
                this.fuel = 25000;
                return;
            }
            if (burnPerUnit <= 0) continue;
            int needed = 25000 - this.fuel;
            int maxSafe = Math.max(1, needed / burnPerUnit);
            int toTake = Math.min(maxSafe, cap = burnPerUnit <= 200 ? 16 : (burnPerUnit < 5000 ? 4 : 1));
            if (toTake < 1) {
                toTake = 1;
            }
            if ((taken = this.extractFromStorages((ResourceKey)key, toTake, false, "Fuel")) <= 0L) continue;
            if (!container.isEmpty()) {
                this.insertIntoStorages((ResourceKey)ItemResource.ofItemStack((ItemStack)container), taken, false, "Furnace");
            }
            this.fuel += burnPerUnit * (int)taken;
            this.updateGridIfOpen(key, -taken);
            if (this.fuel < 25000) continue;
            this.fuel = 25000;
            return;
        }
    }

    public void absorbFluidsAround(BlockPos center) {
        Config.OmniGridEntry cfg = Platform.getConfig().getOmniGrid();
        double radius = 2.0 + (double)this.getRange() * 0.5;
        long maxBlocks = cfg.spongeMaxAbsorb() + this.getStacks() * cfg.spongeExtraPerStack();
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null || this.level.isClientSide) {
            return;
        }
        PlayerActor actor = new PlayerActor("Sponge");
        double radiusSq = radius * radius;
        int range = (int)Math.ceil(radius);
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (int dx = -range; dx <= range; ++dx) {
            for (int dy = -range; dy <= range; ++dy) {
                for (int dz = -range; dz <= range; ++dz) {
                    double distSq;
                    if (dx == 0 && dy == 0 && dz == 0 || (distSq = (double)(dx * dx + dy * dy + dz * dz)) > radiusSq) continue;
                    candidates.add(center.offset(dx, dy, dz));
                }
            }
        }
        candidates.sort(Comparator.comparingDouble(pos -> pos.distSqr((Vec3i)center)));
        long blocksRemaining = maxBlocks;
        HashSet<BlockPos> absorbedSources = new HashSet<BlockPos>();
        for (BlockPos pos2 : candidates) {
            long amount;
            FluidResource resource;
            long canInsert;
            BlockPos sourcePos;
            if (blocksRemaining <= 0L) break;
            FluidState fluid = this.level.getFluidState(pos2);
            if (fluid.isEmpty()) continue;
            Fluid fluidType = fluid.getType();
            if (fluid.isSource()) {
                sourcePos = pos2;
            } else {
                sourcePos = this.findFluidSource(pos2, fluidType, 16 + range * 4);
                if (sourcePos == null) continue;
            }
            if (!absorbedSources.add(sourcePos) || (canInsert = storage.insert((ResourceKey)(resource = new FluidResource(fluidType)), amount = 1000L, Action.SIMULATE, (Actor)actor)) < amount) continue;
            storage.insert((ResourceKey)resource, amount, Action.EXECUTE, (Actor)actor);
            BlockState oldState = this.level.getBlockState(sourcePos);
            this.level.setBlock(sourcePos, Blocks.AIR.defaultBlockState(), 3);
            this.level.updateNeighborsAt(sourcePos, oldState.getBlock());
            this.level.levelEvent(2001, sourcePos, Block.getId((BlockState)oldState));
            --blocksRemaining;
        }
    }

    @javax.annotation.Nullable
    private BlockPos findFluidSource(BlockPos start, Fluid fluidType, int maxDepth) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty() && visited.size() < maxDepth) {
            BlockPos pos = (BlockPos)queue.poll();
            FluidState fluid = this.level.getFluidState(pos);
            if (fluid.isEmpty() || fluid.getType() != fluidType) continue;
            if (fluid.isSource()) {
                return pos;
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos next = pos.relative(dir);
                if (!visited.add(next)) continue;
                queue.add(next);
            }
            BlockPos up = pos.above();
            if (!visited.add(up)) continue;
            queue.add(up);
        }
        return null;
    }

    public void resetUI(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof AbstractOmniGridContainerMenu)) {
            return;
        }
        AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
        if (menu.containerData == null || menu.gridPlayer == null) {
            return;
        }
        menu.containerData.setProgress((int)this.smeltingProgress);
        menu.containerData.setFuel(this.fuel);
        menu.containerData.setSelectedIndex(this.selectedIndex);
        menu.furnaceContainer.toItemContainer().setChanged();
        PlatformResourceKey res = menu.toggleableResourceSlot.getResource();
        if (res != this.cachedSmeltingTarget) {
            menu.toggleableResourceSlot.setFilter(this.cachedSmeltingTarget);
            if (res != null) {
                menu.toggleableResourceSlot.set(((ItemResource)res).toItemStack());
            } else {
                menu.toggleableResourceSlot.set(ItemStack.EMPTY);
            }
            menu.toggleableResourceSlot.container.setChanged();
        }
        menu.flushDeltas();
        menu.broadcastChanges();
    }

    @javax.annotation.Nullable
    public static Fluid findFluidWithTag() {
        if (xpFluid == Fluids.WATER) {
            xpFluid = null;
            for (Holder holder : BuiltInRegistries.FLUID.asHolderIdMap()) {
                if (!holder.is(XP_TAG)) continue;
                xpFluid = (Fluid)holder.value();
            }
        }
        return xpFluid;
    }

    public boolean attemptSmelt(Level level, @javax.annotation.Nullable Player player) {
        int effectiveOpQty;
        ItemResource res;
        SmeltResult result;
        PlatformResourceKey key;
        boolean fuelChanged = false;
        FurnaceData data = this.getCachedData().furnaceData;
        boolean hasCampfireUtil = this.getOrCreateStorage().hasUtilityType(UtilityType.CAMP_FIRE);
        boolean isCampfireFood = false;
        this.selectedIndex = -1;
        ++this.emptyTicks;
        int baseOp = 1 + this.getStacks();
        boolean bulkActive = this.utilityTypes.contains((Object)UtilityType.BULK_SMELTING);
        int operationQuantity = bulkActive ? baseOp * 4 : baseOp;
        float xpPer = 0.0f;
        ItemResource inputKey = null;
        ItemStack resultStack = ItemStack.EMPTY;
        long bestRemaining = Long.MAX_VALUE;
        boolean foundExact = false;
        for (int i = 0; i < 8; ++i) {
            long remaining;
            SmeltResult result2;
            key = data.smeltItems[i];
            if (!(key instanceof ItemResource)) continue;
            ItemResource res2 = (ItemResource)key;
            long available = this.getOrCreateStorage().get((ResourceKey)res2);
            if (available <= 0L || (result2 = OmniFurnaceSlot.getSmeltingResult(level, res2.toItemStack())).output().isEmpty() || (remaining = data.toSmelt[i]) <= 0L) continue;
            if (remaining >= (long)operationQuantity && remaining < bestRemaining) {
                bestRemaining = remaining;
                this.selectedIndex = i;
                foundExact = true;
            }
            if (foundExact || remaining <= 0L || remaining >= bestRemaining) continue;
            bestRemaining = remaining;
            this.selectedIndex = i;
        }
        if (this.selectedIndex == -1 && (key = this.cachedSmeltingTarget) instanceof ItemResource && !(result = OmniFurnaceSlot.getSmeltingResult(level, (res = (ItemResource)key).toItemStack())).output().isEmpty()) {
            this.selectedIndex = 8;
            bestRemaining = 99L;
        }
        if (this.selectedIndex == -1) {
            if (this.emptyTicks >= 3) {
                this.smeltingProgress = 0.0;
            }
            return fuelChanged;
        }
        this.emptyTicks = 0;
        if (this.selectedIndex == 8) {
            inputKey = (ItemResource)this.cachedSmeltingTarget;
            resultStack = OmniFurnaceSlot.getSmeltingResult(level, inputKey.toItemStack()).output();
            xpPer = OmniFurnaceSlot.getSmeltingResult(level, inputKey.toItemStack()).xp();
            bestRemaining = 99L;
        } else {
            inputKey = (ItemResource)data.smeltItems[this.selectedIndex];
            SmeltResult result3 = OmniFurnaceSlot.getSmeltingResult(level, inputKey.toItemStack());
            resultStack = result3.output();
            xpPer = result3.xp();
            bestRemaining = data.toSmelt[this.selectedIndex];
        }
        if (hasCampfireUtil) {
            isCampfireFood = OmniItemProxxy.isCampfireItem(level, inputKey.toItemStack());
        }
        this.smelting = resultStack.getHoverName().getString();
        if (!isCampfireFood && this.fuel < 5000) {
            this.refillFuel(player);
        }
        if (this.fuel <= 0 && !isCampfireFood) {
            this.smeltingProgress = 0.0;
            this.broadcastFurnaceToAllMenus(level, player);
            return true;
        }
        boolean applyBulk = bulkActive && bestRemaining >= (long)operationQuantity;
        int fuelFactor = applyBulk ? 4 : 1;
        int smeltDuration = 20;
        int n = effectiveOpQty = applyBulk ? operationQuantity : baseOp;
        if (this.smeltingProgress < (double)smeltDuration) {
            this.smeltingProgress = applyBulk ? (this.smeltingProgress += 0.5) : (this.smeltingProgress += 1.0);
            if (!isCampfireFood) {
                int fuelMult = this.getStacks() + 1;
                if (this.overclock > 0) {
                    fuelMult *= 2;
                }
                int reduction = (10 - this.energy) * (fuelMult *= fuelFactor);
                if (applyBulk) {
                    reduction *= 2;
                }
                this.fuel = Math.max(0, this.fuel - reduction);
            }
            this.broadcastFurnaceToAllMenus(level, player);
            this.updateFurnaceSlotInMenus(level, player, (PlatformResourceKey)inputKey, bestRemaining);
            return true;
        }
        this.smeltingProgress = 0.0;
        this.furnaceDirty = true;
        long batch = Math.min((long)effectiveOpQty, bestRemaining);
        long extracted = this.extractFromStorages((ResourceKey)inputKey, batch, false, "Furnace");
        if (extracted <= 0L) {
            this.broadcastFurnaceToAllMenus(level, player);
            return fuelChanged;
        }
        ItemStack output = resultStack.copy();
        output.setCount((int)extracted);
        this.insertIntoStorages((ResourceKey)ItemResource.ofItemStack((ItemStack)output), extracted, false, "Furnace");
        this.updateGridIfOpen(output, extracted);
        this.updateGridIfOpen((PlatformResourceKey)inputKey, -extracted);
        this.accumulatedXp += xpPer * (float)extracted;
        this.handleXP();
        if (!isCampfireFood && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            this.distributeXP(sp);
        }
        long newRemaining = Math.max(0L, bestRemaining - extracted);
        if (this.selectedIndex != 8) {
            data.toSmelt[this.selectedIndex] = newRemaining;
            if (newRemaining <= 0L) {
                data.smeltItems[this.selectedIndex] = null;
            }
        }
        this.updateFurnaceSlotInMenus(level, player, (PlatformResourceKey)inputKey, newRemaining);
        return true;
    }

    public static boolean isCampfireItem(Level level, ItemStack stack) {
        return level.getRecipeManager().getRecipeFor(RecipeType.CAMPFIRE_COOKING, (RecipeInput)new SingleRecipeInput(stack), level).isPresent();
    }

    private void broadcastFurnaceToAllMenus(Level level, @javax.annotation.Nullable Player player) {
        if (player != null) {
            this.resetUI(player);
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sl = (ServerLevel)level;
        MinecraftServer server = sl.getServer();
        if (server == null) {
            return;
        }
        for (ServerPlayer sp : server.getPlayerList().getPlayers()) {
            AbstractContainerMenu abstractContainerMenu = sp.containerMenu;
            if (!(abstractContainerMenu instanceof AbstractOmniGridContainerMenu)) continue;
            AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
            if (!this.uuid.equals(menu.storageReference) || menu.gridPlayer == null) continue;
            this.resetUI((Player)sp);
        }
    }

    private void updateFurnaceSlotInMenus(Level level, @javax.annotation.Nullable Player player, PlatformResourceKey key, long newRemaining) {
        if (this.selectedIndex == 8) {
            AbstractContainerMenu abstractContainerMenu;
            if (player != null && (abstractContainerMenu = player.containerMenu) instanceof AbstractOmniGridContainerMenu) {
                AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
                if (menu.containerData == null || menu.gridPlayer == null) {
                    return;
                }
                PlatformResourceKey current = menu.toggleableResourceSlot.getResource();
                if (!Objects.equals(current, this.cachedSmeltingTarget)) {
                    menu.toggleableResourceSlot.setFilter(this.cachedSmeltingTarget);
                    PlatformResourceKey platformResourceKey = this.cachedSmeltingTarget;
                    if (platformResourceKey instanceof ItemResource) {
                        ItemResource itemRes = (ItemResource)platformResourceKey;
                        menu.toggleableResourceSlot.set(itemRes.toItemStack());
                    } else {
                        menu.toggleableResourceSlot.set(ItemStack.EMPTY);
                    }
                    menu.toggleableResourceSlot.container.setChanged();
                    menu.toggleableResourceSlot.setChanged();
                }
            }
            return;
        }
        if (player != null) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof AbstractOmniGridContainerMenu) {
                AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
                if (menu.containerData == null || menu.gridPlayer == null) {
                    return;
                }
                menu.surpressUpdate = true;
                if (newRemaining <= 0L) {
                    menu.furnaceContainer.remove(this.selectedIndex);
                    menu.dataServer.furnaceData.toSmelt[this.selectedIndex] = 0L;
                    menu.dataServer.furnaceData.smeltItems[this.selectedIndex] = null;
                } else {
                    menu.furnaceContainer.set(this.selectedIndex, new ResourceAmount((ResourceKey)key, newRemaining));
                    menu.dataServer.furnaceData.toSmelt[this.selectedIndex] = newRemaining;
                }
                menu.furnaceContainer.toItemContainer().setChanged();
                menu.surpressUpdate = false;
            }
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (ServerPlayer sp : serverLevel.players()) {
            AbstractContainerMenu abstractContainerMenu = sp.containerMenu;
            if (!(abstractContainerMenu instanceof AbstractOmniGridContainerMenu)) continue;
            AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
            if (!Objects.equals(menu.storageReference, this.uuid)) continue;
            if (menu.containerData == null || menu.gridPlayer == null) {
                return;
            }
            menu.surpressUpdate = true;
            if (newRemaining <= 0L) {
                menu.furnaceContainer.remove(this.selectedIndex);
                menu.dataServer.furnaceData.toSmelt[this.selectedIndex] = 0L;
                menu.dataServer.furnaceData.smeltItems[this.selectedIndex] = null;
            } else {
                menu.furnaceContainer.set(this.selectedIndex, new ResourceAmount((ResourceKey)key, newRemaining));
                menu.dataServer.furnaceData.toSmelt[this.selectedIndex] = newRemaining;
            }
            menu.furnaceContainer.toItemContainer().setChanged();
            menu.surpressUpdate = false;
            menu.broadcastChanges();
        }
    }

    public int getSlots() {
        return this.getStackCount();
    }

    public ItemStack getStackInSlot(int i) {
        ResourceKey resourceKey;
        ResourceAmount res;
        ArrayList resources = new ArrayList();
        for (UUID diskUuids : this.getUuids()) {
            Optional pos = RefinedStorageApi.INSTANCE.getStorageRepository(this.level).get(diskUuids);
            if (pos.isPresent()) {
                resources.addAll(((SerializableStorage)RefinedStorageApi.INSTANCE.getStorageRepository(this.level).get(diskUuids).get()).getAll());
            }
            if (this.commandData.isCoreInstalled(CoreTypes.DISK_DRIVE)) continue;
            break;
        }
        if (i < resources.size() && (res = (ResourceAmount)resources.get(i)).amount() > 0L && (resourceKey = res.resource()) instanceof ItemResource) {
            ItemResource itemRes = (ItemResource)resourceKey;
            return itemRes.toItemStack().copyWithCount((int)res.amount());
        }
        return ItemStack.EMPTY;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        Action action;
        long inserted;
        if (stack == null || stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null || this.level == null) {
            return stack;
        }
        ItemResource resource = ItemResource.ofItemStack((ItemStack)stack);
        long remaining = stack.getCount();
        long leftover = remaining - (inserted = storage.insert((ResourceKey)resource, remaining, action = simulate ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY));
        if (leftover <= 0L) {
            return ItemStack.EMPTY;
        }
        ItemStack result = stack.copy();
        result.setCount((int)leftover);
        return result;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0 || this.level == null) {
            return ItemStack.EMPTY;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return ItemStack.EMPTY;
        }
        ArrayList<ResourceAmount> indexed = new ArrayList<ResourceAmount>();
        for (ResourceAmount ra : storage.getAll()) {
            if (!(ra.resource() instanceof ItemResource) || ra.amount() <= 0L) continue;
            indexed.add(ra);
        }
        if (slot < 0 || slot >= indexed.size()) {
            return ItemStack.EMPTY;
        }
        ResourceAmount ra = (ResourceAmount)indexed.get(slot);
        ItemResource itemRes = (ItemResource)ra.resource();
        long available = ra.amount();
        long toExtract = Math.min(available, (long)amount);
        if (toExtract <= 0L) {
            return ItemStack.EMPTY;
        }
        Action action = simulate ? Action.SIMULATE : Action.EXECUTE;
        long extracted = storage.extract((ResourceKey)itemRes, toExtract, action, Actor.EMPTY);
        if (extracted <= 0L) {
            return ItemStack.EMPTY;
        }
        ItemStack result = itemRes.toItemStack();
        result.setCount((int)extracted);
        return result;
    }

    public int getSlotLimit(int i) {
        return 9999;
    }

    public boolean isItemValid(int i, ItemStack itemStack) {
        return !itemStack.isEmpty();
    }

    public long tryForceCraft(ItemStack requested, boolean simulate) {
        if (requested.isEmpty()) {
            return 0L;
        }
        if (this.level == null || this.level.isClientSide()) {
            return 0L;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0L;
        }
        for (RecipeHolder holder : this.level.getRecipeManager().getAllRecipesFor(RecipeType.CRAFTING)) {
            int craftsNeeded;
            CraftingRecipe recipe = (CraftingRecipe)holder.value();
            ItemStack result = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
            if (!ItemStack.isSameItemSameComponents((ItemStack)result, (ItemStack)requested) || !this.canSatisfyRecipe(recipe, craftsNeeded = OmniItemProxxy.getCraftsNeeded(requested, result), storage)) continue;
            if (simulate) {
                return (long)result.getCount() * (long)craftsNeeded;
            }
            this.extractRecipeIngredients(recipe, craftsNeeded, storage);
            long produced = (long)result.getCount() * (long)craftsNeeded;
            long surplus = produced - (long)requested.getCount();
            if (surplus > 0L) {
                ItemStack surplusStack = result.copyWithCount((int)surplus);
                storage.insert((ResourceKey)ItemResource.ofItemStack((ItemStack)surplusStack), surplus, Action.EXECUTE, (Actor)new PlayerActor("ForceCrafting"));
            }
            this.stress += (float)(Platform.getConfig().getOmniGrid().autoCraftFECost() * craftsNeeded);
            return Math.min(produced, (long)requested.getCount());
        }
        return 0L;
    }

    private boolean canSatisfyRecipe(CraftingRecipe recipe, int craftsNeeded, OmniRootStorage storage) {
        HashMap<ItemResource, Integer> required = new HashMap<ItemResource, Integer>();
        for (Ingredient ingredient : recipe.getIngredients()) {
            if (ingredient.isEmpty()) continue;
            boolean satisfied = false;
            for (ItemStack option : ingredient.getItems()) {
                if (!this.checkItem(option)) continue;
                ItemResource key = ItemResource.ofItemStack((ItemStack)option);
                int needed = required.getOrDefault(key, 0) + craftsNeeded;
                long available = storage.get((ResourceKey)key);
                if (available < (long)needed) continue;
                required.put(key, needed);
                satisfied = true;
                break;
            }
            if (satisfied) continue;
            return false;
        }
        return true;
    }

    private boolean checkItem(ItemStack stack) {
        for (OmniGridTask task : this.blockForcedCrafting) {
            if (!OmniGridResourceHandler.matchesTask(stack, task)) continue;
            return false;
        }
        return true;
    }

    private void extractRecipeIngredients(CraftingRecipe recipe, int craftsNeeded, OmniRootStorage storage) {
        for (int craft = 0; craft < craftsNeeded; ++craft) {
            ArrayList<ItemStack> slots = new ArrayList<ItemStack>(Collections.nCopies(9, ItemStack.EMPTY));
            int slotIndex = 0;
            for (Ingredient ingredient : recipe.getIngredients()) {
                if (ingredient.isEmpty()) {
                    ++slotIndex;
                    continue;
                }
                for (ItemStack option : ingredient.getItems()) {
                    ItemResource key;
                    if (!this.checkItem(option) || storage.get((ResourceKey)(key = ItemResource.ofItemStack((ItemStack)option))) <= 0L) continue;
                    ItemStack used = option.copyWithCount(1);
                    slots.set(slotIndex, used);
                    storage.extract((ResourceKey)key, 1L, Action.EXECUTE, (Actor)new PlayerActor("ForceCrafting"));
                    break;
                }
                ++slotIndex;
            }
            NonNullList remainders = recipe.getRemainingItems((RecipeInput)CraftingInput.of((int)3, (int)3, slots));
            for (ItemStack remainder : remainders) {
                if (remainder.isEmpty()) continue;
                storage.insert((ResourceKey)ItemResource.ofItemStack((ItemStack)remainder), remainder.getCount(), Action.EXECUTE, (Actor)new PlayerActor("ForceCrafting"));
            }
        }
    }

    private static int getCraftsNeeded(ItemStack requested, ItemStack recipeResult) {
        int resultCount = recipeResult.getCount();
        int requestCount = requested.getCount();
        return Math.max(1, (int)Math.ceil((double)requestCount / (double)resultCount));
    }

    public long get(ResourceKey resourceKey) {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0L;
        }
        return storage.get(resourceKey);
    }

    public boolean contains(ResourceKey resourceKey) {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return false;
        }
        return storage.get(resourceKey) > 0L;
    }

    public Collection<ResourceAmount> getAll() {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null || this.isDirty) {
            return List.of();
        }
        return storage.getAll();
    }

    public long getStored() {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null || this.isDirty) {
            return 0L;
        }
        return storage.getStored();
    }

    public long getCapacity() {
        return this.energyStorage.getCapacity();
    }

    public long extract(long l) {
        if (!this.verifyEnergy() || this.isDirty) {
            return 0L;
        }
        this.stress += (float)l / (float)(100 + this.getEnergy() * 10);
        return l;
    }

    public boolean contains(EnergyProvider energyProvider) {
        return true;
    }

    public long insert(ResourceKey resourceKey, long amount, Action action, Actor actor) {
        if (amount <= 0L || this.isDirty) {
            return 0L;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0L;
        }
        long inserted = storage.insert(resourceKey, amount, action, actor);
        if (action == Action.EXECUTE && inserted > 0L) {
            this.updateGridIfOpen(resourceKey, inserted);
        }
        return inserted;
    }

    public long extract(ResourceKey resourceKey, long amount, Action action, Actor actor) {
        if (amount <= 0L || this.isDirty) {
            return 0L;
        }
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return 0L;
        }
        long extracted = storage.extract(resourceKey, amount, action, actor);
        if (action == Action.EXECUTE && extracted > 0L) {
            this.updateGridIfOpen(resourceKey, -extracted);
        }
        return extracted;
    }

    public List<TrackedResourceAmount> getResources(Class<? extends Actor> actorType) {
        return this.getAll().stream().map(resourceAmount -> new TrackedResourceAmount(resourceAmount, this.findTrackedResourceByActorType(resourceAmount.resource(), actorType).orElse(null))).toList();
    }

    public Optional<TrackedResource> findTrackedResourceByActorType(ResourceKey key, Class<? extends Actor> actorType) {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return Optional.empty();
        }
        return storage.findTrackedResourceByActorType(key, actorType);
    }

    public void sortSources() {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage != null) {
            storage.sortSources();
        }
    }

    public void addSource(Storage s) {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage != null) {
            storage.addSource(s);
        }
    }

    public void removeSource(Storage s) {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage != null) {
            storage.removeSource(s);
        }
    }

    public boolean hasSource(Predicate<Storage> predicate) {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage == null) {
            return false;
        }
        return storage.hasSource(predicate);
    }

    public boolean contains(Storage storage) {
        return false;
    }

    public void addListener(RootStorageListener listener) {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage != null) {
            storage.addListener(listener);
        }
    }

    public void removeListener(RootStorageListener listener) {
        OmniRootStorage storage = this.getOrCreateStorage();
        if (storage != null) {
            storage.removeListener(listener);
        }
    }

    public void addListener(PatternListener l) {
        if (l == null) {
            return;
        }
        this.patternListeners.add(l);
        for (Pattern p : this.getPatterns()) {
            l.onAdded(p);
        }
    }

    public void removeListener(PatternListener l) {
        if (l == null) {
            return;
        }
        this.patternListeners.remove(l);
    }

    public Set<Pattern> getPatterns() {
        if (this.allPatterns == null || this.allPatterns.isEmpty()) {
            return Set.of();
        }
        return this.allPatterns;
    }

    public List<Pattern> getPatternsByOutput(ResourceKey output) {
        if (output == null || this.patternsByResource == null) {
            return List.of();
        }
        return this.patternsByResource.getOrDefault(output, List.of());
    }

    public Set<ResourceKey> getOutputs() {
        if (this.patternsByResource == null || this.patternsByResource.isEmpty()) {
            return Set.of();
        }
        return this.patternsByResource.keySet();
    }

    public void onAddedIntoContainer(ParentContainer parentContainer) {
    }

    public void onRemovedFromContainer(ParentContainer parentContainer) {
    }

    public boolean contains(AutocraftingNetworkComponent autocraftingNetworkComponent) {
        return true;
    }

    public void addTask(Task task) {
    }

    public void cancelTask(TaskId taskId) {
    }

    public List<TaskStatus> getTaskStatuses() {
        return List.of();
    }

    public long getAmount(ResourceKey resourceKey) {
        return 1L;
    }

    public void receivedExternalIteration() {
    }

    @Nullable
    public PatternProvider getProviderByPattern(Pattern pattern) {
        return this;
    }

    public AutocraftingNetworkComponent.EnsureResult ensureTask(ResourceKey resourceKey, long l, Actor actor, CancellationToken cancellationToken) {
        return AutocraftingNetworkComponent.EnsureResult.MISSING_RESOURCES;
    }

    public CompletableFuture<Optional<Preview>> getPreview(ResourceKey resourceKey, long l, CancellationToken cancellationToken) {
        return null;
    }

    public CompletableFuture<Optional<TreePreview>> getTreePreview(ResourceKey resourceKey, long l, CancellationToken cancellationToken) {
        return null;
    }

    public CompletableFuture<Long> getMaxAmount(ResourceKey resourceKey, CancellationToken cancellationToken) {
        return null;
    }

    public Optional<TaskId> startTask(ResourceKey resourceKey, long l, Actor actor, boolean b, CancellationToken cancellationToken) {
        return Optional.empty();
    }

    public List<TaskStatus> getStatuses() {
        return List.of();
    }

    public void addListener(TaskStatusListener taskStatusListener) {
    }

    public void removeListener(TaskStatusListener taskStatusListener) {
    }

    public void cancel(TaskId taskId) {
    }

    public void cancelAll() {
    }

    public List<ExternalPatternSink> getSinksByPatternLayout(PatternLayout patternLayout) {
        return List.of();
    }

    public ExternalPatternSink.Result accept(Pattern pattern, Collection<ResourceAmount> collection, Action action) {
        return null;
    }

    public boolean isAllowed(Permission permission, SecurityActor securityActor) {
        return true;
    }

    public boolean contains(SecurityNetworkComponent securityNetworkComponent) {
        return false;
    }

    public boolean isAllowed(Permission permission, ServerPlayer serverPlayer) {
        return true;
    }

    class SpyingExternalStorageListener
    implements ExternalStorageListener {
        public final List<ResourceKey> resources = new ArrayList<ResourceKey>();
        public final List<Actor> actors = new ArrayList<Actor>();

        SpyingExternalStorageListener(OmniItemProxxy this$0) {
        }

        public void beforeDetectChanges(ResourceKey resource, Actor actor) {
            this.resources.add(resource);
            this.actors.add(actor);
        }
    }
}

