/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Utils.RefinedTypesUtil;
import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.neoforge.BasicCrafting;
import com.omnigrid.neoforge.LootNotification;
import com.omnigrid.neoforge.OmniBlockTarget;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.OmniResourceAction;
import com.omnigrid.neoforge.OmniResourceDirection;
import com.omnigrid.neoforge.OmniResourceType;
import com.omnigrid.neoforge.PlayerTargetting;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniGridTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniGridTask.class);
    public Optional<PlatformResourceKey> resource = Optional.empty();
    public String keyword = "";
    public String mod = "";
    public String tag = "";
    public String component = "";
    public static int[] maintainInts = new int[]{1, 2, 4, 8, 16, 32, 64};
    public int maintainAmount = 0;
    public int lastSuccessfulSlot = -1;
    public OmniResourceAction action;
    public OmniResourceDirection direction;
    public OmniResourceType type;
    public BasicCrafting basicCrafting;
    public LootNotification notification;
    public ItemResource lastSuccessfulResource = null;
    public long lastSuccessTimestamp = 0L;
    public Direction mcDirection;
    public boolean all = false;
    public boolean provide = false;
    public boolean pull = false;
    public boolean push = false;
    public boolean blacklist = false;
    public boolean isFuzzy = false;
    public boolean player = false;
    public boolean any = false;
    public boolean search = false;
    public boolean collect = false;
    public boolean external = false;
    public boolean compress = false;
    public boolean open = false;
    public int repeat = 1;
    public boolean isBlockTarget = false;
    public ItemStack stack = ItemStack.EMPTY;
    public Fluid fluid;
    public boolean isEnergy = false;
    public int energyAmount = 1000;
    public int containerRotation = 0;
    public BlockPos lastContainer;
    public int blockTargetIndex = -1;
    public PlayerTargetting playerTargetting;
    public Direction lastContainerDirection;
    public boolean linkContainer = false;
    public int cooldown = 0;
    public PlatformResourceKey cachedResource;
    public boolean maintain = false;
    public OmniBlockTarget blockTarget;
    public List<OmniBlockTarget> cacheBlockTargets;
    public List<BlockPos> cacheBlockPositions = new ArrayList<BlockPos>();
    public boolean canDoTask = true;
    public Map<BlockPos, ExporterTransferStrategy> exporters = new HashMap<BlockPos, ExporterTransferStrategy>();
    public Map<BlockPos, ImporterTransferStrategy> importers = new HashMap<BlockPos, ImporterTransferStrategy>();
    public boolean isDirectional = false;
    public int linkRotationIndex = 0;
    public int cachedResourceIndex = -1;
    public int cachedSlotIndex = -1;
    public boolean isValid = true;
    public double energyMultiplier = 1.0;
    public boolean isXP = false;
    public int idx = 0;
    private boolean inverted = false;
    public Filter filter;
    public boolean jeiCraft = false;

    public double getEnergyMultiplier() {
        return this.energyMultiplier;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public OmniGridTask(ItemStack stack) {
        this.resource = Optional.of(ItemResource.ofItemStack((ItemStack)stack));
        this.jeiCraft = true;
    }

    public OmniGridTask(int idx, Optional<PlatformResourceKey> resourceOpt, int actionIndex, int directionIndex, int typeIndex, boolean inverted, boolean blockFlag, int[] upgrades, int quantity, int targetConfig) {
        double mult;
        this.inverted = inverted;
        this.resource = resourceOpt;
        this.idx = idx;
        if (directionIndex >= 11 && directionIndex <= 22) {
            this.isBlockTarget = true;
            this.blockTargetIndex = directionIndex - 11;
            this.direction = OmniResourceDirection.NONE;
            this.linkContainer = blockFlag;
        } else {
            this.direction = directionIndex >= 0 && directionIndex < OmniResourceDirection.values().length ? OmniResourceDirection.values()[directionIndex] : OmniResourceDirection.NONE;
        }
        this.action = OmniResourceAction.values()[Math.min(actionIndex, OmniResourceAction.values().length - 1)];
        this.type = OmniResourceType.values()[Math.min(typeIndex, OmniResourceType.values().length - 1)];
        this.mcDirection = switch (this.direction) {
            case OmniResourceDirection.FRONT -> Direction.NORTH;
            case OmniResourceDirection.BACK -> Direction.SOUTH;
            case OmniResourceDirection.LEFT -> Direction.WEST;
            case OmniResourceDirection.RIGHT -> Direction.EAST;
            case OmniResourceDirection.UP -> Direction.UP;
            case OmniResourceDirection.DOWN -> Direction.DOWN;
            case OmniResourceDirection.PLAYER -> Direction.NORTH;
            default -> Direction.NORTH;
        };
        switch (this.direction) {
            case FRONT: 
            case BACK: 
            case LEFT: 
            case RIGHT: 
            case UP: 
            case DOWN: {
                boolean bl = true;
                break;
            }
            default: {
                boolean bl = this.isDirectional = false;
            }
        }
        if (this.action == OmniResourceAction.PROVIDE) {
            this.provide = true;
        }
        if (this.action == OmniResourceAction.PUSH) {
            this.push = true;
        }
        if (this.action == OmniResourceAction.BLACKLIST) {
            this.blacklist = true;
        }
        if (this.action == OmniResourceAction.PULL) {
            this.pull = true;
        }
        if (this.action == OmniResourceAction.SEARCH) {
            this.search = true;
        }
        if (this.action == OmniResourceAction.COLLECT) {
            this.collect = true;
        }
        if (this.action == OmniResourceAction.EXTERNAL_STORAGE) {
            this.external = true;
        }
        if (this.action == OmniResourceAction.BASIC_CRAFTING) {
            this.compress = true;
            this.basicCrafting = BasicCrafting.values()[Math.min(targetConfig, BasicCrafting.values().length - 1)];
        }
        if (this.action == OmniResourceAction.REGULATE) {
            this.maintain = true;
        }
        if (this.direction == OmniResourceDirection.PLAYER) {
            this.player = true;
            this.playerTargetting = PlayerTargetting.values()[Math.min(targetConfig, PlayerTargetting.values().length - 1)];
        } else {
            this.playerTargetting = PlayerTargetting.INVENTORY_NO_HOTBAR;
        }
        if (this.action == OmniResourceAction.LOOTING) {
            this.open = true;
            this.notification = LootNotification.values()[Math.min(targetConfig, LootNotification.values().length - 1)];
        }
        if (typeIndex == 1) {
            this.isFuzzy = true;
        }
        if (this.maintain || this.basicCrafting == BasicCrafting.REQUEST) {
            this.maintainAmount = quantity;
        }
        this.energyMultiplier = mult = 1.0;
        if (resourceOpt.isPresent()) {
            PlatformResourceKey key = resourceOpt.get();
            if (key instanceof ItemResource) {
                ResourceLocation rl;
                ItemResource itemKey = (ItemResource)key;
                this.stack = itemKey.toItemStack();
                if (typeIndex == 2 && (rl = BuiltInRegistries.ITEM.getKey((Object)itemKey.item())) != null) {
                    this.mod = rl.getNamespace();
                }
                if (typeIndex >= 3) {
                    int tagIdx = typeIndex - 3;
                    List<String> tags = TransferUtils.getItemTagsAsStringList(this.stack);
                    List<String> comps = TransferUtils.getItemComponentsAsStringList(this.stack);
                    if (tagIdx < tags.size()) {
                        this.tag = tags.get(tagIdx);
                    } else if (tagIdx - tags.size() < comps.size()) {
                        int compIdx = tagIdx - tags.size();
                        this.component = comps.get(compIdx);
                    } else {
                        List<String> words = TransferUtils.getItemIdWordsNoNamespace(this.stack);
                        int wordIdx = tagIdx - tags.size() - comps.size();
                        this.keyword = !words.isEmpty() ? words.get(Math.min(wordIdx % words.size(), words.size() - 1)) : "";
                    }
                }
            } else if (key instanceof FluidResource) {
                FluidResource fluidKey = (FluidResource)key;
                this.fluid = fluidKey.fluid();
                if (this.fluid.is(OmniItemProxxy.XP_TAG)) {
                    this.isXP = true;
                }
            } else if (RefinedTypesUtil.rtInstalled() && key instanceof EnergyResource) {
                this.isEnergy = true;
                this.energyAmount = (int)(1000.0 * Math.pow(4.0, upgrades[1] + upgrades[3]));
            }
        } else {
            this.any = true;
        }
    }
}

