/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.google.common.util.concurrent.RateLimiter;
import com.mojang.blaze3d.systems.RenderSystem;
import com.omnigrid.Utils.ButtonCategory;
import com.omnigrid.Utils.CommandValidator;
import com.omnigrid.Utils.ModUtil;
import com.omnigrid.Utils.SmeltResult;
import com.omnigrid.Utils.StressWidget;
import com.omnigrid.Utils.TabButtonColumn;
import com.omnigrid.Utils.ToggleableQuickCraftingSlot;
import com.omnigrid.Utils.TooltipUtils;
import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.AbstractOmniGridScreen;
import com.omnigrid.neoforge.ClearTargetData;
import com.omnigrid.neoforge.ClientModInitializer;
import com.omnigrid.neoforge.CommandConfigurationButton;
import com.omnigrid.neoforge.CoreItem;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.CraftingGridResultSlot;
import com.omnigrid.neoforge.DisableCommandPacket;
import com.omnigrid.neoforge.FilterTextButton;
import com.omnigrid.neoforge.GridSearchBoxWidget;
import com.omnigrid.neoforge.HoveredImageButton;
import com.omnigrid.neoforge.IntButton;
import com.omnigrid.neoforge.Items;
import com.omnigrid.neoforge.MarkedContainerFilterSlot;
import com.omnigrid.neoforge.NumberTextBox;
import com.omnigrid.neoforge.OmniBlockTarget;
import com.omnigrid.neoforge.OmniCommand;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniDataFilterSlot;
import com.omnigrid.neoforge.OmniFurnaceSlot;
import com.omnigrid.neoforge.OmniGridBlock;
import com.omnigrid.neoforge.OmniGridBlockContainerMenu;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.OmniResourceSlot;
import com.omnigrid.neoforge.OmniUpgradeSlot;
import com.omnigrid.neoforge.SyncTabPacket;
import com.omnigrid.neoforge.ToggleableCoreSlot;
import com.omnigrid.neoforge.ToggleableMonitoredResourceSlot;
import com.omnigrid.neoforge.ToggleableResourceSlot;
import com.omnigrid.neoforge.ToggleableUtilitySlot;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.PatternItem;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.content.KeyMappings;
import com.refinedmods.refinedstorage.common.grid.screen.AbstractGridScreen;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.direction.BiDirectionType;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.ProgressWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniGridScreen
extends AbstractOmniGridScreen<AbstractOmniGridContainerMenu> {
    private static final int DISK_SLOT_WIDTH = 23;
    private static final int DISK_SLOT_HEIGHT = 148;
    private static final int BUTTON_SIZE = 16;
    private static final int TRANSFER_BUTTON_SIZE = 10;
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniGridScreen.class);
    @Nullable
    private HoveredImageButton clearToNetworkButton;
    private HoveredImageButton clearToInventoryButton;
    private HoveredImageButton depositButton;
    public FilterTextButton filterTextButton;
    public int filterIndex = 0;
    private int YOffset = 0;
    private HoveredImageButton bruteForceButton;
    private HoveredImageButton withdrawButton;
    private NumberTextBox actionConfigNumber;
    public IntButton actionButton;
    private HoveredImageButton spreadButton;
    private Button exit;
    private ResourceLocation[] hoverOverlay = new ResourceLocation[9];
    private ResourceLocation transferBG = ModUtil.OmniIdentifier("widget/transfer");
    private ArrayList<CommandConfigurationButton> transferOptions = new ArrayList();
    public int filterPage = 0;
    public int screenConfig = 0;
    private ArrayList<CommandConfigurationButton> directional = new ArrayList();
    private ArrayList<CommandConfigurationButton> targetOption = new ArrayList();
    private ArrayList<CommandConfigurationButton> actionButtons = new ArrayList();
    private ArrayList<CommandConfigurationButton> blockTargetButtons = new ArrayList();
    private static final WidgetSprites CLEAR_BUTTON_TO_PLAYER_INVENTORY_SPRITES = new WidgetSprites(ModUtil.OmniIdentifier("widget/down"), ModUtil.OmniIdentifier("widget/down"), ModUtil.OmniIdentifier("widget/down_focused"), ModUtil.OmniIdentifier("widget/down_focused"));
    private static final WidgetSprites CLOSE_CONFIG = new WidgetSprites(ModUtil.OmniIdentifier("widget/exit"), ModUtil.OmniIdentifier("widget/exit"), ModUtil.OmniIdentifier("widget/exith"), ModUtil.OmniIdentifier("widget/exith"));
    private static final WidgetSprites CLEAR_BUTTON_TO_NETWORK_SPRITES = new WidgetSprites(ModUtil.OmniIdentifier("widget/up"), ModUtil.OmniIdentifier("widget/up"), ModUtil.OmniIdentifier("widget/up_focused"), ModUtil.OmniIdentifier("widget/up_focused"));
    private OmniResourceSlot selected;
    private int counter = 0;
    private static final ResourceLocation CAMPFIRE_SPRITE = ModUtil.OmniIdentifier("widget/campfire");
    public ArrayList<IntButton> transferDirectionButtons = new ArrayList();
    private boolean transferPanel = false;
    public static final int CRAFTING_TAB = 0;
    public static final int COMMAND_TAB = 1;
    public static final int FURNACE_TAB = 2;
    public static final int UTILITY_TAB = 3;
    public static final int CORE_TAB = 4;
    private static final int MINI_GUI_X = 3;
    private static final int MINI_GUI_Y = 75;
    private static final int MINI_GUI_WIDTH = 128;
    private static final int MINI_GUI_HEIGHT = 73;
    private static final ResourceLocation CRAFTING_MATRIX_FILTERING_SLOT_HIGHLIGHT = IdentifierUtil.createIdentifier((String)"crafting_grid/crafting_matrix_filtering_slot_highlight");
    private CommandConfigurationButton hoveredButton;
    private CommandConfigurationButton invertButton;
    private CommandConfigurationButton linkButton;
    private int commandIndex = -1;
    private boolean filteringBasedOnCraftingMatrixItems;
    @Nullable
    GridSearchBoxWidget searchField;
    public boolean sideways = false;
    public TabButtonColumn tabs;
    public int yOff = 178;
    public ButtonCategory buttonCategory = ButtonCategory.NONE;
    private static final ResourceLocation DISKSLOT_TEXTURE = ModUtil.OmniIdentifier("disk_slots");
    private static boolean alternate = false;
    private static final ResourceLocation OMNI_GRID_GUI = ModUtil.OmniIdentifier("textures/gui/omni_grid.png");
    private static final String[] faceNames = new String[]{"", "", "Top", "Player", "Left", "Front", "Right", "Bottom", "Back", "", ""};
    private static final CoreTypes[] faceCoreTypes = new CoreTypes[]{CoreTypes.NONE, null, CoreTypes.PLAYER, null, null, null, null, null, null, null};
    private static final String[] actionNames = new String[]{"None", "Provide", "Pull", "Collect", "Push", "Blacklist", "Search", "External Storage", "Simple Crafting", "Regulate", "Auto Looting"};
    private static final CoreTypes[] actionCoreTypes = new CoreTypes[]{null, CoreTypes.PULL, CoreTypes.COLLECT, CoreTypes.PUSH, CoreTypes.BLACKLIST, CoreTypes.SEARCH, CoreTypes.EXTERNAL_STORAGE, CoreTypes.BASIC_CRAFTING, CoreTypes.REGULATE, CoreTypes.LOOTING};
    private static final String[] autoLootOptions = new String[]{"Quantity Looted", "New Items", "Quantity and New Items", "None"};
    private static final String[] basicCraftOptions = new String[]{"Compress 2x2", "Compress 3x3", "Decompress 1x1", "3x1 Row", "1x3 Column", "Auto-request", "Block Brute-Force Crafting", "Smelt"};
    private static final String[] basicCraftOptionDescriptions = new String[]{"Craft items using a 2\u00d72 recipe, such as clay balls into clay blocks.", "Craft items using a full 3\u00d73 recipe, like ingots into storage blocks.", "Break items down into their basic components, such as logs into planks.", "Craft items using a horizontal 3\u00d71 recipe, like slabs.", "Craft items using a vertical 1\u00d73 recipe, such as copper rods.", "Automatically quene autocrafting requests for this item if possible", "Prevents this item from being used by brute-force crafting.", "Request this item be smelted by the Digital Furnace if its available"};
    private static final String[] playerOptions = new String[]{"Inventory (no hotbar)", "Inventory (with hotbar)", "Hotbar", "Offhand", "Ender chest", "Item containers"};
    private static final String[] actionDescription = new String[]{"No action", "While placed, allow automation to take this resource from the configured side", "Take this resource from the target", "Collect this item from the ground and add it to storage", "Push this resource to the target", "Prevent this resource from being inserted by the target", "Search and take this resource from nearby containers.", "Use the target as external storage \n\n When a resource is configured, the Omni Grid prioritizes transferring to and from the external storage when handling that resource", "Perform simple crafting operations", "Keep a set number of this item in the target", "When opening standard chests and barrels, automatically deposit loot into Omni Grid storage. Affected by filters"};
    private static String[] typeTooltipDesciption = new String[]{"Exactly this resource", "This resource but ignore component data", "Any resource from the same mod", "Any resource with this tag"};
    private static final WidgetSprites SPREAD_SPRITES = new WidgetSprites(ModUtil.OmniIdentifier("widget/balance"), ModUtil.OmniIdentifier("widget/spread"), ModUtil.OmniIdentifier("widget/balance_focused"), ModUtil.OmniIdentifier("widget/spread_focused"));
    private static final WidgetSprites PATTERN_SPRITES = new WidgetSprites(ModUtil.OmniIdentifier("widget/pattern"), ModUtil.OmniIdentifier("widget/pattern"), ModUtil.OmniIdentifier("widget/pattern_focused"), ModUtil.OmniIdentifier("widget/pattern_focused"));
    private static final WidgetSprites FURNACE_SPRITES = new WidgetSprites(ModUtil.OmniIdentifier("widget/furnace"), ModUtil.OmniIdentifier("widget/craft"), ModUtil.OmniIdentifier("widget/furnace_focused"), ModUtil.OmniIdentifier("widget/craft_focused"));
    private static final WidgetSprites DEPOSIT_SPRITES = new WidgetSprites(ModUtil.OmniIdentifier("widget/deposit"), ModUtil.OmniIdentifier("widget/deposit"), ModUtil.OmniIdentifier("widget/deposit_focused"), ModUtil.OmniIdentifier("widget/deposit_focused"));
    private static final WidgetSprites CORE_SPRITES = new WidgetSprites(ModUtil.OmniIdentifier("widget/toggle"), ModUtil.OmniIdentifier("widget/toggle"), ModUtil.OmniIdentifier("widget/toggle_focused"), ModUtil.OmniIdentifier("widget/toggle_focused"));
    private static final WidgetSprites WITHDRAW_SPRITES = new WidgetSprites(ModUtil.OmniIdentifier("widget/withdraw"), ModUtil.OmniIdentifier("widget/withdraw"), ModUtil.OmniIdentifier("widget/withdraw_focused"), ModUtil.OmniIdentifier("widget/withdraw_focused"));
    private static final WidgetSprites BRUTEFORCE_SPRITES = new WidgetSprites(ModUtil.OmniIdentifier("widget/brute_unactive"), ModUtil.OmniIdentifier("widget/brute"), ModUtil.OmniIdentifier("widget/brute_unactive_focused"), ModUtil.OmniIdentifier("widget/brute_focused"));
    @Nullable
    private ProgressWidget progressWidget;
    @Nullable
    private StressWidget stress;
    private int lastSentTab = 0;
    private boolean lastSentTransferPanel = false;
    private static final Map<ItemStack, List<String>> DESCRIPTOR_CACHE = Collections.synchronizedMap(new WeakHashMap());
    public int lastActionConfig = 0;
    public RateLimiter rateLimiter = RateLimiter.create((double)4.0);
    public static final ResourceLocation XP_ORB_SPRITE = ModUtil.OmniIdentifier("widget/orb");

    public boolean isTransferPanel() {
        return this.transferPanel;
    }

    public OmniGridScreen(AbstractOmniGridContainerMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title, 156);
        this.inventoryLabelY = 134;
        this.imageHeight = 227;
        this.imageWidth = 223;
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int leftPos, int topPos, int clickedButton) {
        if (mouseX >= (double)(leftPos - 23 + 3) && mouseX <= (double)(leftPos - 100)) {
            return false;
        }
        return super.hasClickedOutside(mouseX, mouseY, leftPos, topPos, clickedButton);
    }

    public double powerPercentage() {
        if (((AbstractOmniGridContainerMenu)this.menu).isUtilityInstalled(UtilityType.CREATIVE)) {
            return 1.0;
        }
        return (double)((AbstractOmniGridContainerMenu)this.menu).containerData.getPower() / (double)((AbstractOmniGridContainerMenu)this.menu).getMaxPower();
    }

    public List<Component> powerTooltip() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (((AbstractOmniGridContainerMenu)this.menu).isUtilityInstalled(UtilityType.CREATIVE)) {
            list.add((Component)Component.literal((String)"Stored ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)"\u221e").withStyle(ChatFormatting.WHITE)));
            return list;
        }
        long stored = ((AbstractOmniGridContainerMenu)this.menu).containerData.getPower();
        long max = ((AbstractOmniGridContainerMenu)this.menu).getMaxPower();
        double percent = max > 0L ? (double)stored / (double)max * 100.0 : 0.0;
        list.add((Component)Component.literal((String)"Stored ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)OmniGridScreen.formatPower(stored)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"/").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)OmniGridScreen.formatPower(max)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)String.format(" (%.0f%%)", percent)).withStyle(ChatFormatting.GRAY)));
        return list;
    }

    private static String formatPower(long value) {
        if (value < 1000000L) {
            return String.format("%,d", value);
        }
        long thousands = value / 1000L;
        return String.format("%,dk", thousands);
    }

    public void updateEnergyWidget() {
        int progressX = 172;
        int progressY = this.imageHeight - 10 - 70 + 3;
        this.renderables.remove(this.progressWidget);
        this.progressWidget = new ProgressWidget(this.leftPos + 172, this.topPos + progressY, 15, 70, this::powerPercentage, this::powerTooltip);
        this.addRenderableWidget((GuiEventListener)this.progressWidget);
        this.renderables.remove((Object)this.stress);
        this.stress = new StressWidget(this.leftPos + 172 + 10, this.topPos + progressY, 5, 70, this::percent, this::efficiencyTooltip);
        this.addRenderableWidget((GuiEventListener)this.stress);
    }

    public long getMaxStress() {
        return ((AbstractOmniGridContainerMenu)this.getMenu()).getMaxPower() / (long)(5 - ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().getUpgrades()[3]);
    }

    public double percent() {
        int stress = (int)Math.min((long)((AbstractOmniGridContainerMenu)this.menu).containerData.get(4), this.getMaxStress());
        return Math.min(1.0, (double)stress / (double)this.getMaxStress());
    }

    public List<Component> efficiencyTooltip() {
        ArrayList<Component> list = new ArrayList<Component>();
        int maxStress = Math.toIntExact(this.getMaxStress());
        int rawStress = ((AbstractOmniGridContainerMenu)this.getMenu()).containerData.get(4);
        double stressPercent = maxStress > 0 ? Math.min(100.0, (double)rawStress / (double)maxStress * 100.0) : 0.0;
        double penaltyPercent = Math.max(0.0, stressPercent - 20.0) * 5.0;
        list.add((Component)Component.literal((String)String.format("System Stress: %.0f%%", stressPercent)));
        ChatFormatting penaltyColor = penaltyPercent == 0.0 ? ChatFormatting.GREEN : (penaltyPercent < 200.0 ? ChatFormatting.YELLOW : ChatFormatting.RED);
        list.add((Component)Component.literal((String)String.format("Energy Penalty: +%.0f%%", penaltyPercent)).withStyle(penaltyColor));
        list.add((Component)Component.literal((String)""));
        list.add((Component)Component.literal((String)"Omni Grid processes put stress on the system.").withStyle(ChatFormatting.YELLOW));
        list.add((Component)Component.literal((String)"Efficiency decreases above 20% stress.").withStyle(ChatFormatting.DARK_RED));
        list.add((Component)Component.literal((String)"Processes stop at 100%.").withStyle(ChatFormatting.RED));
        return list;
    }

    public static String toPercent(double value) {
        return Math.round(value * 100.0) + "%";
    }

    private boolean isInDiskDeadZone(double mouseX, double mouseY) {
        int x = this.leftPos - 23 - 17;
        int y = this.topPos + 74;
        int w = 43;
        int h = 200;
        return mouseX >= (double)x && mouseX < (double)(x + w) && mouseY >= (double)y && mouseY < (double)(y + h);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && !((AbstractOmniGridContainerMenu)this.menu).getCarried().isEmpty() && this.isInDiskDeadZone(mouseX, mouseY)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    protected void init() {
        int i;
        ResourceLocation[] copy;
        int i2;
        this.yOff = 78;
        this.sideways = false;
        this.clearWidgets();
        this.transferOptions.clear();
        this.targetOption.clear();
        this.actionButtons.clear();
        this.blockTargetButtons.clear();
        ((AbstractOmniGridContainerMenu)this.menu).tabPage = 0;
        super.init();
        int diskX = this.leftPos - 23 + 3;
        int diskY = this.topPos;
        int diskWidth = 23;
        int diskHeight = this.imageHeight;
        this.getExclusionZones().add(new Rect2i(diskX, diskY, diskWidth, diskHeight));
        int progressX = 172;
        int progressY = this.imageHeight - 10 - 70 + 3;
        if (this.progressWidget == null) {
            this.updateEnergyWidget();
        } else {
            this.progressWidget.setX(this.leftPos + 172);
            this.progressWidget.setY(this.topPos + progressY);
            this.stress.setX(this.leftPos + 172 + 10);
            this.stress.setY(this.topPos + progressY);
        }
        int clearToNetworkButtonX = this.getCraftingClearButtonX(0) + 2;
        this.inventoryLabelY += 6;
        this.spreadButton = this.createSpreadButton(clearToNetworkButtonX, this.getCraftingClearButtonY(2));
        this.addRenderableWidget((GuiEventListener)this.spreadButton);
        this.clearToNetworkButton = this.createClearButton(clearToNetworkButtonX, this.getCraftingClearButtonY(1), false);
        this.tabs = new TabButtonColumn(clearToNetworkButtonX - 21, this.getCraftingClearButtonY(1) - 3, 20, 23, (Component)Component.literal((String)"None"), this);
        this.addRenderableWidget((GuiEventListener)this.tabs);
        this.addRenderableWidget((GuiEventListener)this.clearToNetworkButton);
        this.clearToInventoryButton = this.createClearButton(clearToNetworkButtonX, this.getCraftingClearButtonY(3), true);
        this.addRenderableWidget((GuiEventListener)this.clearToInventoryButton);
        this.bruteForceButton = this.createBruteForceButton(this.getClearButtonX(-2) - 3, this.getCraftingClearButtonY(4));
        this.withdrawButton = this.createWithdrawButton(this.getClearButtonX(0) + 17, this.getCraftingClearButtonY(4) + 1);
        this.depositButton = this.createDepositButton(this.getClearButtonX(2) + 11, this.getCraftingClearButtonY(4) + 1);
        this.addRenderableWidget((GuiEventListener)this.depositButton);
        this.filterTextButton = new FilterTextButton(this.getClearButtonX(-8), this.getCraftingClearButtonY(1) - 8, this);
        this.addRenderableWidget((GuiEventListener)this.filterTextButton);
        this.addRenderableWidget((GuiEventListener)this.withdrawButton);
        ResourceLocation[] modeSprites = new ResourceLocation[4];
        ResourceLocation[] typeSprites = new ResourceLocation[32];
        ResourceLocation[] sideSpritesRes = new ResourceLocation[9];
        this.addRenderableWidget((GuiEventListener)this.bruteForceButton);
        String[] sideSprites = new String[]{"", "top", "player", "left", "front", "right", "bottom", "back"};
        String[] transportSprites = new String[]{"provide", "pull", "hopper", "push", "disable", "search", "items", "compress", "maintain", "open"};
        for (int i3 = 0; i3 < 4; ++i3) {
            modeSprites[i3] = ModUtil.OmniIdentifier("widget/" + transportSprites[i3]);
        }
        String[] typeNames = new String[]{"precise", "fuzzy", "mod"};
        for (i2 = 0; i2 < 3; ++i2) {
            typeSprites[i2] = ModUtil.OmniIdentifier("widget/" + typeNames[i2]);
        }
        for (i2 = 0; i2 < 13; ++i2) {
            typeSprites[i2 + 3] = ModUtil.OmniIdentifier("widget/tag" + i2);
        }
        for (i2 = 16; i2 < 32; ++i2) {
            typeSprites[i2] = ModUtil.OmniIdentifier("widget/tag" + i2 % 14);
        }
        for (i2 = 0; i2 < 8; ++i2) {
            sideSpritesRes[i2] = ModUtil.OmniIdentifier("widget/" + sideSprites[i2]);
        }
        ResourceLocation[] selections = new ResourceLocation[]{ModUtil.OmniIdentifier("widget/none"), ModUtil.OmniIdentifier("widget/selection")};
        int counter = 0;
        int dataCounter = 0;
        int yOff = 12;
        int yOffset = 24;
        ResourceLocation[] copy0 = (ResourceLocation[])selections.clone();
        OmniResourceSlot ss = ((AbstractOmniGridContainerMenu)this.getMenu()).getCommandResourceSlots()[0];
        this.invertButton = new CommandConfigurationButton(this.leftPos + ss.x - 1 + 36, this.topPos + ss.y - 1 + yOffset - 8 + 36, 18, 18, new ResourceLocation[]{ModUtil.OmniIdentifier("widget/reg"), ModUtil.OmniIdentifier("widget/blacklist")}, counter, c -> this.invertConfig((CommandConfigurationButton)((Object)c)), 1, 1, this, ButtonCategory.FILTER);
        this.transferOptions.add(this.invertButton);
        this.invertButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.invertButton);
        this.invertButton.setRequiredCore(CoreTypes.FILTER);
        for (int i4 = 0; i4 < 2; ++i4) {
            for (int o = 0; o < 5; ++o) {
                ResourceLocation[] copy2 = (ResourceLocation[])selections.clone();
                if (counter >= transportSprites.length) continue;
                copy2[0] = ModUtil.OmniIdentifier("widget/" + transportSprites[counter]);
                CommandConfigurationButton btn = new CommandConfigurationButton(this.getCraftingClearButtonX(o - 3) + 70 + o * 2, this.getCraftingClearButtonY(i4) + yOff + i4 * 2 + 10, 18, 18, copy2, counter, c -> this.actionConfig((CommandConfigurationButton)((Object)c)), 0, 1, this, ButtonCategory.ACTION);
                btn.setRequiredCore(actionCoreTypes[counter]);
                this.actionButtons.add(btn);
                this.transferOptions.add(btn);
                btn.active = false;
                this.addRenderableWidget((GuiEventListener)btn);
                if (++counter != 8) continue;
                this.actionConfigNumber = new NumberTextBox(this, this.font, this.getCraftingClearButtonX(o - 4) + 60, this.getCraftingClearButtonY(i4 + 2) + yOff, 54, 10, (Component)Component.literal((String)"None"));
                this.addRenderableWidget((GuiEventListener)this.actionConfigNumber);
                this.actionConfigNumber.active = false;
            }
        }
        int directIndex = 0;
        for (int i5 = 0; i5 < 3; ++i5) {
            for (int o = 0; o < 3; ++o) {
                if (directIndex >= 8) continue;
                copy = (ResourceLocation[])selections.clone();
                copy[0] = sideSpritesRes[directIndex];
                int x = this.getCraftingClearButtonX(o) + 20;
                if (directIndex >= 6) {
                    x += 18;
                }
                CommandConfigurationButton btn = new CommandConfigurationButton(x, this.getCraftingClearButtonY(i5 + 1), 18, 18, copy, dataCounter, c -> this.directionConfiguration((CommandConfigurationButton)((Object)c)), 0, 0, this, ButtonCategory.TARGET);
                btn.setRequiredCore(faceCoreTypes[dataCounter]);
                ++dataCounter;
                this.targetOption.add(btn);
                if (directIndex > 0 && btn.requiredCore != CoreTypes.PLAYER) {
                    this.directional.add(btn);
                }
                this.transferOptions.add(btn);
                btn.active = false;
                this.addRenderableWidget((GuiEventListener)btn);
                ++directIndex;
            }
        }
        copy0[0] = ModUtil.OmniIdentifier("widget/plink");
        this.linkButton = new CommandConfigurationButton(this.leftPos + ss.x - 1 + 36, this.topPos + ss.y - 1 + yOffset - 22, 18, 18, copy0, 0, c -> this.remoteModeConfiguration((CommandConfigurationButton)((Object)c)), 0, 0, this, ButtonCategory.TARGET);
        this.linkButton.setRequiredCore(CoreTypes.LINK);
        this.transferOptions.add(this.linkButton);
        this.linkButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.linkButton);
        this.exit = new HoveredImageButton(this.leftPos + ss.x - 1 + 54, this.topPos + ss.y - 1 + yOffset - 22, 18, 18, CLOSE_CONFIG, c -> this.closeConfig(), (Component)Component.literal((String)"Exit configuration"), this, 2);
        this.exit.active = false;
        this.addRenderableWidget((GuiEventListener)this.exit);
        List<AbstractOmniGridContainerMenu.TripleInt> spots = AbstractOmniGridContainerMenu.slotPositions(0, this.getCraftingClearButtonX(5) + 5, this.getCraftingClearButtonY(1) + 4, 4, 3, 16);
        for (i = 0; i < 12; ++i) {
            copy = (ResourceLocation[])selections.clone();
            copy[0] = ModUtil.OmniIdentifier("widget/none");
            int btnX = spots.get(i).x();
            int btnY = spots.get(i).y();
            CommandConfigurationButton btn = new CommandConfigurationButton(btnX, btnY, 16, 16, copy, i + 10, c -> this.directionConfiguration((CommandConfigurationButton)((Object)c)), 0, 0, this, ButtonCategory.TARGET);
            if (i >= 8) {
                btn.requiresBooster = true;
            }
            this.transferOptions.add(btn);
            this.blockTargetButtons.add(btn);
            btn.setRequiredCore(CoreTypes.REMOTE);
            this.targetOption.add(btn);
            btn.active = false;
            this.addRenderableWidget((GuiEventListener)btn);
        }
        for (i = 0; i < 9; ++i) {
            this.hoverOverlay[i] = ModUtil.OmniIdentifier("widget/transfer" + i);
        }
        this.setClearToNetworkButtonActive(((AbstractOmniGridContainerMenu)this.getMenu()).isActive());
        ((AbstractOmniGridContainerMenu)this.getMenu()).setActivenessListener(this::setClearToNetworkButtonActive);
        for (Slot s : ((AbstractOmniGridContainerMenu)this.getMenu()).slots) {
            if (!(s instanceof OmniDataFilterSlot)) continue;
            OmniDataFilterSlot slot = (OmniDataFilterSlot)s;
            slot.dirty = true;
        }
        ((AbstractOmniGridContainerMenu)this.getMenu()).dirtyEnergy = true;
        this.closeConfig();
    }

    public void setButtonItems() {
        AbstractContainerMenu abstractContainerMenu = this.getMenu();
        if (!(abstractContainerMenu instanceof OmniGridBlockContainerMenu)) {
            return;
        }
        OmniGridBlockContainerMenu bm = (OmniGridBlockContainerMenu)abstractContainerMenu;
        if (bm.blockPos == null) {
            BlockHitResult hit = ClientModInitializer.getLookedAtBlock(((AbstractOmniGridContainerMenu)this.getMenu()).gridPlayer, ((AbstractOmniGridContainerMenu)this.getMenu()).gridPlayer.level(), 8.0);
            if (((AbstractOmniGridContainerMenu)this.getMenu()).gridPlayer.level().getBlockState(hit.getBlockPos()).getBlock() instanceof OmniGridBlock) {
                bm.blockPos = hit.getBlockPos();
            }
        }
        if (bm.blockPos == null) {
            return;
        }
        List<ItemStack> blocks = OmniGridScreen.getSurroundingBlocksAsItems((Level)Minecraft.getInstance().level, bm.blockPos);
        if (blocks.size() != this.directional.size()) {
            return;
        }
        for (int i = 0; i < this.directional.size(); ++i) {
            this.directional.get((int)i).ghost = blocks.get(i);
        }
    }

    private void closeConfig() {
        this.updateTransferButtons(false);
        this.selected = null;
        this.handleTabClick(0);
        this.screenConfig = 0;
        ((AbstractOmniGridContainerMenu)this.menu).tabPage = 0;
    }

    private void invertConfig(CommandConfigurationButton button) {
        this.getCommand().setInverted(button.getValue() == 1);
        this.updateCommandSlot();
    }

    private void directionConfiguration(CommandConfigurationButton button) {
        if (button.getDataIndex() == 2) {
            this.getCommand().setTarget(3);
            button.setValue(1);
            short action = this.getCommand().getTargetConfig();
            action = button.rightClick ? (short)((action - 1 + 7) % 7) : (short)((action + 1) % 7);
            this.getCommand().setTargetConfig(action);
        } else if (button.getValue() == 0) {
            this.getCommand().setTarget(0);
        } else {
            this.getCommand().setTarget(button.getDataIndex() + 1);
        }
        for (CommandConfigurationButton btn : this.targetOption) {
            if (button.getDataIndex() == btn.getDataIndex()) continue;
            btn.setValue(0);
        }
        this.updateCommandSlot();
    }

    private void remoteModeConfiguration(CommandConfigurationButton button) {
        this.getCommand().setLinked(button.getValue() == 1);
        this.updateCommandSlot();
    }

    private void actionConfig(CommandConfigurationButton button) {
        boolean disable = false;
        if (button.getDataIndex() == 7) {
            this.getCommand().setAction(8);
            button.setValue(1);
            action = this.getCommand().getTargetConfig();
            max = 8;
            action = button.rightClick ? (short)((action - 1 + max) % max) : (short)((action + 1) % max);
            this.getCommand().setTargetConfig(action);
        } else if (button.getDataIndex() == 9) {
            this.getCommand().setAction(10);
            button.setValue(1);
            action = this.getCommand().getTargetConfig();
            max = 4;
            action = button.rightClick ? (short)((action - 1 + max) % max) : (short)((action + 1) % max);
            this.getCommand().setTargetConfig(action);
        } else if (button.getValue() == 0) {
            this.getCommand().setAction(0);
        } else {
            this.getCommand().setAction(button.getDataIndex() + 1);
        }
        for (CommandConfigurationButton btn : this.actionButtons) {
            if (button.getDataIndex() == btn.getDataIndex()) continue;
            btn.setValue(0);
        }
        this.disableButtons(button);
        this.updateCommandSlot();
    }

    public void disableButtons(CommandConfigurationButton button) {
        for (CommandConfigurationButton btn : this.targetOption) {
            btn.setDisabled(false);
        }
        if (button.getValue() != 0 && button.getDataIndex() < 9) {
            boolean noDirection;
            boolean noPlayer;
            boolean bl = noPlayer = button.getDataIndex() == 0 || button.getDataIndex() == 4 || button.getDataIndex() == 6 || button.getDataIndex() == 5;
            if (noPlayer) {
                this.targetOption.get(0).setDisabled(true);
                this.targetOption.get(2).setDisabled(true);
            }
            boolean bl2 = noDirection = button.getDataIndex() == 2 || button.getDataIndex() == 7;
            if (noDirection) {
                for (CommandConfigurationButton btn : this.targetOption) {
                    btn.setDisabled(true);
                }
            }
            boolean remote = button.getDataIndex() == 1 || button.getDataIndex() == 3 || button.getDataIndex() == 6 || button.getDataIndex() == 8;
            this.linkButton.setDisabled(!remote);
            for (CommandConfigurationButton btn : this.blockTargetButtons) {
                btn.setDisabled(!remote);
            }
        }
    }

    public void addSideButton(AbstractSideButtonWidget button) {
        button.setY(this.topPos + this.yOff);
        if (this.sideways) {
            this.yOff += button.getHeight() + 2;
            button.setX(this.getSideButtonX());
        } else {
            button.setX(this.getSideButtonX() - button.getHeight() - 2);
        }
        this.sideways = !this.sideways;
        this.addRenderableWidget((GuiEventListener)button);
    }

    protected int getSideButtonX() {
        return this.leftPos - 18 - 2 - 20;
    }

    protected int getSideButtonY() {
        return super.getSideButtonY() + 66;
    }

    public void typeConfig() {
        this.getCommand().setMode(this.filterIndex);
        this.updateCommandSlot();
    }

    public void updateCommandSlot() {
        OmniResourceSlot omniResourceSlot = this.selected;
        if (omniResourceSlot instanceof OmniResourceSlot) {
            OmniResourceSlot slot = omniResourceSlot;
            ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().commands[slot.getDataIndex()] = this.getCommand();
            ((AbstractOmniGridContainerMenu)this.getMenu()).syncSlot(slot.getDataIndex());
        }
    }

    public static void drawHorizontalBar(GuiGraphics gui, ResourceLocation fill, int x, int y, int width, int height, float progress) {
        int fillWidth = (int)((progress = Mth.clamp((float)progress, (float)0.0f, (float)1.0f)) * (float)width);
        if (fillWidth <= 0) {
            return;
        }
        gui.blitSprite(fill, x, y, fillWidth, height);
    }

    private int getClearButtonX(int i) {
        return this.leftPos + 81 + 9 * i;
    }

    private int getTransferX(int i) {
        return this.leftPos + 57 + 14 * (i + 2);
    }

    private int getTransferY(int i) {
        return this.topPos + this.imageHeight - this.bottomHeight + 14 * i;
    }

    private int getCraftingClearButtonX(int i) {
        return this.leftPos + 2 + 18 * i;
    }

    private int getCraftingClearButtonY(int i) {
        return this.topPos + this.imageHeight - this.bottomHeight - 10 + 18 * i;
    }

    private void setClearToNetworkButtonActive(boolean active) {
        if (this.clearToNetworkButton == null) {
            return;
        }
        this.clearToNetworkButton.active = ((AbstractOmniGridContainerMenu)this.menu).tabPage == 0;
        this.depositButton.active = this.clearToNetworkButton.active;
        this.spreadButton.active = this.clearToNetworkButton.active;
        this.withdrawButton.active = this.clearToNetworkButton.active;
        this.bruteForceButton.active = this.clearToNetworkButton.active;
    }

    @Nullable
    private KeyMapping getClearButtonKeyMapping(boolean toPlayerInventory) {
        return toPlayerInventory ? this.wrapUnbound(KeyMappings.INSTANCE.getClearCraftingGridMatrixToInventory()) : this.wrapUnbound(KeyMappings.INSTANCE.getClearCraftingGridMatrixToNetwork());
    }

    @Nullable
    private KeyMapping wrapUnbound(@Nullable KeyMapping keyMapping) {
        return keyMapping == null || keyMapping.isUnbound() ? null : keyMapping;
    }

    private HoveredImageButton createClearButton(int x, int y, boolean toPlayerInventory) {
        MutableComponent text = IdentifierUtil.createTranslation((String)"gui", (String)("crafting_grid.move." + (toPlayerInventory ? "inventory" : "network")));
        KeyMapping keyMapping = this.getClearButtonKeyMapping(toPlayerInventory);
        if (keyMapping != null) {
            text.append("\n").append((Component)keyMapping.getTranslatedKeyMessage().copy().withStyle(ChatFormatting.GRAY));
        }
        WidgetSprites widgetSprites = toPlayerInventory ? CLEAR_BUTTON_TO_PLAYER_INVENTORY_SPRITES : CLEAR_BUTTON_TO_NETWORK_SPRITES;
        HoveredImageButton button = new HoveredImageButton(x, y, 14, 14, widgetSprites, b -> ((AbstractOmniGridContainerMenu)this.getMenu()).clearClient(toPlayerInventory), (Component)text, this, 1);
        button.setTooltip(Tooltip.create((Component)text));
        return button;
    }

    private HoveredImageButton createSpreadButton(int x, int y) {
        MutableComponent text = MutableComponent.create((ComponentContents)new TranslatableContents("Spread items", "Balance crafting items \n\nShift to spread", TranslatableContents.NO_ARGS));
        WidgetSprites widgetSprites = SPREAD_SPRITES;
        HoveredImageButton button = new HoveredImageButton(x, y, 14, 14, widgetSprites, b -> ((AbstractOmniGridContainerMenu)this.getMenu()).spreadPacket(AbstractGridScreen.hasShiftDown()), (Component)text, this, 1);
        button.setTooltip(Tooltip.create((Component)text));
        return button;
    }

    private HoveredImageButton createDepositButton(int x, int y) {
        MutableComponent text = MutableComponent.create((ComponentContents)new TranslatableContents("", "", TranslatableContents.NO_ARGS));
        WidgetSprites widgetSprites = DEPOSIT_SPRITES;
        HoveredImageButton button = new HoveredImageButton(x, y, 10, 10, widgetSprites, b -> ((AbstractOmniGridContainerMenu)this.getMenu()).depositPacket(true, this.GetCarried()), (Component)Component.empty(), this, 0);
        button.setTooltip(Tooltip.create((Component)text));
        return button;
    }

    public static List<ItemStack> getSurroundingBlocksAsItems(Level level, BlockPos centerPos) {
        if (level == null || centerPos == null || !level.hasChunkAt(centerPos)) {
            return List.of();
        }
        BlockState state = level.getBlockState(centerPos);
        Direction facing = Direction.NORTH;
        if (state.hasProperty((Property)BiDirectionType.INSTANCE.getProperty())) {
            facing = ((BiDirection)state.getValue((Property)BiDirectionType.INSTANCE.getProperty())).asDirection();
        }
        Direction left = facing.getCounterClockWise();
        Direction right = facing.getClockWise();
        Direction back = facing.getOpposite();
        List<BlockPos> positions = List.of(centerPos.above(), centerPos.relative(right), centerPos.relative(facing), centerPos.relative(left), centerPos.below(), centerPos.relative(back));
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(6);
        for (BlockPos pos : positions) {
            if (!level.hasChunkAt(pos)) {
                result.add(ItemStack.EMPTY);
                continue;
            }
            Item item = level.getBlockState(pos).getBlock().asItem();
            result.add(item == net.minecraft.world.item.Items.AIR ? ItemStack.EMPTY : new ItemStack((ItemLike)item));
        }
        return result;
    }

    public void toggleBruteForce() {
        Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new DisableCommandPacket(17));
    }

    private HoveredImageButton createBruteForceButton(int x, int y) {
        WidgetSprites widgetSprites = BRUTEFORCE_SPRITES;
        HoveredImageButton button = new HoveredImageButton(x, y, 12, 12, widgetSprites, b -> this.toggleBruteForce(), (Component)Component.empty(), this, 0);
        button.type = 3;
        return button;
    }

    private HoveredImageButton createWithdrawButton(int x, int y) {
        WidgetSprites widgetSprites = WITHDRAW_SPRITES;
        HoveredImageButton button = new HoveredImageButton(x, y, 10, 10, widgetSprites, b -> ((AbstractOmniGridContainerMenu)this.getMenu()).depositPacket(false, this.GetCarried()), (Component)Component.empty(), this, 0);
        return button;
    }

    public void handleTabClick(int index) {
        boolean transferChanged;
        this.setButtonItems();
        boolean tabChanged = ((AbstractOmniGridContainerMenu)this.menu).tabPage != index;
        boolean bl = transferChanged = this.lastSentTransferPanel != this.transferPanel;
        if (((AbstractOmniGridContainerMenu)this.menu).tabPage == 2 || index == 2) {
            ((AbstractOmniGridContainerMenu)this.menu).utilityCacheDirty = true;
        }
        ((AbstractOmniGridContainerMenu)this.menu).tabPage = index;
        if (this.transferPanel) {
            this.buttonCategory = ButtonCategory.values()[index];
            if (this.buttonCategory == ButtonCategory.FILTER && this.selected != null) {
                this.filterIndex = ((AbstractOmniGridContainerMenu)this.menu).getDataClient().commands[this.selected.getDataIndex()].getMode();
            }
        }
        if (tabChanged || transferChanged) {
            this.lastSentTab = index;
            this.lastSentTransferPanel = this.transferPanel;
            Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new SyncTabPacket(index, this.transferPanel));
        }
        this.toggleSlots();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int guiX = this.leftPos + ((AbstractOmniGridContainerMenu)this.getMenu()).result.x;
        int guiY = this.topPos + ((AbstractOmniGridContainerMenu)this.getMenu()).result.y;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.hoveredButton = null;
        for (CommandConfigurationButton button : this.transferOptions) {
            if (!button.isMouseOver(mouseX, mouseY) || button.category != this.buttonCategory) continue;
            this.hoveredButton = button;
            break;
        }
    }

    public List<Component> addBlockTargetData(OmniCommand command, List<Component> tooltipList) {
        int blockIdx = command.getTarget() - 11;
        OmniBlockTarget bt = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().getBlockTarget(blockIdx);
        if (bt != null) {
            if (command.isLinked()) {
                tooltipList.add((Component)Component.literal((String)"Connected to"));
            }
            tooltipList.add((Component)Component.literal((String)"Target Block: ").append((Component)Component.translatable((String)bt.getTarget().getDescriptionId())).withStyle(ChatFormatting.GREEN));
            tooltipList.add((Component)Component.literal((String)("Position: " + bt.getPosition().toShortString())).withStyle(ChatFormatting.YELLOW));
            tooltipList.add((Component)Component.literal((String)("Face: " + bt.getDirection().toString())).withStyle(ChatFormatting.AQUA));
        } else {
            tooltipList.add((Component)Component.literal((String)"Target Block: (no target)").withStyle(ChatFormatting.RED));
        }
        tooltipList.add((Component)Component.literal((String)""));
        return tooltipList;
    }

    public List<Component> getConfigTooltip(OmniResourceSlot slot) {
        OmniCommand command = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().commands[slot.getDataIndex()];
        PlatformResourceKey current = slot.getResource();
        int typeIndex = command.getMode();
        List<Component> tooltipList = new ArrayList<Component>();
        if (((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().disabledCommands[slot.getDataIndex()]) {
            tooltipList.add((Component)Component.literal((String)"(Disabled)").withStyle(ChatFormatting.GRAY));
            tooltipList.add((Component)Component.literal((String)""));
        }
        String action = actionNames[Math.min(command.getAction(), actionNames.length - 1)];
        String target = faceNames[Math.min(command.getTarget(), faceNames.length - 1)];
        boolean isBlockTarget = false;
        if (command.getTarget() >= 11 && command.getTarget() <= 18) {
            int blockTargetIndex = command.getTarget() - 11;
            OmniBlockTarget blockTarget = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().getBlockTarget(blockTargetIndex);
            isBlockTarget = true;
            if (blockTarget != null) {
                tooltipList = this.addBlockTargetData(command, tooltipList);
            } else {
                tooltipList.add((Component)Component.literal((String)"No target").withStyle(ChatFormatting.RED));
            }
        }
        Object itemToTransfer = "Anything";
        if (current != null) {
            ItemResource res;
            itemToTransfer = current.getResourceType().getTitle().getString();
            if (current instanceof ItemResource) {
                res = (ItemResource)current;
                itemToTransfer = res.toItemStack().getHoverName().getString();
            }
            if (typeIndex == 0) {
                itemToTransfer = "(Precise) " + (String)itemToTransfer;
            } else if (typeIndex == 1) {
                itemToTransfer = "(Fuzzy) " + (String)itemToTransfer;
            } else if (typeIndex == 2 && current instanceof ItemResource) {
                res = (ItemResource)current;
                ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)res.item());
                itemToTransfer = "Mod: " + id.getNamespace();
            } else if (typeIndex >= 3 && current instanceof ItemResource) {
                ItemResource res2 = (ItemResource)current;
                List<String> descriptors = OmniGridScreen.getDescriptorsAsStringList(res2.toItemStack());
                Object object = itemToTransfer = typeIndex >= 0 && typeIndex < descriptors.size() ? descriptors.get(typeIndex) : "None";
            }
            if (command.isInverted()) {
                itemToTransfer = "(Inverted) " + (String)itemToTransfer;
            }
        }
        tooltipList.add((Component)Component.literal((String)action).withStyle(ChatFormatting.RED));
        if (command.getAction() == 8 && command.getTargetConfig() < basicCraftOptions.length) {
            tooltipList.add((Component)Component.literal((String)basicCraftOptions[command.getTargetConfig()]).withStyle(ChatFormatting.WHITE));
        }
        if (command.getAction() == 10 && command.getTargetConfig() < autoLootOptions.length) {
            tooltipList.add((Component)Component.literal((String)"").withStyle(ChatFormatting.YELLOW));
            tooltipList.add((Component)Component.literal((String)autoLootOptions[command.getTargetConfig()]).withStyle(ChatFormatting.WHITE));
            if (this.transferPanel) {
                tooltipList.add((Component)Component.literal((String)"Click to change loot notification ").withStyle(ChatFormatting.GRAY));
            }
        }
        if (!isBlockTarget) {
            tooltipList.add((Component)Component.literal((String)target).withStyle(ChatFormatting.YELLOW));
        }
        tooltipList.add((Component)Component.literal((String)itemToTransfer).withStyle(ChatFormatting.BLUE));
        String actionDescriptions = actionDescription[Math.min(command.getAction(), actionDescription.length - 1)];
        String mode = typeTooltipDesciption[Math.min(command.getMode(), typeTooltipDesciption.length - 1)];
        String targetface = faceNames[Math.min(command.getTarget(), faceNames.length - 1)];
        if (this.hoveredButton != null) {
            switch (this.hoveredButton.getIdentifier()) {
                case 0: {
                    short picked;
                    if (isBlockTarget) break;
                    if (command.getTarget() == 3) {
                        picked = this.getCommand().getTargetConfig();
                        picked = (short)Math.min(playerOptions.length - 1, picked);
                        tooltipList.add((Component)Component.literal((String)"Currently targeting: ").append((Component)Component.literal((String)playerOptions[picked]).withStyle(ChatFormatting.AQUA)));
                        tooltipList.add((Component)Component.literal((String)"of the player carrying this Omni Grid"));
                        tooltipList.add((Component)Component.literal((String)"(Item form only)").withStyle(ChatFormatting.YELLOW));
                        tooltipList.add((Component)Component.literal((String)""));
                        tooltipList.add((Component)Component.literal((String)"\u00a77Click again to change targeted inventory"));
                        break;
                    }
                    tooltipList.add((Component)Component.literal((String)("Omni Grid's " + targetface + " face")));
                    tooltipList.add((Component)Component.literal((String)"Block form only").withStyle(ChatFormatting.YELLOW));
                    break;
                }
                case 1: {
                    short picked;
                    tooltipList.add((Component)Component.literal((String)actionDescriptions));
                    if (command.getAction() == 6) {
                        tooltipList.add((Component)Component.literal((String)""));
                        tooltipList.add((Component)Component.literal((String)"Can only take from containers").withStyle(ChatFormatting.YELLOW));
                        if (((AbstractOmniGridContainerMenu)this.getMenu()).isBlock()) {
                            tooltipList.add((Component)Component.literal((String)"the player who placed this Omni Grid").withStyle(ChatFormatting.YELLOW));
                        } else {
                            tooltipList.add((Component)Component.literal((String)"the player holding this Omni Grid").withStyle(ChatFormatting.YELLOW));
                        }
                        tooltipList.add((Component)Component.literal((String)"is allowed to take from").withStyle(ChatFormatting.YELLOW));
                    }
                    if (command.getAction() == 8) {
                        picked = this.getCommand().getTargetConfig();
                        tooltipList.add((Component)Component.literal((String)"Craft: ").append((Component)Component.literal((String)basicCraftOptions[picked]).withStyle(ChatFormatting.AQUA)));
                        tooltipList.add((Component)Component.literal((String)""));
                        tooltipList.add((Component)Component.literal((String)basicCraftOptionDescriptions[picked]).withStyle(ChatFormatting.YELLOW));
                        if (!(picked != 5 && picked != 6 || ((AbstractOmniGridContainerMenu)this.menu).getDataClient().isCoreInstalled(CoreTypes.AUTOCRAFTING))) {
                            tooltipList.add((Component)Component.literal((String)""));
                            tooltipList.add((Component)Component.literal((String)"Autocrafting Core required").withStyle(ChatFormatting.RED));
                        }
                        if (picked == 7 && !((AbstractOmniGridContainerMenu)this.menu).getDataClient().isCoreInstalled(CoreTypes.FURNACE)) {
                            tooltipList.add((Component)Component.literal((String)""));
                            tooltipList.add((Component)Component.literal((String)"Furnace Core required").withStyle(ChatFormatting.RED));
                        }
                        tooltipList.add((Component)Component.literal((String)""));
                        tooltipList.add((Component)Component.literal((String)"Click again to change crafting format").withStyle(ChatFormatting.GRAY));
                    }
                    if (command.getAction() < 9 || command.getAction() > 15) break;
                    break;
                }
                case 2: {
                    if (((String)itemToTransfer).contains("Component")) {
                        tooltipList.add((Component)Component.literal((String)"Any item with this component"));
                        break;
                    }
                    if (((String)itemToTransfer).contains("Enchantment")) {
                        tooltipList.add((Component)Component.literal((String)"Any item with this enchantment"));
                        break;
                    }
                    if (((String)itemToTransfer).contains("Keyword:")) {
                        tooltipList.add((Component)Component.literal((String)"Any item with this word in it's ID"));
                        break;
                    }
                    tooltipList.add((Component)Component.literal((String)mode));
                }
            }
            if (this.hoveredButton.isDisabled() && this.hoveredButton.getIdentifier() != 1) {
                tooltipList.add((Component)Component.literal((String)""));
                tooltipList.add((Component)Component.literal((String)"Incompatible with current action").withStyle(ChatFormatting.RED));
            }
        }
        if (this.blockTargetButtons.contains((Object)this.hoveredButton)) {
            tooltipList.add((Component)Component.literal((String)""));
            int rUp = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().getUpgrades()[2];
            if (((AbstractOmniGridContainerMenu)this.menu).isUtilityInstalled(UtilityType.REMOTE_BOOSTER)) {
                rUp += 2;
            }
            int range = 6 + rUp * 6;
            BlockPos origin = ((AbstractOmniGridContainerMenu)this.getMenu()).blockEntityPosition;
            int blockTargetIndex = command.getTarget() - 11;
            OmniBlockTarget targetb = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().getBlockTarget(blockTargetIndex);
            if (targetb != null && origin != null) {
                double maxRangeSqr;
                BlockPos targetPos = targetb.getPosition();
                double distSqr = origin.distSqr((Vec3i)targetPos);
                ChatFormatting color = distSqr > (maxRangeSqr = (double)range * (double)range) ? ChatFormatting.RED : ChatFormatting.GREEN;
                tooltipList.add((Component)Component.literal((String)("Range: " + range + " blocks")).withStyle(color));
            } else {
                tooltipList.add((Component)Component.literal((String)("Range: " + range + " blocks")).withStyle(ChatFormatting.GRAY));
            }
        } else if (action.equals("Search") || action.equals("Collect")) {
            int range = 2 + ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().getUpgrades()[2] * 2;
            tooltipList.add((Component)Component.literal((String)("Range: " + range + " blocks")).withStyle(ChatFormatting.GRAY));
        }
        String extra = CommandValidator.VerifyCommand(command.getAction(), command.getTarget(), current);
        if (!extra.isEmpty()) {
            tooltipList.add((Component)Component.literal((String)"").withStyle(ChatFormatting.GRAY));
            tooltipList.add((Component)Component.literal((String)extra).withStyle(ChatFormatting.RED));
        }
        return tooltipList;
    }

    public static List<String> getDescriptorsAsStringList(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return List.of();
        }
        List<String> cached = DESCRIPTOR_CACHE.get(stack);
        if (cached != null) {
            return cached;
        }
        ArrayList<CallSite> descriptors = new ArrayList<CallSite>();
        descriptors.add((CallSite)((Object)("Exact Item: " + stack.getHoverName().getString())));
        descriptors.add((CallSite)((Object)("Item Ignoring Components: " + stack.getHoverName().getString())));
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        descriptors.add((CallSite)((Object)("Mod: " + id.getNamespace())));
        for (String tag : TransferUtils.getItemTagsAsStringList(stack)) {
            descriptors.add((CallSite)((Object)("Tag: " + tag)));
        }
        for (String comp : TransferUtils.getItemComponentsAsStringList(stack)) {
            descriptors.add((CallSite)((Object)("Component: " + comp)));
        }
        for (String word : TransferUtils.getItemIdWordsNoNamespace(stack)) {
            descriptors.add((CallSite)((Object)("Keyword: " + word)));
        }
        List<String> result = List.copyOf(descriptors);
        DESCRIPTOR_CACHE.put(stack, result);
        return result;
    }

    protected void addResourceSlotTooltips(ResourceSlot slot, List<ClientTooltipComponent> tooltip) {
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        ToggleableQuickCraftingSlot tqs;
        Slot slot = this.hoveredSlot;
        if (slot instanceof ToggleableQuickCraftingSlot && (tqs = (ToggleableQuickCraftingSlot)slot).isActive() && tqs.hasItem()) {
            return true;
        }
        slot = this.hoveredSlot;
        if (slot instanceof OmniFurnaceSlot) {
            OmniFurnaceSlot ofs = (OmniFurnaceSlot)slot;
            if (ofs.smelting && ofs.isValid() && ofs.getResource() != null) {
                long count = ofs.getAmount();
                long delta = (long)deltaY;
                if (OmniGridScreen.hasShiftDown()) {
                    delta *= 64L;
                }
                ofs.changeAmountOnClient(count += delta);
            }
        }
        if (this.actionConfigNumber != null && this.actionConfigNumber.isVisible() && this.actionConfigNumber.isHovered()) {
            int current = this.actionConfigNumber.getNumber();
            if (current == -1) {
                current = 0;
            }
            int step = OmniGridScreen.hasShiftDown() ? 10 : 1;
            int newValue = current + (deltaY > 0.0 ? step : -step);
            this.actionConfigNumber.setNumber(newValue);
            this.updateCommandSlot();
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    @Override
    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        int y;
        int x;
        Object tms;
        if (slot instanceof ToggleableQuickCraftingSlot && (tms = (ToggleableQuickCraftingSlot)slot).isValid() && tms.hasItem()) {
            x = slot.x;
            y = slot.y;
            guiGraphics.blitSprite(ModUtil.OmniIdentifier("widget/emptyslot"), x - 1, y - 1, 18, 18);
        }
        if (slot instanceof ToggleableMonitoredResourceSlot) {
            tms = (ToggleableMonitoredResourceSlot)slot;
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            x = slot.x;
            y = slot.y;
            if (!((AbstractOmniGridContainerMenu)this.menu).getDataClient().isCoreInstalled(CoreTypes.MONITOR)) {
                guiGraphics.blitSprite(ModUtil.OmniIdentifier("widget/locked_icon"), x - 1, y - 1, 18, 18);
                guiGraphics.pose().popPose();
                return;
            }
            if (tms.getResource() == null) {
                guiGraphics.pose().popPose();
                return;
            }
            RefinedStorageClientApi.INSTANCE.getResourceRendering(tms.getResource().getClass()).render((ResourceKey)tms.getResource(), guiGraphics, slot.x, slot.y - 1);
            super.renderSlot(guiGraphics, slot);
            guiGraphics.pose().popPose();
            return;
        }
        if (slot instanceof MarkedContainerFilterSlot) {
            MarkedContainerFilterSlot marked = (MarkedContainerFilterSlot)slot;
            if (marked.screen == null) {
                marked.screen = this;
            }
            if (!this.transferPanel || ((AbstractOmniGridContainerMenu)this.menu).tabPage != 1) {
                return;
            }
            guiGraphics.blitSprite(ModUtil.OmniIdentifier("marked_container"), slot.x, slot.y, 18, 18);
        }
        if ((slot.container instanceof CraftingContainer || slot instanceof CraftingGridResultSlot || slot instanceof OmniResourceSlot) && this.transferPanel) {
            return;
        }
        if (slot instanceof CraftingGridResultSlot && ((AbstractOmniGridContainerMenu)this.menu).tabPage != 0) {
            return;
        }
        if (slot instanceof OmniResourceSlot && ((AbstractOmniGridContainerMenu)this.menu).tabPage == 2) {
            return;
        }
        if (slot instanceof OmniResourceSlot) {
            ResourceLocation s;
            int index;
            OmniResourceSlot cmdSlot = (OmniResourceSlot)slot;
            OmniCommand command = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().commands[cmdSlot.getDataIndex()];
            if (command.getAction() > 15) {
                command.setAction(0);
            }
            boolean skip = false;
            if (!command.hasResource()) {
                if (command.getAction() > 0) {
                    index = command.getAction() - 1;
                    if (index >= this.actionButtons.size()) {
                        index = this.actionButtons.size() - 1;
                    }
                    s = this.actionButtons.get(index).getSprites()[0];
                    this.renderScaledOverlay(guiGraphics, s, slot.x - 2, slot.y - 2, 1.0f, 18);
                    skip = true;
                }
            } else {
                RefinedStorageClientApi.INSTANCE.getResourceRendering(command.getResource().getClass()).render((ResourceKey)command.getResource(), guiGraphics, slot.x, slot.y);
                if (cmdSlot.getResource() == null) {
                    cmdSlot.setFilter(command.getResource());
                }
            }
            if (command.getAction() > 0 && !skip) {
                index = command.getAction() - 1;
                if (index >= this.actionButtons.size()) {
                    index = this.actionButtons.size() - 1;
                }
                s = this.actionButtons.get(index).getSprites()[0];
                this.renderScaledOverlay(guiGraphics, s, slot.x - 1, slot.y + 7, 0.5f, 18);
            }
            if (command.getTarget() > 0) {
                int bgX = slot.x + 7;
                int bgY = slot.y + 7;
                int size = 18;
                if (command.getTarget() < 11) {
                    ResourceLocation s2 = this.targetOption.get(command.getTarget() - 1).getSprites()[0];
                    this.renderScaledOverlay(guiGraphics, s2, bgX, bgY, 0.5f, size);
                } else {
                    OmniBlockTarget b = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().blockTargets[command.getTarget() - 11];
                    if (b != null) {
                        int color = ClientModInitializer.getColorForSlot(command.getTarget() - 11, false);
                        guiGraphics.fill(slot.x, slot.y, slot.x + 16, slot.y + 16, color);
                        ItemStack stack = new ItemStack((ItemLike)b.getTarget());
                        this.renderScaledOverlay(guiGraphics, stack, bgX, bgY, 0.5f, size);
                    }
                }
            }
            if (((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().isCommandDisabled(cmdSlot.getDataIndex())) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
                guiGraphics.blitSprite(ModUtil.OmniIdentifier("widget/disabled"), slot.x, slot.y, 16, 16);
                guiGraphics.pose().popPose();
            }
            if (!this.VerifyCommand(cmdSlot.getDataIndex())) {
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 250.0f);
                guiGraphics.blitSprite(IdentifierUtil.createIdentifier((String)"warning"), slot.x + 8, slot.y, 8, 8);
                guiGraphics.pose().popPose();
            }
        }
        super.renderSlot(guiGraphics, slot);
    }

    public boolean VerifyCommand(int index) {
        OmniCommand cmd = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().commands[index];
        return CommandValidator.VerifyCommand(cmd.getAction(), cmd.getTarget(), cmd.getResource()).isEmpty();
    }

    public void renderScaledOverlay(GuiGraphics guiGraphics, Object resource, int x, int y, float scale, int size) {
        ItemStack stack;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 200.0f);
        guiGraphics.pose().scale(scale, scale, 1.0f);
        int bgSize = size + 2;
        int alpha = 0x30000000;
        if (resource instanceof ItemStack && !(stack = (ItemStack)resource).isEmpty()) {
            guiGraphics.renderItem(stack, 1, 1);
        } else if (resource instanceof ResourceLocation) {
            ResourceLocation sprite = (ResourceLocation)resource;
            guiGraphics.blitSprite(sprite, 1, 1, size, size);
        }
        guiGraphics.pose().popPose();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.pose().popPose();
        int var10001 = this.titleLabelX;
        int var10002 = this.titleLabelY;
        int var10003 = this.titleMarquee.getEffectiveWidth(this.font);
        Objects.requireNonNull(this.font);
        boolean hoveringOverTitle = this.isHovering(var10001, var10002, var10003, 9, mouseX, mouseY);
        this.titleMarquee.render(guiGraphics, this.leftPos + this.titleLabelX, this.topPos + this.titleLabelY, this.font, hoveringOverTitle);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
        if (((AbstractOmniGridContainerMenu)this.menu).tabPage > 0 || this.transferPanel) {
            return;
        }
        this.renderPlayerInventoryTitle(guiGraphics);
    }

    public ItemStack GetCarried() {
        ItemStack carried = ((AbstractOmniGridContainerMenu)this.getMenu()).getCarried();
        if (carried.isEmpty()) {
            return new ItemStack((ItemLike)net.minecraft.world.item.Items.BARRIER);
        }
        return carried;
    }

    @Nullable
    public OmniCommand getCommand() {
        if (this.commandIndex != -1) {
            return ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().commands[this.commandIndex];
        }
        return null;
    }

    public static void drawFillBottomToTop(GuiGraphics gg, ResourceLocation sprite, int x, int y, int width, int height, int progress, int maxProgress) {
        if (maxProgress <= 0) {
            return;
        }
        int fill = (int)((double)progress / (double)maxProgress * (double)height);
        if (fill <= 0) {
            return;
        }
        int yStart = y + (height - fill);
        gg.enableScissor(x, yStart, x + width, y + height);
        gg.blitSprite(sprite, x, y, width, height);
        gg.disableScissor();
    }

    public static void renderGhostItem(GuiGraphics gg, ItemStack stack, int x, int y, float alpha) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        gg.renderItem(stack, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private boolean isHoveringFuelBar(int mouseX, int mouseY, int barX, int barY) {
        return mouseX >= barX && mouseX < barX + 70 && mouseY >= barY && mouseY < barY + 4;
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        super.renderBg(graphics, delta, mouseX, mouseY);
        if (this.rateLimiter.tryAcquire() && this.getCommand() != null && this.actionConfigNumber != null && this.lastActionConfig != this.actionConfigNumber.getNumber()) {
            this.lastActionConfig = this.actionConfigNumber.getNumber();
            this.safeSync();
        }
        if (((AbstractOmniGridContainerMenu)this.menu).sortDelayTicks > 0) {
            --((AbstractOmniGridContainerMenu)this.menu).sortDelayTicks;
            if (((AbstractOmniGridContainerMenu)this.menu).sortDelayTicks <= 0) {
                ((AbstractOmniGridContainerMenu)this.menu).getRepository().sort();
            }
        }
        if (this.filteringBasedOnCraftingMatrixItems) {
            this.renderCraftingMatrixFilteringHighlights(graphics);
        }
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (((AbstractOmniGridContainerMenu)this.menu).getDataClient().isCoreInstalled(CoreTypes.DISK_DRIVE)) {
            graphics.blitSprite(DISKSLOT_TEXTURE, x - 23 + 13 - 28, y, 41, 78);
        } else {
            graphics.blitSprite(ModUtil.OmniIdentifier("disk_slot"), x - 23 + 13 - 10, y, 23, 24);
        }
        if (((AbstractOmniGridContainerMenu)this.menu).showCommandSlots()) {
            ToggleableResourceSlot res;
            int index;
            for (index = 0; index < ((AbstractOmniGridContainerMenu)this.getMenu()).getCommandResourceSlots().length; ++index) {
                res = ((AbstractOmniGridContainerMenu)this.getMenu()).getCommandResourceSlots()[index];
                ResourceSlotRendering.render((GuiGraphics)graphics, (ResourceSlot)res, (int)this.leftPos, (int)this.topPos);
            }
            if (((AbstractOmniGridContainerMenu)this.menu).tabPage == 1) {
                for (index = 0; index < ((AbstractOmniGridContainerMenu)this.getMenu()).furnaceSlots.length; ++index) {
                    boolean hasCampfire;
                    res = ((AbstractOmniGridContainerMenu)this.getMenu()).furnaceSlots[index];
                    ResourceSlotRendering.render((GuiGraphics)graphics, (ResourceSlot)res, (int)this.leftPos, (int)this.topPos);
                    if (index != 0) continue;
                    float progress = (float)((AbstractOmniGridContainerMenu)this.menu).containerData.getFuelRemaining() / 25000.0f;
                    if (((AbstractOmniGridContainerMenu)this.menu).isUtilityInstalled(UtilityType.CREATIVE)) {
                        progress = 1.0f;
                    }
                    OmniGridScreen.drawHorizontalBar(graphics, ModUtil.OmniIdentifier("widget/fuel"), this.leftPos + res.x, this.topPos + res.y + 37, 70, 4, progress);
                    OmniGridScreen.drawFillBottomToTop(graphics, ModUtil.OmniIdentifier("widget/arrow"), this.leftPos + res.x + 93, this.topPos + res.y - 3, 14, 16, ((AbstractOmniGridContainerMenu)this.menu).containerData.getProgress(), 20);
                    if (((AbstractOmniGridContainerMenu)this.getMenu()).containerData.getSelectedIndex() == -1) continue;
                    PlatformResourceKey resource = null;
                    if (((AbstractOmniGridContainerMenu)this.getMenu()).containerData.getSelectedIndex() == 8) {
                        resource = ((AbstractOmniGridContainerMenu)this.getMenu()).toggleableResourceSlot.getResource();
                    } else if (((AbstractOmniGridContainerMenu)this.getMenu()).furnaceContainer.get(((AbstractOmniGridContainerMenu)this.getMenu()).containerData.getSelectedIndex()) != null) {
                        resource = ((AbstractOmniGridContainerMenu)this.getMenu()).furnaceContainer.get(((AbstractOmniGridContainerMenu)this.getMenu()).containerData.getSelectedIndex()).resource();
                    }
                    if (resource == null || !(resource instanceof ItemResource)) continue;
                    ItemResource itemResource = (ItemResource)resource;
                    ItemStack inputStack = itemResource.toItemStack();
                    Level level = ((AbstractOmniGridContainerMenu)this.getMenu()).gridPlayer.level();
                    SmeltResult result = OmniFurnaceSlot.getSmeltingResult(level, inputStack);
                    int gx = this.leftPos + res.x + 92;
                    int gy = this.topPos + res.y + 20;
                    OmniGridScreen.renderGhostItem(graphics, result.output(), gx, gy, 1.0f);
                    if (((AbstractOmniGridContainerMenu)this.getMenu()).containerData.getSelectedIndex() == 8) {
                        float scale = 0.6f;
                        int originalSize = 16;
                        int scaledSize = Math.round((float)originalSize * scale);
                        int boxX = gx + 16;
                        int boxY = gy - 16;
                        int adjustedX = boxX + (originalSize - scaledSize) / 2;
                        int adjustedY = boxY + (originalSize - scaledSize) / 2;
                        graphics.fill(adjustedX - 1, adjustedY - 1, adjustedX + scaledSize + 1, adjustedY + scaledSize + 1, -5592406);
                        graphics.fill(adjustedX, adjustedY, adjustedX + scaledSize, adjustedY + scaledSize, -16777216);
                        graphics.pose().pushPose();
                        graphics.pose().translate((float)adjustedX, (float)adjustedY, 100.0f);
                        graphics.pose().scale(scale, scale, 1.0f);
                        OmniGridScreen.renderGhostItem(graphics, itemResource.toItemStack(), 0, 0, 1.0f);
                        graphics.pose().popPose();
                    }
                    boolean isCampfireFood = (hasCampfire = ((AbstractOmniGridContainerMenu)this.getMenu()).isUtilityInstalled(UtilityType.CAMP_FIRE)) && OmniItemProxxy.isCampfireItem(level, inputStack);
                    float scale = 0.6f;
                    float inv = 1.0f / scale;
                    int textX = gx + 8;
                    int textY = gy + 22;
                    if (isCampfireFood) {
                        int iconSize = 8;
                        int iconX = gx;
                        int iconY = textY - 2;
                        graphics.blitSprite(CAMPFIRE_SPRITE, iconX, iconY, 16, 16);
                        continue;
                    }
                    String xpText = String.format("%.2f", Float.valueOf(result.xp()));
                    int color = -16777216;
                    float drawX = (float)textX * inv;
                    float drawY = (float)textY * inv;
                    int textWidth = (int)((float)this.font.width(xpText) * scale);
                    int orbSize = 6;
                    int orbX = textX - textWidth / 2 - orbSize + 4;
                    int orbY = textY;
                    this.renderXPOrb(graphics, orbX, orbY, orbSize);
                    graphics.pose().pushPose();
                    graphics.pose().scale(scale, scale, 1.0f);
                    graphics.drawString(this.font, xpText, drawX, drawY, color, false);
                    graphics.pose().popPose();
                }
            }
        } else if (this.transferPanel) {
            this.actionConfigNumber.render(graphics, mouseX, mouseY, delta);
            this.actionConfigNumber.active = true;
            for (int i = 0; i < this.blockTargetButtons.size(); ++i) {
                CommandConfigurationButton btn = this.blockTargetButtons.get(i);
                if (btn.requiresBooster && !((AbstractOmniGridContainerMenu)this.menu).isUtilityInstalled(UtilityType.REMOTE_BOOSTER)) {
                    return;
                }
                OmniBlockTarget target = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().getBlockTarget(i);
                if (btn.colorslot == -1) {
                    btn.colorslot = i;
                }
                if (this.buttonCategory == ButtonCategory.TARGET) {
                    if (target != null) {
                        ItemStack stack = new ItemStack((ItemLike)target.getTarget());
                        graphics.pose().pushPose();
                        float scale = 0.7f;
                        float centerX = btn.getX() + 6;
                        float centerY = btn.getY() + 6;
                        graphics.pose().translate(centerX, centerY, 0.0f);
                        graphics.pose().scale(scale, scale, 1.0f);
                        graphics.pose().translate(-centerX, -centerY, 0.0f);
                        graphics.renderItem(stack, btn.getX() + 1, btn.getY() + 1);
                        graphics.renderItemDecorations(this.font, stack, btn.getX() + 1, btn.getY() + 1);
                        graphics.pose().popPose();
                    } else {
                        graphics.blitSprite(ModUtil.OmniIdentifier("widget/none"), btn.getX(), btn.getY(), btn.getWidth(), btn.getHeight());
                    }
                }
                graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            Item btn = ((AbstractOmniGridContainerMenu)this.getMenu()).getCarried().getItem();
            if (btn instanceof CoreItem) {
                ToggleableCoreSlot slot;
                CoreItem item = (CoreItem)btn;
                if (((AbstractOmniGridContainerMenu)this.menu).tabPage == 3 && item.getCoreType().getId() < 20 && (slot = ((AbstractOmniGridContainerMenu)this.getMenu()).coreSlots[item.getCoreType().getId()]) != null) {
                    ItemStack stack = new ItemStack((ItemLike)item);
                    graphics.pose().pushPose();
                    int xx = this.leftPos + slot.x;
                    int yy = this.topPos + slot.y;
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    graphics.renderItem(stack, xx, yy);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.disableBlend();
                    graphics.pose().popPose();
                }
            }
        }
        if (((AbstractOmniGridContainerMenu)this.getMenu()).closeConfig) {
            this.closeConfig();
            ((AbstractOmniGridContainerMenu)this.getMenu()).closeConfig = false;
        }
        if (((AbstractOmniGridContainerMenu)this.getMenu()).dirtyEnergy) {
            this.updateEnergyWidget();
            ((AbstractOmniGridContainerMenu)this.getMenu()).dirtyEnergy = false;
        }
    }

    private void renderXPOrb(GuiGraphics graphics, int x, int y, int size) {
        graphics.blitSprite(XP_ORB_SPRITE, x, y, size, size);
    }

    private void renderCraftingMatrixFilteringHighlights(GuiGraphics graphics) {
        for (Slot slot : ((AbstractOmniGridContainerMenu)this.getMenu()).getCraftingMatrixSlots()) {
            if (!slot.hasItem()) continue;
            graphics.blitSprite(CRAFTING_MATRIX_FILTERING_SLOT_HIGHLIGHT, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 18, 18);
        }
    }

    @Override
    protected void containerTick() {
        AbstractOmniGridContainerMenu menu;
        boolean mayFilterOnCraftingMatrixItems;
        super.containerTick();
        boolean bl = mayFilterOnCraftingMatrixItems = this.hoveredSlot != null && this.hoveredSlot.container instanceof ResultContainer && OmniGridScreen.hasShiftDown() && OmniGridScreen.hasControlDown();
        if (mayFilterOnCraftingMatrixItems && !this.filteringBasedOnCraftingMatrixItems) {
            this.filteringBasedOnCraftingMatrixItems = true;
            ((AbstractOmniGridContainerMenu)this.getMenu()).filterBasedOnCraftingMatrixItems();
            if (this.searchField != null) {
                this.searchField.setEditable(false);
            }
        } else if (!mayFilterOnCraftingMatrixItems && this.filteringBasedOnCraftingMatrixItems) {
            ((AbstractOmniGridContainerMenu)this.getMenu()).stopFilteringBasedOnCraftingMatrixItems();
            this.filteringBasedOnCraftingMatrixItems = false;
            if (this.searchField != null) {
                this.searchField.setEditable(true);
            }
        }
        if ((menu = (AbstractOmniGridContainerMenu)this.getMenu()) == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        this.rapidExtraction();
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (KeyMappings.INSTANCE.getClearCraftingGridMatrixToInventory() != null && Platform.INSTANCE.isKeyDown(KeyMappings.INSTANCE.getClearCraftingGridMatrixToInventory())) {
            ((AbstractOmniGridContainerMenu)this.getMenu()).clear(true);
        } else if (KeyMappings.INSTANCE.getClearCraftingGridMatrixToNetwork() != null && Platform.INSTANCE.isKeyDown(KeyMappings.INSTANCE.getClearCraftingGridMatrixToNetwork())) {
            ((AbstractOmniGridContainerMenu)this.getMenu()).clear(false);
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    protected void renderStretchingBackground(GuiGraphics graphics, int x, int y, int rows) {
        for (int row = 0; row < rows; ++row) {
            int textureY = 37;
            if (row == 0) {
                textureY = 19;
            } else if (row == rows - 1) {
                textureY = 55;
            }
            graphics.blit(this.getTexture(), x, y + 18 * row, 0, textureY, this.imageWidth, 18);
        }
    }

    protected ResourceLocation getTexture() {
        if (this.transferPanel) {
            return ModUtil.OmniIdentifier("textures/gui/omni_grid_transfer.png");
        }
        if (((AbstractOmniGridContainerMenu)this.menu).tabPage == 2) {
            return ModUtil.OmniIdentifier("textures/gui/omni_grid_crafter.png");
        }
        if (((AbstractOmniGridContainerMenu)this.menu).tabPage == 1) {
            return ModUtil.OmniIdentifier("textures/gui/omni_furnace.png");
        }
        if (((AbstractOmniGridContainerMenu)this.menu).tabPage == 3) {
            return ModUtil.OmniIdentifier("textures/gui/omni_core_panel.png");
        }
        return OMNI_GRID_GUI;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        PatternItem patternItem;
        Optional pattern;
        Item item;
        if (this.exit != null && this.exit.active && this.exit.isMouseOver(mouseX, mouseY)) {
            this.exit.onPress();
            return true;
        }
        if (((AbstractOmniGridContainerMenu)this.menu).tabPage == 0 && this.hoveredSlot instanceof ToggleableUtilitySlot && ((AbstractOmniGridContainerMenu)this.getMenu()).gridPlayer.isShiftKeyDown() && (item = this.hoveredSlot.getItem().getItem()) instanceof PatternItem && (pattern = (patternItem = (PatternItem)item).getPattern(this.hoveredSlot.getItem(), ((AbstractOmniGridContainerMenu)this.getMenu()).gridPlayer.level())).isPresent()) {
            ResourceAmount result = (ResourceAmount)((Pattern)pattern.get()).layout().outputs().getFirst();
            RefinedStorageClientApi.INSTANCE.openAutocraftingPreview(List.of(result), (Screen)this);
            return true;
        }
        for (int i = 0; i < this.blockTargetButtons.size(); ++i) {
            CommandConfigurationButton btn = this.blockTargetButtons.get(i);
            if (!btn.isMouseOver(mouseX, mouseY) || ((AbstractOmniGridContainerMenu)this.menu).tabPage != 1 || !this.isTransferPanel()) continue;
            if (button == 1) {
                OmniCommandData data = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient();
                data.setBlockTarget(i, null);
                Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new ClearTargetData(i));
                return true;
            }
            btn.mouseClicked(mouseX, mouseY, button);
            if (button == 0) {
                // empty if block
            }
            return true;
        }
        if (this.hoveredSlot != null && !this.transferPanel && (item = this.hoveredSlot) instanceof OmniResourceSlot) {
            OmniResourceSlot dataFilterSlot = (OmniResourceSlot)item;
            if (((AbstractOmniGridContainerMenu)this.menu).showCommandSlots() && !this.transferPanel) {
                if (button == 0) {
                    if (OmniGridScreen.hasShiftDown()) {
                        ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().commands[dataFilterSlot.getDataIndex()] = new OmniCommand();
                        dataFilterSlot.change(ItemStack.EMPTY, false);
                        ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().disabledCommands[dataFilterSlot.getDataIndex()] = false;
                        ((AbstractOmniGridContainerMenu)this.getMenu()).syncSlot(dataFilterSlot.getDataIndex());
                        ((AbstractOmniGridContainerMenu)this.menu).tabPage = 0;
                        this.updateTransferButtons(false);
                        this.selected = null;
                        return true;
                    }
                    if (((AbstractOmniGridContainerMenu)this.getMenu()).getCarried().isEmpty()) {
                        this.SelectSlot(dataFilterSlot);
                        return true;
                    }
                } else if (button == 1 && ((AbstractOmniGridContainerMenu)this.menu).getCarried().isEmpty()) {
                    if (OmniGridScreen.hasShiftDown()) {
                        dataFilterSlot.change(ItemStack.EMPTY, false);
                        ((AbstractOmniGridContainerMenu)this.getMenu()).syncSlot(dataFilterSlot.getDataIndex());
                    } else {
                        ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().disabledCommands[dataFilterSlot.getDataIndex()] = !((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().disabledCommands[dataFilterSlot.getDataIndex()];
                        Platform.INSTANCE.sendPacketToServer((CustomPacketPayload)new DisableCommandPacket(dataFilterSlot.getDataIndex()));
                    }
                    return true;
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void SelectSlot(OmniResourceSlot dataFilterSlot) {
        this.tabs.configOption = 0;
        this.selected = dataFilterSlot;
        this.commandIndex = this.selected.getContainerSlot();
        ((AbstractOmniGridContainerMenu)this.getMenu()).broadcastChanges();
        this.LoadConfigData();
        this.updateTransferButtons(true);
        this.handleTabClick(0);
        this.screenConfig = 0;
    }

    public void updateTransferButtons(boolean newTransferOption) {
        this.exit.active = ((AbstractOmniGridContainerMenu)this.menu).screenIsTransferPanel = (this.transferPanel = newTransferOption);
        if (this.transferPanel) {
            this.buttonCategory = ButtonCategory.ACTION;
        }
        for (CommandConfigurationButton btn : this.transferOptions) {
            btn.active = this.transferPanel;
        }
        this.toggleSlots();
        this.safeSync();
    }

    public void toggleSlots() {
        for (Slot s : ((AbstractOmniGridContainerMenu)this.getMenu()).slots) {
            if (!(s instanceof CraftingGridResultSlot)) continue;
            CraftingGridResultSlot ss = (CraftingGridResultSlot)s;
            ss.enable = ((AbstractOmniGridContainerMenu)this.menu).tabPage == 0 && !this.transferPanel;
        }
    }

    public void safeSync() {
        if (this.selected != null) {
            ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().commands[this.selected.getDataIndex()].setQuantity(this.actionConfigNumber.getNumber());
            LOGGER.info("Saving action config {}", (Object)((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().commands[this.selected.getDataIndex()]);
            ((AbstractOmniGridContainerMenu)this.getMenu()).syncSlot(this.selected.getDataIndex());
        }
    }

    public void LoadConfigData() {
        OmniCommand command = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().commands[this.commandIndex];
        for (int i = 0; i < this.transferOptions.size(); ++i) {
            CommandConfigurationButton btn = this.transferOptions.get(i);
            btn.setValue(0);
        }
        if (command.getTarget() > 0) {
            if (command.getTarget() >= 11) {
                this.blockTargetButtons.get(command.getTarget() - 11).setValue(1);
            } else {
                this.targetOption.get(command.getTarget() - 1).setValue(1);
            }
        }
        if (command.getAction() > 0) {
            int index = command.getAction() - 1;
            if (index >= this.actionButtons.size()) {
                index = this.actionButtons.size() - 1;
            }
            this.actionButtons.get(index).setValue(1);
            this.actionConfigNumber.setNumber(command.getQuantity());
            this.disableButtons(this.actionButtons.get(index));
        }
        this.invertButton.setValue(command.isInverted() ? 1 : 0);
        this.linkButton.setValue(command.isLinked() ? 1 : 0);
    }

    private void renderNumberTooltip(GuiGraphics graphics, int x, int y, Component title) {
        graphics.renderTooltip(this.font, List.of(title, Component.literal((String)"Set number or scroll to change").withStyle(ChatFormatting.GRAY), Component.literal((String)"Shift: \u00d710").withStyle(ChatFormatting.DARK_GRAY)), Optional.empty(), x, y);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        ArrayList<ClientTooltipComponent> tooltip;
        OmniFurnaceSlot omniFurnaceSlot;
        Slot stack;
        ToggleableQuickCraftingSlot toggleableQuickCraftingSlot;
        Slot hasAutoCrafting2;
        Object slot;
        CoreTypes required;
        boolean hoveredSlotValidForHelp;
        boolean bl = hoveredSlotValidForHelp = this.hoveredSlot != null && this.hoveredSlot.container instanceof ResultContainer && this.hoveredSlot.hasItem();
        if (this.actionConfigNumber.isHovered() && this.transferPanel && ((AbstractOmniGridContainerMenu)this.menu).tabPage == 0) {
            if (this.getCommand() == null) return;
            OmniCommand cmd = this.getCommand();
            switch (cmd.getAction()) {
                case 8: {
                    if (cmd.getTargetConfig() != 5) return;
                    this.renderNumberTooltip(graphics, x, y, (Component)Component.literal((String)"Stop autocrafting once this many of the item are in storage. Leave blank to ignore"));
                    return;
                }
                case 9: {
                    this.renderNumberTooltip(graphics, x, y, (Component)Component.literal((String)"Regulate Target"));
                    return;
                }
            }
            return;
        }
        if (!this.transferPanel && ((AbstractOmniGridContainerMenu)this.menu).tabPage == 1 && this.isHoveringFuelBar(x, y, this.leftPos + 11, this.topPos + 78 + 36)) {
            int fuel = ((AbstractOmniGridContainerMenu)this.menu).containerData.getFuelRemaining();
            int n = 25000;
            ArrayList<MutableComponent> tooltip2 = new ArrayList<MutableComponent>();
            if (((AbstractOmniGridContainerMenu)this.menu).isUtilityInstalled(UtilityType.CREATIVE)) {
                tooltip2.add(Component.literal((String)"\u221e").withStyle(ChatFormatting.AQUA));
            } else {
                int percent = n > 0 ? fuel * 100 / n : 0;
                tooltip2.add(Component.literal((String)(percent + "%")).withStyle(ChatFormatting.GRAY));
            }
            graphics.renderTooltip(this.font, tooltip2, Optional.empty(), x, y);
            return;
        }
        if (((AbstractOmniGridContainerMenu)this.menu).tabPage == 0 && this.bruteForceButton.isHovered()) {
            ArrayList<MutableComponent> tooltip3 = new ArrayList<MutableComponent>();
            if (((AbstractOmniGridContainerMenu)this.getMenu()).containerData.get(3) == 0) {
                tooltip3.add(Component.literal((String)"(Disabled)").withStyle(ChatFormatting.GRAY));
            }
            tooltip3.add(Component.literal((String)"Brute-force Crafting").withStyle(ChatFormatting.GREEN));
            tooltip3.add(Component.literal((String)"When transferring a recipe, autocraft missing ingredients if possible").withStyle(ChatFormatting.YELLOW));
            tooltip3.add(Component.literal((String)""));
            tooltip3.add(Component.literal((String)"Warning: Can use any item in your storage. You may blacklist items with the Simple Crafting command").withStyle(ChatFormatting.RED));
            graphics.renderTooltip(this.font, tooltip3, Optional.empty(), x, y);
            return;
        }
        if (((AbstractOmniGridContainerMenu)this.menu).tabPage == 2) {
            Slot slot2 = this.hoveredSlot;
            if (slot2 instanceof ToggleableCoreSlot) {
                ToggleableCoreSlot coreSlot = (ToggleableCoreSlot)slot2;
                CoreTypes coreTypes = CoreTypes.fromId(coreSlot.coreIdx);
                Items items = Items.INSTANCE;
                ItemStack coreStack = switch (coreTypes) {
                    default -> throw new MatchException(null, null);
                    case CoreTypes.PROVIDE -> new ItemStack((ItemLike)items.getOmniProvideCore());
                    case CoreTypes.PULL -> new ItemStack((ItemLike)items.getOmniPullCore());
                    case CoreTypes.PUSH -> new ItemStack((ItemLike)items.getOmniPushCore());
                    case CoreTypes.COLLECT -> new ItemStack((ItemLike)items.getOmniCollectCore());
                    case CoreTypes.BLACKLIST -> new ItemStack((ItemLike)items.getOmniBlacklistCore());
                    case CoreTypes.SEARCH -> new ItemStack((ItemLike)items.getOmniSearchCore());
                    case CoreTypes.EXTERNAL_STORAGE -> new ItemStack((ItemLike)items.getOmniExternalCore());
                    case CoreTypes.BASIC_CRAFTING -> new ItemStack((ItemLike)items.getOmniCraftCore());
                    case CoreTypes.REGULATE -> new ItemStack((ItemLike)items.getOmniRegulateCore());
                    case CoreTypes.DEPOSITING -> new ItemStack((ItemLike)items.getOmniInterfacerCore());
                    case CoreTypes.PLAYER -> new ItemStack((ItemLike)items.getOmniPlayerCore());
                    case CoreTypes.FURNACE -> new ItemStack((ItemLike)items.getOmniFurnaceCore());
                    case CoreTypes.LOOTING -> new ItemStack((ItemLike)items.getOmniLootingCore());
                    case CoreTypes.REMOTE -> new ItemStack((ItemLike)items.getOmniRemoteCore());
                    case CoreTypes.LINK -> new ItemStack((ItemLike)items.getLinkCore());
                    case CoreTypes.FILTER -> new ItemStack((ItemLike)items.getOmniPrecisionCore());
                    case CoreTypes.MONITOR -> new ItemStack((ItemLike)items.getOmniMontitorCore());
                    case CoreTypes.AUTOCRAFTING -> new ItemStack((ItemLike)items.getOmniAutocraftingCore());
                    case CoreTypes.DISK_DRIVE -> new ItemStack((ItemLike)items.getOmniDiskDriveCore());
                    case CoreTypes.INVERTED -> new ItemStack((ItemLike)items.getInvertedCore());
                    case CoreTypes.NONE -> ItemStack.EMPTY;
                };
                ArrayList<Object> tooltip4 = new ArrayList<Object>();
                if (coreSlot.hasItem()) {
                    tooltip4.add(Component.literal((String)"Installed").withStyle(ChatFormatting.GREEN));
                } else {
                    tooltip4.add(Component.literal((String)"Missing").withStyle(ChatFormatting.RED));
                }
                tooltip4.add(coreStack.getHoverName().copy());
                tooltip4.add(Component.literal((String)""));
                tooltip4.add(((CoreItem)coreStack.getItem()).getTitleComponent());
                tooltip4.add(Component.literal((String)""));
                tooltip4.add(((CoreItem)coreStack.getItem()).getDescriptionComponent());
                graphics.renderComponentTooltip(this.font, tooltip4, x, y);
                return;
            }
        } else if (this.hoveredButton != null && (required = this.hoveredButton.getRequiredCore()) != null && !this.hoveredButton.coreInstalled() && required != CoreTypes.NONE) {
            ArrayList<MutableComponent> arrayList = new ArrayList<MutableComponent>();
            arrayList.add(Component.literal((String)"Requires:").withStyle(ChatFormatting.RED));
            arrayList.add(Component.literal((String)required.toString()).withStyle(ChatFormatting.YELLOW));
            graphics.renderComponentTooltip(this.font, arrayList, x, y);
            return;
        }
        if (((AbstractOmniGridContainerMenu)this.getMenu()).getCarried().isEmpty() && hoveredSlotValidForHelp && !this.filteringBasedOnCraftingMatrixItems && !(this.hoveredSlot instanceof CraftingGridResultSlot)) {
            ItemStack stack2 = this.hoveredSlot.getItem();
            List list = this.getTooltipFromContainerItem(stack2);
            List processedLines = Platform.INSTANCE.processTooltipComponents(stack2, graphics, x, stack2.getTooltipImage(), list);
            processedLines.add(HelpClientTooltipComponent.create((Component)IdentifierUtil.createTranslation((String)"gui", (String)"crafting_grid.press_shift_ctrl_to_only_show_items_used_in_crafting")));
            Platform.INSTANCE.renderTooltip(graphics, processedLines, x, y);
            return;
        }
        if (this.hoveredSlot != null) {
            ArrayList<MutableComponent> tooltip5;
            Slot slot3 = this.hoveredSlot;
            if (slot3 instanceof OmniUpgradeSlot && !(slot = (OmniUpgradeSlot)slot3).hasItem()) {
                if (slot.getContainerSlot() == 0) {
                    ArrayList<MutableComponent> arrayList = new ArrayList<MutableComponent>();
                    arrayList.add(Component.literal((String)"Speed Upgrade Slot (3)"));
                    arrayList.add(Component.literal((String)""));
                    arrayList.add(Component.literal((String)"Processes tasks faster"));
                    graphics.renderComponentTooltip(this.font, arrayList, x, y - 20);
                } else if (slot.getContainerSlot() == 1) {
                    ArrayList<MutableComponent> arrayList = new ArrayList<MutableComponent>();
                    arrayList.add(Component.literal((String)"Stack Upgrade Slot (3)"));
                    arrayList.add(Component.literal((String)""));
                    arrayList.add(Component.literal((String)"Increases quantity"));
                    arrayList.add(Component.literal((String)"of resources transferred"));
                    graphics.renderComponentTooltip(this.font, arrayList, x, y - 20);
                } else if (slot.getContainerSlot() == 2) {
                    ArrayList<MutableComponent> arrayList = new ArrayList<MutableComponent>();
                    arrayList.add(Component.literal((String)"Range Upgrade Slot (3)"));
                    arrayList.add(Component.literal((String)""));
                    arrayList.add(Component.literal((String)"Increases range of"));
                    arrayList.add(Component.literal((String)"Search, Collect, and"));
                    arrayList.add(Component.literal((String)"remote block targets"));
                    graphics.renderComponentTooltip(this.font, arrayList, x, y - 20);
                } else if (slot.getContainerSlot() == 3) {
                    ArrayList<MutableComponent> arrayList = new ArrayList<MutableComponent>();
                    arrayList.add(Component.literal((String)"Energy Upgrade Slot (3)"));
                    arrayList.add(Component.literal((String)""));
                    arrayList.add(Component.literal((String)"Increases energy"));
                    arrayList.add(Component.literal((String)"capacity and stress"));
                    arrayList.add(Component.literal((String)"efficiency"));
                    arrayList.add(Component.literal((String)"per upgrade"));
                    graphics.renderComponentTooltip(this.font, arrayList, x, y - 20);
                }
            }
            if (this.hoveredSlot instanceof MarkedContainerFilterSlot && !this.hoveredSlot.hasItem()) {
                tooltip5 = new ArrayList<MutableComponent>();
                tooltip5.add(Component.literal((String)"Container items"));
                tooltip5.add(Component.literal((String)""));
                tooltip5.add(Component.literal((String)"Push/Pull actions can interact"));
                tooltip5.add(Component.literal((String)"with instances of this in the players inventory"));
                tooltip5.add(Component.literal((String)"while using player targeting"));
                graphics.renderComponentTooltip(this.font, tooltip5, x, y - 20);
                return;
            }
            Slot slot4 = this.hoveredSlot;
            if (slot4 instanceof OmniResourceSlot) {
                slot = (OmniResourceSlot)slot4;
                List<Component> list = this.getConfigTooltip((OmniResourceSlot)((Object)slot));
                list.add((Component)Component.literal((String)""));
                OmniCommand info = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().commands[((OmniResourceSlot)((Object)slot)).getDataIndex()];
                if (info.getResource() != null || info.getAction() > 0) {
                    list.add((Component)Component.literal((String)"Right-click to toggle").withStyle(ChatFormatting.DARK_GRAY));
                    list.add((Component)Component.literal((String)"Shift-click to clear").withStyle(ChatFormatting.DARK_GRAY));
                    list.add((Component)Component.literal((String)"Shift-right-click to clear resource").withStyle(ChatFormatting.DARK_GRAY));
                } else {
                    list.add((Component)Component.literal((String)"Click to set a command").withStyle(ChatFormatting.GREEN));
                    list.add((Component)Component.literal((String)"Drag a resource here for the command to affect").withStyle(ChatFormatting.DARK_GRAY));
                    list.add((Component)Component.literal((String)"Leave blank for the command to affect all items").withStyle(ChatFormatting.DARK_GRAY));
                }
                graphics.renderComponentTooltip(this.font, list, x, y);
                return;
            }
            if (this.hoveredSlot instanceof ToggleableResourceSlot && !this.transferPanel && ((AbstractOmniGridContainerMenu)this.menu).tabPage == 2) {
                tooltip5 = new ArrayList();
                tooltip5.add(Component.literal((String)"Resource Monitor").withStyle(ChatFormatting.BLUE));
                tooltip5.add(Component.literal((String)"Drag a resource here for the Omni Grid screen to display").withStyle(ChatFormatting.YELLOW));
                if (!((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().isCoreInstalled(CoreTypes.MONITOR)) {
                    tooltip5.add(Component.literal((String)""));
                    tooltip5.add(Component.literal((String)"Requires: Omni Monitor Core").withStyle(ChatFormatting.RED));
                }
                graphics.renderComponentTooltip(this.font, tooltip5, x, y);
                return;
            }
            Slot slot5 = this.hoveredSlot;
            if (slot5 instanceof ToggleableUtilitySlot) {
                slot = (ToggleableUtilitySlot)slot5;
                if (((AbstractOmniGridContainerMenu)this.menu).tabPage == 2 && !this.hoveredSlot.hasItem()) {
                    ArrayList<MutableComponent> arrayList = new ArrayList<MutableComponent>();
                    boolean hasAutoCrafting2 = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().isCoreInstalled(CoreTypes.AUTOCRAFTING);
                    boolean hasFurnace = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().isCoreInstalled(CoreTypes.FURNACE);
                    arrayList.add(Component.literal((String)"Utility Slot").withStyle(ChatFormatting.GRAY));
                    arrayList.add(Component.literal((String)"Accepts:").withStyle(ChatFormatting.YELLOW));
                    arrayList.add(Component.literal((String)"\u2022 Core Cartridges").withStyle(ChatFormatting.AQUA));
                    arrayList.add(Component.literal((String)"\u2022 Utility cores").withStyle(ChatFormatting.GREEN));
                    if (hasAutoCrafting2) {
                        arrayList.add(Component.literal((String)"\u2022 Non-processing crafting patterns").withStyle(ChatFormatting.GREEN));
                    } else {
                        arrayList.add(Component.literal((String)"\u2022 Non-processing crafting patterns").withStyle(ChatFormatting.DARK_GRAY));
                    }
                    if (hasAutoCrafting2 && hasFurnace) {
                        arrayList.add(Component.literal((String)"\u2022 Smelting processing patterns").withStyle(ChatFormatting.GREEN));
                    } else {
                        arrayList.add(Component.literal((String)"\u2022 Smelting processing patterns").withStyle(ChatFormatting.DARK_GRAY));
                    }
                    if (!hasAutoCrafting2 || !hasFurnace) {
                        arrayList.add(Component.empty());
                        arrayList.add(Component.literal((String)"Install required cores to unlock more options").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                    }
                    graphics.renderComponentTooltip(this.font, arrayList, x, y);
                    return;
                }
            }
        }
        if (this.selected != null && this.commandIndex > -1 && this.hoveredButton != null) {
            this.renderFullConfigInfo(graphics, x, y, this.selected);
            return;
        }
        Slot slot6 = this.hoveredSlot;
        if (slot6 instanceof OmniResourceSlot) {
            slot = (OmniResourceSlot)slot6;
            if (!this.transferPanel) {
                this.renderFullConfigInfo(graphics, x, y, (OmniResourceSlot)((Object)slot));
                return;
            }
        }
        if (this.transferPanel && this.actionConfigNumber.isHovered() && this.getCommand() != null) {
            if (this.getCommand().getAction() == 4) {
                ArrayList<MutableComponent> arrayList = new ArrayList<MutableComponent>();
                arrayList.add(Component.literal((String)"Push until the Omni Grid"));
                arrayList.add(Component.literal((String)"has this many items"));
                arrayList.add(Component.literal((String)""));
                arrayList.add(Component.literal((String)"Leave blank to ignore"));
                graphics.renderComponentTooltip(this.font, arrayList, x, y);
            }
            if (this.getCommand().getAction() == 2) {
                ArrayList<MutableComponent> arrayList = new ArrayList<MutableComponent>();
                arrayList.add(Component.literal((String)"Pull until the Omni Grid"));
                arrayList.add(Component.literal((String)"has this many items"));
                arrayList.add(Component.literal((String)""));
                arrayList.add(Component.literal((String)"Leave blank to ignore"));
                graphics.renderComponentTooltip(this.font, arrayList, x, y);
            }
        }
        if ((hasAutoCrafting2 = this.hoveredSlot) instanceof ToggleableQuickCraftingSlot && (toggleableQuickCraftingSlot = (ToggleableQuickCraftingSlot)hasAutoCrafting2).isValid() && toggleableQuickCraftingSlot.hasItem()) {
            stack = toggleableQuickCraftingSlot.getItem();
            if (!stack.has(DataComponents.INSTANCE.getCraftingPatternState()) && !stack.has(DataComponents.INSTANCE.getPatternState())) {
                ((AbstractOmniGridContainerMenu)this.menu).createPattern((ItemStack)stack);
            }
            MutableComponent comp = Component.literal((String)"Save Crafting Pattern?").withStyle(ChatFormatting.AQUA);
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(this.getTooltipFromContainerItem((ItemStack)stack));
            list.add(0, comp);
            graphics.renderTooltip(this.font, list, stack.getTooltipImage(), (ItemStack)stack, x, y);
            return;
        }
        stack = this.hoveredSlot;
        if (stack instanceof OmniFurnaceSlot && (omniFurnaceSlot = (OmniFurnaceSlot)stack).isValid() && omniFurnaceSlot.getResource() != null && omniFurnaceSlot.smelting && !(tooltip = new ArrayList<ClientTooltipComponent>(this.getResourceSlotTooltip(((AbstractOmniGridContainerMenu)this.menu).getCarried(), omniFurnaceSlot))).isEmpty()) {
            tooltip.add(0, ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)"Click or Scroll to change amount").withStyle(ChatFormatting.GREEN).getVisualOrderText()));
            Platform.INSTANCE.renderTooltip(graphics, tooltip, x, y);
            return;
        }
        super.renderTooltip(graphics, x, y);
    }

    public void renderFullConfigInfo(GuiGraphics graphics, int x, int y, OmniResourceSlot slot) {
        OmniCommand command = ((AbstractOmniGridContainerMenu)this.getMenu()).getDataClient().commands[slot.getDataIndex()];
        boolean skip = false;
        int actionIndex = command.getAction() - 1;
        if (actionIndex >= this.actionButtons.size()) {
            actionIndex = this.actionButtons.size() - 1;
        }
        ArrayList<ResourceLocation> pics = new ArrayList<ResourceLocation>();
        if (actionIndex > 0) {
            pics.add(this.actionButtons.get(actionIndex).getSprites()[0]);
        }
        if (command.getTarget() > 0 && command.getTarget() < 11) {
            pics.add(this.targetOption.get(command.getTarget() - 1).getSprites()[0]);
        }
        if (command.isInverted()) {
            pics.add(this.invertButton.getSprites()[1]);
        }
        List<ClientTooltipComponent> tooltip = TooltipUtils.withImagesAbove(pics, 16, 16);
        if (!skip) {
            Platform.INSTANCE.renderTooltip(graphics, tooltip, x, y - 20);
        }
        graphics.renderComponentTooltip(this.font, this.getConfigTooltip(slot), x, y);
    }

    protected int getBottomHeight() {
        return this.bottomHeight;
    }

    protected int getBottomV() {
        return 73;
    }

    public void renderOmniGridCommandDataDebug(GuiGraphics guiGraphics, OmniCommandData data, int screenHeight) {
        int x = 10;
        int y = screenHeight - 180;
        int lineHeight = 10;
        guiGraphics.drawString(this.font, "OmniData Debug:", x, y, 0xFFFFFF);
        for (int i = 0; i < data.commands.length; ++i) {
            OmniCommand cmd = data.commands[i];
            String text = String.format("C[%d]: m=%d, a=%d, t=%d", i, cmd.getMode(), cmd.getAction(), cmd.getTarget());
            guiGraphics.drawString(this.font, text, x, y + lineHeight * (i + 1), 0xFFFFFF);
        }
        int blockStartY = y + lineHeight * (data.commands.length + 2);
        guiGraphics.drawString(this.font, "block:", x, blockStartY, 0xFFFFFF);
    }
}

