/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Utils.OmniProxxyStorage;
import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.Items;
import com.omnigrid.neoforge.OmniGridTask;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniGridResourceHandler
implements IItemHandler,
IFluidHandler {
    private OmniProxxyStorage storage;
    public List<OmniGridTask> insertionBlacklist = new ArrayList<OmniGridTask>();
    public List<OmniGridTask> exportWhiteList = new ArrayList<OmniGridTask>();
    private final AbstractOmniGridBlockEntity be;
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniGridResourceHandler.class);

    public OmniGridResourceHandler(AbstractOmniGridBlockEntity be) {
        this.be = be;
        this.storage = new OmniProxxyStorage(be.getStorageReference());
    }

    public OmniProxxyStorage getStorage() {
        return this.storage;
    }

    public void setWhitelist(List<OmniGridTask> whitelist) {
        this.exportWhiteList = whitelist;
    }

    private boolean hasStorage() {
        return this.storage != null;
    }

    public int getSlots() {
        if (!this.hasStorage()) {
            return 1;
        }
        int itemCount = 0;
        for (ResourceAmount ra : this.storage.getAll()) {
            if (!(ra.resource() instanceof ItemResource)) continue;
            ++itemCount;
        }
        return 1 + itemCount;
    }

    public ItemStack getStackInSlot(int slot) {
        if (!this.hasStorage()) {
            return ItemStack.EMPTY;
        }
        if (slot == 0) {
            return ItemStack.EMPTY;
        }
        int index = slot - 1;
        ArrayList<ResourceAmount> all = new ArrayList<ResourceAmount>(this.storage.getAll());
        ArrayList<ItemResource> items = new ArrayList<ItemResource>();
        for (ResourceAmount ra : all) {
            ResourceKey resourceKey = ra.resource();
            if (!(resourceKey instanceof ItemResource)) continue;
            ItemResource ir = (ItemResource)resourceKey;
            items.add(ir);
        }
        if (index < 0 || index >= items.size()) {
            return ItemStack.EMPTY;
        }
        ItemResource resource = (ItemResource)items.get(index);
        ItemStack template = resource.toItemStack();
        long count = this.storage.extract((ResourceKey)resource, Integer.MAX_VALUE, Action.SIMULATE, Actor.EMPTY);
        if (count <= 0L) {
            return ItemStack.EMPTY;
        }
        ItemStack preview = template.copy();
        preview.setCount((int)Math.min(count, (long)template.getMaxStackSize()));
        return preview;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.hasStorage() || stack.isEmpty() || !this.be.getOmniData().isCoreInstalled(CoreTypes.DEPOSITING)) {
            return stack;
        }
        if (slot != 0) {
            return stack;
        }
        if (this.isBlacklistedItem(stack)) {
            return stack;
        }
        int inserted = (int)this.storage.insert(stack, stack.getCount(), simulate);
        if (!simulate && inserted > 0) {
            ItemStack remainder = stack.copy();
            remainder.shrink(inserted);
            this.notifyContainerMenus();
            return remainder.isEmpty() ? ItemStack.EMPTY : remainder;
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.hasStorage() || slot == 0) {
            return ItemStack.EMPTY;
        }
        int index = slot - 1;
        ArrayList<ResourceAmount> resources = new ArrayList<ResourceAmount>(this.storage.getAll());
        if (index < 0 || index >= resources.size()) {
            return ItemStack.EMPTY;
        }
        ResourceAmount ra = (ResourceAmount)resources.get(index);
        ResourceKey key = ra.resource();
        if (!(key instanceof ItemResource)) {
            return ItemStack.EMPTY;
        }
        ItemResource itemRes = (ItemResource)key;
        ItemStack stackTemplate = itemRes.toItemStack();
        if (!this.isWhitelistedItem(stackTemplate)) {
            return ItemStack.EMPTY;
        }
        long extracted = this.storage.extract((ResourceKey)itemRes, amount, simulate ? Action.SIMULATE : Action.EXECUTE, Actor.EMPTY);
        if (extracted <= 0L) {
            return ItemStack.EMPTY;
        }
        return stackTemplate.copyWithCount((int)extracted);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.hasStorage() && slot == 0;
    }

    public int getTanks() {
        return 1 + this.getStoredFluids().size();
    }

    public FluidStack getFluidInTank(int tank) {
        if (!this.hasStorage()) {
            return FluidStack.EMPTY;
        }
        if (tank == 0) {
            return FluidStack.EMPTY;
        }
        List<FluidResource> fluids = this.getStoredFluids();
        int index = tank - 1;
        if (index < 0 || index >= fluids.size()) {
            return FluidStack.EMPTY;
        }
        FluidResource resource = fluids.get(index);
        long amount = this.storage.getAmount(resource.fluid());
        if (amount <= 0L) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(resource.fluid(), (int)amount);
    }

    private List<FluidResource> getStoredFluids() {
        if (!this.hasStorage()) {
            return List.of();
        }
        ArrayList<FluidResource> fluids = new ArrayList<FluidResource>();
        for (ResourceAmount ra : this.storage.getAll()) {
            ResourceKey key = ra.resource();
            if (!(key instanceof FluidResource)) continue;
            FluidResource fr = (FluidResource)key;
            fluids.add(fr);
        }
        return fluids;
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.hasStorage() && tank == 0;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.hasStorage() || resource.isEmpty() || !this.be.getOmniData().isCoreInstalled(CoreTypes.DEPOSITING)) {
            return 0;
        }
        if (this.isBlacklistedFluid(resource.getFluid())) {
            return 0;
        }
        return (int)this.storage.insert(resource.getFluid(), resource.getAmount(), action.simulate());
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.hasStorage() || resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (!this.isWhitelistedFluid(resource.getFluid())) {
            return FluidStack.EMPTY;
        }
        int extracted = (int)this.storage.extract(resource.getFluid(), resource.getAmount(), action.simulate());
        return extracted > 0 ? new FluidStack(resource.getFluid(), extracted) : FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    public static boolean matchesTask(ResourceKey resource, OmniGridTask task) {
        if (task == null) {
            return false;
        }
        boolean inverted = task.isInverted();
        if (task.any) {
            return !inverted;
        }
        if (resource instanceof ItemResource) {
            ItemResource itemRes = (ItemResource)resource;
            ItemStack stack = itemRes.toItemStack();
            return OmniGridResourceHandler.matchesTask(stack, task);
        }
        Optional<PlatformResourceKey> optKey = task.resource;
        if (optKey == null || optKey.isEmpty()) {
            return !inverted;
        }
        boolean result = optKey.get().getResourceType().equals((Object)resource);
        return inverted ? !result : result;
    }

    public static boolean matchesTask(ItemStack item, OmniGridTask task) {
        List<String> components;
        List<String> tags;
        ResourceLocation rl;
        if (item == null || item.isEmpty() || item.getItem() == Items.INSTANCE.getOmniGrid()) {
            return false;
        }
        if (task.any) {
            return true;
        }
        boolean inverted = task.isInverted();
        boolean result = true;
        if (!(task.mod == null || task.mod.isEmpty() || (rl = BuiltInRegistries.ITEM.getKey((Object)item.getItem())) != null && rl.getNamespace().equals(task.mod))) {
            result = false;
        }
        if (result && task.tag != null && !task.tag.isEmpty() && !"None".equals(task.tag) && !(tags = TransferUtils.getItemTagsAsStringList(item)).contains(task.tag)) {
            result = false;
        }
        if (result && task.component != null && !task.component.isEmpty() && !(components = TransferUtils.getItemComponentsAsStringList(item)).contains(task.component)) {
            result = false;
        }
        if (result && task.keyword != null && !task.keyword.isEmpty()) {
            rl = BuiltInRegistries.ITEM.getKey((Object)item.getItem());
            if (rl != null) {
                String keyword;
                String idPath = rl.getPath().toLowerCase(Locale.ROOT);
                if (!idPath.contains(keyword = task.keyword.toLowerCase(Locale.ROOT))) {
                    result = false;
                }
            } else {
                result = false;
            }
        }
        if (result && OmniGridResourceHandler.isEmpty(task.mod) && OmniGridResourceHandler.isEmpty(task.tag) && OmniGridResourceHandler.isEmpty(task.component) && OmniGridResourceHandler.isEmpty(task.keyword) && task.stack != null && !task.stack.isEmpty()) {
            result = task.isFuzzy ? ItemStack.isSameItem((ItemStack)item, (ItemStack)task.stack) : ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)task.stack);
        }
        if (inverted) {
            result = !result;
        }
        return result;
    }

    private void notifyContainerMenus() {
        if (this.be == null || this.be.getLevel() == null || this.be.getLevel().isClientSide) {
            return;
        }
        this.be.markDataDirty();
        for (ServerPlayer player : ((ServerLevel)this.be.getLevel()).players()) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (!(abstractContainerMenu instanceof AbstractOmniGridContainerMenu)) continue;
            AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
            if (menu.blockEntityPosition == null || !menu.blockEntityPosition.equals((Object)this.be.getBlockPos())) continue;
            menu.flushDeltas();
        }
    }

    private boolean isBlacklistedItem(ItemStack stack) {
        for (OmniGridTask task : this.insertionBlacklist) {
            if (!OmniGridResourceHandler.matchesTask(stack, task)) continue;
            return true;
        }
        return false;
    }

    private boolean isWhitelistedItem(ItemStack stack) {
        for (OmniGridTask task : this.exportWhiteList) {
            if (!OmniGridResourceHandler.matchesTask(stack, task)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlacklistedFluid(Fluid fluid) {
        for (OmniGridTask task : this.insertionBlacklist) {
            if (task.fluid == null || !task.fluid.equals(fluid)) continue;
            return true;
        }
        return false;
    }

    private boolean isWhitelistedFluid(Fluid fluid) {
        for (OmniGridTask task : this.exportWhiteList) {
            if (task.fluid == null || !task.fluid.equals(fluid)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.isEmpty() || "None".equals(s);
    }
}

