/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.common.Platform;

class OmniGridOperations
implements GridOperations {
    private final GridOperations delegate;
    private final EnergyStorage energyStorage;

    OmniGridOperations(GridOperations delegate, EnergyStorage energyStorage) {
        this.delegate = delegate;
        this.energyStorage = energyStorage;
    }

    public boolean extract(ResourceKey resource, GridExtractMode extractMode, InsertableStorage destination) {
        if (this.delegate.extract(resource, extractMode, destination)) {
            this.energyStorage.extract(Platform.INSTANCE.getConfig().getPortableGrid().getExtractEnergyUsage(), Action.EXECUTE);
            return true;
        }
        return false;
    }

    public boolean insert(ResourceKey resource, GridInsertMode insertMode, ExtractableStorage source) {
        if (this.delegate.insert(resource, insertMode, source)) {
            this.energyStorage.extract(Platform.INSTANCE.getConfig().getPortableGrid().getInsertEnergyUsage(), Action.EXECUTE);
            return true;
        }
        return false;
    }
}

