/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.resource.list.ResourceList;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.composite.ParentComposite;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageListener;
import com.refinedmods.refinedstorage.api.storage.external.ExternalStorageProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniGridExternalStorage
implements Storage {
    public ExternalStorageProvider provider;
    public static final Logger LOGGER = LoggerFactory.getLogger(OmniGridExternalStorage.class);
    private final ExternalStorageListener listener;
    private final MutableResourceList cache = MutableResourceListImpl.create();
    private final Set<ParentComposite> parents = new HashSet<ParentComposite>();

    public OmniGridExternalStorage(ExternalStorageProvider provider) {
        this.provider = provider;
        this.listener = new SpyingExternalStorageListener();
    }

    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        long extracted = this.provider.extract(resource, amount, action, actor);
        if (action == Action.EXECUTE && extracted > 0L) {
            this.listener.beforeDetectChanges(resource, actor);
            this.detectChanges();
        }
        return extracted;
    }

    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        long inserted = this.provider.insert(resource, amount, action, actor);
        if (action == Action.EXECUTE && inserted > 0L) {
            this.listener.beforeDetectChanges(resource, actor);
            this.detectChanges();
        }
        return inserted;
    }

    public boolean detectChanges() {
        ResourceList updatedCache = this.buildCache();
        boolean hasChanges = this.detectCompleteRemovals(updatedCache);
        return hasChanges |= this.detectAdditionsAndPartialRemovals(updatedCache);
    }

    private boolean detectCompleteRemovals(ResourceList updatedCache) {
        HashSet<ResourceKey> removedInUpdatedCache = new HashSet<ResourceKey>();
        for (ResourceKey inOldCache : this.cache.getAll()) {
            if (updatedCache.contains(inOldCache)) continue;
            removedInUpdatedCache.add(inOldCache);
        }
        removedInUpdatedCache.forEach(this::removeFromCache);
        return !removedInUpdatedCache.isEmpty();
    }

    private boolean detectAdditionsAndPartialRemovals(ResourceList updatedCache) {
        boolean hasChanges = false;
        for (ResourceKey resource : updatedCache.getAll()) {
            boolean doesNotExistInOldCache;
            long amountInUpdatedCache = updatedCache.get(resource);
            long amountInOldCache = this.cache.get(resource);
            boolean bl = doesNotExistInOldCache = amountInOldCache == 0L;
            if (doesNotExistInOldCache) {
                this.addToCache(resource, amountInUpdatedCache);
                hasChanges = true;
                continue;
            }
            hasChanges |= this.detectPotentialDifference(resource, amountInUpdatedCache, amountInOldCache);
        }
        return hasChanges;
    }

    private boolean detectPotentialDifference(ResourceKey resource, long amountInUpdatedCache, long amountInOldCache) {
        long diff = amountInUpdatedCache - amountInOldCache;
        if (diff > 0L) {
            this.addToCache(resource, diff);
            return true;
        }
        if (diff < 0L) {
            this.removeFromCache(resource, Math.abs(diff));
            return true;
        }
        return false;
    }

    private void addToCache(ResourceKey resource, long amount) {
        this.cache.add(resource, amount);
        this.parents.forEach(parent -> parent.addToCache(resource, amount));
    }

    private void removeFromCache(ResourceKey resource) {
        this.removeFromCache(resource, this.cache.get(resource));
    }

    private void removeFromCache(ResourceKey resource, long amount) {
        this.cache.remove(resource, amount);
        this.parents.forEach(parent -> parent.removeFromCache(resource, amount));
    }

    private ResourceList buildCache() {
        MutableResourceListImpl list = MutableResourceListImpl.create();
        this.provider.iterator().forEachRemaining(arg_0 -> ((MutableResourceList)list).add(arg_0));
        return list;
    }

    public Collection<ResourceAmount> getAll() {
        return this.cache.copyState();
    }

    public long getStored() {
        return 99999L;
    }

    static class SpyingExternalStorageListener
    implements ExternalStorageListener {
        public final List<ResourceKey> resources = new ArrayList<ResourceKey>();
        public final List<Actor> actors = new ArrayList<Actor>();

        SpyingExternalStorageListener() {
        }

        public void beforeDetectChanges(ResourceKey resource, Actor actor) {
            this.resources.add(resource);
            this.actors.add(actor);
        }
    }
}

