/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Utils.CurioStats;
import com.omnigrid.Utils.RefinedTypesUtil;
import com.omnigrid.Utils.ResourceTrackerTooltipComponent;
import com.omnigrid.Utils.TransferUtils;
import com.omnigrid.Utils.UtilityType;
import com.omnigrid.Utils.VirtualContainerUtil;
import com.omnigrid.customRender.OmniClientBlockPacket;
import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.BlockEntities;
import com.omnigrid.neoforge.ClientResourceTracker;
import com.omnigrid.neoforge.ContentNames;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.DataComponents;
import com.omnigrid.neoforge.FurnaceData;
import com.omnigrid.neoforge.Items;
import com.omnigrid.neoforge.LootNotification;
import com.omnigrid.neoforge.ModInitializer;
import com.omnigrid.neoforge.OmniBlockTarget;
import com.omnigrid.neoforge.OmniCommand;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniEffectPacket;
import com.omnigrid.neoforge.OmniGrid;
import com.omnigrid.neoforge.OmniGridItemExtendedMenuProvider;
import com.omnigrid.neoforge.OmniGridTask;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.OmniRootStorage;
import com.omnigrid.neoforge.OmniUtilityInventory;
import com.omnigrid.neoforge.Platform;
import com.omnigrid.neoforge.UpdateTracker;
import com.omnigrid.neoforge.UpgradeableEnergyStorage;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.AbstractProxyEnergyStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.SerializableStorage;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItemHelper;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.api.support.energy.AbstractEnergyBlockItem;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReferenceHandlerItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.storage.DiskInventory;
import com.refinedmods.refinedstorage.common.storage.ItemStorageVariant;
import com.refinedmods.refinedstorage.common.support.FilteredContainer;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniGridBlockItem
extends AbstractEnergyBlockItem
implements SlotReferenceHandlerItem,
UpgradeDestination {
    private static final Component HELP = IdentifierUtil.createTranslation((String)"item", (String)"omni_grid.help");
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniGridBlockItem.class);
    public static final Map<UUID, OmniItemProxxy> GLOBAL_STORAGES = new HashMap<UUID, OmniItemProxxy>();
    public static final HashMap<UUID, Long> lastOpened = new HashMap();
    public static final HashMap<UUID, Integer> STOP_CLIENT_SERVER = new HashMap();
    public static final HashMap<UUID, OmniBlockTarget[]> CLIENT_BLOCK_TARGETS = new HashMap();
    public static final HashMap<UUID, Short> MAX_POWER_CACHE = new HashMap();
    public static HashMap<UUID, Boolean> stopClient = new HashMap();
    protected final StorageContainerItemHelper helper = RefinedStorageApi.INSTANCE.getStorageContainerItemHelper();
    public static final Map<UUID, CurioStats> CLIENT_CURIOS_STATS = new ConcurrentHashMap<UUID, CurioStats>();
    public static final String KEY = "omnigrid-ProxxyID";

    public OmniGridBlockItem(Block block) {
        super(block, new Item.Properties().stacksTo(1), RefinedStorageApi.INSTANCE.getEnergyItemHelper());
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        if (level.isClientSide) {
            return false;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof AbstractOmniGridBlockEntity)) {
            return false;
        }
        AbstractOmniGridBlockEntity grid = (AbstractOmniGridBlockEntity)be;
        com.refinedmods.refinedstorage.common.content.DataComponents rsData = com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE;
        UUID ref = (UUID)stack.get(rsData.getStorageReference());
        ModInitializer.SaveProxxyInfo(ref, level);
        if (ref != null) {
            grid.setStorageReference(ref);
            if (GLOBAL_STORAGES.containsKey(ref)) {
                OmniItemProxxy proxxy = GLOBAL_STORAGES.get(ref);
                if (proxxy.utilityTypes.contains((Object)UtilityType.SPONGE)) {
                    proxxy.absorbFluidsAround(pos);
                }
            }
        }
        if (player != null) {
            grid.setPlacedBy(player.getUUID());
        }
        if (stack.has(net.minecraft.core.component.DataComponents.CUSTOM_MODEL_DATA)) {
            ((AbstractOmniGridBlockEntity)be).customModel = ((CustomModelData)stack.get(net.minecraft.core.component.DataComponents.CUSTOM_MODEL_DATA)).value();
        }
        IEnergyStorage itemPower = (IEnergyStorage)Capabilities.EnergyStorage.ITEM.getCapability(stack, null);
        IEnergyStorage blockPower = (IEnergyStorage)Capabilities.EnergyStorage.BLOCK.getCapability(level, pos, state, be, null);
        if (itemPower != null && blockPower != null) {
            blockPower.receiveEnergy(itemPower.getEnergyStored(), false);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().execute(() -> {
                BlockEntity after = level.getBlockEntity(pos);
                if (after instanceof AbstractOmniGridBlockEntity) {
                    AbstractOmniGridBlockEntity g = (AbstractOmniGridBlockEntity)after;
                    g.fixVirtualData();
                    g.initialize(level);
                    g.setLevel(level);
                    g.diskStateListener.updateIfNecessary();
                    g.updateActivenessBlockState(g.getBlockState(), g.getInWorldOmniGrid().isGridActive());
                    if (GLOBAL_STORAGES.containsKey(ref)) {
                        g.proxxy = GLOBAL_STORAGES.get(ref);
                    }
                    if (stack.has(net.minecraft.core.component.DataComponents.ENCHANTMENTS)) {
                        g.enchantments = (ItemEnchantments)stack.get(net.minecraft.core.component.DataComponents.ENCHANTMENTS);
                    }
                    g.markDataDirty();
                    LOGGER.debug("[OmniGridPlacement] Forced virtual hydration + activation for {}", (Object)pos);
                }
            });
        }
        grid.setChanged();
        return true;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        CollisionContext collisioncontext;
        Player player = context.getPlayer();
        CollisionContext collisionContext = collisioncontext = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        if ((!this.mustSurvive() || state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) && context.getLevel().isUnobstructed(state, context.getClickedPos(), collisioncontext) && player.isShiftKeyDown()) {
            return true;
        }
        this.use(player.level(), player, context.getHand());
        return false;
    }

    public static boolean updateClientList(OmniCommandData data) {
        for (int i = 0; i < 16; ++i) {
            OmniCommand cmd = data.commands[i];
            if (cmd.getAction() != 10 || data.isCommandDisabled(i)) continue;
            return true;
        }
        return false;
    }

    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        stack.set(net.minecraft.core.component.DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(7));
        return stack;
    }

    public UpgradeDestination getUpgrade() {
        return this;
    }

    static void setDiskInventory(ItemStack stack, DiskInventory diskInventory, Level level) {
        VirtualContainerUtil.saveVirtualInventory((Container)diskInventory, stack, level);
    }

    public static OmniItemProxxy UpdatePlayerTransferCache(ItemStack stack, Level level, @Nullable FilteredContainer inventory) {
        OmniItemProxxy old;
        OmniCommandData omniData;
        UUID id = OmniGridBlockItem.getOrCreate(stack);
        DiskInventoryListenerImpl listener = new DiskInventoryListenerImpl(level);
        OmniUtilityInventory inv = inventory != null ? (OmniUtilityInventory)inventory : OmniGridBlockItem.createDiskInventory(stack, listener, level);
        if (stack.has(DataComponents.INSTANCE.CData())) {
            stack.remove(DataComponents.INSTANCE.CData());
        }
        if ((omniData = VirtualContainerUtil.loadOmniDataFromVirtual(stack, level)) == null) {
            omniData = new OmniCommandData();
            VirtualContainerUtil.saveOmniDataToVirtual(omniData, stack, level);
        }
        OmniItemProxxy newProxxy = new OmniItemProxxy(inv, omniData, level, id, null, null, OmniGridBlockItem.createEnergyStorage(stack));
        if (stack.has(net.minecraft.core.component.DataComponents.CUSTOM_MODEL_DATA)) {
            newProxxy.color = ((CustomModelData)stack.get(net.minecraft.core.component.DataComponents.CUSTOM_MODEL_DATA)).value();
        }
        if (newProxxy.utilityTypes.contains((Object)UtilityType.DURABLE)) {
            if (!stack.has(net.minecraft.core.component.DataComponents.UNBREAKABLE)) {
                stack.set(net.minecraft.core.component.DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
            }
        } else {
            stack.remove(net.minecraft.core.component.DataComponents.UNBREAKABLE);
        }
        if (stack.has(net.minecraft.core.component.DataComponents.CUSTOM_NAME)) {
            newProxxy.name = (Component)stack.get(net.minecraft.core.component.DataComponents.CUSTOM_NAME);
        }
        if ((old = GLOBAL_STORAGES.get(id)) != null) {
            TransferUtils.transferProxxyData(old, newProxxy);
        } else {
            newProxxy.accumulatedXp = omniData.getFurnaceData().accumulatedXp;
            newProxxy.fuel = omniData.getFurnaceData().fuel;
        }
        if (ModList.get().isLoaded("curios")) {
            short type = ModInitializer.getHighestCuriosTier(newProxxy.utilityTypes);
            if (type > 0) {
                stack.set(DataComponents.INSTANCE.getCuriosData(), (Object)new CurioStats(ModInitializer.getHighestCuriosTier(newProxxy.utilityTypes), omniData.getNormalCoresInstalled(), omniData.getStrongCoresInstalled(), omniData.getTotalUpgradesInstalled()));
                stack.set(DataComponents.INSTANCE.getCuriosData(), (Object)new CurioStats(ModInitializer.getHighestCuriosTier(newProxxy.utilityTypes), omniData.getNormalCoresInstalled(), omniData.getStrongCoresInstalled(), omniData.getTotalUpgradesInstalled()));
            } else if (stack.has(DataComponents.INSTANCE.getCuriosData())) {
                stack.remove(DataComponents.INSTANCE.getCuriosData());
            }
        }
        newProxxy.setUpdatedData(omniData);
        GLOBAL_STORAGES.put(id, newProxxy);
        VirtualContainerUtil.saveOmniDataToVirtual(omniData, stack, level);
        return newProxxy;
    }

    public static void virtualStorageRegistry(ItemStack stack, Level level, Entity entity) {
        CompoundTag tag;
        if (level.isClientSide) {
            return;
        }
        com.refinedmods.refinedstorage.common.content.DataComponents rsData = com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE;
        DataComponents omniData = DataComponents.INSTANCE;
        if (stack.has(rsData.getStorageReference())) {
            return;
        }
        ItemStack virtualDisk = new ItemStack((ItemLike)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getItemStorageDisk(ItemStorageVariant.ONE_K));
        virtualDisk.inventoryTick(level, entity, 0, false);
        UUID newRef = (UUID)virtualDisk.get(rsData.getStorageReference());
        if (newRef == null) {
            System.err.println("[OmniGridMigration] Failed to initialize virtual storage reference!");
            return;
        }
        stack.set(rsData.getStorageReference(), (Object)newRef);
        StorageRepository repo = RefinedStorageApi.INSTANCE.getStorageRepository(level);
        Optional optStorage = repo.get(newRef);
        if (optStorage.isEmpty()) {
            System.err.println("[OmniGridMigration] Could not find virtual storage repository for " + String.valueOf(newRef));
            return;
        }
        SerializableStorage storage = (SerializableStorage)optStorage.get();
        CustomData beData = (CustomData)stack.get(net.minecraft.core.component.DataComponents.BLOCK_ENTITY_DATA);
        if (beData != null && (tag = beData.copyTag()).contains("inv")) {
            CompoundTag invTag = tag.getCompound("inv");
            SimpleContainer inv = new SimpleContainer(80);
            ContainerUtil.read((CompoundTag)invTag, (Container)inv, (HolderLookup.Provider)level.registryAccess());
            VirtualContainerUtil.saveVirtualInventory((Container)inv, stack, level);
            repo.markAsChanged();
            tag.remove("inv");
            stack.set(net.minecraft.core.component.DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            System.out.println("[OmniGridMigration] Migrated items from legacy 'inv' to virtual storage for " + stack.getDisplayName().getString());
        }
        if (stack.has(omniData.CData())) {
            OmniCommandData commandData = (OmniCommandData)stack.get(omniData.CData());
            if (commandData != null) {
                boolean success = VirtualContainerUtil.saveOmniDataToVirtual(commandData, newRef, level);
                if (success) {
                    System.out.println("[OmniGridMigration] Migrated OmniCommandData to virtual storage for " + stack.getDisplayName().getString());
                } else {
                    System.err.println("[OmniGridMigration] Failed to migrate OmniCommandData for " + stack.getDisplayName().getString());
                }
            }
            stack.remove(omniData.CData());
            if (stack.has(net.minecraft.core.component.DataComponents.LORE)) {
                stack.remove(net.minecraft.core.component.DataComponents.LORE);
            }
        }
        System.out.println("[OmniGridMigration] Migration complete for " + stack.getDisplayName().getString());
    }

    public static void dumpThreads() {
        Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> e : all.entrySet()) {
            Thread t = e.getKey();
            LOGGER.error("=== THREAD {} | {} | {} ===", new Object[]{t.getName(), t.getState(), t.isDaemon() ? "daemon" : "user"});
            for (StackTraceElement el : e.getValue()) {
                LOGGER.error("  at {}", (Object)el);
            }
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        long extracted;
        long deficit;
        boolean energyLow;
        IEnergyStorage energyStorage;
        ServerPlayer player;
        block38: {
            block37: {
                if (!(entity instanceof ServerPlayer)) break block37;
                player = (ServerPlayer)entity;
                if (!level.isClientSide) break block38;
            }
            return;
        }
        OmniGridBlockItem.virtualStorageRegistry(stack, level, entity);
        OmniItemProxxy proxxy = OmniGridBlockItem.getOrCreateProxy(stack, level);
        if (proxxy == null) {
            OmniGridBlockItem.UpdatePlayerTransferCache(stack, level, null);
            return;
        }
        proxxy.taskCenterPosition = player.blockPosition();
        if (proxxy.isDirty()) {
            FurnaceData data;
            proxxy.getCachedData().furnaceData = data = proxxy.getCachedData().furnaceData;
            OmniGridBlockItem.UpdatePlayerTransferCache(stack, level, null);
            proxxy.setDirty(false);
            player.getInventory().setChanged();
        }
        if (proxxy.utilityTypes.contains((Object)UtilityType.CURIOS_5) || proxxy.utilityTypes.contains((Object)UtilityType.CREATIVE)) {
            ++proxxy.healCD;
            if (proxxy.healCD >= 100) {
                if (player.getAttribute(ModInitializer.HEALTH_REGEN) != null) {
                    player.heal((float)player.getAttribute(ModInitializer.HEALTH_REGEN).getValue() / 12.0f);
                }
                proxxy.healCD = 0;
            }
        }
        int stored = (energyStorage = (IEnergyStorage)Capabilities.EnergyStorage.ITEM.getCapability(stack, null)) != null ? energyStorage.getEnergyStored() : 0;
        int max = energyStorage != null ? energyStorage.getMaxEnergyStored() : 0;
        boolean bl = energyLow = max > 0 && (double)stored < (double)max * 0.1;
        if (energyLow && RefinedTypesUtil.rtInstalled() && (deficit = (long)(max / 2 - stored)) > 0L && (extracted = RefinedTypesUtil.safeEnergyExtract((Storage)proxxy.getOrCreateStorage(), deficit, Action.EXECUTE)) > 0L) {
            energyStorage.receiveEnergy((int)extracted, false);
            proxxy.updateGridIfOpen((PlatformResourceKey)EnergyResource.createEnergyResource(), -extracted);
            stored = energyStorage.getEnergyStored();
        }
        if (stored <= 0) {
            proxxy.taskTimer = 0;
            return;
        }
        if (!level.isClientSide && proxxy.overclock > 0 && proxxy.player != null && player != null) {
            this.spawnOverclockParticles(player, proxxy.utilityTypes.contains((Object)UtilityType.OVERCLOCKER));
        }
        if (proxxy.diminishStress(OmniGridBlockItem.createEnergyStorage(stack))) {
            return;
        }
        if (proxxy.attemptProcess()) {
            ArrayList<OmniGridTask> tasks;
            boolean isHeld;
            proxxy.equipped = isHeld = isSelected || slot == 40 || TransferUtils.isThisStackEquipped((Player)player, stack);
            if (proxxy.player == null) {
                proxxy.player = player.getUUID();
                com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient(player, (CustomPacketPayload)new OmniClientBlockPacket(proxxy.uuid, proxxy.getCachedData().blockTargets));
            } else {
                proxxy.handleFire((Player)player);
            }
            boolean smeltingChange = false;
            if (proxxy.getCachedData().isCoreInstalled(CoreTypes.FURNACE)) {
                smeltingChange = proxxy.attemptSmelt(level, (Player)player);
            }
            boolean craftingChange = false;
            if (proxxy.getCachedData().isCoreInstalled(CoreTypes.AUTOCRAFTING)) {
                craftingChange = proxxy.getTaskManager().tickCrafting(level, (Player)player);
            } else if (!proxxy.getTaskManager().getTasks().isEmpty()) {
                proxxy.getTaskManager().clearAll();
            }
            boolean taskChange = false;
            for (int i = 0; !(i >= 1 || proxxy.utilityTypes.contains((Object)UtilityType.LIMITER) && !isHeld || proxxy.utilityTypes.contains((Object)UtilityType.LIMITER_INVERTED) && isHeld || (tasks = proxxy.getCachedTasks()) == null || tasks.isEmpty()); ++i) {
                proxxy.doTasks(isHeld, (Player)player);
            }
            if (taskChange || craftingChange || smeltingChange || proxxy.dirtyUI) {
                proxxy.resetUI((Player)player);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = player;
                if (sp.containerMenu == sp.inventoryMenu && isHeld) {
                    proxxy.updateTracked(sp, OmniGridBlockItem.getOrCreate(stack));
                }
            }
        }
        if (STOP_CLIENT_SERVER.containsKey(player.getUUID())) {
            if (player.containerMenu != player.inventoryMenu && !(player.containerMenu instanceof AbstractOmniGridContainerMenu)) {
                BlockHitResult result;
                boolean showQuantity = false;
                boolean showNotif = false;
                int activity = 0;
                OmniRootStorage storage = proxxy.getOrCreateStorage();
                for (OmniGridTask task : proxxy.cachedTasks) {
                    if (!task.open) continue;
                    activity += TransferUtils.takeFromContainerMenu(task, storage, (Player)player);
                    if (task.notification == LootNotification.QUANTITY || task.notification == LootNotification.BOTH) {
                        showQuantity = true;
                    }
                    if (task.notification == LootNotification.NONE) continue;
                    showNotif = true;
                }
                proxxy.stress += (float)activity;
                player.closeContainer();
                if (showNotif) {
                    if (activity > 0) {
                        if (showQuantity) {
                            player.displayClientMessage((Component)Component.literal((String)("Deposited " + activity + " items into Omni Grid storage")).withStyle(ChatFormatting.AQUA), true);
                        }
                    } else {
                        player.displayClientMessage((Component)Component.literal((String)"No items deposited").withStyle(ChatFormatting.DARK_RED), true);
                    }
                }
                if ((result = ModInitializer.getLookedAtBlock((Player)player, player.blockInteractionRange() + 1.0)).getBlockPos() != null) {
                    com.refinedmods.refinedstorage.common.Platform.INSTANCE.sendPacketToClient(player, (CustomPacketPayload)new OmniEffectPacket(result.getBlockPos().asLong(), (byte)proxxy.color, activity > 0));
                }
            }
            STOP_CLIENT_SERVER.remove(player.getUUID());
        }
        if (energyStorage != null) {
            if (proxxy.utilityTypes.contains((Object)UtilityType.CREATIVE)) {
                proxxy.stress = 0.0f;
                proxxy.fuel = 25000;
                proxxy.getCachedData().furnaceData.fuel = 25000;
                if (energyStorage.getEnergyStored() < energyStorage.getMaxEnergyStored()) {
                    energyStorage.receiveEnergy(energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored(), false);
                }
            }
            if (energyStorage.getEnergyStored() > energyStorage.getMaxEnergyStored()) {
                int overflow = energyStorage.getEnergyStored() - energyStorage.getMaxEnergyStored();
                energyStorage.extractEnergy(overflow, false);
            }
        }
        GLOBAL_STORAGES.put(OmniGridBlockItem.getOrCreate(stack), proxxy);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        IItemHandler handler;
        BlockEntity be;
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) != null && (handler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(level, pos, state, be, null)) != null) {
            return false;
        }
        return super.mineBlock(stack, level, state, pos, entity);
    }

    public boolean canAttackBlock(BlockState state, Level world, BlockPos pos, Player player) {
        IItemHandler handler;
        BlockEntity be;
        Level level = player.level();
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) != null && (handler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(level, pos, state, be, null)) != null) {
            return false;
        }
        return super.canAttackBlock(state, world, pos, player);
    }

    public static UUID getOrCreate(ItemStack stack) {
        return (UUID)stack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference());
    }

    public static OmniItemProxxy getOrCreateProxy(ItemStack stack, Level level) {
        UUID id = OmniGridBlockItem.getOrCreate(stack);
        OmniItemProxxy proxy = GLOBAL_STORAGES.get(id);
        if (proxy == null) {
            proxy = OmniGridBlockItem.UpdatePlayerTransferCache(stack, level, null);
            GLOBAL_STORAGES.put(id, proxy);
        }
        return proxy;
    }

    public static EnergyStorage createEnergyStorage(ItemStack stack) {
        int powerMultiplier = 1;
        if (GLOBAL_STORAGES.containsKey(stack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()))) {
            powerMultiplier += OmniGridBlockItem.GLOBAL_STORAGES.get((Object)stack.get((DataComponentType)com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference())).energy;
        } else if (MAX_POWER_CACHE.containsKey(stack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference())) && FMLEnvironment.dist.isClient()) {
            powerMultiplier = MAX_POWER_CACHE.get(stack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference())).shortValue();
        }
        UpgradeableEnergyStorage energyStorage = new UpgradeableEnergyStorage(Platform.getConfig().getOmniGrid().getEnergyCapacity() * (long)powerMultiplier, (UUID)stack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference()));
        return RefinedStorageApi.INSTANCE.asBlockItemEnergyStorage((EnergyStorage)energyStorage, stack, BlockEntities.INSTANCE.getOmniGrid());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level.getServer() != null) {
                SlotReference slotReference = RefinedStorageApi.INSTANCE.createInventorySlotReference(player, hand);
                slotReference.resolve(player).ifPresent(s -> this.use(serverPlayer, (ItemStack)s, slotReference));
            }
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public static int getSerializedSize(ItemStack stack, Level level) {
        try {
            CompoundTag tag = (CompoundTag)stack.saveOptional((HolderLookup.Provider)level.registryAccess());
            if (tag == null) {
                return 0;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (DataOutputStream dos = new DataOutputStream(baos);){
                NbtIo.write((CompoundTag)tag, (DataOutput)dos);
            }
            return baos.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void use(ServerPlayer player, ItemStack stack, SlotReference slotReference) {
        OmniGrid omniGrid;
        OmniGridEnergyStorage energyStorage = this.createEnergyStorageInternal(stack);
        ServerLevel level = player.serverLevel();
        DiskInventoryListenerImpl listener = new DiskInventoryListenerImpl((Level)level);
        OmniItemProxxy proxxy = OmniGridBlockItem.getOrCreateProxy(stack, (Level)level);
        OmniUtilityInventory diskInventory = proxxy.getInventory();
        diskInventory.setStorageRepository(RefinedStorageApi.INSTANCE.getStorageRepository((Level)level));
        OmniCommandData data = VirtualContainerUtil.loadOmniDataFromVirtual(stack, (Level)level);
        data.furnaceData = proxxy.getCachedData().furnaceData;
        data.furnaceData.fuel = proxxy.fuel;
        proxxy.dirtyUI = true;
        proxxy.distributeXP(player);
        VirtualContainerUtil.writeCoresFromOmniData((Container)diskInventory, data);
        UUID id = OmniGridBlockItem.getOrCreate(stack);
        listener.omniGrid = omniGrid = new OmniGrid((EnergyStorage)energyStorage, () -> {}, id, (Level)level);
        energyStorage.omniGrid = omniGrid;
        omniGrid.updateStorage();
        omniGrid.initRecipie(() -> ((ServerPlayer)player).level());
        com.refinedmods.refinedstorage.common.Platform.INSTANCE.getMenuOpener().openMenu(player, (MenuProvider)new OmniGridItemExtendedMenuProvider((Component)Objects.requireNonNullElse((Component)stack.get(net.minecraft.core.component.DataComponents.CUSTOM_NAME), ContentNames.omni_grid), omniGrid, (EnergyStorage)energyStorage, diskInventory, slotReference, data));
    }

    private OmniGridEnergyStorage createEnergyStorageInternal(ItemStack stack) {
        return new OmniGridEnergyStorage(OmniGridBlockItem.createEnergyStorage(stack));
    }

    public static OmniUtilityInventory createDiskInventory(ItemStack stack, DiskInventoryListenerImpl listener, Level level) {
        OmniUtilityInventory inv = new OmniUtilityInventory(listener, 80);
        VirtualContainerUtil.getVirtualInventory(inv, stack, level);
        return inv;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        UUID ref = (UUID)stack.get(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference());
        if (ref != null && UpdateTracker.CLIENT_TRACKERS.containsKey(ref)) {
            ClientResourceTracker tracker = UpdateTracker.CLIENT_TRACKERS.get(ref);
            PlatformResourceKey[] res = tracker.resources();
            boolean anyTracked = false;
            for (PlatformResourceKey key : res) {
                if (key == null) continue;
                anyTracked = true;
                break;
            }
            if (anyTracked) {
                return Optional.of(new ResourceTrackerTooltipComponent(tracker.resources(), tracker.counts()));
            }
        }
        return Optional.of(new HelpTooltipComponent((Component)Component.literal((String)"An upgraded version of the Portable Grid with a built-in crafting grid and can gain further functions with Omni Cores.")));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        super.appendHoverText(stack, context, lines, flag);
    }

    public Component getName() {
        return Component.literal((String)"Omni Grid");
    }

    public Component getName(ItemStack stack) {
        Component name = super.getName(stack);
        if (stack.has(net.minecraft.core.component.DataComponents.CUSTOM_NAME)) {
            return (Component)stack.get(net.minecraft.core.component.DataComponents.CUSTOM_NAME);
        }
        return name;
    }

    public ItemStack getStackRepresentation() {
        return new ItemStack((ItemLike)Items.INSTANCE.getOmniGrid());
    }

    private void spawnOverclockParticles(ServerPlayer player, boolean blue) {
        ServerLevel server = player.serverLevel();
        if (server.random.nextFloat() >= 0.1f) {
            return;
        }
        boolean main = player.getMainHandItem().getItem() instanceof OmniGridBlockItem;
        boolean off = player.getOffhandItem().getItem() instanceof OmniGridBlockItem;
        if (!main && !off) {
            return;
        }
        Vec3 base = player.position().add(0.0, (double)player.getBbHeight() * 0.75, 0.0);
        Vec3 look = player.getLookAngle().normalize();
        Vec3 side = new Vec3(look.z, 0.0, -look.x).normalize();
        Vec3 sideOffset = side.scale(off ? 0.35 : -0.35);
        Vec3 forward = look.scale(0.4);
        Vec3 pos = base.add(sideOffset).add(forward);
        SimpleParticleType particle = blue ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME;
        server.sendParticles((ParticleOptions)particle, pos.x, pos.y, pos.z, 2, 0.04, 0.01, 0.04, 0.01);
    }

    public static class DiskInventoryListenerImpl
    implements DiskInventory.DiskListener {
        private final Level level;
        @Nullable
        private OmniGrid omniGrid;

        public DiskInventoryListenerImpl(Level level) {
            this.level = level;
        }

        public void onDiskChanged(DiskInventory inventory, int slot) {
            boolean isActive;
            boolean stillLoading;
            boolean bl = stillLoading = this.omniGrid == null;
            if (stillLoading) {
                return;
            }
            boolean wasActive = this.omniGrid.isGridActive();
            this.omniGrid.updateStorage();
            if (this.omniGrid.storage != null) {
                ModInitializer.SaveProxxyInventory(this.omniGrid.storage.id, this.level, (FilteredContainer)inventory);
                this.omniGrid.storage.getProxxy().setDirty(true);
            }
            if (wasActive != (isActive = this.omniGrid.isGridActive())) {
                this.omniGrid.activeChanged(isActive);
            }
        }
    }

    private static class OmniGridEnergyStorage
    extends AbstractProxyEnergyStorage {
        @Nullable
        private OmniGrid omniGrid;

        private OmniGridEnergyStorage(EnergyStorage energyStorage) {
            super(energyStorage);
        }

        public long extract(long amount, Action action) {
            if (action == Action.EXECUTE && this.omniGrid != null) {
                boolean wasActive = this.omniGrid.isGridActive();
                long extracted = super.extract(amount, action);
                boolean isActive = this.omniGrid.isGridActive();
                if (wasActive != isActive) {
                    this.omniGrid.activeChanged(isActive);
                }
                return extracted;
            }
            return super.extract(amount, action);
        }
    }
}

