/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.neoforge.AbstractOmniGridBlockEntity;
import com.omnigrid.neoforge.AbstractOmniGridEntity;
import com.omnigrid.neoforge.BlockEntities;
import com.omnigrid.neoforge.BlockEntityProvider;
import com.omnigrid.neoforge.DataComponents;
import com.omnigrid.neoforge.Items;
import com.omnigrid.neoforge.OmniCommandData;
import com.omnigrid.neoforge.OmniGridBlockEntityTicker;
import com.refinedmods.refinedstorage.api.network.impl.node.storage.StorageNetworkNode;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.direction.BiDirectionType;
import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OmniGridBlock
extends AbstractDirectionalBlock<BiDirection>
implements EntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final IntegerProperty CUSTOM_MODEL_DATA = IntegerProperty.create((String)"custom_model_data", (int)0, (int)22);
    private static final Component HELP = IdentifierUtil.createTranslation((String)"item", (String)"cable.help");
    private static final VoxelShape SHAPE_HORIZONTAL = OmniGridBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.2, (double)16.0);
    private static final VoxelShape SHAPE_VERTICAL_SOUTH = OmniGridBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.2);
    private static final VoxelShape SHAPE_VERTICAL_NORTH = OmniGridBlock.box((double)0.0, (double)0.0, (double)2.8000000000000007, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_VERTICAL_EAST = OmniGridBlock.box((double)0.0, (double)0.0, (double)0.0, (double)13.2, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_VERTICAL_WEST = OmniGridBlock.box((double)2.8000000000000007, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final OmniGridBlockEntityTicker<StorageNetworkNode, AbstractOmniGridEntity> TICKER = new OmniGridBlockEntityTicker(BlockEntities.INSTANCE::getOmniGrid);
    private final BlockEntityProvider<AbstractOmniGridEntity> blockEntityProvider;

    public OmniGridBlock(BlockEntityProvider<AbstractOmniGridEntity> blockEntityProvider) {
        super(BlockBehaviour.Properties.of().strength(0.1f, 4.0f).sound(SoundType.COPPER_GRATE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)CUSTOM_MODEL_DATA, (Comparable)Integer.valueOf(7))).setValue((Property)this.getDirectionType().getProperty(), (Comparable)BiDirection.SOUTH)).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.blockEntityProvider = blockEntityProvider;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CUSTOM_MODEL_DATA});
        builder.add(new Property[]{ACTIVE});
    }

    protected BlockState getDefaultState() {
        return (BlockState)((BlockState)super.getDefaultState().setValue((Property)CUSTOM_MODEL_DATA, (Comparable)Integer.valueOf(7))).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    @Deprecated
    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack stack = Items.INSTANCE.getFakeOmniGrid().getDefaultInstance();
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof AbstractOmniGridEntity) {
            AbstractOmniGridEntity og = (AbstractOmniGridEntity)be;
            CustomModelData model = (CustomModelData)og.components().get(net.minecraft.core.component.DataComponents.CUSTOM_MODEL_DATA);
            stack.set(net.minecraft.core.component.DataComponents.CUSTOM_MODEL_DATA, (Object)model);
        }
        return stack;
    }

    protected DirectionType<BiDirection> getDirectionType() {
        return BiDirectionType.INSTANCE;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractOmniGridBlockEntity) {
            AbstractOmniGridBlockEntity be = (AbstractOmniGridBlockEntity)blockEntity;
            return Math.min(15, be.activeTaskCount);
        }
        return 0;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BiDirection direction;
        EnumProperty directionProperty = this.getDirectionType().getProperty();
        BiDirection val = (BiDirection)state.getValue((Property)directionProperty);
        switch (val) {
            default: {
                throw new MatchException(null, null);
            }
            case UP_SOUTH: 
            case DOWN_SOUTH: 
            case SOUTH: {
                BiDirection biDirection = BiDirection.SOUTH;
                break;
            }
            case UP_NORTH: 
            case DOWN_NORTH: 
            case NORTH: {
                BiDirection biDirection = BiDirection.NORTH;
                break;
            }
            case UP_EAST: 
            case DOWN_EAST: 
            case EAST: {
                BiDirection biDirection = BiDirection.EAST;
                break;
            }
            case UP_WEST: 
            case DOWN_WEST: 
            case WEST: {
                BiDirection biDirection = direction = BiDirection.WEST;
            }
        }
        if (direction == null) {
            return SHAPE_HORIZONTAL;
        }
        VoxelShape d = switch (direction) {
            case BiDirection.SOUTH -> SHAPE_VERTICAL_SOUTH;
            case BiDirection.NORTH -> SHAPE_VERTICAL_NORTH;
            case BiDirection.EAST -> SHAPE_VERTICAL_EAST;
            case BiDirection.WEST -> SHAPE_VERTICAL_WEST;
            default -> SHAPE_HORIZONTAL;
        };
        return OmniGridBlock.box((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)13.0, (double)15.9);
    }

    public boolean skipRendering(BlockState thisState, BlockState adjacentState, Direction direction) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        ItemStack stack = context.getItemInHand();
        CustomModelData color = (CustomModelData)stack.getOrDefault(net.minecraft.core.component.DataComponents.CUSTOM_MODEL_DATA, (Object)CustomModelData.DEFAULT);
        OmniCommandData data = (OmniCommandData)stack.get(DataComponents.INSTANCE.CData());
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)CUSTOM_MODEL_DATA, (Comparable)Integer.valueOf(color.value()));
        BiDirection facing = (BiDirection)this.getDirectionType().getDirection(context.getClickedFace(), context.getHorizontalDirection(), context.getPlayer() != null ? context.getPlayer().getXRot() : 0.0f);
        BiDirection direction = switch (facing) {
            default -> throw new MatchException(null, null);
            case BiDirection.UP_SOUTH, BiDirection.DOWN_SOUTH, BiDirection.SOUTH -> BiDirection.SOUTH;
            case BiDirection.UP_NORTH, BiDirection.DOWN_NORTH, BiDirection.NORTH -> BiDirection.NORTH;
            case BiDirection.UP_EAST, BiDirection.DOWN_EAST, BiDirection.EAST -> BiDirection.EAST;
            case BiDirection.UP_WEST, BiDirection.DOWN_WEST, BiDirection.WEST -> BiDirection.WEST;
        };
        return (BlockState)state.setValue((Property)this.getDirectionType().getProperty(), (Comparable)direction);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean moving) {
        BlockEntity be;
        super.neighborChanged(state, level, pos, block, fromPos, moving);
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) instanceof AbstractOmniGridBlockEntity) {
            AbstractOmniGridBlockEntity yourBE = (AbstractOmniGridBlockEntity)be;
            yourBE.UpdateTransferCaches();
            yourBE.update(state);
            for (Direction direction : Direction.values()) {
                yourBE.initCache(direction);
            }
        }
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return this.blockEntityProvider.create(blockPos, blockState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TICKER.get(level, type);
    }
}

