/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Utils.MergedPattern;
import com.omnigrid.Utils.OmniProxxyStorage;
import com.omnigrid.neoforge.ClientCraftingGrid;
import com.omnigrid.neoforge.OmniCraftTask;
import com.omnigrid.neoforge.OmniGridBlockItem;
import com.omnigrid.neoforge.OmniGridOperations;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.omnigrid.neoforge.OmniRootStorage;
import com.omnigrid.neoforge.Platform;
import com.refinedmods.refinedstorage.api.autocrafting.Pattern;
import com.refinedmods.refinedstorage.api.autocrafting.PatternRepository;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculator;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CraftingCalculatorImpl;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewCraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewItem;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewType;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreviewCraftingCalculatorListener;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreviewNode;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherManager;
import com.refinedmods.refinedstorage.api.network.impl.node.grid.GridWatcherManagerImpl;
import com.refinedmods.refinedstorage.api.network.node.grid.EmptyGridOperations;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.network.node.grid.GridWatcher;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.NoopStorage;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.TrackedResourceAmount;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.api.storage.tracked.TrackedResource;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.grid.CraftingGrid;
import com.refinedmods.refinedstorage.common.grid.DirectCommitExtractTransaction;
import com.refinedmods.refinedstorage.common.grid.ExtractTransaction;
import com.refinedmods.refinedstorage.common.grid.SnapshotExtractTransaction;
import com.refinedmods.refinedstorage.common.support.RecipeMatrix;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniGrid
implements CraftingGrid {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniGrid.class);
    public final EnergyStorage energyStorage;
    public final GridWatcherManager watchers = new GridWatcherManagerImpl();
    private final StateTrackedStorage.Listener diskListener;
    @Nullable
    protected OmniProxxyStorage storage;
    private ClientCraftingGrid clientCraftingGrid;
    private RecipeMatrix<CraftingRecipe, CraftingInput> craftingRecipe;
    private UUID id;
    public Level level;
    public ArrayList<ResourceAmount> requiredCraftingAmounts = new ArrayList();
    private Player player;
    private boolean watchersAttached = false;
    public boolean bruteForceCrafting = false;
    private static final ExecutorService PREVIEW_EXEC = Executors.newFixedThreadPool(2);
    private static final ExecutorService QUERY_EXEC = Executors.newSingleThreadExecutor();

    public void setId(UUID id) {
        this.id = id;
    }

    OmniGrid(EnergyStorage energyStorage, StateTrackedStorage.Listener diskListener, Level level) {
        this.energyStorage = energyStorage;
        this.diskListener = diskListener;
        this.level = level;
    }

    OmniGrid(EnergyStorage energyStorage, StateTrackedStorage.Listener diskListener, UUID id, Level level) {
        this.energyStorage = energyStorage;
        this.diskListener = diskListener;
        this.id = id;
        this.level = level;
    }

    void initRecipie(Supplier<Level> levelSupplier) {
        this.craftingRecipe = this.createMatrix(levelSupplier, () -> {});
    }

    boolean updateStorage() {
        OmniItemProxxy proxy;
        if (this.storage == null) {
            this.storage = new OmniProxxyStorage(this.id);
        }
        if ((proxy = OmniGridBlockItem.GLOBAL_STORAGES.get(this.id)) != null) {
            proxy.getOrCreateStorage();
        }
        if (!this.watchersAttached) {
            this.watchers.attachAll((RootStorage)this.storage);
            this.watchersAttached = true;
        }
        return true;
    }

    public static RecipeMatrix<CraftingRecipe, CraftingInput> crafting(Runnable listener, Supplier<@NullableType Level> levelSupplier) {
        return new RecipeMatrix(listener, levelSupplier, 3, 3, CraftingContainer::asCraftInput, RecipeType.CRAFTING);
    }

    private RecipeMatrix<CraftingRecipe, CraftingInput> createMatrix(Supplier<Level> levelSupplier, Runnable listener) {
        RecipeMatrix recipe = RecipeMatrix.crafting((Runnable)listener, levelSupplier);
        this.setMatrixSlots((RecipeMatrix<CraftingRecipe, CraftingInput>)recipe);
        return recipe;
    }

    private void setMatrixSlots(RecipeMatrix<CraftingRecipe, CraftingInput> recipe) {
        this.clientCraftingGrid = new ClientCraftingGrid();
        CraftingInput.Positioned positioned = this.clientCraftingGrid.getCraftingMatrix().asPositionedCraftInput();
        int left = positioned.left();
        int top = positioned.top();
        CraftingInput input = positioned.input();
        for (int y = 0; y < input.height(); ++y) {
            for (int x = 0; x < input.width(); ++x) {
                int matrixIndex = x + left + (y + top) * recipe.getMatrix().getWidth();
                recipe.getMatrix().setItem(matrixIndex, input.getItem(x, y).copy());
            }
        }
    }

    void activeChanged(boolean active) {
        this.watchers.activeChanged(active);
    }

    public void addWatcher(GridWatcher watcher, Class<? extends Actor> actorType) {
        this.energyStorage.extract(Platform.getConfig().getOmniGrid().getOpenEnergyUsage(), Action.EXECUTE);
        this.watchers.addWatcher(watcher, actorType, (RootStorage)this.getRootStorage());
    }

    public void removeWatcher(GridWatcher watcher) {
        this.watchers.removeWatcher(watcher, (RootStorage)this.getRootStorage());
    }

    @Nullable
    private OmniProxxyStorage getRootStorage() {
        return this.storage;
    }

    public Storage getItemStorage() {
        if (this.storage == null) {
            return new NoopStorage();
        }
        return this.storage;
    }

    public boolean isGridActive() {
        return this.energyStorage.getStored() > 0L && this.storage != null;
    }

    public List<TrackedResourceAmount> getResources(Class<? extends Actor> actorType) {
        if (this.storage == null) {
            return Collections.emptyList();
        }
        OmniRootStorage rootStorage = this.storage.resolveStorage();
        if (rootStorage != null) {
            return rootStorage.getAll().stream().map(resource -> new TrackedResourceAmount(resource, (TrackedResource)rootStorage.findTrackedResourceByActorType(resource.resource(), actorType).orElse(null))).toList();
        }
        return this.storage.getAll().stream().map(resource -> new TrackedResourceAmount(resource, (TrackedResource)this.storage.findTrackedResourceByActorType(resource.resource(), actorType).orElse(null))).toList();
    }

    public Set<PlatformResourceKey> getAutocraftableResources() {
        HashSet<PlatformResourceKey> result = new HashSet<PlatformResourceKey>();
        for (List<Pattern> patterns : OmniGridBlockItem.GLOBAL_STORAGES.get((Object)this.id).patternsByResource.values()) {
            for (Pattern pattern : patterns) {
                for (ResourceAmount res : pattern.layout().outputs()) {
                    result.add((PlatformResourceKey)res.resource());
                }
            }
        }
        return result;
    }

    public GridOperations createOperations(ResourceType resourceType, ServerPlayer player) {
        if (this.storage == null) {
            return EmptyGridOperations.INSTANCE;
        }
        OmniProxxyStorage rootStorage = this.storage;
        GridOperations operations = resourceType.createGridOperations((RootStorage)rootStorage, (Actor)this.HighlightPlayerActor((Player)player));
        return new OmniGridOperations(operations, this.energyStorage);
    }

    public boolean canMenuStayOpen(Player player) {
        return true;
    }

    public void balanceItems() {
        boolean notDone = true;
        while (notDone) {
            notDone = false;
            for (int i = 0; i < 9; ++i) {
                ItemStack item = this.getCraftingMatrix().getItem(i);
                if (item.isEmpty()) continue;
                for (int o = 0; o < 9; ++o) {
                    ItemStack item2 = this.getCraftingMatrix().getItem(o);
                    if (!ItemStack.isSameItem((ItemStack)item, (ItemStack)item2) || item.getCount() - 1 <= item2.getCount()) continue;
                    item.setCount(item.getCount() - 1);
                    item2.setCount(item2.getCount() + 1);
                    notDone = true;
                }
            }
        }
    }

    public void depositItems(Player player, boolean deposit, ItemStack filter) {
        ItemStack filt = new ItemStack((ItemLike)Items.BARRIER);
        OmniProxxyStorage storage = this.getRootStorage();
        if (storage == null) {
            return;
        }
        Inventory inv = player.getInventory();
        if (deposit) {
            for (int i = 9; i < 36; ++i) {
                ItemResource res;
                long moved;
                boolean matches;
                ItemStack item = inv.getItem(i);
                if (item.isEmpty() || item.getItem() instanceof OmniGridBlockItem) continue;
                boolean bl = matches = ItemStack.isSameItem((ItemStack)filt, (ItemStack)filter) || ItemStack.isSameItem((ItemStack)item, (ItemStack)filter);
                if (!matches || (moved = storage.insert((ResourceKey)(res = ItemResource.ofItemStack((ItemStack)item)), item.getCount(), Action.EXECUTE, (Actor)this.HighlightPlayerActor(player))) <= 0L) continue;
                item.shrink((int)moved);
            }
            return;
        }
        ArrayList<ResourceAmount> resources = new ArrayList<ResourceAmount>(storage.getAll());
        block1: for (ResourceAmount ra : resources) {
            boolean matches;
            ItemResource itemRes;
            ItemStack stack;
            ResourceKey moved = ra.resource();
            if (!(moved instanceof ItemResource) || (stack = (itemRes = (ItemResource)moved).toItemStack()).getItem() instanceof OmniGridBlockItem || !(matches = ItemStack.isSameItem((ItemStack)filt, (ItemStack)filter) || ItemStack.isSameItem((ItemStack)filter, (ItemStack)stack))) continue;
            do {
                int slot;
                if ((slot = inv.getFreeSlot()) == -1) {
                    return;
                }
                long extracted = storage.extract((ResourceKey)itemRes, 64L, Action.EXECUTE, (Actor)this.HighlightPlayerActor(player));
                if (extracted <= 0L) continue block1;
                inv.setItem(slot, stack.copyWithCount((int)extracted));
            } while (storage.get((ResourceKey)itemRes) > 0L);
        }
    }

    public PlayerActor HighlightPlayerActor(Player player) {
        return new PlayerActor("\u00a7a" + player.getGameProfile().getName());
    }

    public void spreadItems() {
        RecipeMatrixContainer craftingGrid = this.getCraftingMatrix();
        int size = 9;
        HashMap<ItemStack, List> itemSlots = new HashMap<ItemStack, List>();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = craftingGrid.getItem(i);
            if (stack.isEmpty()) continue;
            itemSlots.computeIfAbsent(stack.copy(), k -> new ArrayList()).add(i);
        }
        for (Map.Entry entry : itemSlots.entrySet()) {
            Object slotStack;
            ItemStack item = (ItemStack)entry.getKey();
            List occupiedSlots = (List)entry.getValue();
            LinkedHashSet<Integer> allRelevantSlots = new LinkedHashSet<Integer>(occupiedSlots);
            for (int i = 0; i < size; ++i) {
                slotStack = craftingGrid.getItem(i);
                if (!slotStack.isEmpty() || !craftingGrid.canPlaceItem(i, item.copy())) continue;
                allRelevantSlots.add(i);
            }
            int total = 0;
            slotStack = occupiedSlots.iterator();
            while (slotStack.hasNext()) {
                int i = (Integer)slotStack.next();
                total += craftingGrid.getItem(i).getCount();
            }
            int numSlots = allRelevantSlots.size();
            int base = total / numSlots;
            int remainder = total % numSlots;
            int i = 0;
            Iterator iterator = allRelevantSlots.iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                int count = base + (i < remainder ? 1 : 0);
                if (count > 0) {
                    craftingGrid.setItem(slot, item.copyWithCount(count));
                } else {
                    craftingGrid.setItem(slot, ItemStack.EMPTY);
                }
                ++i;
            }
        }
        this.balanceItems();
    }

    public RecipeMatrixContainer getCraftingMatrix() {
        return Objects.requireNonNull(this.craftingRecipe).getMatrix();
    }

    public NonNullList<ItemStack> getRemainingItems(Player player, CraftingInput craftingInput) {
        return Objects.requireNonNull(this.craftingRecipe).getRemainingItems(player.level(), player, craftingInput);
    }

    public ExtractTransaction startExtractTransaction(Player player, boolean directCommit) {
        if (this.getRootStorage() == null) {
            return ExtractTransaction.NOOP;
        }
        this.getRootStorage().doingJei = this.bruteForceCrafting;
        DirectCommitExtractTransaction commit = directCommit ? new DirectCommitExtractTransaction((RootStorage)this.getRootStorage()) : new SnapshotExtractTransaction(player, (RootStorage)this.getRootStorage(), this.getCraftingMatrix());
        this.getRootStorage().doingJei = false;
        return commit;
    }

    public ResultContainer getCraftingResult() {
        return Objects.requireNonNull(this.craftingRecipe).getResult();
    }

    public boolean clearMatrix(Player player, boolean toPlayerInventory) {
        boolean success;
        boolean bl = success = toPlayerInventory ? this.getCraftingMatrix().clearToPlayerInventory(player) : this.clearMatrixIntoStorage(player);
        if (success) {
            // empty if block
        }
        return success;
    }

    private boolean clearMatrixIntoStorage(Player player) {
        return this.getCraftingMatrix().clearIntoStorage((RootStorage)this.getRootStorage(), player);
    }

    public void transferRecipe(Player player, List<List<ItemResource>> recipe) {
        if (this.storage != null) {
            this.storage.doingJei = this.bruteForceCrafting;
            this.getCraftingMatrix().transferRecipe(player, (RootStorage)this.getRootStorage(), recipe);
            this.storage.doingJei = false;
            if (this.storage.getProxxy() == null) {
                return;
            }
            this.storage.getProxxy().dirtyResourceSlots = true;
        }
    }

    public void acceptQuickCraft(Player player, ItemStack craftedStack) {
        if (player.getInventory().add(craftedStack)) {
            return;
        }
        long inserted = this.getRootStorage().insert((ResourceKey)ItemResource.ofItemStack((ItemStack)craftedStack), craftedStack.getCount(), Action.EXECUTE, (Actor)this.HighlightPlayerActor(player));
        if (inserted != (long)craftedStack.getCount()) {
            long remainder = (long)craftedStack.getCount() - inserted;
            ItemStack remainderStack = craftedStack.copyWithCount((int)remainder);
            player.drop(remainderStack, false);
        }
    }

    public CompletableFuture<Optional<Preview>> getPreview(ResourceKey resource, long amount, CancellationToken token) {
        if (this.storage == null) {
            return CompletableFuture.completedFuture(Optional.of(new Preview(PreviewType.NOT_AVAILABLE, List.of(), List.of())));
        }
        if (!this.storage.getProxxy().getTaskManager().getTasks().isEmpty()) {
            return CompletableFuture.completedFuture(Optional.of(new Preview(PreviewType.NOT_AVAILABLE, List.of(), List.of())));
        }
        return CompletableFuture.supplyAsync(() -> {
            Preview preview = this.resolveLocalPreview(resource, amount, token);
            this.requiredCraftingAmounts.clear();
            if (preview != null) {
                for (PreviewItem item : preview.items()) {
                    this.addCrafting(item);
                }
            }
            this.requiredCraftingAmounts = (ArrayList)OmniGrid.mergeResourceAmounts(this.requiredCraftingAmounts);
            return Optional.of(preview);
        }, PREVIEW_EXEC);
    }

    public CompletableFuture<Optional<TreePreview>> getTreePreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        if (this.storage == null || this.storage.getProxxy() == null) {
            return CompletableFuture.completedFuture(Optional.of(new TreePreview(PreviewType.NOT_AVAILABLE, null, List.of())));
        }
        if (!this.storage.getProxxy().getTaskManager().getTasks().isEmpty()) {
            return CompletableFuture.completedFuture(Optional.of(new TreePreview(PreviewType.CANCELLED, null, List.of())));
        }
        PatternRepository repo = new PatternRepository(){
            private final List<Pattern> patterns = new ArrayList<Pattern>();
            {
                for (List<Pattern> patterns1 : OmniGrid.this.storage.getProxxy().patternsByResource.values()) {
                    this.patterns.addAll(patterns1);
                }
            }

            public Set<Pattern> getAll() {
                return Set.copyOf(this.patterns);
            }

            public void add(Pattern pattern, int priority) {
                this.patterns.add(pattern);
            }

            public void update(Pattern pattern, int priority) {
            }

            public void remove(Pattern pattern) {
                this.patterns.remove(pattern);
            }

            public Collection<Pattern> getByOutput(ResourceKey key) {
                return this.patterns.stream().filter(p -> p.layout().outputs().stream().anyMatch(out -> out.resource().equals((Object)key))).toList();
            }

            public Set<ResourceKey> getOutputs() {
                return this.patterns.stream().flatMap(p -> p.layout().outputs().stream()).map(ResourceAmount::resource).collect(Collectors.toSet());
            }
        };
        OmniRootStorage root = this.storage.resolveStorage();
        CraftingCalculatorImpl calculator = new CraftingCalculatorImpl(repo, (RootStorage)root);
        return CompletableFuture.supplyAsync(() -> this.lambda$getTreePreview$5((CraftingCalculator)calculator, resource, amount, cancellationToken), PREVIEW_EXEC);
    }

    public void compileCrafting(TreePreviewNode node, int index) {
        this.addCrafting(node);
        for (TreePreviewNode n : node.getChildren()) {
            this.compileCrafting(n, index + 1);
        }
    }

    public static List<ResourceAmount> mergeResourceAmounts(List<ResourceAmount> list) {
        if (list == null || list.isEmpty()) {
            return List.of();
        }
        HashMap<ResourceKey, Long> merged = new HashMap<ResourceKey, Long>();
        for (ResourceAmount ra : list) {
            if (ra == null || ra.resource() == null) continue;
            merged.merge(ra.resource(), ra.amount(), Long::sum);
        }
        ArrayList<ResourceAmount> result = new ArrayList<ResourceAmount>();
        for (Map.Entry entry : merged.entrySet()) {
            result.add(new ResourceAmount((ResourceKey)entry.getKey(), ((Long)entry.getValue()).longValue()));
        }
        result.sort(Comparator.comparing(r -> r.resource().toString()));
        return result;
    }

    public void addCrafting(TreePreviewNode item) {
        if (item.getToCraft() > 0L) {
            this.requiredCraftingAmounts.add(new ResourceAmount(item.getResource(), item.getToCraft()));
        }
    }

    public void addCrafting(PreviewItem item) {
        if (item.toCraft() > 0L) {
            this.requiredCraftingAmounts.add(new ResourceAmount(item.resource(), item.toCraft()));
        }
    }

    public CompletableFuture<Long> getMaxAmount(ResourceKey resource, CancellationToken cancellationToken) {
        return CompletableFuture.supplyAsync(() -> this.maxAmountLocal(resource, cancellationToken), QUERY_EXEC);
    }

    public Optional<TaskId> startTask(ResourceKey resource, long amount, Actor actor, boolean notify, CancellationToken token) {
        if (this.storage == null) {
            LOGGER.warn("\u274c No storage \u2014 skipping task start.");
            return Optional.empty();
        }
        OmniItemProxxy proxxy = OmniGridBlockItem.GLOBAL_STORAGES.get(this.id);
        if (proxxy == null) {
            LOGGER.warn("\u274c No proxy found for grid {}", (Object)this.id);
            return Optional.empty();
        }
        if (this.requiredCraftingAmounts == null || this.requiredCraftingAmounts.isEmpty()) {
            LOGGER.warn("\u26a0\ufe0f No required crafting amounts available \u2014 nothing to start");
            return Optional.empty();
        }
        LOGGER.info("\ud83e\uddee Starting task chain for {} \u00d7{}", (Object)resource, (Object)amount);
        LOGGER.info("  Required {} total craftable resources:", (Object)this.requiredCraftingAmounts.size());
        for (ResourceAmount ra : this.requiredCraftingAmounts) {
            LOGGER.info("   \u2022 {} \u00d7{}", (Object)ra.resource(), (Object)ra.amount());
        }
        ArrayList<OmniCraftTask> newTasks = new ArrayList<OmniCraftTask>();
        for (ResourceAmount ra : this.requiredCraftingAmounts) {
            ResourceKey key = ra.resource();
            long totalAmount = ra.amount();
            List<MergedPattern> patternsForKey = proxxy.patterns.get(key);
            if (patternsForKey == null || patternsForKey.isEmpty()) {
                LOGGER.warn("   \u26a0\ufe0f Skipping {}, no crafting patterns found", (Object)key);
                continue;
            }
            MergedPattern pattern = patternsForKey.get(0);
            ItemStack out = pattern.getPrimaryOutput();
            if (out.isEmpty() && pattern.processingOutputs.isEmpty()) {
                LOGGER.warn("   \u26a0\ufe0f Skipping {}, pattern has empty output", (Object)key);
                continue;
            }
            long yield = Math.max(1, out.getCount());
            long craftsNeeded = (totalAmount + yield - 1L) / yield;
            newTasks.add(new OmniCraftTask(key, totalAmount, craftsNeeded, notify));
            LOGGER.info("   \u2705 Queued task: {} \u2192 {} crafts ({} output each)", new Object[]{key, craftsNeeded, yield});
        }
        if (newTasks.isEmpty()) {
            LOGGER.warn("\u26a0\ufe0f No valid tasks could be created.");
            return Optional.empty();
        }
        proxxy.getTaskManager().addAllTasks(newTasks);
        LOGGER.info("\ud83d\udce6 Added {} crafting tasks for {}", (Object)newTasks.size(), (Object)this.id);
        return Optional.of(new TaskId(UUID.randomUUID()));
    }

    private Preview resolveLocalPreview(ResourceKey resource, long amount, CancellationToken token) {
        if (this.storage == null) {
            return new Preview(PreviewType.NOT_AVAILABLE, List.of(), List.of());
        }
        PatternRepository repo = new PatternRepository(){
            private final List<Pattern> patterns = new ArrayList<Pattern>();
            {
                this.patterns.addAll(OmniGrid.this.storage.getProxxy().getPatterns());
            }

            public Set<Pattern> getAll() {
                return Set.copyOf(this.patterns);
            }

            public void add(Pattern pattern, int priority) {
                this.patterns.add(pattern);
            }

            public void update(Pattern pattern, int priority) {
            }

            public void remove(Pattern pattern) {
                this.patterns.remove(pattern);
            }

            public Collection<Pattern> getByOutput(ResourceKey key) {
                return this.patterns.stream().filter(p -> p.layout().outputs().stream().anyMatch(out -> out.resource().equals((Object)key))).toList();
            }

            public Set<ResourceKey> getOutputs() {
                return this.patterns.stream().flatMap(p -> p.layout().outputs().stream()).map(ResourceAmount::resource).collect(Collectors.toSet());
            }
        };
        OmniRootStorage root = this.storage.resolveStorage();
        CraftingCalculatorImpl calculator = new CraftingCalculatorImpl(repo, (RootStorage)root);
        try {
            return PreviewCraftingCalculatorListener.calculatePreview((CraftingCalculator)calculator, (ResourceKey)resource, (long)amount, (CancellationToken)token);
        }
        catch (Exception e) {
            LOGGER.error("Error computing Preview for {}: {}", (Object)resource, (Object)e);
            return new Preview(PreviewType.NOT_AVAILABLE, List.of(), List.of());
        }
    }

    private long getLocalCount(RootStorage root, ResourceKey key) {
        if (root == null) {
            return 0L;
        }
        return root.get(key);
    }

    private long maxAmountLocal(ResourceKey res, CancellationToken token) {
        long hi;
        Preview pv;
        boolean ok;
        long base = this.getLocalCount(this.getRootStorage(), res);
        long lo = 0L;
        for (hi = Math.max(1L, base); (ok = (pv = this.resolveLocalPreview(res, hi, token)).items().stream().allMatch(i -> i.missing() == 0L)) && hi <= 0x4000000000000L; hi <<= 1) {
            lo = hi;
        }
        while (lo < hi) {
            long mid = lo + (hi - lo + 1L >> 1);
            Preview pv2 = this.resolveLocalPreview(res, mid, token);
            boolean ok2 = pv2.items().stream().allMatch(i -> i.missing() == 0L);
            if (ok2) {
                lo = mid;
                continue;
            }
            hi = mid - 1L;
        }
        return lo;
    }

    private /* synthetic */ Optional lambda$getTreePreview$5(CraftingCalculator calculator, ResourceKey resource, long amount, CancellationToken cancellationToken) {
        try {
            TreePreview tree = TreePreviewCraftingCalculatorListener.calculateTree((CraftingCalculator)calculator, (ResourceKey)resource, (long)amount, (CancellationToken)cancellationToken);
            this.requiredCraftingAmounts.clear();
            if (tree != null && tree.rootNode() != null) {
                this.compileCrafting(tree.rootNode(), 0);
            }
            this.requiredCraftingAmounts = (ArrayList)OmniGrid.mergeResourceAmounts(this.requiredCraftingAmounts);
            return Optional.of(tree);
        }
        catch (Exception e) {
            LOGGER.error("Error computing TreePreview for {}: {}", (Object)resource, (Object)e);
            return Optional.of(new TreePreview(PreviewType.NOT_AVAILABLE, null, List.of()));
        }
    }

    private static final class Totals {
        long available;
        long toCraft;
        long missing;

        private Totals() {
        }

        void add(long av, long craft, long miss) {
            this.available += av;
            this.toCraft += craft;
            this.missing += miss;
        }
    }
}

