/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Utils.RefinedTypesUtil;
import com.omnigrid.Utils.SmeltResult;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.ToggleableResourceSlot;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class OmniFurnaceSlot
extends ToggleableResourceSlot {
    public Consumer<OmniFurnaceSlot> onChange;
    public boolean smelting = true;
    private int dataIndex = 0;

    public int getDataIndex() {
        return this.dataIndex;
    }

    public OmniFurnaceSlot(boolean smelting, AbstractOmniGridContainerMenu menu, ResourceContainer resourceContainer, int index, Component helpText, int x, int y, ResourceSlotType type, Consumer<OmniFurnaceSlot> onChange) {
        super(resourceContainer, index, helpText, x, y, type, menu, 1);
        this.onChange = onChange;
        this.dataIndex = index;
        this.smelting = smelting;
    }

    public boolean shouldRenderAmount() {
        ItemResource res;
        PlatformResourceKey platformResourceKey = this.getResource();
        if (platformResourceKey instanceof ItemResource && (res = (ItemResource)platformResourceKey).item() == Items.AIR) {
            return false;
        }
        return this.smelting;
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public void setFilter(PlatformResourceKey resource) {
        if (this.verify((ResourceKey)resource, false)) {
            super.setFilter(resource);
            this.onChange.accept(this);
        }
    }

    public boolean supportsItemSlotInteractions() {
        return false;
    }

    public boolean verify(ResourceKey res, boolean skipTab) {
        if (res == null) {
            return true;
        }
        if (this.menu.tabPage != 1 && !skipTab) {
            return false;
        }
        if (res instanceof ItemResource) {
            ItemResource itemRes = (ItemResource)res;
            ItemStack stack = itemRes.toItemStack();
            if (stack.isEmpty()) {
                return true;
            }
            if (this.smelting) {
                ItemStack result = OmniFurnaceSlot.getSmeltingResult(this.menu.gridPlayer.level(), stack).output();
                return !result.isEmpty();
            }
            return stack.getBurnTime(RecipeType.SMELTING) > 0;
        }
        if (res instanceof FluidResource) {
            FluidResource fluidRes = (FluidResource)res;
            return !this.smelting && fluidRes.fluid().isSame((Fluid)Fluids.LAVA);
        }
        return RefinedTypesUtil.rtInstalled() && res instanceof EnergyResource;
    }

    public static SmeltResult getSmeltingResult(Level level, ItemStack input) {
        if (level == null || input == null || input.isEmpty()) {
            return new SmeltResult(ItemStack.EMPTY, 0.0f);
        }
        SingleRecipeInput recipeInput = new SingleRecipeInput(input);
        Optional match = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)recipeInput, level);
        if (match.isEmpty()) {
            return new SmeltResult(ItemStack.EMPTY, 0.0f);
        }
        SmeltingRecipe recipe = (SmeltingRecipe)((RecipeHolder)match.get()).value();
        ItemStack output = recipe.assemble(recipeInput, (HolderLookup.Provider)level.registryAccess());
        if (output == null) {
            output = ItemStack.EMPTY;
        }
        float xp = recipe.getExperience();
        return new SmeltResult(output.copy(), xp);
    }

    public void change(@Nullable ResourceAmount resourceAmount) {
        if (resourceAmount != null && !this.verify(resourceAmount.resource(), true)) {
            return;
        }
        super.change(resourceAmount);
        this.onChange.accept(this);
    }

    public void change(ItemStack stack, boolean tryAlternatives) {
        super.change(stack, tryAlternatives);
        this.onChange.accept(this);
    }
}

