/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.neoforge.Items;
import com.refinedmods.refinedstorage.api.network.impl.node.exporter.ExporterTransferStrategyImpl;
import com.refinedmods.refinedstorage.api.network.impl.node.exporter.MissingResourcesListeningExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.exporter.ExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.exporter.ExporterTransferQuotaProvider;
import com.ultramega.refinedtypes.type.energy.EnergyCapabilityCache;
import com.ultramega.refinedtypes.type.energy.EnergyInsertableStorage;
import com.ultramega.refinedtypes.type.energy.EnergyResource;
import java.util.Objects;
import java.util.function.ToLongFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;

public class OmniEnergyExporterStrategyFactory
implements ExporterTransferStrategyFactory {
    public Class<? extends ResourceKey> getResourceType() {
        return EnergyResource.class;
    }

    public ExporterTransferStrategy create(ServerLevel level, BlockPos pos, Direction direction, UpgradeState upgradeState, boolean fuzzyMode) {
        long singleAmount;
        EnergyCapabilityCache capabilityCache = new EnergyCapabilityCache(level, pos, direction);
        EnergyInsertableStorage destination = new EnergyInsertableStorage(capabilityCache);
        if (upgradeState.getAmount((UpgradeItem)Items.INSTANCE.getOmniEnergy()) >= 4) {
            singleAmount = Integer.MAX_VALUE;
        } else {
            int upgrades = upgradeState.getAmount((UpgradeItem)Items.INSTANCE.getOmniEnergy()) + upgradeState.getAmount((UpgradeItem)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getStackUpgrade());
            singleAmount = (long)Math.min((double)Platform.INSTANCE.getBucketAmount() * Math.pow(8.0, upgrades), 2.147483647E9);
        }
        Objects.requireNonNull(destination);
        ExporterTransferStrategy strategy = this.create(fuzzyMode, destination, (ToLongFunction<ResourceKey>)new ExporterTransferQuotaProvider(singleAmount, upgradeState, arg_0 -> ((EnergyInsertableStorage)destination).getAmount(arg_0), true));
        if (upgradeState.has((UpgradeItem)com.refinedmods.refinedstorage.common.content.Items.INSTANCE.getAutocraftingUpgrade())) {
            Objects.requireNonNull(destination);
            return new MissingResourcesListeningExporterTransferStrategy(strategy, MissingResourcesListeningExporterTransferStrategy.OnMissingResources.scheduleAutocrafting((ToLongFunction)new ExporterTransferQuotaProvider(singleAmount, upgradeState, arg_0 -> ((EnergyInsertableStorage)destination).getAmount(arg_0), false)));
        }
        return strategy;
    }

    private ExporterTransferStrategy create(boolean fuzzyMode, EnergyInsertableStorage destination, ToLongFunction<ResourceKey> transferQuotaProvider) {
        return fuzzyMode ? new ExporterTransferStrategyImpl((InsertableStorage)destination, transferQuotaProvider, FuzzyRootStorage.expander()) : new ExporterTransferStrategyImpl((InsertableStorage)destination, transferQuotaProvider);
    }
}

