/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.neoforge.OmniTransferEffect;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record OmniEffectPacket(long blockPos, byte color, boolean active) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OmniEffectPacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier((String)"omni_effect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OmniEffectPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_LONG, OmniEffectPacket::blockPos, (StreamCodec)ByteBufCodecs.BYTE, OmniEffectPacket::color, (StreamCodec)ByteBufCodecs.BOOL, OmniEffectPacket::active, OmniEffectPacket::new);

    public static void handle(OmniEffectPacket packet, PacketContext ctx) {
        BlockPos blockPos = BlockPos.of((long)packet.blockPos);
        boolean found = false;
        for (OmniTransferEffect effect : OmniTransferEffect.clientEffects) {
            if (!effect.blockPos.equals((Object)blockPos)) continue;
            found = true;
            effect.color = packet.color;
            effect.active = packet.active;
            effect.reset();
            break;
        }
        if (!found) {
            OmniTransferEffect.clientEffects.add(new OmniTransferEffect(blockPos, packet.color, packet.active));
        }
    }

    public static void handle(BlockPos blockPos, int color, boolean active) {
        OmniTransferEffect.clientEffects.add(new OmniTransferEffect(blockPos, (short)color, active));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }
}

