/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.omnigrid.Utils.MergedPattern;
import com.omnigrid.neoforge.AbstractOmniGridContainerMenu;
import com.omnigrid.neoforge.AutocraftingInfoPacket;
import com.omnigrid.neoforge.OmniCraftTask;
import com.omnigrid.neoforge.OmniItemProxxy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public class OmniCraftTaskManager {
    private final OmniItemProxxy proxxy;
    private final List<OmniCraftTask> craftTasks = new ArrayList<OmniCraftTask>();
    public boolean dirty = false;

    public List<OmniCraftTask> getTasks() {
        return this.craftTasks;
    }

    public OmniCraftTaskManager(OmniItemProxxy proxxy) {
        this.proxxy = proxxy;
    }

    public boolean tickCrafting(Level level, @Nullable Player player) {
        boolean changed = false;
        if (this.craftTasks.isEmpty()) {
            return false;
        }
        if (this.dirty) {
            this.updateMenus(level);
        }
        ArrayList<OmniCraftTask> smeltQueue = new ArrayList<OmniCraftTask>();
        ArrayList<OmniCraftTask> craftQueue = new ArrayList<OmniCraftTask>();
        for (OmniCraftTask task : this.craftTasks) {
            List list = this.proxxy.patterns.getOrDefault(task.getResource(), List.of());
            if (!list.isEmpty() && ((MergedPattern)list.get(0)).getType() == PatternType.PROCESSING) {
                smeltQueue.add(task);
                continue;
            }
            craftQueue.add(task);
        }
        Iterator smeltIterator = smeltQueue.iterator();
        while (smeltIterator.hasNext()) {
            OmniCraftTask task;
            task = (OmniCraftTask)smeltIterator.next();
            boolean queued = this.proxxy.tryCraftSimpleTask(task, level, player);
            if (!queued) continue;
            this.craftTasks.remove(task);
            smeltIterator.remove();
            changed = true;
        }
        Iterator craftIterator = craftQueue.iterator();
        while (craftIterator.hasNext()) {
            boolean success;
            OmniCraftTask task = (OmniCraftTask)craftIterator.next();
            if (task.cooldown > 0) {
                --task.cooldown;
                continue;
            }
            int tries = (int)Math.pow(4.0, this.proxxy.getStacks());
            boolean crafted = false;
            for (int i = 0; i < tries && (success = this.proxxy.tryCraftSimpleTask(task, level, player)); ++i) {
                task.incrementProgress();
                crafted = true;
                this.updateMenu(level, task);
                if (task.isComplete()) break;
            }
            if (!crafted) continue;
            changed = true;
            if (!task.isComplete()) break;
            if (player != null && task.notify) {
                String name = ((ItemResource)task.getResource()).toItemStack().getHoverName().getString();
                player.displayClientMessage((Component)Component.literal((String)("OmniGrid has finished crafting " + name + " x" + task.amount)).withStyle(ChatFormatting.GREEN), true);
            }
            this.craftTasks.remove(task);
            craftIterator.remove();
            break;
        }
        return changed;
    }

    public void updateMenus(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            for (ServerPlayer sp : sl.players()) {
                AbstractContainerMenu abstractContainerMenu = sp.containerMenu;
                if (!(abstractContainerMenu instanceof AbstractOmniGridContainerMenu)) continue;
                AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
                if (menu.storageReference != this.proxxy.uuid) continue;
                for (OmniCraftTask craftTask : this.getTasks()) {
                    if (craftTask.amountPerTask == 0) continue;
                    Platform.INSTANCE.sendPacketToClient(sp, (CustomPacketPayload)new AutocraftingInfoPacket((PlatformResourceKey)craftTask.resource, (int)(craftTask.craftsNeeded - craftTask.craftsDone) * craftTask.amountPerTask));
                }
            }
        }
    }

    public void updateMenu(Level level, OmniCraftTask craftTask) {
        if (craftTask.amountPerTask == 0) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            for (ServerPlayer sp : sl.players()) {
                AbstractContainerMenu abstractContainerMenu = sp.containerMenu;
                if (!(abstractContainerMenu instanceof AbstractOmniGridContainerMenu)) continue;
                AbstractOmniGridContainerMenu menu = (AbstractOmniGridContainerMenu)abstractContainerMenu;
                if (menu.storageReference != this.proxxy.uuid) continue;
                Platform.INSTANCE.sendPacketToClient(sp, (CustomPacketPayload)new AutocraftingInfoPacket((PlatformResourceKey)craftTask.resource, (int)(craftTask.craftsNeeded - craftTask.craftsDone) * craftTask.amountPerTask));
            }
        }
    }

    private void mergeDuplicateTasks() {
        HashMap<ResourceKey, OmniCraftTask> merged = new HashMap<ResourceKey, OmniCraftTask>();
        for (OmniCraftTask t : this.craftTasks) {
            merged.merge(t.getResource(), t, (a, b) -> {
                a.addAmount(b.amount);
                a.addCraftsNeeded(b.getCraftsNeeded());
                return a;
            });
        }
        this.craftTasks.clear();
        this.craftTasks.addAll(merged.values());
    }

    public void addAllTasks(Collection<OmniCraftTask> tasks) {
        if (tasks == null || tasks.isEmpty()) {
            return;
        }
        int before = this.craftTasks.size();
        for (OmniCraftTask t : tasks) {
            this.craftTasks.add(t);
        }
        int added = this.craftTasks.size() - before;
        if (added > 0) {
            // empty if block
        }
    }

    public boolean isTaskPending(ResourceKey resource) {
        for (OmniCraftTask task : this.craftTasks) {
            if (!task.resource.equals((Object)resource) || task.isComplete()) continue;
            return true;
        }
        return false;
    }

    public void addTask(OmniCraftTask task) {
        this.craftTasks.add(task);
    }

    public boolean hasTask(ResourceKey resource) {
        return this.craftTasks.stream().anyMatch(t -> t.resource.equals((Object)resource));
    }

    public void tickTasks() {
        Iterator<OmniCraftTask> it = this.craftTasks.iterator();
        while (it.hasNext()) {
            OmniCraftTask task = it.next();
            if (task.cooldown > 0) {
                --task.cooldown;
            }
            if (!task.isComplete()) continue;
            if (task.notify) {
                System.out.println("\u2705 Task complete for " + String.valueOf(task.resource));
            }
            it.remove();
        }
    }

    public void pauseTasksFor(ResourceKey resource, int ticks) {
        for (OmniCraftTask task : this.craftTasks) {
            if (!task.resource.equals((Object)resource)) continue;
            task.pauseForSubtasks(ticks);
        }
    }

    public void clearAll() {
        this.craftTasks.clear();
    }
}

