/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.omnigrid.Utils.OmniPresetData;
import com.omnigrid.neoforge.CoreTypes;
import com.omnigrid.neoforge.DataComponents;
import com.omnigrid.neoforge.FurnaceData;
import com.omnigrid.neoforge.Items;
import com.omnigrid.neoforge.OmniBlockTarget;
import com.omnigrid.neoforge.OmniCommand;
import com.omnigrid.neoforge.OmniGridTask;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmniCommandData {
    private static final byte CORE_LAYOUT_V1 = 1;
    private static final byte CORE_LAYOUT_V2 = 2;
    public OmniCommand[] commands = new OmniCommand[16];
    public OmniBlockTarget[] blockTargets = new OmniBlockTarget[12];
    public PlatformResourceKey[] tracked = new PlatformResourceKey[4];
    private byte upgrades = 0;
    private byte coreLayoutVersion = 1;
    public boolean[] disabledCommands = new boolean[16];
    @Nullable
    public ItemStack[] craftingMatrix = new ItemStack[9];
    public static final int CORE_COUNT = 20;
    public boolean[] coresInstalled = new boolean[20];
    public FurnaceData furnaceData = new FurnaceData();
    public boolean bruteforce = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(OmniCommandData.class);
    private static final Codec<List<Boolean>> CORES_INSTALLED_CODEC = Codec.BOOL.listOf().xmap(list -> {
        if (list.size() == 16) {
            ArrayList<Boolean> upgraded = new ArrayList<Boolean>(20);
            upgraded.addAll((Collection<Boolean>)list);
            while (upgraded.size() < 20) {
                upgraded.add(Boolean.FALSE);
            }
            upgraded.set(CoreTypes.PROVIDE.ordinal(), true);
            upgraded.set(CoreTypes.DEPOSITING.ordinal(), true);
            upgraded.set(CoreTypes.INVERTED.ordinal(), true);
            upgraded.set(CoreTypes.DISK_DRIVE.ordinal(), true);
            upgraded.set(CoreTypes.REMOTE.ordinal(), true);
            upgraded.set(CoreTypes.AUTOCRAFTING.ordinal(), true);
            upgraded.set(CoreTypes.FURNACE.ordinal(), true);
            return upgraded;
        }
        return list;
    }, Function.identity()).validate(list -> list.size() == 20 ? DataResult.success((Object)list) : DataResult.error(() -> "Expected exactly 20 core flags, got " + list.size()));
    public static final Codec<OmniCommandData> OMNI_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OmniCommand.COMMAND_CODEC.listOf().fieldOf("commands").forGetter(data -> Arrays.asList(data.commands)), (App)OmniBlockTarget.OMNI_BLOCK_CODEC.listOf().optionalFieldOf("blockTargets", List.of()).forGetter(data -> {
        ArrayList<OmniBlockTarget> present = new ArrayList<OmniBlockTarget>();
        for (OmniBlockTarget bt : data.blockTargets) {
            if (bt == null) continue;
            present.add(bt);
        }
        return present;
    }), (App)Codec.INT.listOf().optionalFieldOf("upgrades", List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0))).forGetter(data -> {
        int[] arr = data.getUpgrades();
        ArrayList<Integer> list = new ArrayList<Integer>(4);
        for (int v : arr) {
            list.add(v);
        }
        return list;
    }), (App)Codec.BOOL.listOf().optionalFieldOf("disabledCommands", List.of()).forGetter(data -> {
        ArrayList<Boolean> list = new ArrayList<Boolean>(16);
        for (boolean b : data.disabledCommands) {
            list.add(b);
        }
        return list;
    }), (App)CORES_INSTALLED_CODEC.optionalFieldOf("coresInstalled", List.of()).forGetter(data -> {
        ArrayList<Boolean> list = new ArrayList<Boolean>(20);
        for (int i = 0; i < 20; ++i) {
            list.add(data.coresInstalled[i]);
        }
        return list;
    }), (App)ResourceCodecs.CODEC.optionalFieldOf("tr0").forGetter(d -> Optional.ofNullable(d.tracked[0])), (App)ResourceCodecs.CODEC.optionalFieldOf("tr1").forGetter(d -> Optional.ofNullable(d.tracked[1])), (App)ResourceCodecs.CODEC.optionalFieldOf("tr2").forGetter(d -> Optional.ofNullable(d.tracked[2])), (App)ResourceCodecs.CODEC.optionalFieldOf("tr3").forGetter(d -> Optional.ofNullable(d.tracked[3])), (App)FurnaceData.FURNACE_CODEC.optionalFieldOf("furnaceData", (Object)new FurnaceData()).forGetter(data -> data.furnaceData), (App)Codec.BOOL.optionalFieldOf("bruteforce", (Object)false).forGetter(data -> data.bruteforce), (App)ItemStack.CODEC.listOf().optionalFieldOf("cm", List.of()).forGetter(data -> {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>(9);
        for (int i = 0; i < 9; ++i) {
            ItemStack s = data.craftingMatrix[i];
            out.add(s == null ? Items.INSTANCE.getFakeOmniGrid().getDefaultInstance() : s);
        }
        return out;
    })).apply((Applicative)instance, (commandsList, blockTargetsList, upgradesList, disabledList, installedList, tr0, tr1, tr2, tr3, furnaceData, bruteForce, craftingContents) -> {
        int i;
        int i2;
        OmniCommandData data = new OmniCommandData();
        for (i2 = 0; i2 < 16; ++i2) {
            if (i2 >= commandsList.size()) continue;
            data.commands[i2] = (OmniCommand)commandsList.get(i2);
        }
        for (i2 = 0; i2 < 12; ++i2) {
            if (i2 >= blockTargetsList.size()) continue;
            data.blockTargets[i2] = (OmniBlockTarget)blockTargetsList.get(i2);
        }
        int[] upgradeArray = new int[4];
        for (i = 0; i < 4; ++i) {
            upgradeArray[i] = i < upgradesList.size() ? (Integer)upgradesList.get(i) : 0;
        }
        data.setUpgrades(upgradeArray);
        for (i = 0; i < 16; ++i) {
            data.disabledCommands[i] = i < disabledList.size() && (Boolean)disabledList.get(i) != false;
        }
        for (i = 0; i < 20; ++i) {
            data.coresInstalled[i] = i < installedList.size() && (Boolean)installedList.get(i) != false;
        }
        data.furnaceData = furnaceData;
        data.tracked[0] = tr0.orElse(null);
        data.tracked[1] = tr1.orElse(null);
        data.tracked[2] = tr2.orElse(null);
        data.tracked[3] = tr3.orElse(null);
        data.bruteforce = bruteForce;
        if (!craftingContents.isEmpty()) {
            List list = craftingContents;
            for (int i3 = 0; i3 < 9; ++i3) {
                ItemStack restored;
                data.craftingMatrix[i3] = restored = i3 < list.size() && !((ItemStack)list.get(i3)).isEmpty() ? ((ItemStack)list.get(i3)).copy() : Items.INSTANCE.getFakeOmniGrid().getDefaultInstance();
            }
        } else {
            for (i = 0; i < 9; ++i) {
                data.craftingMatrix[i] = Items.INSTANCE.getFakeOmniGrid().getDefaultInstance();
            }
        }
        return data;
    }));
    private static final String KEY_CMDS_BIN = "cmdB";
    private static final byte CMDS_BIN_VER = 1;
    private int cachedHash = 0;
    private boolean hashDirty = true;

    public OmniCommandData() {
        for (int i = 0; i < this.commands.length; ++i) {
            this.commands[i] = new OmniCommand(0, null);
            this.disabledCommands[i] = false;
        }
        Arrays.fill(this.blockTargets, null);
        Arrays.fill(this.tracked, null);
        Arrays.fill(this.coresInstalled, false);
        this.coreLayoutVersion = (byte)2;
        this.setUpgrades(new int[]{0, 0, 0, 0});
    }

    public static OmniCommandData FullData() {
        OmniCommandData data = new OmniCommandData();
        for (int i = 0; i < 20; ++i) {
            data.coresInstalled[i] = true;
        }
        data.setUpgrades(new int[]{3, 3, 3, 3});
        data.furnaceData = new FurnaceData();
        data.furnaceData.fuel = 25000;
        data.coreLayoutVersion = (byte)2;
        return data;
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        int i;
        for (OmniCommand cmd : this.commands) {
            cmd.toNetwork(buf);
        }
        int count = (int)Arrays.stream(this.blockTargets).filter(Objects::nonNull).count();
        buf.writeByte(count);
        for (int i2 = 0; i2 < this.blockTargets.length; ++i2) {
            if (this.blockTargets[i2] == null) continue;
            buf.writeByte(i2);
            this.blockTargets[i2].toNetwork(buf);
        }
        buf.writeByte(this.upgrades);
        int mask = 0;
        for (int i3 = 0; i3 < 16; ++i3) {
            if (!this.disabledCommands[i3]) continue;
            mask = (short)(mask | 1 << i3);
        }
        buf.writeShort(mask);
        buf.writeByte(this.coreLayoutVersion);
        int coreMask = 0;
        for (i = 0; i < 20; ++i) {
            if (!this.coresInstalled[i]) continue;
            coreMask |= 1 << i;
        }
        buf.writeVarInt(coreMask);
        for (i = 0; i < 4; ++i) {
            PlatformResourceKey key = this.tracked[i];
            buf.writeBoolean(key != null);
            if (key == null) continue;
            ResourceCodecs.STREAM_CODEC.encode((Object)buf, (Object)key);
        }
        buf.writeBoolean(this.bruteforce);
        for (i = 0; i < 9; ++i) {
            ItemStack s = this.craftingMatrix[i];
            if (s == null || s.isEmpty()) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)s);
        }
    }

    public static OmniCommandData fromNetwork(RegistryFriendlyByteBuf buf) {
        byte version;
        OmniCommand[] cmds = new OmniCommand[16];
        for (int i = 0; i < 16; ++i) {
            cmds[i] = OmniCommand.fromNetwork(buf);
        }
        OmniBlockTarget[] blocks = new OmniBlockTarget[12];
        int count = buf.readByte() & 0xFF;
        for (int n = 0; n < count; ++n) {
            int idx = buf.readByte() & 0xFF;
            blocks[idx] = OmniBlockTarget.fromNetwork(buf);
        }
        int upgrades = buf.readByte() & 0xFF;
        short mask = buf.readShort();
        OmniCommandData data = new OmniCommandData();
        data.commands = cmds;
        data.blockTargets = blocks;
        data.upgrades = (byte)upgrades;
        for (int i = 0; i < 16; ++i) {
            data.disabledCommands[i] = (mask >> i & 1) != 0;
        }
        data.coreLayoutVersion = version = buf.readByte();
        int coreMask = buf.readVarInt();
        for (int i = 0; i < 20; ++i) {
            data.coresInstalled[i] = (coreMask >> i & 1) != 0;
        }
        if (data.coreLayoutVersion < 2) {
            data.coresInstalled[CoreTypes.PROVIDE.ordinal()] = true;
            data.coresInstalled[CoreTypes.DEPOSITING.ordinal()] = true;
            data.coresInstalled[CoreTypes.INVERTED.ordinal()] = true;
            data.coresInstalled[CoreTypes.DISK_DRIVE.ordinal()] = true;
        }
        PlatformResourceKey[] tracked = new PlatformResourceKey[4];
        for (int i = 0; i < 4; ++i) {
            boolean hasKey = buf.readBoolean();
            tracked[i] = hasKey ? (PlatformResourceKey)ResourceCodecs.STREAM_CODEC.decode((Object)buf) : null;
        }
        data.tracked = tracked;
        data.bruteforce = buf.readBoolean();
        ItemStack[] stacks = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            boolean present = buf.readBoolean();
            data.craftingMatrix[i] = present ? (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf) : null;
        }
        data.craftingMatrix = stacks;
        return data;
    }

    public String toString() {
        return "Preset Data";
    }

    public CompoundTag toNbt(HolderLookup.Provider provider) {
        int i;
        CompoundTag tag = new CompoundTag();
        tag.putByteArray(KEY_CMDS_BIN, OmniCommandData.serializeCommandsCompact(this.commands, provider));
        ListTag blockList = new ListTag();
        for (int i2 = 0; i2 < this.blockTargets.length; ++i2) {
            OmniBlockTarget bt = this.blockTargets[i2];
            if (bt == null) continue;
            CompoundTag blk = bt.toNbt();
            blk.putByte("idx", (byte)i2);
            blockList.add((Object)blk);
        }
        tag.put("blockTargets", (Tag)blockList);
        tag.putByte("upgrades", this.upgrades);
        if (this.furnaceData == null) {
            this.furnaceData = new FurnaceData();
        }
        tag.put("fd", (Tag)this.furnaceData.toNbt(provider));
        short disabledMask = 0;
        for (int i3 = 0; i3 < 16; ++i3) {
            if (i3 >= this.disabledCommands.length || !this.disabledCommands[i3]) continue;
            disabledMask = (short)(disabledMask | 1 << i3);
        }
        tag.putShort("disabledCommands", disabledMask);
        int coreMask = 0;
        for (i = 0; i < 20; ++i) {
            if (!this.coresInstalled[i]) continue;
            coreMask |= 1 << i;
        }
        tag.putInt("coresInstalled", coreMask);
        tag.putByte("coreLayoutVersion", (byte)2);
        for (i = 0; i < 4; ++i) {
            PlatformResourceKey key = this.tracked[i];
            if (key == null) continue;
            tag.put("tracked" + i, (Tag)ResourceCodecs.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)key).getOrThrow());
        }
        tag.putBoolean("bruteforce", this.bruteforce);
        for (i = 0; i < 9; ++i) {
            ItemStack stack = this.craftingMatrix[i];
            String emptyFlag = "cc" + i + "_e";
            if (stack == null || stack.isEmpty()) {
                tag.putBoolean(emptyFlag, true);
                continue;
            }
            tag.putBoolean(emptyFlag, false);
            tag.put("cc" + i, (Tag)ItemStack.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)stack).getOrThrow());
        }
        return tag;
    }

    public short getNormalCoresInstalled() {
        short count = 0;
        for (int i = 0; i < 16; ++i) {
            if (!this.coresInstalled[i]) continue;
            count = (short)(count + 1);
        }
        return count;
    }

    public short getStrongCoresInstalled() {
        short count = 0;
        for (int i = 16; i < 20; ++i) {
            if (!this.coresInstalled[i]) continue;
            count = (short)(count + 1);
        }
        return count;
    }

    public short getTotalUpgradesInstalled() {
        short sum = 0;
        for (int i = 0; i < 4; ++i) {
            sum = (short)(sum + (this.upgrades >> i * 2 & 3));
        }
        return sum;
    }

    public FurnaceData getFurnaceData() {
        return this.furnaceData;
    }

    public PlatformResourceKey getSmeltingItem(int slot) {
        return slot >= 0 && slot < 4 ? this.furnaceData.smeltItems[slot] : null;
    }

    public void setSmeltingItem(int slot, PlatformResourceKey key) {
        if (slot >= 0 && slot < 4) {
            this.furnaceData.smeltItems[slot] = key;
        }
    }

    public PlatformResourceKey getFuelItem(int slot) {
        return slot >= 0 && slot < 4 ? this.furnaceData.fuelItems[slot] : null;
    }

    public void setFuelItem(int slot, PlatformResourceKey key) {
        if (slot >= 0 && slot < 4) {
            this.furnaceData.fuelItems[slot] = key;
        }
    }

    public long getQuantity(int i) {
        return i >= 0 && i < 4 ? this.furnaceData.toSmelt[i] : 0L;
    }

    public void setExtraLong(int i, long v) {
        if (i >= 0 && i < 4) {
            this.furnaceData.toSmelt[i] = v;
        }
    }

    public int getBurnTime() {
        return this.furnaceData.fuel;
    }

    public void setBurnTime(int v) {
        this.furnaceData.fuel = v;
    }

    public void setFurnaceData(FurnaceData fd) {
        if (fd != null) {
            this.furnaceData = fd;
        }
    }

    public static OmniCommandData fromNbt(CompoundTag tag, HolderLookup.Provider provider) {
        int i;
        ListTag list;
        OmniCommandData data = new OmniCommandData();
        if (tag.contains(KEY_CMDS_BIN, 7)) {
            byte[] bytes = tag.getByteArray(KEY_CMDS_BIN);
            try {
                OmniCommandData.deserializeCommandsCompact(bytes, data.commands, provider);
            }
            catch (Exception exception) {}
        } else if (tag.contains("commands", 9)) {
            list = tag.getList("commands", 10);
            for (int i2 = 0; i2 < list.size() && i2 < data.commands.length; ++i2) {
                data.commands[i2] = OmniCommand.fromNbt(list.getCompound(i2), provider);
            }
        }
        if (tag.contains("blockTargets", 9)) {
            list = tag.getList("blockTargets", 10);
            for (int i3 = 0; i3 < list.size(); ++i3) {
                int idx;
                CompoundTag blk = list.getCompound(i3);
                if (!blk.contains("idx") || (idx = blk.getByte("idx") & 0xFF) < 0 || idx >= data.blockTargets.length) continue;
                data.blockTargets[idx] = OmniBlockTarget.fromNbt(blk);
            }
        }
        data.furnaceData = tag.contains("fd", 10) ? FurnaceData.fromNbt(tag.getCompound("fd"), provider) : new FurnaceData();
        if (tag.contains("upgrades")) {
            data.upgrades = tag.getByte("upgrades");
        }
        if (tag.contains("disabledCommands")) {
            short mask = tag.getShort("disabledCommands");
            for (int i4 = 0; i4 < 16; ++i4) {
                data.disabledCommands[i4] = (mask >> i4 & 1) != 0;
            }
        }
        if (tag.contains("coresInstalled")) {
            byte version;
            byte by = version = tag.contains("coreLayoutVersion") ? tag.getByte("coreLayoutVersion") : (byte)1;
            if (version == 1) {
                short oldMask = tag.getShort("coresInstalled");
                Arrays.fill(data.coresInstalled, false);
                for (int oldId = 0; oldId < 16; ++oldId) {
                    if ((oldMask >> oldId & 1) == 0) continue;
                    CoreTypes type = CoreTypes.V1_BY_ID[oldId];
                    data.setCoreInstalled(type, true);
                }
                data.coreLayoutVersion = (byte)2;
            } else {
                int mask = tag.getInt("coresInstalled");
                for (int i5 = 0; i5 < 20; ++i5) {
                    data.coresInstalled[i5] = (mask >> i5 & 1) != 0;
                }
            }
        }
        for (i = 0; i < 4; ++i) {
            String keyName = "tracked" + i;
            data.tracked[i] = tag.contains(keyName, 10) ? (PlatformResourceKey)ResourceCodecs.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound(keyName)).getOrThrow() : null;
        }
        if (data.disabledCommands.length != 16) {
            data.disabledCommands = new boolean[16];
        }
        if (data.coresInstalled.length != 20) {
            data.coresInstalled = Arrays.copyOf(data.coresInstalled, 20);
        }
        data.bruteforce = tag.contains("bruteforce") && tag.getBoolean("bruteforce");
        for (i = 0; i < 9; ++i) {
            String key;
            String emptyFlag = "cc" + i + "_e";
            data.craftingMatrix[i] = tag.contains(emptyFlag) && tag.getBoolean(emptyFlag) ? null : (tag.contains(key = "cc" + i) ? (ItemStack)ItemStack.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get(key)).result().orElse(null) : null);
        }
        return data;
    }

    public boolean isFullyUpgradedAndCored() {
        int[] ups;
        for (int val : ups = this.getUpgrades()) {
            if (val != 0) continue;
            return false;
        }
        for (int i = 0; i < this.coresInstalled.length; ++i) {
            if (this.coresInstalled[i]) continue;
            return false;
        }
        return true;
    }

    public void sanitize() {
        int i;
        for (i = 0; i < 9; ++i) {
            if (this.craftingMatrix[i] != null) continue;
            this.craftingMatrix[i] = Items.INSTANCE.getFakeOmniGrid().getDefaultInstance();
        }
        for (i = 0; i < 4; ++i) {
            if (this.tracked[i] != null) continue;
        }
        if (this.furnaceData == null) {
            this.furnaceData = new FurnaceData();
        }
    }

    public boolean isCoreInstalled(CoreTypes type) {
        int i = type.ordinal();
        return i >= 0 && i < this.coresInstalled.length && this.coresInstalled[i];
    }

    public void setCoreInstalled(CoreTypes type, boolean installed) {
        int i = type.ordinal();
        if (i >= 0 && i < this.coresInstalled.length) {
            this.coresInstalled[i] = installed;
        }
    }

    public List<CoreTypes> getInstalledCores() {
        ArrayList<CoreTypes> installed = new ArrayList<CoreTypes>(16);
        for (CoreTypes type : CoreTypes.values()) {
            if (!this.isCoreInstalled(type)) continue;
            installed.add(type);
        }
        return installed;
    }

    public boolean isCommandDisabled(int index) {
        return index >= 0 && index < 16 && this.disabledCommands[index];
    }

    public void setCommandDisabled(int index, boolean disabled) {
        if (index >= 0 && index < 16) {
            this.disabledCommands[index] = disabled;
        }
    }

    private static byte[] serializeCommandsCompact(OmniCommand[] cmds, HolderLookup.Provider provider) {
        RegistryAccess.Frozen frozen;
        if (provider instanceof RegistryAccess) {
            RegistryAccess ra = (RegistryAccess)provider;
            frozen = ra;
        } else {
            frozen = RegistryAccess.EMPTY;
        }
        RegistryAccess.Frozen registryAccess = frozen;
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer((int)256)), (RegistryAccess)registryAccess);
        buf.writeByte((byte)1);
        int nonEmpty = 0;
        for (OmniCommand c : cmds) {
            if (c == null || c.pack() == 0 && !c.hasResource()) continue;
            ++nonEmpty;
        }
        buf.writeVarInt(nonEmpty);
        for (int i = 0; i < cmds.length; ++i) {
            OmniCommand c = cmds[i];
            if (c == null || c.pack() == 0 && !c.hasResource()) continue;
            buf.writeByte(i);
            buf.writeShort((int)c.pack());
            buf.writeInt(c.getQuantity());
            buf.writeShort((int)c.getTargetConfig());
            boolean hasRes = c.hasResource();
            buf.writeBoolean(hasRes);
            if (!hasRes) continue;
            ResourceCodecs.STREAM_CODEC.encode((Object)buf, (Object)c.getResource());
        }
        byte[] out = new byte[buf.writerIndex()];
        buf.getBytes(0, out);
        return out;
    }

    public static void writePresetToItem(OmniCommandData source, ItemStack presetStack, UUID presetId) {
        if (source == null || presetStack == null) {
            return;
        }
        presetStack.remove(DataComponents.INSTANCE.CData());
        OmniPresetData presetData = new OmniPresetData(source.commands, source.disabledCommands);
        presetStack.set(DataComponents.INSTANCE.getPresetData(), (Object)presetData);
        presetStack.set(com.refinedmods.refinedstorage.common.content.DataComponents.INSTANCE.getStorageReference(), (Object)presetId);
    }

    private static void deserializeCommandsCompact(byte[] bytes, OmniCommand[] dest, HolderLookup.Provider provider) {
        RegistryAccess.Frozen frozen;
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = new OmniCommand(0, null);
        }
        if (provider instanceof RegistryAccess) {
            RegistryAccess ra = (RegistryAccess)provider;
            frozen = ra;
        } else {
            frozen = RegistryAccess.EMPTY;
        }
        RegistryAccess.Frozen registryAccess = frozen;
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])bytes)), (RegistryAccess)registryAccess);
        if (!buf.isReadable()) {
            return;
        }
        byte ver = buf.readByte();
        if (ver != 1) {
            return;
        }
        int count = buf.readVarInt();
        for (int n = 0; n < count && buf.readableBytes() >= 10; ++n) {
            short idx = buf.readUnsignedByte();
            short packed = buf.readShort();
            int quantity = buf.readInt();
            short targetConfig = buf.readShort();
            boolean hasRes = buf.readBoolean();
            PlatformResourceKey key = null;
            if (hasRes) {
                try {
                    key = (PlatformResourceKey)ResourceCodecs.STREAM_CODEC.decode((Object)buf);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (idx < 0 || idx >= dest.length) continue;
            OmniCommand cmd = new OmniCommand(packed, key);
            cmd.setQuantity(quantity);
            cmd.setTargetConfig(targetConfig);
            dest[idx] = cmd;
        }
    }

    public boolean isValidTask(OmniGridTask task) {
        if (task == null) {
            return false;
        }
        if (task.provide && !this.isCoreInstalled(CoreTypes.PROVIDE)) {
            return false;
        }
        if (task.pull && !this.isCoreInstalled(CoreTypes.PULL)) {
            return false;
        }
        if (task.push && !this.isCoreInstalled(CoreTypes.PUSH)) {
            return false;
        }
        if (task.collect && !this.isCoreInstalled(CoreTypes.COLLECT)) {
            return false;
        }
        if (task.search && !this.isCoreInstalled(CoreTypes.SEARCH)) {
            return false;
        }
        if (task.blacklist && !this.isCoreInstalled(CoreTypes.BLACKLIST)) {
            return false;
        }
        if (task.external && !this.isCoreInstalled(CoreTypes.EXTERNAL_STORAGE)) {
            return false;
        }
        if (task.maintain && !this.isCoreInstalled(CoreTypes.REGULATE)) {
            return false;
        }
        if (task.open && !this.isCoreInstalled(CoreTypes.LOOTING)) {
            return false;
        }
        if (task.basicCrafting != null && !this.isCoreInstalled(CoreTypes.BASIC_CRAFTING)) {
            return false;
        }
        if (task.player && !this.isCoreInstalled(CoreTypes.PLAYER)) {
            return false;
        }
        if (task.linkContainer && !this.isCoreInstalled(CoreTypes.LINK)) {
            return false;
        }
        if (task.blockTargetIndex > -1 && !this.isCoreInstalled(CoreTypes.REMOTE)) {
            return false;
        }
        if (task.filter != null && !this.isCoreInstalled(CoreTypes.FILTER)) {
            return false;
        }
        return !task.isInverted() || this.isCoreInstalled(CoreTypes.INVERTED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OmniCommandData)) {
            return false;
        }
        OmniCommandData other = (OmniCommandData)o;
        return Arrays.equals(this.commands, other.commands) && Arrays.equals(this.blockTargets, other.blockTargets) && this.upgrades == other.upgrades && Arrays.equals(this.disabledCommands, other.disabledCommands) && Arrays.equals(this.coresInstalled, other.coresInstalled) && Arrays.equals(this.tracked, other.tracked) && this.bruteforce == other.bruteforce && Objects.equals(this.furnaceData, other.furnaceData);
    }

    public int[] getUpgrades() {
        int[] arr = new int[4];
        for (int i = 0; i < 4; ++i) {
            arr[i] = this.upgrades >> i * 2 & 3;
        }
        return arr;
    }

    public void setUpgrades(int[] upgradesArray) {
        if (upgradesArray.length != 4) {
            throw new IllegalArgumentException("Exactly 4 upgrades required");
        }
        byte b = 0;
        for (int i = 0; i < 4; ++i) {
            int val = upgradesArray[i] & 3;
            b = (byte)(b | val << i * 2);
        }
        this.upgrades = b;
    }

    public OmniBlockTarget getBlockTarget(int index) {
        if (index < 0 || index >= this.blockTargets.length) {
            return null;
        }
        return this.blockTargets[index];
    }

    public void setBlockTarget(int index, OmniBlockTarget target) {
        if (index < 0 || index >= this.blockTargets.length) {
            throw new IndexOutOfBoundsException("BlockTarget index must be between 0 and 7, got " + index);
        }
        this.blockTargets[index] = target;
    }
}

