/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class OmniCommand {
    private short packed;
    @Nullable
    private PlatformResourceKey resource;
    private int quantity = 0;
    private short targetConfig = 0;
    private static final int MODE_MASK = 31;
    private static final int ACTION_MASK = 15;
    private static final int TARGET_MASK = 31;
    private static final int MODE_SHIFT = 0;
    private static final int ACTION_SHIFT = 5;
    private static final int TARGET_SHIFT = 9;
    private static final int INVERTED_SHIFT = 14;
    private static final int LINKED_SHIFT = 15;
    public static final Codec<OmniCommand> COMMAND_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.SHORT.fieldOf("packed").forGetter(OmniCommand::pack), (App)Codec.INT.fieldOf("quantity").orElse((Object)0).forGetter(OmniCommand::getQuantity), (App)Codec.SHORT.fieldOf("targetConfig").orElse((Object)0).forGetter(OmniCommand::getTargetConfig), (App)ResourceCodecs.CODEC.optionalFieldOf("resource").forGetter(c -> Optional.ofNullable(c.getResource()))).apply((Applicative)instance, (packed, quantity, targetConfig, resourceOpt) -> {
        OmniCommand cmd = new OmniCommand((short)packed, resourceOpt.orElse(null));
        cmd.setQuantity((int)quantity);
        cmd.setTargetConfig((short)targetConfig);
        return cmd;
    }));

    public OmniCommand(int mode, int action, int target, boolean inverted, boolean isLinked) {
        this.packed = OmniCommand.packValues(mode, action, target, inverted, isLinked);
    }

    public OmniCommand(int mode, int action, int target, boolean inverted, boolean isLinked, int quantity, short targetConfig) {
        this.packed = OmniCommand.packValues(mode, action, target, inverted, isLinked);
        this.quantity = quantity;
        this.targetConfig = targetConfig;
    }

    public OmniCommand() {
        this(0, 0, 0, false, false, 0, 0);
    }

    public OmniCommand(short packed, @Nullable PlatformResourceKey resource) {
        this.packed = packed;
        this.resource = resource;
    }

    public int getMode() {
        return this.packed >> 0 & 0x1F;
    }

    public int getAction() {
        return this.packed >> 5 & 0xF;
    }

    public int getTarget() {
        return this.packed >> 9 & 0x1F;
    }

    public boolean isInverted() {
        return (this.packed >> 14 & 1) != 0;
    }

    public boolean isLinked() {
        return (this.packed >> 15 & 1) != 0;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public short getTargetConfig() {
        return this.targetConfig;
    }

    public void setTargetConfig(short targetConfig) {
        this.targetConfig = targetConfig;
    }

    public void setMode(int mode) {
        this.packed = OmniCommand.packValues(mode, this.getAction(), this.getTarget(), this.isInverted(), this.isLinked());
    }

    public void setAction(int action) {
        this.packed = OmniCommand.packValues(this.getMode(), action, this.getTarget(), this.isInverted(), this.isLinked());
    }

    public void setTarget(int target) {
        this.packed = OmniCommand.packValues(this.getMode(), this.getAction(), target, this.isInverted(), this.isLinked());
    }

    public void setInverted(boolean inverted) {
        this.packed = OmniCommand.packValues(this.getMode(), this.getAction(), this.getTarget(), inverted, this.isLinked());
    }

    public void setLinked(boolean linked) {
        this.packed = OmniCommand.packValues(this.getMode(), this.getAction(), this.getTarget(), this.isInverted(), linked);
    }

    private static short packValues(int mode, int action, int target, boolean inverted, boolean linked) {
        return (short)((mode & 0x1F) << 0 | (action & 0xF) << 5 | (target & 0x1F) << 9 | (inverted ? 1 : 0) << 14 | (linked ? 1 : 0) << 15);
    }

    public static OmniCommand unpack(short packed) {
        return new OmniCommand(packed, null);
    }

    public short pack() {
        return this.packed;
    }

    @Nullable
    public PlatformResourceKey getResource() {
        return this.resource;
    }

    public void setResource(@Nullable PlatformResourceKey resource) {
        this.resource = resource;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        buf.writeShort((int)this.packed);
        buf.writeInt(this.quantity);
        buf.writeShort((int)this.targetConfig);
        if (this.resource != null) {
            buf.writeBoolean(true);
            ResourceCodecs.STREAM_CODEC.encode((Object)buf, (Object)this.resource);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static OmniCommand fromNetwork(RegistryFriendlyByteBuf buf) {
        short packed = buf.readShort();
        int quantity = buf.readInt();
        short targetConfig = buf.readShort();
        PlatformResourceKey key = buf.readBoolean() ? (PlatformResourceKey)ResourceCodecs.STREAM_CODEC.decode((Object)buf) : null;
        OmniCommand cmd = new OmniCommand(packed, key);
        cmd.setQuantity(quantity);
        cmd.setTargetConfig(targetConfig);
        return cmd;
    }

    public CompoundTag toNbt(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        tag.putShort("p", this.packed);
        tag.putInt("q", this.quantity);
        tag.putShort("tCfg", this.targetConfig);
        if (this.resource != null) {
            tag.put("r", (Tag)ResourceCodecs.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.resource).getOrThrow());
        }
        return tag;
    }

    public static OmniCommand fromNbt(CompoundTag tag, HolderLookup.Provider provider) {
        short packed = tag.getShort("p");
        int quantity = tag.contains("q") ? tag.getInt("q") : 0;
        short targetConfig = tag.contains("tCfg") ? tag.getShort("tCfg") : (short)0;
        PlatformResourceKey key = null;
        if (tag.contains("r", 10)) {
            key = (PlatformResourceKey)ResourceCodecs.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound("r")).getOrThrow();
        }
        OmniCommand cmd = new OmniCommand(packed, key);
        cmd.setQuantity(quantity);
        cmd.setTargetConfig(targetConfig);
        return cmd;
    }

    public String debugDump() {
        StringBuilder sb = new StringBuilder();
        sb.append("OmniCommand {\n");
        sb.append("  packed        = ").append(this.packed).append(" (0x").append(Integer.toHexString(this.packed & 0xFFFF)).append(")\n");
        sb.append("  mode          = ").append(this.getMode()).append("\n");
        sb.append("  action        = ").append(this.getAction()).append("\n");
        sb.append("  target        = ").append(this.getTarget()).append("\n");
        sb.append("  inverted      = ").append(this.isInverted()).append("\n");
        sb.append("  linked        = ").append(this.isLinked()).append("\n");
        sb.append("  quantity      = ").append(this.quantity).append("\n");
        sb.append("  targetConfig  = ").append(this.targetConfig).append("\n");
        sb.append("  resource      = ").append(this.resource != null ? this.resource : "<none>").append("\n");
        sb.append("}");
        return sb.toString();
    }
}

