/*
 * Decompiled with CFR 0.152.
 */
package com.omnigrid.neoforge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class OmniBlockTarget {
    private final Item target;
    private final BlockPos position;
    private final Direction direction;
    public static final StreamCodec<RegistryFriendlyByteBuf, OmniBlockTarget> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)BuiltInRegistries.ITEM.key()), OmniBlockTarget::getTarget, (StreamCodec)BlockPos.STREAM_CODEC, OmniBlockTarget::getPosition, (StreamCodec)ByteBufCodecs.VAR_INT.map(Direction::from3DDataValue, Direction::get3DDataValue), OmniBlockTarget::getDirection, OmniBlockTarget::new);
    public static final Codec<OmniBlockTarget> OMNI_BLOCK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("target").xmap(rl -> (Item)BuiltInRegistries.ITEM.getOptional(rl).orElseThrow(() -> new IllegalArgumentException("Unknown item: " + String.valueOf(rl))), arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).forGetter(OmniBlockTarget::getTarget), (App)BlockPos.CODEC.fieldOf("pos").forGetter(OmniBlockTarget::getPosition), (App)Codec.INT.xmap(Direction::from3DDataValue, Direction::get3DDataValue).fieldOf("dir").forGetter(OmniBlockTarget::getDirection)).apply((Applicative)instance, OmniBlockTarget::new));

    public OmniBlockTarget(Item target, BlockPos position, Direction direction) {
        this.target = target;
        this.position = position;
        this.direction = direction;
    }

    public Item getTarget() {
        return this.target;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public static OmniBlockTarget fromNetwork(RegistryFriendlyByteBuf buf) {
        Item target = (Item)ByteBufCodecs.registry((ResourceKey)BuiltInRegistries.ITEM.key()).decode((Object)buf);
        BlockPos pos = (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf);
        Direction dir = (Direction)ByteBufCodecs.VAR_INT.map(Direction::from3DDataValue, Direction::get3DDataValue).decode((Object)buf);
        return new OmniBlockTarget(target, pos, dir);
    }

    public void toNetwork(RegistryFriendlyByteBuf buf) {
        ByteBufCodecs.registry((ResourceKey)BuiltInRegistries.ITEM.key()).encode((Object)buf, (Object)this.target);
        BlockPos.STREAM_CODEC.encode((Object)buf, (Object)this.position);
        ByteBufCodecs.VAR_INT.map(Direction::from3DDataValue, Direction::get3DDataValue).encode((Object)buf, (Object)this.direction);
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.putString("target", BuiltInRegistries.ITEM.getKey((Object)this.target).toString());
        tag.putLong("pos", this.position.asLong());
        tag.putInt("dir", this.direction.get3DDataValue());
        return tag;
    }

    public static OmniBlockTarget fromNbt(CompoundTag tag) {
        Item target = (Item)BuiltInRegistries.ITEM.getOptional(ResourceLocation.tryParse((String)tag.getString("target"))).orElseThrow(() -> new IllegalArgumentException("Unknown item: " + tag.getString("target")));
        BlockPos pos = BlockPos.of((long)tag.getLong("pos"));
        Direction dir = Direction.from3DDataValue((int)tag.getInt("dir"));
        return new OmniBlockTarget(target, pos, dir);
    }

    public String toString() {
        return "OmniBlockTarget{target=" + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)this.target)) + ", pos=" + String.valueOf(this.position) + ", dir=" + String.valueOf(this.direction) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OmniBlockTarget)) {
            return false;
        }
        OmniBlockTarget other = (OmniBlockTarget)o;
        return this.target == other.target && this.position.equals((Object)other.position) && this.direction == other.direction;
    }

    public int hashCode() {
        int result = this.target.hashCode();
        result = 31 * result + this.position.hashCode();
        result = 31 * result + this.direction.hashCode();
        return result;
    }
}

